/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.actions.ShutDownAction;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.swing.GlassPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AutoLogOffAlertDialog;
import com.floreantpos.util.PosGuiUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class PosWindow
extends JFrame
implements WindowListener {
    private static final String EXTENDEDSTATE = "extendedstate";
    private static final String WLOCY = "wlocy";
    private static final String WLOCX = "wlocx";
    private static final String WHEIGHT = "wheight";
    private static final String WWIDTH = "wwidth";
    private GlassPane glassPane;
    private JLabel statusLabel;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss aaa");
    private Timer clockTimer = new Timer(1000, new ClockTimerHandler());
    private JLabel lblRestaurantName;
    private JLabel lblUser;
    private JLabel lblTerminal;
    private JLabel lblDatabase;
    private JLabel lblTime;
    private Timer autoLogoffTimer;
    private AutoLogoffHandler autoLogoffHandler = new AutoLogoffHandler();

    public PosWindow() {
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.addWindowListener(this);
        this.glassPane = new GlassPane();
        this.glassPane.setOpacity(0.6f);
        this.setGlassPane(this.glassPane);
        this.statusLabel = new JLabel();
        JPanel statusBarContainer = new JPanel(new BorderLayout());
        statusBarContainer.add((Component)new JSeparator(0), "North");
        JPanel infoPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 5", "[]20px[]20px[]", "[]"));
        infoPanel.setOpaque(true);
        Font f = this.statusLabel.getFont().deriveFont(1, PosUIManager.getFontSize(10));
        this.lblRestaurantName = new JLabel();
        this.lblTerminal = new JLabel("Terminal: " + TerminalConfig.getTerminalId());
        this.lblUser = new JLabel();
        this.lblDatabase = new JLabel();
        this.lblTime = new JLabel("");
        this.lblTime.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.lblRestaurantName.setFont(f);
        this.lblUser.setFont(f);
        this.lblTerminal.setFont(f);
        this.lblDatabase.setFont(f);
        this.lblTime.setFont(f);
        infoPanel.add(this.lblRestaurantName);
        infoPanel.add(this.lblTerminal);
        infoPanel.add(this.lblUser);
        infoPanel.add((Component)this.lblDatabase, "grow");
        statusBarContainer.add((Component)infoPanel, "West");
        statusBarContainer.add((Component)this.lblTime, "East");
        this.getContentPane().add((Component)statusBarContainer, "South");
        this.clockTimer.start();
    }

    public void rendererUserInfo() {
        User currentUser = Application.getCurrentUser();
        if (currentUser != null) {
            this.lblUser.setText("USER: " + currentUser.getFullName() + " (" + currentUser.getType().getName() + ")");
        } else {
            this.lblUser.setText("USER: NOT LOGGED IN");
        }
    }

    public void setRestaurantName(String name) {
        this.lblRestaurantName.setText(name);
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    public void setupSizeAndLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(AppConfig.getInt(WWIDTH, (int)screenSize.getWidth()), AppConfig.getInt(WHEIGHT, (int)screenSize.getHeight()));
        this.setLocation(AppConfig.getInt(WLOCX, screenSize.width - this.getWidth() >> 1), AppConfig.getInt(WLOCY, screenSize.height - this.getHeight() >> 1));
        this.setMinimumSize(new Dimension(1024, 724));
        this.setDefaultCloseOperation(0);
        int extendedState = AppConfig.getInt(EXTENDEDSTATE, -1);
        if (extendedState != -1) {
            this.setExtendedState(extendedState);
        }
    }

    public void enterFullScreenMode() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize);
        this.setExtendedState(6);
        this.setUndecorated(true);
        this.setLocation(0, 0);
    }

    public void leaveFullScreenMode() {
        GraphicsDevice window = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
        this.setUndecorated(false);
        window.setFullScreenWindow(null);
    }

    public void saveSizeAndLocation() {
        int width = this.getWidth();
        int height = this.getHeight();
        AppConfig.putInt(WWIDTH, width);
        AppConfig.putInt(WHEIGHT, height);
        Point locationOnScreen = this.getLocationOnScreen();
        AppConfig.putInt(WLOCX, locationOnScreen.x);
        AppConfig.putInt(WLOCY, locationOnScreen.y);
        AppConfig.putInt(EXTENDEDSTATE, this.getExtendedState());
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.startTimer();
        } else {
            this.stopTimer();
        }
    }

    private void startTimer() {
        this.clockTimer.start();
    }

    private void stopTimer() {
        this.clockTimer.stop();
    }

    public void startAutoLogoffTimer() {
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal != null && terminal.isIsAutoLogOffEnabled().booleanValue()) {
            this.autoLogoffTimer = new Timer(terminal.getAutoLogOffSec() * 1000, this.autoLogoffHandler);
            this.autoLogoffTimer.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.autoLogoffHandler, 56L);
        }
    }

    public void stopAutoLogoffTimer() {
        if (this.autoLogoffTimer != null) {
            this.autoLogoffTimer.stop();
            this.autoLogoffTimer = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.autoLogoffHandler);
        }
    }

    private void showFooterTimer() {
        StringBuilder sb = new StringBuilder();
        sb.append(dateFormat.format(Calendar.getInstance().getTime()));
        this.lblTime.setText(sb.toString());
    }

    public void setGlassPaneVisible(boolean b) {
        this.glassPane.setVisible(b);
    }

    public void updateView() {
        this.lblTerminal.setText("Terminal: " + TerminalConfig.getTerminalId());
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (Application.getCurrentUser() != null) {
            new ShutDownAction().actionPerformed(null);
        } else {
            Application.getInstance().shutdownPOS();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private class AutoLogoffHandler
    implements ActionListener,
    AWTEventListener {
        @Override
        public void eventDispatched(AWTEvent event) {
            this.reset();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PosWindow.this.autoLogoffTimer.stop();
            if (!PosWindow.this.isShowing()) {
                return;
            }
            if (PosGuiUtil.isModalDialogShowing()) {
                this.reset();
                return;
            }
            AutoLogOffAlertDialog dialog = new AutoLogOffAlertDialog();
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                this.reset();
                return;
            }
            Application.getInstance().doAutoLogout();
        }

        public void reset() {
            if (PosWindow.this.autoLogoffTimer != null) {
                PosWindow.this.autoLogoffTimer.restart();
            } else {
                Toolkit.getDefaultToolkit().removeAWTEventListener(PosWindow.this.autoLogoffHandler);
            }
        }
    }

    private class ClockTimerHandler
    implements ActionListener {
        private ClockTimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PosWindow.this.isShowing()) {
                PosWindow.this.clockTimer.stop();
                return;
            }
            PosWindow.this.showFooterTimer();
        }
    }
}

