/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UpdateNotificationDialog;
import com.floreantpos.update.UpdateListener;
import com.floreantpos.update.UpdateService;
import com.floreantpos.update.ZipUtil;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public class UpdateManager
implements UpdateListener {
    public static final String SOFTWARE_NUMERIC_VERSION = "software.numeric.version";
    public static final String HAS_UPDATE = "has_update";
    public static final String FORCE_UPDATE = "force_update";
    private JFrame parentWindow;

    public JFrame getParentWindow() {
        return this.parentWindow;
    }

    public void setParentWindow(JFrame parentWindow) {
        this.parentWindow = parentWindow;
    }

    public void checkForUpdate() {
        String updateServerURL = Application.getInstance().getUpdateServerURL();
        String appName = VersionInfo.getAppName();
        String version = VersionInfo.getVersion();
        int numericVersion = VersionInfo.getNumericVersion();
        UpdateService.checkForUpdate((Component)this.parentWindow, (UpdateListener)this, (String)updateServerURL, (String)appName, (String)version, (int)numericVersion);
    }

    public void checkHasRemainingUpdates() {
        if (!AppConfig.getBoolean(HAS_UPDATE, false)) {
            return;
        }
        if (!AppConfig.getBoolean(FORCE_UPDATE, false)) {
            try {
                OroMqttClient mqttClient = OroMqttClient.getInstance(TerminalUtil.getSystemUID());
                mqttClient.initMqttClient();
                this.sendUpdateNotification("MESSAGE", "Software update", "Software will automatically restart for an update in 30sec.");
                PosLog.debug(this.getClass(), "mqtt client started");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            UpdateNotificationDialog.showUpdatePromptDialog("Update info");
        }
        this.runUpdateProcess();
        AppConfig.removeProperty(HAS_UPDATE);
        System.exit(0);
    }

    public void sendUpdateNotification(String action, String content, String msg) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("action", (Object)action);
        jsonObject.put("content", (Object)content);
        jsonObject.put("msg", (Object)msg);
        jsonObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
        jsonObject.put("terminalAppNumericVersion", VersionInfo.getNumericVersion());
        OroMqttClient.getInstance().publishData("auto-update-service", jsonObject.toString());
    }

    public void runUpdateProcess() {
        UpdateManager.extractLatestUpdater();
        try {
            File currentJar = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            String decodedParentPath = URLDecoder.decode(currentJar.getPath(), "UTF-8");
            String decodedUpdaterPath = decodedParentPath.replace(currentJar.getName(), "auto-updater.jar");
            String appName = VersionInfo.getAppName();
            System.out.println(decodedParentPath);
            System.out.println(decodedUpdaterPath);
            ProcessBuilder pb = new ProcessBuilder("java", "-cp", decodedUpdaterPath, "com.floreantpos.update.UpdateServiceWindow", decodedParentPath, appName);
            pb.start();
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    public static void extractLatestUpdater() {
        try {
            String appName = VersionInfo.getAppName();
            appName = appName.replaceAll("\\W+", "_").toLowerCase();
            String sourceZipFile = String.valueOf(System.getProperty("java.io.tmpdir")) + "/" + appName + "/" + appName + ".zip";
            try (ZipFile zipFile = new ZipFile(sourceZipFile);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    String decodedParentPath;
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith("lib") || !name.contains("auto-updater")) continue;
                    InputStream in = zipFile.getInputStream(entry);
                    File currentJar = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    if (!currentJar.isFile()) {
                        return;
                    }
                    currentJar = currentJar.getParentFile();
                    String outputFolder = decodedParentPath = URLDecoder.decode(currentJar.getPath(), "UTF-8");
                    PosLog.debug(UpdateManager.class, "decode parent path: " + decodedParentPath);
                    PosLog.debug(UpdateManager.class, "auto updater destination: " + outputFolder);
                    File entryDestination = new File(outputFolder, "auto-updater.jar");
                    FileOutputStream out = new FileOutputStream(entryDestination);
                    ZipUtil.copy((InputStream)in, (OutputStream)out);
                    try {
                        in.close();
                        out.close();
                    }
                    catch (IOException ioe) {
                        PosLog.error(UpdateManager.class, ioe);
                    }
                    PosLog.debug(UpdateManager.class, "Success");
                    break;
                }
            }
        }
        catch (Exception e) {
            PosLog.error(UpdateManager.class, e);
        }
    }

    public void publishIfNewUpdateAvailable() {
        boolean forcedUpdate = AppConfig.getBoolean(FORCE_UPDATE, false);
        if (forcedUpdate) {
            AppConfig.removeProperty(FORCE_UPDATE);
            AppConfig.removeProperty("last_app_version");
            return;
        }
        AppConfig.removeProperty(FORCE_UPDATE);
        int lastAppVersion = AppConfig.getInt("last_app_version", VersionInfo.getNumericVersion());
        if (VersionInfo.getNumericVersion() > lastAppVersion) {
            Store store = StoreDAO.getRestaurant();
            store.setSoftwareVersion(VersionInfo.getVersion());
            store.setSoftwareNumericVersion(VersionInfo.getNumericVersion());
            StoreDAO.getInstance().update(store);
            DataProvider.get().refreshStore();
            this.sendUpdateNotification("UPDATE", "Software has been updated", "");
            AppConfig.removeProperty(HAS_UPDATE);
            AppConfig.removeProperty("last_app_version");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    POSMessageDialog.showMessage(UpdateManager.this.parentWindow, "Software has been update to version " + VersionInfo.getVersion());
                }
            });
        }
    }

    public void downloadComplete() {
        try {
            AppConfig.put(HAS_UPDATE, true);
            AppConfig.putInt("last_app_version", VersionInfo.getNumericVersion());
            final POSDialog posDialog = new POSDialog((Frame)this.parentWindow, true);
            PosButton posButton = new PosButton("Restart now");
            posButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    posDialog.dispose();
                }
            });
            JLabel label = new JLabel("Download complete. System will restart in 5 sec.");
            JPanel mainPanel = new JPanel();
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            mainPanel.add(label);
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(posButton);
            posDialog.add(mainPanel);
            posDialog.add((Component)buttonPanel, "South");
            posDialog.setSize(PosUIManager.getSize(400, 150));
            posDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    Timer timer = new Timer(5000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            posDialog.dispose();
                        }
                    });
                    timer.start();
                }
            });
            posDialog.open();
            Main.restart();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this.parentWindow, e.getMessage(), e);
        }
    }

    public void updateComplete() {
    }

    public void updateCanceled() {
        Store store = StoreDAO.getRestaurant();
        int softwareNVersion = POSUtil.parseInteger(store.getProperty(SOFTWARE_NUMERIC_VERSION, String.valueOf(VersionInfo.getNumericVersion())));
        if (VersionInfo.getNumericVersion() < softwareNVersion) {
            System.exit(0);
        }
    }

    public void startDownload() {
        String appName = VersionInfo.getAppName().replaceAll("\\W+", "_").toLowerCase();
        UpdateService.startDownload((Component)Application.getPosWindow(), (UpdateListener)new UpdateListener(){

            public void updateComplete() {
            }

            public void downloadComplete() {
                try {
                    AppConfig.put(UpdateManager.HAS_UPDATE, true);
                    AppConfig.put(UpdateManager.FORCE_UPDATE, true);
                    AppConfig.putInt("last_app_version", VersionInfo.getNumericVersion());
                    Main.restart();
                }
                catch (Exception e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
                }
            }

            public void updateCanceled() {
            }
        }, (String)Application.getInstance().getUpdateServerURL(), (String)appName);
    }

    public void subscribeToUpdateService(OroMqttClient oroMqttClient, String uniqueId) throws Exception {
        oroMqttClient.subscribe(String.valueOf(uniqueId) + "auto-update-service", 0, new IMqttMessageListener(){

            public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
                PosLog.debug(this.getClass(), "Update message received");
                String data = new String(mqttMessage.getPayload());
                JSONObject jsonObject = new JSONObject(data);
                String terminalKey = jsonObject.getString("terminalKey");
                PosLog.debug(this.getClass(), "Update notification from terminal " + terminalKey);
                if (terminalKey.equals(TerminalUtil.getSystemUID())) {
                    return;
                }
                Action action = Action.valueOf(jsonObject.getString("action"));
                Object object = jsonObject.get("content");
                Object message = jsonObject.get("msg");
                Toolkit.getDefaultToolkit().beep();
                switch (action) {
                    case MESSAGE: {
                        PosLog.debug(this.getClass(), "going to show that software will be updated");
                        UpdateNotificationDialog.showMessage(object.toString(), message.toString(), false);
                        break;
                    }
                    case UPDATE: {
                        if (String.valueOf(VersionInfo.getNumericVersion()).equals(StoreDAO.getRestaurant().getSoftwareVersion())) {
                            return;
                        }
                        UpdateNotificationDialog notificationDialog = UpdateNotificationDialog.getInstance(object.toString(), message.toString(), true);
                        notificationDialog.setUpdateButtonVisible(false);
                        notificationDialog.startUpdating();
                    }
                }
            }
        });
    }

    public void checkVersionCompatibility(Integer databaseVersionInDb, String softwareVersionInDb, Integer softwareNumericVersionInDb) {
        try {
            boolean oldVersion;
            Integer thisVersion = VersionInfo.getNumericVersion();
            Integer thisDatabaseVersion = 154;
            boolean bl = oldVersion = softwareNumericVersionInDb != null && softwareNumericVersionInDb > thisVersion;
            if (oldVersion || databaseVersionInDb != null && databaseVersionInDb > thisDatabaseVersion) {
                String message = "Some other terminal is running updated version of the software.\nTo continue, you must update to version %s or later.\nDo you want to update now?.";
                message = String.format(message, softwareVersionInDb);
                String option = null;
                option = TerminalConfig.isShowDbConfigureButton() ? POSMessageDialog.showOptionDialog(Application.getPosWindow(), message, "Update required", "Yes", "Use different database", "No") : POSMessageDialog.showOptionDialog(Application.getPosWindow(), message, "Update required", "Yes", "No");
                if (option == null || option.equals("No")) {
                    POSMessageDialog.showError(Application.getPosWindow(), "System will now shutdown.");
                    System.exit(1);
                } else if (option.equals("Yes")) {
                    this.startDownload();
                } else {
                    DatabaseConfigurationDialog dialog = DatabaseConfigurationDialog.show(Application.getPosWindow());
                    if (dialog.isCanceled()) {
                        POSMessageDialog.showError(Application.getPosWindow(), "System will now shutdown.");
                        System.exit(1);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void performDatabaseUpgrade() throws Exception {
        String hibernateDialect;
        boolean databaseUpdated;
        Database database = AppConfig.getDefaultDatabase();
        String connectString = AppConfig.getConnectString();
        String databaseUser = AppConfig.getDatabaseUser();
        String databasePassword = AppConfig.getDatabasePassword();
        String hibernateConnectionDriverClass = database.getHibernateConnectionDriverClass();
        Map<String, String> storeProperties = DatabaseUtil.getStoreProperties(connectString, hibernateConnectionDriverClass, databaseUser, databasePassword);
        String softwareVersion = storeProperties.get("software.version");
        Integer databaseVersion = null;
        Integer softwareNumericVersion = null;
        try {
            databaseVersion = Integer.parseInt(storeProperties.get("database.version"));
            softwareNumericVersion = Integer.parseInt(storeProperties.get(SOFTWARE_NUMERIC_VERSION));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkVersionCompatibility(databaseVersion, softwareVersion, softwareNumericVersion);
        if (!DatabaseUtil.isDbUpdateNeeded(databaseVersion)) {
            return;
        }
        String message = Messages.getString("DB_UPGRADE_REQUIRED");
        String title = Messages.getString("ALERT");
        int option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), message, title);
        if (option != 0) {
            return;
        }
        message = Messages.getString("DB_UPGRADE_ALERT_MESSAGE");
        option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), message, title);
        if (option != 0) {
            POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SHUTDOWN_MESSAGE"));
            System.exit(1);
        }
        if (databaseUpdated = DatabaseUtil.updateDatabase(connectString, hibernateDialect = database.getHibernateDialect(), hibernateConnectionDriverClass, databaseUser, databasePassword)) {
            JOptionPane.showMessageDialog(Application.getPosWindow(), Messages.getString("DB_UPGRADE_SUCCESS"));
            System.exit(100);
        } else {
            JOptionPane.showMessageDialog(Application.getPosWindow(), Messages.getString("DatabaseConfigurationDialog.3"));
        }
    }

    static enum Action {
        MESSAGE,
        UPDATE;

    }
}

