/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.Currency;
import com.floreantpos.model.DrawerPullVoidEntry;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseCashDrawer;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"transactions", "assignedUser", "assignedBy", "closedBy", "terminal", "storeOperationData"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class CashDrawer
extends BaseCashDrawer {
    private static final long serialVersionUID = 1L;
    protected transient DrawerType drawerType;
    private transient Double cardVoidAmount;
    private transient StoreSession storeSession;
    private transient Double promotionAmount;
    private Set<DrawerPullVoidEntry> voidEntries;

    @Transient
    public User getAssignedUser() {
        if (this.getAssignedUserId() == null) {
            return null;
        }
        return (User)DataProvider.get().getObjectOf(User.class, (Serializable)((Object)this.getAssignedUserId()));
    }

    @Transient
    public void setAssignedUser(User user) {
        if (user == null) {
            this.setAssignedUserId(null);
        } else {
            this.setAssignedUserId(user.getId());
        }
    }

    @Transient
    public User getAssignedBy() {
        return DataProvider.get().getUserById(this.getAssignedByUserId());
    }

    public void setAssignedBy(User user) {
        if (user == null) {
            this.setAssignedByUserId(null);
        } else {
            this.setAssignedByUserId(user.getId());
        }
    }

    @Transient
    public User getClosedBy() {
        return DataProvider.get().getUserById(this.getClosedByUserId());
    }

    @Transient
    public void setClosedBy(User user) {
        if (user == null) {
            this.setClosedByUserId(null);
        } else {
            this.setClosedByUserId(user.getId());
        }
    }

    @Transient
    public Terminal getTerminal() {
        return DataProvider.get().getTerminalById(this.getTerminalId());
    }

    @Transient
    public void setTerminal(Terminal terminal) {
        if (terminal == null) {
            this.setTerminalId(null);
        } else {
            this.setTerminalId(terminal.getId());
        }
    }

    public DrawerType getDrawerType() {
        return DrawerType.fromInt(super.getType());
    }

    public void setDrawerType(DrawerType drawerType) {
        super.setType(drawerType.getTypeNumber());
    }

    public double getGiftCardAddBalance() {
        Map<String, Double> revenueCategory = super.getOtherRevenueCategory();
        if (revenueCategory == null) {
            return 0.0;
        }
        Set<String> keys = revenueCategory.keySet();
        double total = 0.0;
        for (String key : keys) {
            total += revenueCategory.get(key).doubleValue();
        }
        return total;
    }

    public CashBreakdown getCurrencyBalance(Currency currency) {
        List<CashBreakdown> list = this.getCashBreakdownList();
        if (list == null) {
            return null;
        }
        for (CashBreakdown cashBreakdown : list) {
            if (!currency.equals(cashBreakdown.getCurrency())) continue;
            return cashBreakdown;
        }
        return null;
    }

    public void setGiftCardAddBalance(double giftCardAddBalance) {
    }

    public void setPayOutNumber(Integer i) {
    }

    public String getCashReceiptNumber() {
        return "";
    }

    public void setCashReceiptNumber(String s) {
    }

    public String getCreditCardReceiptNumber() {
        return "";
    }

    public void setCreditCardReceiptNumber(String s) {
    }

    public String getDrawerBleedNumber() {
        return "";
    }

    public void setDebitCardReceiptNumber(String s) {
    }

    public String getDebitCardReceiptNumber() {
        return "";
    }

    public void setDrawerBleedNumber(String s) {
    }

    public Integer getPayOutNumber() {
        return 0;
    }

    public void addCurrencyBalances(List<CashBreakdown> cashBreakdown) {
        this.getCashBreakdownList().addAll(cashBreakdown);
    }

    @Override
    public List<CashBreakdown> getCashBreakdownList() {
        List<CashBreakdown> curBalanceList = super.getCashBreakdownList();
        if (curBalanceList == null) {
            curBalanceList = new ArrayList<CashBreakdown>();
            super.setCashBreakdownList(curBalanceList);
        }
        return curBalanceList;
    }

    public void calculate() {
        this.setTotalRevenue(this.getNetSales() + this.getSalesTax() - this.getTotalDiscountAmount());
        this.setGrossReceipts(this.getTotalRevenue() + this.getCashTips() + this.getChargedTips());
        double total = this.getCashReceiptAmount() + this.getCreditCardReceiptAmount() + this.getDebitCardReceiptAmount() + this.getGiftCertReturnAmount() + this.getCustomPaymentAmount() - this.getGiftCertChangeAmount() - this.getRefundAmount() - this.getCardVoidAmount() - this.getCustomerPaymentAmount();
        this.setReceiptDifferential(NumberUtil.roundToTwoDigit(this.getGrossReceipts() - total));
        this.setTipsDifferential(this.getCashTips() + this.getChargedTips() - this.getTipsPaid());
        double totalCash = this.getCashReceiptAmount();
        double tips = this.getTipsPaid();
        double totalPayout = this.getPayOutAmount();
        double beginCash = this.getBeginCash();
        double refundAmount = this.getRefundAmount();
        double drawerBleed = this.getDrawerBleedAmount();
        double accountable = beginCash + totalCash - tips - totalPayout - refundAmount - drawerBleed;
        this.setDrawerAccountable(accountable);
    }

    public Set<DrawerPullVoidEntry> getVoidEntries() {
        if (this.getId() == null) {
            return this.voidEntries;
        }
        this.voidEntries = new HashSet<DrawerPullVoidEntry>(VoidItemDAO.getInstance().getVoidEntries(this));
        if (this.voidEntries != null) {
            double totalVoidAmount = 0.0;
            for (DrawerPullVoidEntry drawerPullVoidEntry : this.voidEntries) {
                totalVoidAmount += drawerPullVoidEntry.getAmount().doubleValue();
            }
            this.setTotalVoid(totalVoidAmount);
        }
        return this.voidEntries;
    }

    public void setVoidEntries(Set<DrawerPullVoidEntry> voidEntries) {
        this.voidEntries = voidEntries;
        if (voidEntries != null) {
            double totalVoidAmount = 0.0;
            for (DrawerPullVoidEntry drawerPullVoidEntry : voidEntries) {
                totalVoidAmount += drawerPullVoidEntry.getAmount().doubleValue();
            }
            this.setTotalVoid(totalVoidAmount);
        }
    }

    public boolean isOpen() {
        return this.getReportTime() == null;
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public Double getCardVoidAmount() {
        return this.cardVoidAmount == null ? new Double(0.0) : this.cardVoidAmount;
    }

    public void setCardVoidAmount(Double cardVoidAmount) {
        this.cardVoidAmount = cardVoidAmount;
    }

    public StoreSession getStoreSession() {
        if (StringUtils.isEmpty((String)this.getStoreSessionId())) {
            return null;
        }
        if (this.storeSession != null && StringUtils.equals((String)this.storeSession.getId(), (String)this.getStoreSessionId())) {
            return this.storeSession;
        }
        return (StoreSession)DataProvider.get().getObjectOf(StoreSession.class, (Serializable)((Object)this.getStoreSessionId()));
    }

    public void setStoreSession(StoreSession storeSession) {
        if (storeSession == null) {
            this.storeSession = null;
            this.setStoreSessionId(null);
        } else {
            this.storeSession = storeSession;
            this.setStoreSessionId(storeSession.getId());
        }
    }

    @Deprecated
    public StoreSession getStoreOperationData() {
        if (StringUtils.isEmpty((String)this.getStoreSessionId())) {
            return null;
        }
        if (this.storeSession != null && StringUtils.equals((String)this.storeSession.getId(), (String)this.getStoreSessionId())) {
            return this.storeSession;
        }
        return (StoreSession)DataProvider.get().getObjectOf(StoreSession.class, (Serializable)((Object)this.getStoreSessionId()));
    }

    @Deprecated
    public void setStoreOperationData(StoreSession storeSession) {
        if (storeSession == null) {
            this.storeSession = null;
            this.setStoreSessionId(null);
        } else {
            this.storeSession = storeSession;
            this.setStoreSessionId(storeSession.getId());
        }
    }

    public Double getPromotionAmount() {
        return this.promotionAmount;
    }

    public void setPromotionAmount(Double promotionAmount) {
        this.promotionAmount = promotionAmount;
    }
}

