/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.util.AESencrp;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
public class Customer
extends BaseCustomer {
    private static final long serialVersionUID = 1L;
    public static final String APPETIZER_PREF = "appetizerPref";
    public static final String BILLINGSTATEMENT_PREF = "billingStatementPref";
    public static final String COCKTAIL_PREF = "cocktailPref";
    public static final String DESSERT_PREF = "dessertPref";
    public static final String ENTREE_PREF = "entreePref";
    public static final String GOLFBALL_PREF = "golfBallPref";
    public static final String MEAL_PREF = "mealPref";
    public static final String PAYMENT_PREF = "paymentPref";
    public static final String PILLOW_PREF = "pillowPref";
    public static final String ROLLAWAYCRIB_PREF = "rollawayCribPref";
    public static final String SEATING_PREF = "seatingPref";
    public static final String SMOKING_PREF = "smokingPref";
    public static final String WINE_PREF = "winePref";
    public static final String ROOM_ACCESS_PREF = "roomAccessPref";
    public static final String ROOM_LOC_PREF = "roomLocPref";
    public static final String ROOM_NUMBER_PREF = "roomNumberPref";
    public static final String REMAINING_CURRENT_QUARTER = "club62__Remaining_Current_Quarter_F_B_Spends__c";
    public static final String STATUS = "club62__Status__c";
    public static final String STREET_1 = "street_1";
    public static final String STREET_2 = "street_2";
    public static final String STREET_3 = "street_3";
    private Boolean selected;

    public Customer() {
    }

    public Customer(String id) {
        super(id);
    }

    @Override
    public String toString() {
        String fName = this.getName();
        return fName;
    }

    public ImageIcon getImage() {
        return null;
    }

    @Override
    public String getName() {
        String name = super.getFirstName();
        if (StringUtils.isNotEmpty((String)super.getLastName())) {
            name = name + " " + super.getLastName();
        }
        return name;
    }

    @Override
    public void setMobileNo(String mobileNo) {
        if (StringUtils.isNotEmpty((String)mobileNo)) {
            mobileNo = mobileNo.replaceAll("(\\+)?\\D", "$1");
        }
        super.setMobileNo(mobileNo);
    }

    @Override
    public void setWorkPhoneNo(String workPhoneNo) {
        if (StringUtils.isNotEmpty((String)workPhoneNo)) {
            workPhoneNo = workPhoneNo.replaceAll("(\\+)?\\D", "$1");
        }
        super.setWorkPhoneNo(workPhoneNo);
    }

    @Override
    public void setHomePhoneNo(String homePhoneNo) {
        if (StringUtils.isNotEmpty((String)homePhoneNo)) {
            homePhoneNo = homePhoneNo.replaceAll("(\\+)?\\D", "$1");
        }
        super.setHomePhoneNo(homePhoneNo);
    }

    public Boolean isSelected() {
        return this.selected == null ? Boolean.FALSE : this.selected;
    }

    public void setSelected(Boolean enable) {
        this.selected = enable;
    }

    public CustomerGroup getCustomerGroup() {
        if (StringUtils.isNotEmpty((String)this.getCustomerGroupId())) {
            return CustomerGroupDAO.getInstance().get(this.getCustomerGroupId());
        }
        return null;
    }

    public void setCustomerGroup(CustomerGroup customerGroup) {
        String customerGroupId = null;
        if (customerGroup != null) {
            customerGroupId = customerGroup.getId();
        }
        super.setCustomerGroupId(customerGroupId);
    }

    public void setEncryptedSecretCode(String secretCode) {
        try {
            this.setSecretCode(AESencrp.encrypt(secretCode));
        }
        catch (Exception e) {
            this.setSecretCode(secretCode);
        }
    }

    public String getUnencryptedSecretCode() {
        String secretKey = this.getSecretCode();
        if (StringUtils.isNotEmpty((String)secretKey)) {
            try {
                secretKey = AESencrp.decrypt(secretKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return secretKey;
    }

    public static enum MemberType {
        MEMBER(0, "Member"),
        GUEST(1, "Guest"),
        EMPLOYEE(2, "Employee");

        private int typeInt;
        private String name;

        private MemberType(int type, String name) {
            this.typeInt = type;
            this.name = name;
        }

        public int getTypeInt() {
            return this.typeInt;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static MemberType fromInt(int type) {
            MemberType[] values;
            for (MemberType memberType : values = MemberType.values()) {
                if (memberType.getTypeInt() != type) continue;
                return memberType;
            }
            return MEMBER;
        }
    }
}

