/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.User;

public enum DrawerType {
    DRAWER(0),
    STAFF_BANK(1);

    private int typeNumber;

    private DrawerType(int typeNumber) {
        this.typeNumber = typeNumber;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public static DrawerType fromInt(int typeNumber) {
        DrawerType[] values;
        for (DrawerType transLocEnum : values = DrawerType.values()) {
            if (transLocEnum.typeNumber != typeNumber) continue;
            return transLocEnum;
        }
        return DRAWER;
    }

    public String toString() {
        return this.name();
    }

    public static DrawerType getUserDrawerType(User user) {
        return user.isStaffBank() != false ? STAFF_BANK : DRAWER;
    }
}

