/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.base.BaseKitchenTicket;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;

public class KitchenTicket
extends BaseKitchenTicket {
    private static final long serialVersionUID = 1L;
    private String customerName;
    private Printer printer;
    private Ticket parentTicket;
    private Boolean filterItem;
    private Integer sortOrder;

    public KitchenTicket() {
    }

    public KitchenTicket(String id) {
        super(id);
    }

    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setStatus(kitchenStatus.name());
    }

    public List<KitchenTicketItem> getModifiersForTicketItem(String ticketItemId) {
        ArrayList<KitchenTicketItem> modifiers = new ArrayList<KitchenTicketItem>();
        List<KitchenTicketItem> ticketItems = this.getTicketItems();
        if (ticketItems != null) {
            for (KitchenTicketItem kitchenTicketItem : ticketItems) {
                if (!kitchenTicketItem.isModifierItem().booleanValue() || !ticketItemId.equals(kitchenTicketItem.getTicketItemId())) continue;
                modifiers.add(kitchenTicketItem);
            }
        }
        return modifiers;
    }

    public List<KitchenTicketItem> getCookingInstructionForTicketItem(String ticketItemId) {
        ArrayList<KitchenTicketItem> instructions = new ArrayList<KitchenTicketItem>();
        List<KitchenTicketItem> ticketItems = this.getTicketItems();
        if (ticketItems != null) {
            for (KitchenTicketItem kitchenTicketItem : ticketItems) {
                if (!kitchenTicketItem.isCookingInstruction().booleanValue() || !ticketItemId.equals(kitchenTicketItem.getTicketItemId())) continue;
                instructions.add(kitchenTicketItem);
            }
        }
        return instructions;
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public List<Printer> getPrinters() {
        ArrayList<Printer> printers = new ArrayList<Printer>();
        PosPrinters posPrinters = DataProvider.get().getPrinters();
        PrinterGroup printerGroup = this.getPrinterGroup();
        if (printerGroup == null) {
            printers.addAll(posPrinters.getKitchenPrinters());
            return printers;
        }
        List<String> printerNames = printerGroup.getPrinterNames();
        List<Printer> kitchenPrinters = posPrinters.getKitchenPrinters();
        for (Printer printer : kitchenPrinters) {
            if (!printerNames.contains(printer.getVirtualPrinter().getName())) continue;
            printers.add(printer);
        }
        return printers;
    }

    @Override
    public List<KitchenTicketItem> getTicketItems() {
        List<KitchenTicketItem> items = super.getTicketItems();
        if (items == null) {
            items = new ArrayList<KitchenTicketItem>();
            super.setTicketItems(items);
        }
        return items;
    }

    public static List<KitchenTicket> fromTicket(Ticket ticket, boolean isFilterKitchenPrintedItems) {
        return KitchenTicket.fromTicket(ticket, isFilterKitchenPrintedItems, null);
    }

    public static List<KitchenTicket> fromTicket(Ticket ticket, boolean isFilterKitchenPrintedItems, List<TicketItem> ticketItems) {
        boolean isItemBasedKitPrint;
        HashMap<Printer, KitchenTicket> itemMap = new HashMap<Printer, KitchenTicket>();
        ArrayList<KitchenTicket> kitchenTickets = new ArrayList<KitchenTicket>(4);
        Ticket clonedTicket = (Ticket)SerializationUtils.clone((Serializable)ticket);
        boolean bl = isItemBasedKitPrint = ticketItems == null;
        if (ticketItems == null) {
            ticketItems = clonedTicket.getTicketItems();
        }
        if (ticketItems == null) {
            return kitchenTickets;
        }
        OrderType orderType = ticket.getOrderType();
        for (TicketItem ticketItem : ticketItems) {
            List<Printer> printers = ticketItem.getPrinters(orderType);
            if (isFilterKitchenPrintedItems && ticketItem.isPrintedToKitchen().booleanValue() || !ticketItem.isShouldPrintToKitchen().booleanValue()) continue;
            for (Printer printer : printers) {
                KitchenTicket kitchenTicket = (KitchenTicket)itemMap.get(printer);
                if (kitchenTicket == null) {
                    kitchenTicket = new KitchenTicket();
                    kitchenTicket.setPrinterGroup(ticketItem.getPrinterGroup());
                    kitchenTicket.setTicketId(ticket.getId());
                    kitchenTicket.setTokenNo(ticket.getTokenNo());
                    kitchenTicket.setCreateDate(StoreDAO.getServerTimestamp());
                    kitchenTicket.setOrderType(orderType);
                    if (ticket.getTableNumbers() != null) {
                        kitchenTicket.setTableNumbers(new ArrayList<Integer>(ticket.getTableNumbers()));
                    }
                    kitchenTicket.setServerName(ticket.getOwner().getFirstName());
                    kitchenTicket.setStatus(KitchenStatus.WAITING.name());
                    if (StringUtils.isNotEmpty((String)ticket.getProperty("CUSTOMER_NAME"))) {
                        kitchenTicket.setCustomerName(ticket.getProperty("CUSTOMER_NAME"));
                    }
                    kitchenTicket.setPrinter(printer);
                    VirtualPrinter virtualPrinter = printer.getVirtualPrinter();
                    if (virtualPrinter != null) {
                        kitchenTicket.setPrinterName(virtualPrinter.getName());
                    }
                    itemMap.put(printer, kitchenTicket);
                }
                KitchenTicket.addKitchenItem(ticketItem, kitchenTicket);
                KitchenTicket.includeModifiers(ticketItem, kitchenTicket);
                ticketItem.setPrintedToKitchen(true);
                KitchenTicket.includeCookintInstructions(ticketItem, kitchenTicket);
            }
        }
        Collection values = itemMap.values();
        for (KitchenTicket kitchenTicket : values) {
            kitchenTicket.setParentTicket(ticket);
            kitchenTicket.setFilterItem(isFilterKitchenPrintedItems);
            kitchenTickets.add(kitchenTicket);
            String kitchenTicketNumber = ticket.getProperty("KITCHEN_TICKET_NUMBER");
            kitchenTicketNumber = kitchenTicketNumber == null ? "1" : String.valueOf(Integer.valueOf(kitchenTicketNumber) + 1);
            ticket.addProperty("KITCHEN_TICKET_NUMBER", kitchenTicketNumber);
            kitchenTicket.setSequenceNumber(Integer.valueOf(kitchenTicketNumber));
        }
        if (!isItemBasedKitPrint) {
            ticket.markPrintedToKitchen(ticketItems);
        } else {
            ticket.markPrintedToKitchen();
        }
        return kitchenTickets;
    }

    private static void addKitchenItem(TicketItem ticketItem, KitchenTicket kitchenTicket) {
        KitchenTicketItem item = new KitchenTicketItem();
        item.setTicketItemId(ticketItem.getId());
        item.setMenuItemCode(ticketItem.getItemCode());
        item.setVoided(ticketItem.isVoided());
        item.setVoidedItemId(ticketItem.getVoidedItemId());
        item.setMenuItemName(ticketItem.getNameDisplay());
        item.setPrintKitchenSticker(ticketItem.isPrintKitchenSticker());
        if (ticketItem.getMenuItem() == null) {
            item.setMenuItemGroupName("MISC.");
            item.setSortOrder(10001);
        } else {
            item.setMenuItemGroupName(ticketItem.getGroupName());
            item.setSortOrder(ticketItem.getTableRowNum());
        }
        item.setCourseId(ticketItem.getCourseId());
        item.setCourseName(ticketItem.getCourseName());
        item.setUnitName(ticketItem.getUnitName());
        item.setQuantity(ticketItem.getQuantity());
        item.setKitchenStatusValue(KitchenStatus.WAITING);
        item.setKitchenTicket(kitchenTicket);
        item.setSeat(ticketItem.isTreatAsSeat());
        item.setSeatNumber(ticketItem.getSeatNumber());
        kitchenTicket.addToticketItems(item);
    }

    private static void includeCookintInstructions(TicketItem ticketItem, KitchenTicket kitchenTicket) {
        List<TicketItemCookingInstruction> cookingInstructions = ticketItem.getCookingInstructions();
        if (cookingInstructions != null) {
            for (TicketItemCookingInstruction ticketItemCookingInstruction : cookingInstructions) {
                KitchenTicketItem item = new KitchenTicketItem();
                item.setCookingInstruction(true);
                item.setTicketItemId(ticketItem.getId());
                item.setMenuItemName(ticketItemCookingInstruction.getNameDisplay());
                if (ticketItem.getMenuItem() == null) {
                    item.setMenuItemGroupName("MISC.");
                    item.setSortOrder(10001);
                } else {
                    item.setMenuItemGroupName(ticketItem.getGroupName());
                }
                item.setKitchenTicket(kitchenTicket);
                kitchenTicket.addToticketItems(item);
            }
        }
    }

    private static void includeModifiers(TicketItem ticketItem, KitchenTicket kitchenTicket) {
        List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            for (TicketItemModifier itemModifier : ticketItemModifiers) {
                if (!itemModifier.isShouldPrintToKitchen().booleanValue()) continue;
                KitchenTicketItem item = new KitchenTicketItem();
                item.setTicketItemId(ticketItem.getId());
                item.setTicketItemModifierId(itemModifier.getId());
                item.setModifierItem(true);
                item.setMenuItemName(itemModifier.getNameDisplay(true));
                if (ticketItem.getMenuItem() == null) {
                    item.setMenuItemGroupName("MISC.");
                    item.setSortOrder(10001);
                } else {
                    item.setMenuItemGroupName(ticketItem.getGroupName());
                }
                item.setQuantity(itemModifier.getItemQuantity());
                item.setKitchenStatusValue(KitchenStatus.WAITING);
                item.setKitchenTicket(kitchenTicket);
                kitchenTicket.addToticketItems(item);
                itemModifier.setPrintedToKitchen(true);
            }
        }
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Ticket getParentTicket() {
        if (this.parentTicket == null) {
            this.parentTicket = TicketDAO.getInstance().get(this.getTicketId());
        }
        return this.parentTicket;
    }

    public void setParentTicket(Ticket parentTicket) {
        this.parentTicket = parentTicket;
    }

    public Boolean isFilterItem() {
        return this.filterItem;
    }

    public void setFilterItem(Boolean filterItem) {
        this.filterItem = filterItem;
    }

    public void setOrderType(OrderType orderType) {
        if (orderType != null) {
            super.setOrderTypeId(orderType.getId());
        } else {
            super.setOrderTypeId(null);
        }
    }

    public OrderType getOrderType() {
        if (StringUtils.isEmpty((String)this.getOrderTypeId())) {
            return null;
        }
        return DataProvider.get().getOrderType(this.getOrderTypeId());
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Integer getSortOrder() {
        return this.sortOrder == null ? 0 : this.sortOrder;
    }
}

