/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.base.BaseMenuItemModifierSpec;
import com.floreantpos.model.dao.ModifierGroupDAO;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="menuItemModifierSpec")
@JsonIgnoreProperties(ignoreUnknown=true, value={"defaultModifiers"})
public class MenuItemModifierSpec
extends BaseMenuItemModifierSpec {
    private static final long serialVersionUID = 1L;
    private ModifierGroup modifierGroup;

    public MenuItemModifierSpec() {
    }

    public MenuItemModifierSpec(String id) {
        super(id);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getUniqueId() {
        return ("menuitem_modifiergroup_" + this.toString() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public Set<MenuModifier> getModifiers() {
        Set<MenuItemModifierPage> modifierPages = this.getModifierPages();
        HashSet<MenuModifier> menuModifiers = new HashSet<MenuModifier>();
        if (modifierPages != null) {
            for (MenuItemModifierPage page : modifierPages) {
                if (page.getPageItems() == null) continue;
                for (MenuItemModifierPageItem pageItem : page.getPageItems()) {
                    MenuModifier modifier = pageItem.getMenuModifier();
                    if (modifier == null) continue;
                    modifier.setPageItemId(pageItem.getId());
                    menuModifiers.add(modifier);
                }
            }
        }
        return menuModifiers;
    }

    public boolean hasMenuItemModifierPageItem() {
        Set<MenuItemModifierPage> modifierPages = this.getModifierPages();
        if (modifierPages == null || modifierPages.isEmpty()) {
            return false;
        }
        for (MenuItemModifierPage menuItemModifierPage : modifierPages) {
            List<MenuItemModifierPageItem> pageItems = menuItemModifierPage.getPageItems();
            if (pageItems == null && pageItems.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getDisplayName() {
        return super.getName();
    }

    @JsonIgnoreProperties
    public Set<MenuModifier> getDefaultModifiers() {
        HashSet<MenuModifier> defaultModifiers = new HashSet<MenuModifier>();
        List<DefaultMenuModifier> defaultModifierList = super.getDefaultModifierList();
        if (defaultModifierList != null) {
            for (DefaultMenuModifier defaultMenuModifier : defaultModifierList) {
                defaultModifiers.add(defaultMenuModifier.getModifier());
            }
        }
        return defaultModifiers;
    }

    public ModifierGroup getModifierGroup() {
        if (this.modifierGroup != null) {
            return this.modifierGroup;
        }
        String modifierGroupId = super.getModifierGroupId();
        if (StringUtils.isEmpty((String)modifierGroupId)) {
            return null;
        }
        this.modifierGroup = ModifierGroupDAO.getInstance().get(modifierGroupId);
        return this.modifierGroup;
    }

    public void setModifierGroup(ModifierGroup modifierGroup) {
        this.modifierGroup = modifierGroup;
        String modifierGroupId = null;
        if (modifierGroup != null) {
            modifierGroupId = modifierGroup.getId();
        }
        this.setModifierGroupId(modifierGroupId);
    }
}

