/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.base.BaseMenuPage;
import com.floreantpos.model.dao.MenuPageDAO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MenuPage
extends BaseMenuPage {
    private static final long serialVersionUID = 1L;
    public static final int MAX_SIZE = 16;
    private Map<String, MenuPageItem> cellItemMap;

    public MenuPage() {
    }

    public MenuPage(String id) {
        super(id);
    }

    @Override
    public Integer getButtonWidth() {
        Integer buttonWidth = super.getButtonWidth();
        if (buttonWidth < 30) {
            return 30;
        }
        return buttonWidth;
    }

    @Override
    public Integer getButtonHeight() {
        Integer buttonHeight = super.getButtonHeight();
        if (buttonHeight < 30) {
            return 30;
        }
        return buttonHeight;
    }

    public MenuPageItem getItemForCell(int col, int row) {
        MenuPageDAO.getInstance().initialize(this);
        List<MenuPageItem> pageItems = this.getPageItems();
        if (pageItems == null || pageItems.size() == 0) {
            return null;
        }
        if (this.cellItemMap == null || this.cellItemMap.size() != pageItems.size()) {
            this.cellItemMap = new HashMap<String, MenuPageItem>();
            for (MenuPageItem menuPageItem : pageItems) {
                String cellKey = String.valueOf(menuPageItem.getCol()) + String.valueOf(menuPageItem.getRow());
                this.cellItemMap.put(cellKey, menuPageItem);
            }
        }
        String cellKey = String.valueOf(col) + String.valueOf(row);
        return this.cellItemMap.get(cellKey);
    }

    @Override
    public String toString() {
        return super.getName();
    }
}

