/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.base.BaseRecepieItem;
import com.floreantpos.model.dao.MenuItemDAO;
import java.util.List;

public class RecepieItem
extends BaseRecepieItem {
    private static final long serialVersionUID = 1L;
    private double cost;
    private IUnit unit;
    private String groupName;
    private String groupId;

    public RecepieItem() {
    }

    public RecepieItem(String id) {
        super(id);
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void setUnit(IUnit unit) {
        this.unit = unit;
    }

    public IUnit getUnit() {
        List<IUnit> units;
        MenuItem inventoryItem = this.getInventoryItem();
        MenuItemDAO.getInstance().initialize(inventoryItem);
        if (inventoryItem != null && (units = inventoryItem.getUnits()) != null && units.size() > 0) {
            for (IUnit iUnit : units) {
                if (this.getUnitCode() == null || !this.getUnitCode().equals(iUnit.getUniqueCode())) continue;
                this.unit = iUnit;
            }
        }
        return this.unit;
    }

    public void calculatePercentage() {
        MenuItem inventoryItem = this.getInventoryItem();
        if (inventoryItem != null) {
            double baseUnitQuantity = inventoryItem.getBaseUnitQuantity(this.getUnitCode());
            this.setPercentage(this.getQuantity() * baseUnitQuantity * 100.0);
            this.setCost(inventoryItem.getCost() * this.getQuantity() * baseUnitQuantity);
        }
    }

    @Override
    public String toString() {
        return super.getInventoryItem().toString();
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }
}

