/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.TipsReceivedBy;
import com.floreantpos.model.base.BaseStore;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.util.POSUtil;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"storeLogo"})
@XmlRootElement(name="restaurant")
public class Store
extends BaseStore {
    private static final long serialVersionUID = 1L;
    public static final String STORE_PROP_DEFAULT_RESERVATION_OWNER = "Reservation.owner";
    public static final String STORE_PROP_DEFAULT_RESERVATION_ORDERTYPE = "Reservation.ordertype";
    public static final String STORE_PROP_RESERVATION_MERGE_IF_SAME_USER = "Reservation.Merge_If_Same_Member";
    public static final String STORE_PROP_RESERVATION_LOGGED_IN_USER = "Reservation.Logged_In_User_As_Owner";
    public static final String STORE_PROP_RESERVATION_DEFAULT_SALES_AREA = "Reservation.Default_Sales_Area";
    public static final String STORE_PROP_AUTOMATICALLY_SYNC_CHARGES_WHEN_DAY_CLOSED = "Charges.Automatically_Sync_Day";
    private ImageIcon storeLogo;
    private ImageIcon loginScreenBackground;

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public String getProperty(String key) {
        Map<String, String> properties = this.getProperties();
        if (properties == null) {
            return null;
        }
        return properties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String string = this.getProperties().get(key);
        if (StringUtils.isEmpty((String)string)) {
            string = defaultValue;
        }
        return string;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String string = this.getProperties().get(key);
        if (StringUtils.isEmpty((String)string)) {
            return defaultValue;
        }
        return Boolean.valueOf(string);
    }

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    @Override
    public String getCurrencyName() {
        String currencyName = super.getCurrencyName();
        if (StringUtils.isEmpty((String)currencyName)) {
            return "Sample Currency";
        }
        return currencyName;
    }

    @Override
    public String getCurrencySymbol() {
        String currencySymbol = super.getCurrencySymbol();
        if (StringUtils.isEmpty((String)currencySymbol)) {
            currencySymbol = "$";
        }
        return currencySymbol;
    }

    public boolean isAllwMemberbasedPOI() {
        String update = this.getProperty("inventory.allowMemberPOI");
        if (StringUtils.isEmpty((String)update)) {
            return false;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateOnHandBlncForSale() {
        String update = this.getProperty("inventory.updateOnHandBlnceForSale");
        if (StringUtils.isEmpty((String)update)) {
            return true;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateAvlBlncForSale() {
        String update = this.getProperty("inventory.updateAvlBlnceForSale");
        if (StringUtils.isEmpty((String)update)) {
            return true;
        }
        return Boolean.valueOf(update);
    }

    public boolean isAllwNegOnHandBlnce() {
        String update = this.getProperty("inventory.allowNegetiveOnHandBalance");
        if (StringUtils.isEmpty((String)update)) {
            return false;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateAvlBlncForPOCreated() {
        String update = this.getProperty("inventory.updateAvailBalanceForPurchaseOrderCreated");
        if (StringUtils.isEmpty((String)update)) {
            return false;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateOnHandBlncForPORec() {
        String update = this.getProperty("inventory.updateOnHandBalanceForPurchaseOrderReceived");
        if (StringUtils.isEmpty((String)update)) {
            return true;
        }
        return Boolean.valueOf(update);
    }

    public String getImageId() {
        String oldLogoResourceId;
        String storeLogoResourceId = this.getProperty("logo.imageid");
        if (StringUtils.isEmpty((String)storeLogoResourceId) && (oldLogoResourceId = this.getProperty("ticket.header.logo.imageid")) != null) {
            this.addProperty("logo.imageid", oldLogoResourceId);
            return oldLogoResourceId;
        }
        return storeLogoResourceId;
    }

    public ImageIcon getStoreLogo() {
        if (this.storeLogo == null) {
            String storeLogoResourceId = this.getImageId();
            if (StringUtils.isEmpty((String)storeLogoResourceId)) {
                return null;
            }
            ImageResource logoResource = ImageResourceDAO.getInstance().findById(storeLogoResourceId);
            if (logoResource != null) {
                this.storeLogo = new ImageIcon(logoResource.getImage());
                if (this.storeLogo.getIconWidth() > 128 || this.storeLogo.getIconHeight() > 128) {
                    this.storeLogo = new ImageIcon(POSUtil.getScaledImage(logoResource.getImage(), 128, 128));
                }
            }
        }
        return this.storeLogo;
    }

    public boolean isInventoryAvgPricingMethod() {
        String property = this.getProperty("inventory.pricing.method");
        if (property == null) {
            return false;
        }
        return property.equals("avg");
    }

    public void setStoreLogo(ImageIcon storeLogo) {
        this.storeLogo = storeLogo;
    }

    public ImageIcon getLoginScreenBackground() {
        if (this.loginScreenBackground == null) {
            String resourceId = this.getProperty("loginscreen.background");
            if (resourceId == null) {
                return null;
            }
            ImageResource resource = ImageResourceDAO.getInstance().findById(resourceId);
            if (resource != null) {
                this.loginScreenBackground = new ImageIcon(resource.getImage());
            }
        }
        return this.loginScreenBackground;
    }

    public void setLoginScreenBackground(ImageIcon loginScreenBackground) {
        this.loginScreenBackground = loginScreenBackground;
    }

    public static String getWebServiceUrl() {
        Store store = Application.getInstance().getStore();
        return store.getProperty("web.service.url") + "/service/data/store/" + store.getProperty("web.service.schema");
    }

    public TipsReceivedBy getTipsReceivedByForDeliveryOrder() {
        try {
            String tipsReceiver = this.getProperty("tips.receiver.delivery");
            if (StringUtils.isNotEmpty((String)tipsReceiver)) {
                return TipsReceivedBy.valueOf(tipsReceiver);
            }
            return TipsReceivedBy.Server;
        }
        catch (Exception e) {
            throw new PosException("Tips received by configuration is wrong.");
        }
    }

    public TipsReceivedBy getTipsReceivedByForNonDeliveryOrder() {
        try {
            String tipsReceiver = this.getProperty("tips.receiver.nonDelivery");
            if (StringUtils.isNotEmpty((String)tipsReceiver)) {
                return TipsReceivedBy.valueOf(tipsReceiver);
            }
            return TipsReceivedBy.Server;
        }
        catch (Exception e) {
            throw new PosException("Tips received by configuration is wrong.");
        }
    }

    public double getOvertimeMarkup() {
        try {
            String overtimeMarkup = this.getProperty("overtime.markup");
            if (StringUtils.isNotEmpty((String)overtimeMarkup)) {
                return Double.parseDouble(overtimeMarkup);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    public boolean hasCreateMemberPermission() {
        try {
            String memberCreate = this.getProperty("member.create.permission");
            if (StringUtils.isNotEmpty((String)memberCreate)) {
                return Boolean.valueOf(memberCreate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @XmlTransient
    @JsonIgnoreProperties
    public Integer getDatabaseVersion() {
        String property = this.getProperty("database.version");
        try {
            return Integer.parseInt(property);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setDatabaseVersion(int verson) {
        this.addProperty("database.version", String.valueOf(verson));
    }

    @XmlTransient
    @JsonIgnoreProperties
    public String getSoftwareVersion() {
        return this.getProperty("software.version");
    }

    public void setSoftwareVersion(String version) {
        this.addProperty("software.version", version);
    }

    @XmlTransient
    @JsonIgnoreProperties
    public Integer getSoftwareNumericVersion() {
        String property = this.getProperty("software.numeric.version");
        try {
            return Integer.parseInt(property);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setSoftwareNumericVersion(int verson) {
        this.addProperty("software.numeric.version", String.valueOf(verson));
    }

    public boolean isAutoSyncCharges() {
        return this.getBooleanProperty(STORE_PROP_AUTOMATICALLY_SYNC_CHARGES_WHEN_DAY_CLOSED, Boolean.FALSE);
    }

    public boolean isAllowPenyRounding() {
        try {
            String penyRoundAmnt = this.getProperty("store.peny.rounding");
            if (StringUtils.isNotEmpty((String)penyRoundAmnt)) {
                return Boolean.valueOf(penyRoundAmnt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int getCustomerMonitorDisplayOption() {
        try {
            String displayOptionString = this.getProperty("customer.monitor.display.option");
            if (StringUtils.isNotEmpty((String)displayOptionString)) {
                return Integer.parseInt(displayOptionString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int getCustomerMonitorDisplaySlideDuration() {
        try {
            String slideDurationString = this.getProperty("customer.monitor.slide.duration");
            if (StringUtils.isNotEmpty((String)slideDurationString)) {
                return Integer.parseInt(slideDurationString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 5;
    }

    public String getServerUrl() {
        try {
            String serverUrl = this.getProperty("update_server_url");
            if (StringUtils.isNotEmpty((String)serverUrl)) {
                return serverUrl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

