/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.base.BaseSubRecipe;
import com.floreantpos.util.NumberUtil;
import java.util.List;

public class SubRecipe
extends BaseSubRecipe {
    private static final long serialVersionUID = 1L;
    private Double cost;

    public Double getCost() {
        this.calculateCost();
        this.cost = NumberUtil.roundToTwoDigit(this.cost);
        return this.cost == null ? 0.0 : this.cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    private void calculateCost() {
        List<RecepieItem> items;
        double portionCost = 0.0;
        double recipeCost = 0.0;
        Recepie recipe = this.getRecipe();
        if (recipe != null && (items = recipe.getRecepieItems()) != null && items.size() > 0) {
            for (RecepieItem recepieItem : items) {
                recepieItem.calculatePercentage();
                recipeCost += recepieItem.getCost();
            }
        }
        portionCost = recipeCost * this.getPortion() / recipe.getYield();
        this.setCost(portionCost);
    }

    public String getName() {
        Recepie recipe = this.getRecipe();
        if (recipe != null) {
            return recipe.getName();
        }
        return "";
    }

    public Double getYield() {
        Recepie recipe = this.getRecipe();
        if (recipe != null) {
            return recipe.getYield();
        }
        return 1.0;
    }
}

