/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.TipsReceivedBy;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseTicket;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DiscountUtil;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.beans.Transient;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;

@JsonIgnoreProperties(ignoreUnknown=true, value={"transactions", "ticketItems"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="ticket")
public class Ticket
extends BaseTicket {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd yyyy, h:m a");
    private static final String CUSTOMER_TAX_EXEMPT = "customer.taxExempt";
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ONLINE_ID = "onlineOrderId";
    public static final String PROPERTY_CARD_TRANSACTION_ID = "card_transaction_id";
    public static final String PROPERTY_CARD_TRACKS = "card_tracks";
    public static final String PROPERTY_CARD_NAME = "card_name";
    public static final String PROPERTY_PAYMENT_METHOD = "payment_method";
    public static final String PROPERTY_CARD_READER = "card_reader";
    public static final String PROPERTY_CARD_NUMBER = "card_number";
    public static final String PROPERTY_CARD_EXP_YEAR = "card_exp_year";
    public static final String PROPERTY_CARD_EXP_MONTH = "card_exp_month";
    public static final String PROPERTY_ADVANCE_PAYMENT = "advance_payment";
    public static final String PROPERTY_CARD_AUTH_CODE = "card_auth_code";
    public static final String PROPERTY_FOR_HERE_AND_TO_GO = "ticket.ForHereToGo";
    public static final String STATUS_WAITING = "Waiting (Kitchen)";
    public static final String STATUS_READY = "Ready";
    public static final String STATUS_NOT_SENT = "Not Sent";
    public static final String STATUS_DRIVING = "Driving";
    public static final String STATUS_VOID = "Void";
    public static final String CUSTOMER_PHONE = "CUSTOMER_MOBILE";
    public static final String CUSTOMER_NAME = "CUSTOMER_NAME";
    public static final String CUSTOMER_LAST_NAME = "CUSTOMER_LAST_NAME";
    public static final String CUSTOMER_ID = "CUSTOMER_ID";
    public static final String CUSTOMER_ZIP_CODE = "CUSTOMER_ZIP_CODE";
    public static final String MANAGER_INSTRUCTION = "MANAGER_INSTRUCTION";
    public static final String PHONE_EXTENSION = "PHONE_EXTENSION";
    public static final String DRIVER_OUT_TIME = "OUT_AT";
    public static final String PROPERTY_DISCOUNT = "DISCOUNT";
    public static final int ORDER_PENDING = 0;
    public static final int ORDER_VERIFIED = 1;
    public static final int ORDER_FULLY_INVOICED = 2;
    public static final int ORDER_PARTIALLY_INVOICED = 3;
    public static final int ORDER_FULLY_SHIPMENT = 4;
    public static final int ORDER_PARTIALLY_SHIPMENT = 5;
    public static final int ORDER_PARTIALLY_SHIPMENT_AND_INVOICED = 6;
    public static final int ORDER_CLOSED = 7;
    public static final int ORDER_CANCELLED = 8;
    public static final String[] ORDER_STATUS = new String[]{"Pending", "Verified", "Fully Invoiced", "Partially Invoiced", "Fully Shipped", "Partially Shipped", "Partially Shipped and Invoiced", "Closed", "Cancelled"};
    public static final String ORDER_VERIFIED_BY = "Verified_By";
    public static final String ORDER_SENT_BY = "Sent_By";
    public static final String ORDER_SHIPMENT_BY = "Shipping_By";
    public static final String ORDER_INVOICED_BY = "Invoiced_By";
    public static final String ORDER_CLOSED_BY = "Closed_By";
    public static final String DEBIT = "DEBIT";
    public static final String CREDIT = "CREDIT";
    public static final String SPLIT = "split";
    public static final String SPLIT_TICKET_ID = "split_ticket_id";
    public static final String SPLIT_TYPE = "SPLIT_TYPE";
    public static final int SPLIT_EQUALLY = 0;
    public static final int SPLIT_BY_SEAT = 1;
    public static final int SPLIT_MANUALLY = 2;
    private double ticketDiscountAmount;
    private double itemDiscountAmount;
    private double voidSubtotal;
    private double voidTotal;
    private List deletedItems;
    private String sortOrder;
    private boolean needSpecialAttention;
    private Customer customer;
    private Outlet outlet;
    private Department department;
    private SalesArea salesArea;
    private List<TicketDiscount> discounts;
    private List<Integer> tableNumbers;
    private List<ShopTable> tables;
    private boolean shouldUpdateTableStatus;
    private double roundedDueAmount;
    private double toleranceAmount;
    private Boolean refundableItem;

    public Ticket() {
    }

    public Ticket(String id) {
        super(id);
    }

    public Ticket(boolean populateDefaultProperties) {
        if (populateDefaultProperties) {
            this.populateDefaultProperties();
        }
    }

    public TicketType getTicketType() {
        return TicketType.getByTypeNo(super.getType());
    }

    public void setTicketType(TicketType type) {
        if (type != null) {
            super.setType(type.getTypeNo());
        }
    }

    public void addTable(int tableNumber) {
        List<Integer> numbers = this.getTableNumbers();
        if (numbers == null) {
            numbers = new ArrayList<Integer>();
            this.setTableNumbers(numbers);
        }
        numbers.add(tableNumber);
    }

    @Override
    public void setClosed(Boolean closed) {
        super.setClosed(closed);
    }

    public double getGratuityAmount() {
        Gratuity gratuity = this.getGratuity();
        if (gratuity != null) {
            return gratuity.getAmount();
        }
        return 0.0;
    }

    public void updateGratuityInfo() {
        Gratuity gratuity = this.getGratuity();
        if (gratuity == null) {
            return;
        }
        Store store = Application.getInstance().getStore();
        if (this.getAssignedDriver() != null) {
            TipsReceivedBy tipsReceiverForDelivery = store.getTipsReceivedByForDeliveryOrder();
            if (tipsReceiverForDelivery == TipsReceivedBy.Driver) {
                gratuity.setOwnerId(this.getAssignedDriver().getId());
            } else if (tipsReceiverForDelivery == TipsReceivedBy.Cashier) {
                gratuity.setOwnerId(this.getCashier() != null ? this.getCashier().getId() : this.getOwner().getId());
            } else {
                gratuity.setOwnerId(this.getOwner().getId());
            }
        } else {
            TipsReceivedBy tipsReceiverForNonDelivery = store.getTipsReceivedByForNonDeliveryOrder();
            if (tipsReceiverForNonDelivery == TipsReceivedBy.Cashier) {
                gratuity.setOwnerId(this.getCashier().getId());
            } else {
                gratuity.setOwnerId(this.getOwner().getId());
            }
        }
        gratuity.setTicketId(this.getId());
    }

    public void setGratuityAmount(double amount) {
        Gratuity gratuity = this.getGratuity();
        if (gratuity == null) {
            gratuity = this.createGratuity();
            this.setGratuity(gratuity);
        }
        gratuity.setAmount(amount);
    }

    public Gratuity createGratuity() {
        Gratuity gratuity = this.getGratuity();
        if (gratuity == null) {
            gratuity = new Gratuity();
            gratuity.setTicketId(this.getId());
            gratuity.setTerminalId(Application.getInstance().getTerminal().getId());
            gratuity.setPaid(false);
        }
        return gratuity;
    }

    public boolean hasGratuity() {
        return this.getGratuity() != null;
    }

    @Override
    public void setCreateDate(Date createDate) {
        super.setCreateDate(createDate);
        super.setActiveDate(createDate);
    }

    @Override
    @Transient
    public List<TicketItem> getTicketItems() {
        List<TicketItem> items = super.getTicketItems();
        if (items == null) {
            items = new ArrayList<TicketItem>();
            super.setTicketItems(items);
        }
        return items;
    }

    @Override
    public Integer getNumberOfGuests() {
        Integer guests = super.getNumberOfGuests();
        if (guests == null || guests == 0) {
            return 1;
        }
        return guests;
    }

    public String getCreateDateFormatted() {
        return dateFormat.format(this.getCreateDate());
    }

    public String getTitle() {
        String title = "";
        if (this.getId() != null) {
            title = title + "#" + this.getId();
        }
        title = title + ": " + this.getOwner();
        title = title + ":" + this.getCreateDateFormatted();
        title = title + ": " + NumberUtil.formatNumber(this.getTotalAmountWithTips());
        return title;
    }

    public int getBeverageCount() {
        List<TicketItem> ticketItems = this.getTicketItems();
        if (ticketItems == null) {
            return 0;
        }
        int count = 0;
        for (TicketItem ticketItem : ticketItems) {
            if (!ticketItem.isBeverage().booleanValue()) continue;
            count = (int)((double)count + ticketItem.getQuantity());
        }
        return count;
    }

    public void calculatePrice() {
        List<TicketItem> ticketItems = this.getTicketItems();
        if (ticketItems == null) {
            return;
        }
        if (!this.isShouldCalculatePrice().booleanValue()) {
            this.setDiscountAmount(this.calculateTicketDiscount(this.getSubtotalAmount(), 0.0, 0.0));
            return;
        }
        PosLog.debug(this.getClass(), "Price calculation start----------------");
        BigDecimal subtotal = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal discount = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal itemsServiceChargeAmount = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal taxAmount = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal itemDiscountAmountWithVoidItems = NumberUtil.convertToBigDecimal(0.0);
        this.voidSubtotal = 0.0;
        this.voidTotal = 0.0;
        this.itemDiscountAmount = 0.0;
        this.ticketDiscountAmount = 0.0;
        double gratuityAmount = this.getGratuityAmount();
        this.setRefundableItem(false);
        for (TicketItem ticketItem : ticketItems) {
            ticketItem.calculatePrice();
            subtotal = NumberUtil.round(subtotal.add(NumberUtil.convertToBigDecimal(ticketItem.getSubtotalAmount())));
            itemsServiceChargeAmount = NumberUtil.round(itemsServiceChargeAmount.add(NumberUtil.convertToBigDecimal(ticketItem.getServiceCharge())));
            if (!this.isTaxIncluded().booleanValue()) {
                taxAmount = NumberUtil.round(taxAmount.add(NumberUtil.convertToBigDecimal(ticketItem.getTaxAmount())));
            }
            itemDiscountAmountWithVoidItems = NumberUtil.round(itemDiscountAmountWithVoidItems.add(NumberUtil.convertToBigDecimal(ticketItem.getDiscountAmount())));
            if (ticketItem.isVoided().booleanValue()) {
                this.setRefundableItem(true);
                if (ticketItem.getVoidedItemId() == null) continue;
                this.voidSubtotal += Math.abs(ticketItem.getSubtotalAmount());
                this.voidTotal += Math.abs(ticketItem.getSubtotalAmount()) + Math.abs(ticketItem.getTaxAmount());
                continue;
            }
            this.itemDiscountAmount += ticketItem.getDiscountAmount().doubleValue();
        }
        this.ticketDiscountAmount = this.calculateTicketDiscount(subtotal.doubleValue(), this.voidSubtotal, this.itemDiscountAmount);
        discount = NumberUtil.convertToBigDecimal(this.calculateTotalDiscountAmount(subtotal.doubleValue(), this.voidSubtotal, this.ticketDiscountAmount, itemDiscountAmountWithVoidItems.doubleValue()));
        double deliveryChargeAmount = this.getDeliveryCharge();
        double ticketServiceChargeAmount = this.calculateServiceCharge(subtotal.doubleValue(), discount.doubleValue());
        double totalServiceCharge = ticketServiceChargeAmount + itemsServiceChargeAmount.doubleValue();
        PosLog.debug(this.getClass(), String.format("Ticket info------------------------------", new Object[0]));
        PosLog.debug(this.getClass(), String.format("subtoal: %s", subtotal));
        PosLog.debug(this.getClass(), String.format("void subtoal: %s", this.voidSubtotal));
        BigDecimal totalAmount = NumberUtil.convertToBigDecimal(0.0);
        if (this.ticketDiscountAmount > 0.0) {
            BigDecimal itemDiscountedSubtotal = subtotal.subtract(NumberUtil.convertToBigDecimal(this.itemDiscountAmount));
            BigDecimal discountSubtotal = itemDiscountedSubtotal.subtract(NumberUtil.convertToBigDecimal(this.ticketDiscountAmount));
            BigDecimal newTax = NumberUtil.convertToBigDecimal(0.0);
            if (itemDiscountedSubtotal.compareTo(BigDecimal.ZERO) > 0) {
                newTax = discountSubtotal.multiply(taxAmount).divide(itemDiscountedSubtotal, 4, RoundingMode.HALF_UP);
            }
            if (this.isTaxIncluded().booleanValue()) {
                totalAmount = totalAmount.add(discountSubtotal);
                taxAmount = NumberUtil.convertToBigDecimal(0.0);
            } else {
                totalAmount = totalAmount.add(discountSubtotal).add(NumberUtil.convertToBigDecimal(newTax.doubleValue()));
                taxAmount = NumberUtil.round(newTax);
            }
        } else {
            totalAmount = this.isTaxIncluded() != false ? totalAmount.add(subtotal).subtract(discount) : totalAmount.add(subtotal).subtract(discount).add(taxAmount);
        }
        totalAmount = totalAmount.add(NumberUtil.convertToBigDecimal(this.getDeliveryCharge())).add(NumberUtil.convertToBigDecimal(totalServiceCharge));
        totalAmount = NumberUtil.round(totalAmount);
        BigDecimal dueAmount = NumberUtil.round(totalAmount.add(NumberUtil.convertToBigDecimal(gratuityAmount)).subtract(NumberUtil.convertToBigDecimal(this.getPaidAmount())).add(NumberUtil.convertToBigDecimal(this.getRefundAmount())));
        dueAmount = this.calculateToleranceAmount(dueAmount);
        this.setSubtotalAmount(subtotal.doubleValue());
        this.setDiscountAmount(discount.doubleValue());
        this.setServiceCharge(NumberUtil.round(totalServiceCharge));
        this.setTaxAmount(taxAmount.doubleValue());
        this.setTotalAmount(totalAmount.doubleValue());
        this.setDueAmount(dueAmount.doubleValue());
        if (this.ticketDiscountAmount <= 0.0 && this.getRefundableAmount() <= 0.0 && this.getRefundAmount() <= 0.0) {
            this.setSubtotalAmount(NumberUtil.roundToTwoDigit(subtotal.doubleValue()));
            this.setDiscountAmount(NumberUtil.roundToTwoDigit(discount.doubleValue()));
            this.setServiceCharge(NumberUtil.roundToTwoDigit(this.getServiceCharge()));
            this.setTaxAmount(NumberUtil.roundToTwoDigit(taxAmount.doubleValue()));
            return;
        }
        BigDecimal adjustedTotal = NumberUtil.convertToBigDecimal(0.0);
        double adjustedDiscount = 0.0;
        for (TicketItem ticketItem : ticketItems) {
            ticketItem.calculateAdjustedPrice();
            adjustedTotal = adjustedTotal.add(NumberUtil.convertToBigDecimal(ticketItem.getAdjustedTotal()));
            adjustedDiscount += ticketItem.getDiscountAmount().doubleValue();
        }
        double originalTicketPrice = this.getTotalAmount() + this.getVoidTotal();
        if (originalTicketPrice > 0.0) {
            this.ticketDiscountAmount = this.ticketDiscountAmount * (originalTicketPrice - this.getRefundableAmount() - this.getRefundAmount()) / originalTicketPrice;
        }
        adjustedTotal = NumberUtil.round(adjustedTotal.add(NumberUtil.convertToBigDecimal(deliveryChargeAmount)).add(NumberUtil.convertToBigDecimal(ticketServiceChargeAmount)));
        dueAmount = NumberUtil.round(adjustedTotal.add(NumberUtil.convertToBigDecimal(gratuityAmount)).subtract(NumberUtil.convertToBigDecimal(this.getPaidAmount())).add(NumberUtil.convertToBigDecimal(this.getRefundAmount())));
        dueAmount = this.calculateToleranceAmount(dueAmount);
        this.setSubtotalAmount(subtotal.doubleValue());
        this.setDiscountAmount(adjustedDiscount += this.ticketDiscountAmount);
        this.setServiceCharge(this.getServiceCharge());
        this.setDueAmount(dueAmount.doubleValue());
    }

    private BigDecimal calculateToleranceAmount(BigDecimal dueAmount) {
        double dueAmountDouble = dueAmount.doubleValue();
        Store store = DataProvider.get().getStore();
        if (store != null) {
            this.roundedDueAmount = store.isAllowPenyRounding() ? (double)Math.round(dueAmountDouble * 100.0 / 5.0) * 5.0 / 100.0 : dueAmountDouble;
        }
        this.toleranceAmount = this.roundedDueAmount - dueAmountDouble;
        double toleranceAmountFactor = 0.0;
        Currency mainCurrency = CurrencyUtil.getMainCurrency();
        if (mainCurrency != null) {
            toleranceAmountFactor = mainCurrency.getTolerance();
        }
        if (Math.abs(this.roundedDueAmount) <= toleranceAmountFactor) {
            this.toleranceAmount = this.toleranceAmount < 0.0 || this.roundedDueAmount > 0.0 ? (this.toleranceAmount += -this.roundedDueAmount) : (this.toleranceAmount += this.roundedDueAmount);
            return BigDecimal.ZERO;
        }
        if (this.roundedDueAmount == 0.0 || this.roundedDueAmount <= 0.05) {
            return NumberUtil.convertToBigDecimal(this.roundedDueAmount);
        }
        return dueAmount;
    }

    public double getSubtotalAmountWithVoidItems() {
        return this.getSubtotalAmount() + this.getVoidSubtotal();
    }

    private double calculateTotalDiscountAmount(double subtotal, double voidSubtotal, double ticketDiscountAmount, double itemDiscountAmountWithVoidItems) {
        if (this.getDiscounts() == null || this.getDiscounts().size() == 0) {
            return itemDiscountAmountWithVoidItems;
        }
        double subtotalAmountWithVoidItems = subtotal + voidSubtotal;
        double totalDiscountAmount = 0.0;
        totalDiscountAmount += itemDiscountAmountWithVoidItems;
        totalDiscountAmount += ticketDiscountAmount;
        if (subtotalAmountWithVoidItems != 0.0) {
            totalDiscountAmount -= ticketDiscountAmount * Math.abs(voidSubtotal) / subtotalAmountWithVoidItems;
        }
        if (subtotal > 0.0 && totalDiscountAmount > subtotal) {
            totalDiscountAmount = subtotal;
        }
        if (ticketDiscountAmount > subtotal) {
            ticketDiscountAmount = subtotal;
        }
        if (totalDiscountAmount < 0.0) {
            totalDiscountAmount = 0.0;
        }
        return NumberUtil.round(totalDiscountAmount);
    }

    private double calculateTicketDiscount(double subtotal, double voidSubtotal, double itemDiscount) {
        double subtotalWithVoidItems = subtotal + voidSubtotal;
        double subtotalAfterItemDiscount = subtotal - itemDiscount;
        double ticketDisount = 0.0;
        List<TicketDiscount> ticketCouponAndDiscounts = this.getDiscounts();
        if (ticketCouponAndDiscounts != null) {
            for (TicketDiscount ticketDiscount : ticketCouponAndDiscounts) {
                Double calculateDiscountAmount;
                double discountForThisCoupon = 0.0;
                if (ticketDiscount.getType() == 2) {
                    discountForThisCoupon = DiscountUtil.calculateRepriceDiscount(this, ticketDiscount.getValue());
                } else if (ticketDiscount.getType() == 1) {
                    calculateDiscountAmount = DiscountUtil.calculateDiscountAmount(subtotalWithVoidItems - this.itemDiscountAmount, ticketDiscount);
                    discountForThisCoupon = calculateDiscountAmount * ticketDiscount.getCouponQuantity();
                } else {
                    calculateDiscountAmount = DiscountUtil.calculateDiscountAmount(subtotalAfterItemDiscount, ticketDiscount);
                    discountForThisCoupon = calculateDiscountAmount * ticketDiscount.getCouponQuantity();
                }
                ticketDiscount.setTotalDiscountAmount(discountForThisCoupon);
                ticketDisount += discountForThisCoupon;
            }
        }
        this.buildDiscounts();
        return NumberUtil.round(ticketDisount);
    }

    public double getAmountByType(TicketDiscount discount) {
        switch (discount.getType()) {
            case 0: {
                return discount.getValue();
            }
            case 1: {
                return discount.getValue() * this.getSubtotalAmount() / 100.0;
            }
        }
        return 0.0;
    }

    public static TicketDiscount convertToTicketDiscount(Discount discount, Ticket ticket) {
        TicketDiscount ticketDiscount = new TicketDiscount();
        ticketDiscount.setDiscountId(discount.getId());
        ticketDiscount.setName(discount.getName());
        ticketDiscount.setType(discount.getType());
        ticketDiscount.setMinimumAmount(discount.getMinimumBuy());
        ticketDiscount.setValue(discount.getValue());
        ticketDiscount.setTicket(ticket);
        return ticketDiscount;
    }

    private double fixInvalidAmount(double amount) {
        if (Double.isNaN(amount)) {
            amount = 0.0;
        }
        return amount;
    }

    public double calculateDiscountFromType(TicketDiscount coupon, double subtotal) {
        List<TicketItem> ticketItems = this.getTicketItems();
        double discount = 0.0;
        int type = coupon.getType();
        double couponValue = coupon.getValue();
        switch (type) {
            case 3: {
                discount += couponValue;
                break;
            }
            case 1: {
                HashSet<String> categoryIds = new HashSet<String>();
                for (TicketItem item : ticketItems) {
                    String itemId = item.getMenuItemId();
                    if (categoryIds.contains(itemId)) continue;
                    discount += couponValue;
                    categoryIds.add(itemId);
                }
                break;
            }
            case 2: {
                for (TicketItem item : ticketItems) {
                    discount += couponValue * item.getQuantity();
                }
                break;
            }
            case 6: {
                discount += subtotal * couponValue / 100.0;
                break;
            }
            case 4: {
                HashSet<String> categoryIds = new HashSet<String>();
                for (TicketItem item : ticketItems) {
                    String itemId = item.getMenuItemId();
                    if (categoryIds.contains(itemId)) continue;
                    discount += item.getUnitPrice() * couponValue / 100.0;
                    categoryIds.add(itemId);
                }
                break;
            }
            case 5: {
                for (TicketItem item : ticketItems) {
                    discount += item.getSubtotalAmountWithoutModifiers() * couponValue / 100.0;
                }
                break;
            }
            case 0: {
                discount += couponValue;
            }
        }
        return discount;
    }

    public void addDeletedItems(Object o) {
        if (this.deletedItems == null) {
            this.deletedItems = new ArrayList();
        }
        this.deletedItems.add(o);
    }

    public List getDeletedItems() {
        return this.deletedItems;
    }

    public void clearDeletedItems() {
        if (this.deletedItems != null) {
            this.deletedItems.clear();
        }
        this.deletedItems = null;
    }

    public int countItem(TicketItem ticketItem) {
        List<TicketItem> items = this.getTicketItems();
        if (items == null) {
            return 0;
        }
        int count = 0;
        for (TicketItem ticketItem2 : items) {
            if (!ticketItem.getMenuItemId().equals(ticketItem2.getMenuItemId())) continue;
            ++count;
        }
        return count;
    }

    public boolean needsKitchenPrint() {
        if (this.getDeletedItems() != null && this.getDeletedItems().size() > 0) {
            return true;
        }
        List<TicketItem> ticketItems = this.getTicketItems();
        for (TicketItem item : ticketItems) {
            List<TicketItemCookingInstruction> cookingInstructions;
            if (item.isShouldPrintToKitchen().booleanValue() && !item.isPrintedToKitchen().booleanValue()) {
                return true;
            }
            List<TicketItemModifier> ticketItemModifiers = item.getTicketItemModifiers();
            if (ticketItemModifiers != null) {
                for (TicketItemModifier modifier : ticketItemModifiers) {
                    if (!modifier.isShouldPrintToKitchen().booleanValue() || modifier.isPrintedToKitchen().booleanValue()) continue;
                    return true;
                }
            }
            if ((cookingInstructions = item.getCookingInstructions()) == null) continue;
            for (TicketItemCookingInstruction ticketItemCookingInstruction : cookingInstructions) {
                if (ticketItemCookingInstruction.isPrintedToKitchen().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public double calculateServiceCharge(double subtotalAmount, double discountAmount) {
        Outlet store = DataProvider.get().getOutlet();
        if (store == null) {
            return 0.0;
        }
        double serviceChargePercentage = 0.0;
        if (store.getServiceChargePercentage() != null) {
            serviceChargePercentage = store.getServiceChargePercentage();
        }
        double serviceCharge = 0.0;
        if (serviceChargePercentage > 0.0) {
            serviceCharge = (subtotalAmount - discountAmount) * (serviceChargePercentage / 100.0);
        }
        return this.fixInvalidAmount(serviceCharge);
    }

    public void addProperty(String name, String value) {
        if (this.getProperties() == null) {
            this.setProperties(new HashMap<String, String>());
        }
        this.getProperties().put(name, value);
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public String getProperty(String key) {
        if (this.getProperties() == null) {
            return null;
        }
        return this.getProperties().get(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.getProperties() == null) {
            return null;
        }
        String string = this.getProperties().get(key);
        if (StringUtils.isEmpty((String)string)) {
            return defaultValue;
        }
        return string;
    }

    public void removeProperty(String propertyName) {
        Map<String, String> properties = this.getProperties();
        if (properties == null) {
            return;
        }
        properties.remove(propertyName);
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public String toURLForm() {
        String s = "ticket_id=" + this.getId();
        List<TicketItem> items = this.getTicketItems();
        if (items == null || items.size() == 0) {
            return s;
        }
        for (int i = 0; i < items.size(); ++i) {
            TicketItem ticketItem = items.get(i);
            s = s + "&items[" + i + "][id]=" + ticketItem.getId();
            s = s + "&items[" + i + "][name]=" + POSUtil.encodeURLString(ticketItem.getName());
            s = s + "&items[" + i + "][price]=" + ticketItem.getSubtotalAmount();
        }
        s = s + "&tax=" + this.getTaxAmount();
        s = s + "&subtotal=" + this.getSubtotalAmount();
        s = s + "&grandtotal=" + this.getTotalAmountWithTips();
        return s;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
        if (customer != null) {
            this.setCustomerId(customer.getId());
            this.addProperty(CUSTOMER_ID, String.valueOf(customer.getId()));
            this.addProperty(CUSTOMER_NAME, customer.getFirstName());
            this.addProperty(CUSTOMER_LAST_NAME, customer.getLastName());
            this.addProperty(CUSTOMER_PHONE, customer.getMobileNo());
            this.addProperty(CUSTOMER_ZIP_CODE, customer.getZipCode());
            this.addProperty(CUSTOMER_TAX_EXEMPT, customer.isTaxExempt().toString());
        } else {
            this.removeCustomer();
        }
    }

    @Transient
    public Customer getCustomer() {
        if (this.customer != null) {
            return this.customer;
        }
        String customerId = this.getCustomerId();
        if (StringUtils.isEmpty((String)customerId)) {
            return null;
        }
        this.customer = DataProvider.get().getCustomer(customerId);
        return this.customer;
    }

    public void removeCustomer() {
        this.removeProperty(CUSTOMER_ID);
        this.removeProperty(CUSTOMER_NAME);
        this.removeProperty(CUSTOMER_PHONE);
        this.removeProperty(CUSTOMER_ZIP_CODE);
        this.removeProperty(CUSTOMER_TAX_EXEMPT);
    }

    public String getSortOrder() {
        if (this.sortOrder == null) {
            return "";
        }
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public String getStatus() {
        if (super.getStatus() == null) {
            return "";
        }
        return super.getStatus();
    }

    public String getOrderStatusDisplay() {
        return ORDER_STATUS[this.getOrderStatus()];
    }

    public void setOrderStatusDisplay(String orderStatusDisplay) {
    }

    public void consolidateTicketItems() {
        List<TicketItem> ticketItems = this.getTicketItems();
        LinkedHashMap itemMap = new LinkedHashMap();
        for (TicketItem ticketItem : ticketItems) {
            String menuItemId = ticketItem.getMenuItemId() == null ? ticketItem.getName() : ticketItem.getMenuItemId();
            if (StringUtils.isEmpty((String)menuItemId)) continue;
            List itemListInMap = (List)itemMap.get(menuItemId);
            if (itemListInMap == null) {
                ArrayList<TicketItem> list = new ArrayList<TicketItem>();
                list.add(ticketItem);
                itemMap.put(menuItemId.toString(), list);
                continue;
            }
            boolean merged = false;
            for (TicketItem itemInMap : itemListInMap) {
                if (!itemInMap.isMergable(ticketItem, false)) continue;
                itemInMap.merge(ticketItem);
                merged = true;
                break;
            }
            if (merged) continue;
            itemListInMap.add(ticketItem);
        }
        this.getTicketItems().clear();
        Collection values = itemMap.values();
        for (List list : values) {
            if (list == null) continue;
            this.getTicketItems().addAll(list);
        }
        List<TicketItem> list = this.getTicketItems();
        if (this.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            Collections.sort(list, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem o1, TicketItem o2) {
                    if (o1.getId() == null || o2.getId() == null) {
                        return 0;
                    }
                    return o1.getId().compareTo(o2.getId());
                }
            });
            Collections.sort(list, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem o1, TicketItem o2) {
                    return o1.getSeatNumber() - o2.getSeatNumber();
                }
            });
        }
        this.calculatePrice();
    }

    public void consolidateKitchenTicketItems() {
        boolean isFilterKitchenPrintedItems = true;
        this.consolidateKitchenTicketItems(isFilterKitchenPrintedItems);
    }

    public void consolidateKitchenTicketItems(boolean isFilterTicket) {
        this.consolidateKitchenTicketItems(isFilterTicket, null);
    }

    public void consolidateKitchenTicketItems(boolean isFilterTicket, List<TicketItem> ticketItems) {
        if (this.isSourceOnline()) {
            return;
        }
        if (ticketItems == null) {
            ticketItems = this.getTicketItems();
        }
        LinkedHashMap itemMap = new LinkedHashMap();
        for (TicketItem ticketItem : ticketItems) {
            List itemListInMap;
            if (!ticketItem.isShouldPrintToKitchen().booleanValue() && !ticketItem.isPrintKitchenSticker().booleanValue() || isFilterTicket && ticketItem.isPrintedToKitchen().booleanValue()) continue;
            String menuItemId = ticketItem.getMenuItemId();
            if (StringUtils.isEmpty((String)menuItemId)) {
                menuItemId = ticketItem.getName();
            }
            if ((itemListInMap = (List)itemMap.get(menuItemId)) == null) {
                ArrayList<TicketItem> list = new ArrayList<TicketItem>();
                list.add(ticketItem);
                itemMap.put(menuItemId.toString(), list);
                continue;
            }
            itemListInMap.add(ticketItem);
        }
        ticketItems.clear();
        Collection values = itemMap.values();
        for (List list : values) {
            if (list == null) continue;
            ticketItems.addAll(list);
        }
        List<TicketItem> list = ticketItems;
        if (this.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            Collections.sort(list, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem o1, TicketItem o2) {
                    if (o1.getId() == null || o2.getId() == null) {
                        return 0;
                    }
                    return o1.getId().compareTo(o2.getId());
                }
            });
            Collections.sort(list, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem o1, TicketItem o2) {
                    return o1.getSeatNumber() - o2.getSeatNumber();
                }
            });
        }
        this.calculatePrice();
    }

    public void markPrintedToKitchen() {
        List<TicketItem> ticketItems = this.getTicketItems();
        this.markPrintedToKitchen(ticketItems);
    }

    public void markPrintedToKitchen(List<TicketItem> ticketItems) {
        for (TicketItem ticketItem : ticketItems) {
            List<TicketItemCookingInstruction> cookingInstructions;
            List<Printer> printers;
            if (ticketItem.isPrintedToKitchen().booleanValue() || !ticketItem.isShouldPrintToKitchen().booleanValue() || (printers = ticketItem.getPrinters(this.getOrderType())) == null) continue;
            ticketItem.setPrintedToKitchen(true);
            List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
            if (ticketItemModifiers != null) {
                for (TicketItemModifier itemModifier : ticketItemModifiers) {
                    itemModifier.setPrintedToKitchen(true);
                }
            }
            if ((cookingInstructions = ticketItem.getCookingInstructions()) == null) continue;
            for (TicketItemCookingInstruction ticketItemCookingInstruction : cookingInstructions) {
                ticketItemCookingInstruction.setPrintedToKitchen(true);
            }
            ticketItem.buildCoookingInstructions();
        }
    }

    public boolean isSourceOnline() {
        String property = this.getProperty("source");
        return "online".equals(property);
    }

    public boolean isReservation() {
        TicketType ticketType;
        return this.getTicketType() != null && (ticketType = this.getTicketType()).equals((Object)TicketType.RESERVATION);
    }

    public Ticket clone(Ticket source) {
        return (Ticket)SerializationUtils.clone((Serializable)source);
    }

    public boolean isNeedSpecialAttention() {
        return this.needSpecialAttention;
    }

    public void setNeedSpecialAttention(boolean needSpecialAttention) {
        this.needSpecialAttention = needSpecialAttention;
    }

    public String getNumberToDisplay() {
        return "TOKEN# " + this.getTokenNo();
    }

    @Transient
    public Outlet getOutlet() {
        if (this.outlet != null) {
            return this.outlet;
        }
        String outletId = this.getOutletId();
        if (outletId == null) {
            return null;
        }
        this.outlet = (Outlet)DataProvider.get().getObjectOf(Outlet.class, (Serializable)((Object)outletId));
        return this.outlet;
    }

    @Transient
    public void setOutlet(Outlet outlet) {
        this.outlet = outlet;
        if (outlet == null) {
            this.setOutletId(null);
        } else {
            this.setOutletId(outlet.getId());
        }
    }

    public Department getDepartment() {
        String departmentId = this.getDepartmentId();
        if (departmentId == null) {
            return null;
        }
        if (this.department == null) {
            this.department = (Department)DataProvider.get().getObjectOf(Department.class, (Serializable)((Object)this.getOutletId()));
        }
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
        if (department == null) {
            this.setDepartmentId(null);
        } else {
            this.setDepartmentId(department.getId());
        }
    }

    public SalesArea getSalesArea() {
        if (this.salesArea != null) {
            return this.salesArea;
        }
        String salesAreaId = this.getSalesAreaId();
        if (salesAreaId == null) {
            return null;
        }
        this.salesArea = DataProvider.get().getSalesArea(salesAreaId);
        return this.salesArea;
    }

    public void setSalesArea(SalesArea salesArea) {
        this.salesArea = salesArea;
        if (salesArea == null) {
            this.setSalesAreaId(null);
        } else {
            this.setSalesAreaId(salesArea.getId());
        }
    }

    public boolean isSplited() {
        return Boolean.valueOf(this.getProperty(SPLIT));
    }

    public void updateTicketItemPriceByOrderType(String orderTypeOption) {
        List<TicketItem> ticketItems = this.getTicketItems();
        OrderType orderType = this.getOrderType();
        TaxGroup taxGroup = null;
        if (ticketItems == null) {
            return;
        }
        if (orderTypeOption == "FOR HERE") {
            taxGroup = orderType.getForHereTaxGroup();
            this.addProperty(PROPERTY_FOR_HERE_AND_TO_GO, "FOR HERE");
        } else if (orderTypeOption == "TO GO") {
            taxGroup = orderType.getToGoTaxGroup();
            this.addProperty(PROPERTY_FOR_HERE_AND_TO_GO, "TO GO");
        }
        for (TicketItem ticketItem : ticketItems) {
            MenuItem.setItemTaxes(ticketItem, taxGroup, this.getOrderType());
        }
        this.calculatePrice();
    }

    public String getSplitId() {
        return this.getProperty(SPLIT_TICKET_ID);
    }

    public void setSplitOrder(int order) {
        this.addProperty("SPLIT_ORDER", String.valueOf(order));
    }

    public String getDiffWithCrntTime() {
        return DateUtil.getElapsedTime(this.getCreateDate(), new Date());
    }

    public void setDiffWithCrntTime(String diffWithCrntTime) {
    }

    public String getTableNames() {
        List<Integer> tableNumbers = this.getTableNumbers();
        if (tableNumbers == null || tableNumbers.size() <= 0) {
            return "";
        }
        List<String> tableNames = ShopTableDAO.getInstance().getTableNames(tableNumbers);
        if (tableNames != null && !tableNames.isEmpty()) {
            return tableNames.toString().replaceAll("[\\[\\]]", "");
        }
        String tabNum = "";
        if (tableNumbers != null && tableNumbers.size() > 0) {
            int count = 0;
            for (Integer tableNumber : tableNumbers) {
                tabNum = tabNum + tableNumber;
                if (count < tableNumbers.size() - 1) {
                    tabNum = tabNum + ", ";
                }
                ++count;
            }
        }
        return tabNum;
    }

    public Double getTotalAmountWithTips() {
        return super.getTotalAmount() + this.getGratuityAmount();
    }

    public void calculateRefundAmount() {
        double refundAmount = 0.0;
        double voidAmount = 0.0;
        Set<PosTransaction> transactions = this.getTransactions();
        if (transactions != null) {
            for (PosTransaction t : transactions) {
                if (!(t instanceof RefundTransaction)) continue;
                refundAmount += t.getAmount().doubleValue();
            }
        }
        this.setRefundAmount(refundAmount + voidAmount);
    }

    public String getTableNumbersDisplay() {
        List<Integer> numbers = this.getTableNumbers();
        if (numbers == null || numbers.size() <= 0) {
            return "";
        }
        String tableNumbers = numbers.toString().replaceAll("[\\[\\]]", "");
        return tableNumbers;
    }

    public boolean isPrintedToKitchenOrInventoryAdjusted() {
        for (TicketItem ticketItem : this.getTicketItems()) {
            if (ticketItem.isPrintedToKitchen().booleanValue() || ticketItem.isInventoryAdjusted()) {
                return true;
            }
            if (!ticketItem.isHasModifiers().booleanValue()) continue;
            for (TicketItemModifier modifier : ticketItem.getTicketItemModifiers()) {
                if (!modifier.isPrintedToKitchen().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean hasRefundableItem() {
        return this.refundableItem == null ? false : this.refundableItem;
    }

    public void setRefundableItem(boolean refundableItem) {
        this.refundableItem = refundableItem;
    }

    public double getTicketDiscountAmount() {
        return this.ticketDiscountAmount;
    }

    public double getItemDiscountAmount() {
        return this.itemDiscountAmount;
    }

    public double getVoidSubtotal() {
        return this.voidSubtotal;
    }

    public double getVoidTotal() {
        return this.voidTotal;
    }

    @Override
    public void setTotalAmount(Double totalAmount) {
        super.setTotalAmount(totalAmount + 0.0);
    }

    @Override
    public void setDueAmount(Double dueAmount) {
        super.setDueAmount(dueAmount + 0.0);
    }

    @Override
    public void setDiscountAmount(Double discountAmount) {
        super.setDiscountAmount(discountAmount + 0.0);
    }

    @Override
    public void setTaxAmount(Double taxAmount) {
        super.setTaxAmount(taxAmount + 0.0);
    }

    public OrderType getOrderType() {
        return DataProvider.get().getOrderTypeById(this.getOrderTypeId());
    }

    public void setOrderType(OrderType orderType) {
        String orderTypeId = null;
        if (orderType != null) {
            orderTypeId = orderType.getId();
        }
        super.setOrderTypeId(orderTypeId);
    }

    public Shift getShift() {
        return DataProvider.get().getShiftById(this.getShiftId());
    }

    public void setShift(Shift shift) {
        String shiftId = null;
        if (shift != null) {
            shiftId = shift.getId();
        }
        super.setShiftId(shiftId);
    }

    public User getOwner() {
        return DataProvider.get().getUserById(this.getOwnerId());
    }

    public void setOwner(User owner) {
        String ownerId = null;
        String ownerTypeId = null;
        if (owner != null) {
            ownerId = owner.getId();
            ownerTypeId = owner.getUserTypeId();
        }
        super.setOwnerId(ownerId);
        super.setOwnerTypeId(ownerTypeId);
    }

    public User getCashier() {
        return DataProvider.get().getUserById(this.getCashierId());
    }

    public void setCashier(User cashier) {
        String cashierId = null;
        if (cashier != null) {
            cashierId = cashier.getId();
        }
        super.setCashierId(cashierId);
    }

    public User getAssignedDriver() {
        return DataProvider.get().getUserById(this.getAssignedDriverId());
    }

    public void setAssignedDriver(User assignedDriver) {
        String assignedDriverId = null;
        if (assignedDriver != null) {
            assignedDriverId = assignedDriver.getId();
        }
        super.setAssignedDriverId(assignedDriverId);
    }

    public User getVoidedBy() {
        return DataProvider.get().getUserById(this.getVoidedById());
    }

    public void setVoidedBy(User voidBy) {
        String voidById = null;
        if (voidBy != null) {
            voidById = voidBy.getId();
        }
        super.setVoidedById(voidById);
    }

    public Terminal getTerminal() {
        return DataProvider.get().getTerminalById(this.getTerminalId());
    }

    public void setTerminal(Terminal terminal) {
        Integer terminalId = null;
        if (terminal != null) {
            terminalId = terminal.getId();
        }
        super.setTerminalId(terminalId);
    }

    public void setDiscounts(List<TicketDiscount> discounts) {
        this.discounts = discounts;
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketDiscount>();
        }
    }

    public List<TicketDiscount> getDiscounts() {
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketDiscount>();
            this.convertDiscountPropertyToList();
        }
        return this.discounts;
    }

    public void convertDiscountPropertyToList() {
        String property = super.getDiscountsProperty();
        if (StringUtils.isNotEmpty((String)property)) {
            JsonReader jsonParser = Json.createReader((Reader)new StringReader(property));
            JsonArray jsonArray = jsonParser.readArray();
            jsonParser.close();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject dObj = (JsonObject)jsonArray.get(i);
                TicketDiscount td = new TicketDiscount();
                td.setTicket(this);
                td.setDiscountId(JsonUtil.getString(dObj, TicketDiscount.PROP_DISCOUNT_ID));
                td.setName(JsonUtil.getString(dObj, TicketDiscount.PROP_NAME));
                td.setType(JsonUtil.getInt(dObj, TicketDiscount.PROP_TYPE));
                td.setAutoApply(JsonUtil.getBoolean(dObj, TicketDiscount.PROP_AUTO_APPLY));
                td.setCouponQuantity(JsonUtil.getDouble(dObj, TicketDiscount.PROP_COUPON_QUANTITY));
                td.setMinimumAmount(JsonUtil.getDouble(dObj, TicketDiscount.PROP_MINIMUM_AMOUNT));
                td.setValue(JsonUtil.getDouble(dObj, TicketDiscount.PROP_VALUE));
                td.setTotalDiscountAmount(JsonUtil.getDouble(dObj, TicketDiscount.PROP_TOTAL_DISCOUNT_AMOUNT));
                this.discounts.add(td);
            }
        }
    }

    public void addTodiscounts(TicketDiscount ticketDiscount) {
        this.discounts = this.getDiscounts();
        this.discounts.add(ticketDiscount);
        this.buildDiscounts();
    }

    public void buildDiscounts() {
        JSONArray jsonArray = new JSONArray();
        for (TicketDiscount ticketDiscount : this.discounts) {
            jsonArray.put((Object)ticketDiscount.toJson());
        }
        this.setDiscountsProperty(jsonArray.toString());
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> properties = super.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            super.setProperties(properties);
        }
        return properties;
    }

    @Override
    public String getTicketTableNumbers() {
        String ticketTableNumbers = "";
        List<Integer> tableNumbers = this.getTableNumbers();
        if (tableNumbers != null && tableNumbers.size() > 0) {
            Iterator<Integer> iterator = tableNumbers.iterator();
            while (iterator.hasNext()) {
                Integer tableNo = iterator.next();
                ticketTableNumbers = ticketTableNumbers + tableNo;
                if (!iterator.hasNext()) continue;
                ticketTableNumbers = ticketTableNumbers + ",";
            }
        }
        return ticketTableNumbers;
    }

    @Override
    public void setTicketTableNumbers(String ticketTableNumbers) {
        this.tableNumbers = new ArrayList<Integer>();
        if (StringUtils.isNotEmpty((String)ticketTableNumbers)) {
            String[] tableNums;
            for (String tbl : tableNums = ticketTableNumbers.split(",")) {
                int tableNo = POSUtil.parseInteger(tbl);
                if (tableNo <= 0) continue;
                this.tableNumbers.add(tableNo);
            }
        }
        super.setTicketTableNumbers(ticketTableNumbers);
    }

    public List<Integer> getTableNumbers() {
        return this.tableNumbers;
    }

    public void setTableNumbers(List<Integer> tableNumbers) {
        this.tableNumbers = tableNumbers;
    }

    public List<ShopTable> getTables() {
        List<Integer> tableNumbers = this.getTableNumbers();
        if (tableNumbers == null || tableNumbers.size() == 0) {
            return new ArrayList<ShopTable>(1);
        }
        if (this.tables == null) {
            this.tables = new ArrayList<ShopTable>(1);
        }
        for (Integer tableId : tableNumbers) {
            ShopTable table = new ShopTable(tableId);
            if (this.tables.contains(table) || (table = ShopTableDAO.getInstance().loadWithSeats(tableId)) == null) continue;
            this.tables.add(table);
        }
        return this.tables;
    }

    public void voidItem(TicketItem ticketItem, String voidReason, boolean itemWasted) {
        this.voidItem(ticketItem, voidReason, itemWasted, ticketItem.getQuantity());
    }

    public void voidItem(TicketItem ticketItem, String voidReason, boolean itemWasted, double quantity) {
        List<TicketItemModifier> ticketItemModifiers;
        if (StringUtils.isEmpty((String)voidReason)) {
            throw new PosException("Void reason cannot be empty.");
        }
        if (quantity == 0.0) {
            throw new PosException("Invalid quantity.");
        }
        if (quantity > Math.abs(ticketItem.getQuantity())) {
            throw new PosException("Void quantity cannot be greater than item quantity.");
        }
        TicketItem voidTicketItem = ticketItem.cloneAsNew();
        voidTicketItem.setId(null);
        voidTicketItem.setQuantity(-quantity);
        voidTicketItem.setPrintedToKitchen(false);
        voidTicketItem.setVoided(true);
        voidTicketItem.setCloudSynced(false);
        voidTicketItem.setVoidedItemId(ticketItem.getId());
        if (itemWasted) {
            voidTicketItem.setInventoryAdjustQty(-quantity);
        } else {
            voidTicketItem.setInventoryAdjustQty(0.0);
        }
        if (voidTicketItem.isHasModifiers().booleanValue() && (ticketItemModifiers = voidTicketItem.getTicketItemModifiers()) != null) {
            for (TicketItemModifier modifier : ticketItemModifiers) {
                if (modifier.isInfoOnly().booleanValue()) continue;
                modifier.setItemQuantity(-modifier.getItemQuantity().doubleValue());
            }
        }
        VoidItem voidItem = ticketItem.createVoidItem(voidReason, itemWasted, quantity);
        if (ticketItem.isComboItem().booleanValue() && voidTicketItem.getComboItems() != null) {
            for (TicketItem comboTicketItem : voidTicketItem.getComboItems()) {
                double ticketItemQuantity = ticketItem.getQuantity();
                double adjustQuantity = quantity - ticketItemQuantity;
                double toBeVoidComboQuantity = comboTicketItem.getQuantity() + adjustQuantity * comboTicketItem.getQuantity() / ticketItemQuantity;
                comboTicketItem.setQuantity(-toBeVoidComboQuantity);
                if (itemWasted) {
                    voidTicketItem.setInventoryAdjustQty(-toBeVoidComboQuantity);
                } else {
                    voidTicketItem.setInventoryAdjustQty(0.0);
                }
                VoidItem comboVoidItem = comboTicketItem.createVoidItem(voidReason, itemWasted, toBeVoidComboQuantity);
                comboTicketItem.setVoided(true);
                comboTicketItem.setVoidItem(comboVoidItem);
            }
        }
        voidTicketItem.setVoidItem(voidItem);
        this.addToticketItems(voidTicketItem);
    }

    public boolean isPriceIncludesTax() {
        return super.isTaxIncluded();
    }

    public void setPriceIncludesTax(boolean priceIncludesTax) {
        super.setTaxIncluded(priceIncludesTax);
    }

    private void populateDefaultProperties() {
        Outlet outlet;
        Department department;
        Application application = Application.getInstance();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        this.setTaxIncluded(application.isPriceIncludesTax());
        this.setTerminal(terminal);
        StoreSession storeSession = DataProvider.get().getStoreSession();
        if (storeSession != null) {
            this.setStoreSessionId(storeSession.getId());
        }
        if ((department = terminal.getDepartment()) != null) {
            this.setDepartmentId(department.getId());
        }
        if ((outlet = terminal.getOutlet()) != null) {
            this.setOutletId(outlet.getId());
        }
        this.setOwner(Application.getCurrentUser());
        this.setShift(ShiftUtil.getCurrentShift());
        this.setShouldIncludeInSales(true);
        Calendar currentTime = DateUtil.getServerTimeCalendar();
        this.setCreateDate(currentTime.getTime());
        this.setCreationHour(currentTime.get(11));
    }

    public boolean isShouldUpdateTableStatus() {
        return this.shouldUpdateTableStatus;
    }

    public void setShouldUpdateTableStatus(boolean isUpdateTable) {
        this.shouldUpdateTableStatus = isUpdateTable;
    }

    public double getToleranceAmount() {
        return this.toleranceAmount;
    }

    public double getRoundedDueAmount() {
        return this.roundedDueAmount;
    }

    public PosTransaction getBartabTransaction() {
        String bartabTransactionId = this.getProperty("bartab.transaction.id");
        if (StringUtils.isNotEmpty((String)bartabTransactionId)) {
            for (PosTransaction transaction : this.getTransactions()) {
                if (!bartabTransactionId.equals(String.valueOf(transaction.getId()))) continue;
                return transaction;
            }
        }
        for (PosTransaction transaction : this.getTransactions()) {
            if (!(transaction instanceof CreditCardTransaction) || !transaction.isAuthorizable().booleanValue() || transaction.isCaptured().booleanValue() || transaction.isVoided().booleanValue()) continue;
            return transaction;
        }
        for (PosTransaction transaction : this.getTransactions()) {
            if (!(transaction instanceof CreditCardTransaction)) continue;
            return transaction;
        }
        return null;
    }
}

