/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Course;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.OrgJsonUtil;
import java.beans.Transient;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class TicketItem
extends BaseTicketItem
implements ITicketItem {
    public static final String PROPERTY_COOKING_INSTRUCTION = "COOKING_INSTRUCTION";
    public static final String PROPERTY_TAX = "TAX";
    public static final String PROPERTY_DISCOUNT = "DISCOUNT";
    private static final long serialVersionUID = 1L;
    private transient boolean syncEdited;
    private MenuItem menuItem;
    private int tableRowNum;
    private Double quantityToShip;
    public static final int HALF = 0;
    public static final int FULL = 1;
    public static final int SHARED_FULL = 2;
    public static final int SHARED_CUSTOM = 3;
    private Boolean includeVoidQuantity;
    private VoidItem voidItem;
    private List<TicketItemCookingInstruction> cookingInstructions;
    private List<TicketItemTax> taxes;
    private List<TicketItemDiscount> discounts;
    private TicketItem parentTicketItem;
    private Integer sortOrder;

    public TicketItem() {
    }

    public TicketItem(String id) {
        super(id);
    }

    public TicketItem(Ticket ticket, String name, double unitPrice, double quantity, TicketItemTax tax) {
        this.setName(name);
        this.setUnitPrice(unitPrice);
        this.setQuantity(quantity);
        this.addTotaxes(tax);
        this.setTicket(ticket);
    }

    public TicketItem createNew() {
        if (this instanceof ModifiableTicketItem) {
            return new ModifiableTicketItem();
        }
        return new TicketItem();
    }

    public Boolean isHasModifiers() {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        return ticketItemModifiers != null && ticketItemModifiers.size() > 0;
    }

    public TicketItemModifier getSizeModifier() {
        return null;
    }

    public void setSizeModifier(TicketItemModifier sizeModifier) {
    }

    public List<TicketItemModifier> getTicketItemModifiers() {
        return null;
    }

    public void setTicketItemModifiers(List<TicketItemModifier> ticketItemModifiers) {
    }

    public void addToticketItemModifiers(TicketItemModifier ticketItemModifier) {
    }

    public TicketItem clone() {
        return (TicketItem)SerializationUtils.clone((Serializable)this);
    }

    public TicketItem cloneAsNew() {
        try {
            TicketItem newTicketItem = (TicketItem)CopyUtil.deepCopy(this);
            newTicketItem.setId(null);
            newTicketItem.setVersion(0L);
            newTicketItem.setPrintedToKitchen(false);
            newTicketItem.setInventoryAdjustQty(0.0);
            newTicketItem.setCloudSynced(false);
            newTicketItem.setHasSyncError(false);
            newTicketItem.setSeat(null);
            if (newTicketItem.getSizeModifier() != null) {
                newTicketItem.getSizeModifier().setId(null);
                newTicketItem.getSizeModifier().setPrintedToKitchen(false);
            }
            List<TicketItemModifier> ticketItemModifiers = newTicketItem.getTicketItemModifiers();
            newTicketItem.setTicketItemModifiers(null);
            if (ticketItemModifiers != null && ticketItemModifiers.size() > 0) {
                for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                    ticketItemModifier.setId(null);
                    ticketItemModifier.setPrintedToKitchen(false);
                    newTicketItem.addToticketItemModifiers(ticketItemModifier);
                }
            }
            List<TicketItem> comboItems = newTicketItem.getComboItems();
            ArrayList<TicketItem> newComboItems = new ArrayList<TicketItem>();
            if (this.isComboItem().booleanValue()) {
                ComboTicketItem comboTicketItem = (ComboTicketItem)newTicketItem;
                if (comboItems != null) {
                    for (TicketItem oldComboItem : comboItems) {
                        TicketItem clonedCombo = oldComboItem.cloneAsNew();
                        clonedCombo.setId(null);
                        clonedCombo.setParentTicketItem(comboTicketItem);
                        newComboItems.add(clonedCombo);
                    }
                    comboTicketItem.setComboItems(newComboItems);
                }
                return comboTicketItem;
            }
            newTicketItem.setComboItems(null);
            return newTicketItem;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setComboItems(Object object) {
    }

    public void setTaxes(List<TicketItemTax> taxes) {
        this.taxes = taxes;
        this.buildTaxes();
    }

    public List<TicketItemTax> getTaxes() {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
            String property = super.getTaxesProperty();
            if (StringUtils.isNotEmpty((String)property)) {
                JsonReader jsonParser = Json.createReader((Reader)new StringReader(property));
                JsonArray jsonArray = jsonParser.readArray();
                jsonParser.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    TicketItemTax tit = new TicketItemTax();
                    tit.setId(JsonUtil.getString(jsonObject, TicketItemTax.PROP_ID));
                    tit.setName(JsonUtil.getString(jsonObject, TicketItemTax.PROP_NAME));
                    tit.setRate(JsonUtil.getDouble(jsonObject, TicketItemTax.PROP_RATE));
                    tit.setTaxAmount(JsonUtil.getDouble(jsonObject, TicketItemTax.PROP_TAX_AMOUNT));
                    this.taxes.add(tit);
                }
            }
        }
        return this.taxes;
    }

    public void addTotaxes(TicketItemTax tax) {
        this.taxes = this.getTaxes();
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
        this.taxes.add(tax);
    }

    public void buildTaxes() {
        if (this.taxes == null || this.taxes.isEmpty()) {
            this.setTaxesProperty(null);
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (TicketItemTax ticketItemTax : this.taxes) {
            jsonArray.put((Object)ticketItemTax.toJson());
        }
        this.setTaxesProperty(jsonArray.toString());
    }

    public void setDiscounts(List<TicketItemDiscount> discounts) {
        this.discounts = discounts;
    }

    public List<TicketItemDiscount> getDiscounts() {
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketItemDiscount>();
            String property = super.getDiscountsProperty();
            if (StringUtils.isNotEmpty((String)property)) {
                JSONArray jsonArray = new JSONArray(property);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    TicketItemDiscount tid = new TicketItemDiscount();
                    tid.setTicketItem(this);
                    tid.setDiscountId(OrgJsonUtil.getString(jsonObject, TicketItemDiscount.PROP_DISCOUNT_ID));
                    tid.setName(OrgJsonUtil.getString(jsonObject, TicketItemDiscount.PROP_NAME));
                    tid.setType(OrgJsonUtil.getInt(jsonObject, TicketItemDiscount.PROP_TYPE));
                    tid.setAutoApply(OrgJsonUtil.getBoolean(jsonObject, TicketItemDiscount.PROP_AUTO_APPLY));
                    tid.setCouponQuantity(OrgJsonUtil.getDouble(jsonObject, TicketItemDiscount.PROP_COUPON_QUANTITY));
                    tid.setMinimumAmount(OrgJsonUtil.getDouble(jsonObject, TicketItemDiscount.PROP_MINIMUM_AMOUNT));
                    tid.setValue(OrgJsonUtil.getDouble(jsonObject, TicketItemDiscount.PROP_VALUE));
                    tid.setAmount(OrgJsonUtil.getDouble(jsonObject, TicketItemDiscount.PROP_AMOUNT));
                    this.discounts.add(tid);
                }
            }
        }
        return this.discounts;
    }

    public void addTodiscounts(TicketItemDiscount tax) {
        this.discounts = this.getDiscounts();
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketItemDiscount>();
        }
        this.discounts.add(tax);
    }

    public void buildDiscounts() {
        if (this.discounts == null || this.discounts.isEmpty()) {
            this.setDiscountsProperty(null);
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (TicketItemDiscount ticketItemDiscount : this.discounts) {
            jsonArray.put((Object)ticketItemDiscount.toJson());
        }
        this.setDiscountsProperty(jsonArray.toString());
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    public void setTableRowNum(int tableRowNum) {
        this.tableRowNum = tableRowNum;
    }

    @Override
    public boolean canAddCookingInstruction() {
        return this.isPrintedToKitchen() == false;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setCookingInstructions(List<TicketItemCookingInstruction> cookingInstructions) {
        this.cookingInstructions = cookingInstructions;
        this.buildCoookingInstructions();
    }

    public void addCookingInstructions(List<TicketItemCookingInstruction> instructions) {
        this.cookingInstructions = this.getCookingInstructions();
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>(2);
        }
        for (TicketItemCookingInstruction ticketItemCookingInstruction : instructions) {
            this.addCookingInstruction(ticketItemCookingInstruction);
        }
    }

    public void addCookingInstruction(TicketItemCookingInstruction cookingInstruction) {
        this.cookingInstructions = this.getCookingInstructions();
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>();
            return;
        }
        this.cookingInstructions.add(cookingInstruction);
        this.buildCoookingInstructions();
    }

    public void buildCoookingInstructions() {
        if (this.cookingInstructions == null || this.cookingInstructions.isEmpty()) {
            this.setCookingInstructionsProperty(null);
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (TicketItemCookingInstruction cookingIns : this.cookingInstructions) {
            jsonArray.put((Object)cookingIns.toJson());
        }
        this.setCookingInstructionsProperty(jsonArray.toString());
    }

    public void removeCookingInstruction(TicketItemCookingInstruction itemCookingInstruction) {
        List<TicketItemCookingInstruction> cookingInstructions2 = this.getCookingInstructions();
        if (cookingInstructions2 == null || cookingInstructions2.size() == 0) {
            return;
        }
        Iterator<TicketItemCookingInstruction> iterator = cookingInstructions2.iterator();
        while (iterator.hasNext()) {
            TicketItemCookingInstruction ticketItemCookingInstruction = iterator.next();
            if (ticketItemCookingInstruction.getTableRowNum() != itemCookingInstruction.getTableRowNum()) continue;
            iterator.remove();
            this.buildCoookingInstructions();
            return;
        }
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String itemId = ticketItemModifier.getItemId();
            if (itemId == null || !itemId.equals(menuModifier.getId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, int modifierType, OrderType type, Multiplier multiplier) {
        return this.addTicketItemModifier(menuModifier, modifierType, type, multiplier, 1.0);
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, int modifierType, OrderType type, Multiplier multiplier, double quantity) {
        TicketItemModifier ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticketItemModifier.setItemId(menuModifier.getId());
        ticketItemModifier.setPageItemId(menuModifier.getPageItemId());
        MenuItemModifierSpec menuItemModifierGroup = menuModifier.getMenuItemModifierGroup();
        if (menuItemModifierGroup != null) {
            ticketItemModifier.setGroupId(menuItemModifierGroup.getId());
        }
        ticketItemModifier.setItemQuantity(quantity);
        ticketItemModifier.setName(menuModifier.getDisplayName());
        double price = menuModifier.getPriceForMultiplier(multiplier);
        if (multiplier != null) {
            ticketItemModifier.setMultiplierName(multiplier.getId());
            ticketItemModifier.setName(multiplier.getTicketPrefix() + " " + menuModifier.getDisplayName());
        }
        ticketItemModifier.setUnitPrice(price);
        ticketItemModifier.setTaxes(menuModifier.getTaxByOrderType(type));
        ticketItemModifier.setModifierType(modifierType);
        ticketItemModifier.setShouldPrintToKitchen(menuModifier.isShouldPrintToKitchen());
        ticketItemModifier.setTicketItem(this);
        this.addToticketItemModifiers(ticketItemModifier);
        return ticketItemModifier;
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, boolean addOn) {
        TicketItemModifier ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticketItemModifier.setItemId(menuModifier.getId());
        MenuItemModifierSpec menuItemModifierGroup = menuModifier.getMenuItemModifierGroup();
        if (menuItemModifierGroup != null) {
            ticketItemModifier.setGroupId(menuItemModifierGroup.getId());
        }
        ticketItemModifier.setItemCount(1);
        ticketItemModifier.setName(menuModifier.getDisplayName());
        if (addOn) {
            ticketItemModifier.setUnitPrice(menuModifier.getExtraPrice());
            ticketItemModifier.setModifierType(3);
        } else {
            ticketItemModifier.setUnitPrice(menuModifier.getPrice());
            ticketItemModifier.setModifierType(1);
        }
        ticketItemModifier.setTaxes(menuModifier.getTaxByOrderType(ticketItemModifier.getTicketItem().getTicket().getOrderType()));
        ticketItemModifier.setShouldPrintToKitchen(menuModifier.isShouldPrintToKitchen());
        ticketItemModifier.setTicketItem(this);
        this.addToticketItemModifiers(ticketItemModifier);
        return ticketItemModifier;
    }

    public void updateModifiersUnitPrice(double defaultSellPortion) {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
                ticketItemModifier.setUnitPrice(ticketItemModifier.getUnitPrice() * defaultSellPortion / 100.0);
            }
        }
    }

    public boolean contains(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        int count = 0;
        if (ticketItemModifiers != null) {
            for (TicketItemModifier ticketItemModifier2 : ticketItemModifiers) {
                if (ticketItemModifier2.isInfoOnly().booleanValue() || !ticketItemModifier.getName().trim().equals(ticketItemModifier2.getName().trim())) continue;
                ++count;
            }
        }
        return count > 1;
    }

    public TicketItemModifier removeTicketItemModifier(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        if (ticketItemModifiers == null) {
            return ticketItemModifier;
        }
        Iterator<TicketItemModifier> iter = ticketItemModifiers.iterator();
        while (iter.hasNext()) {
            TicketItemModifier oldTicketItemModifier = iter.next();
            if (!oldTicketItemModifier.getItemId().equals(ticketItemModifier.getItemId()) || oldTicketItemModifier.getModifierType() != ticketItemModifier.getModifierType()) continue;
            iter.remove();
            return oldTicketItemModifier;
        }
        return ticketItemModifier;
    }

    public void calculatePrice() {
        BigDecimal unitPrice = NumberUtil.convertToBigDecimal(this.getUnitPrice());
        BigDecimal itemQuantity = NumberUtil.convertToBigDecimal(this.getQuantity());
        BigDecimal subtotalWithoutModifiers = NumberUtil.round(unitPrice.multiply(itemQuantity));
        BigDecimal discountWithoutModifiers = this.calculateDiscount(subtotalWithoutModifiers);
        BigDecimal serviceCharge = this.calculateServiceCharge(subtotalWithoutModifiers);
        BigDecimal taxWithoutModifiers = null;
        taxWithoutModifiers = this.isTaxOnServiceCharge() != false ? this.calculateTax(subtotalWithoutModifiers.subtract(discountWithoutModifiers).add(serviceCharge)) : this.calculateTax(subtotalWithoutModifiers.subtract(discountWithoutModifiers));
        PosLog.debug(this.getClass(), String.format("Item %s, unit price: %s, quantity: %s, tax rate: %s", this.getName(), unitPrice, this.getQuantity(), this.getTotalTaxRate()));
        PosLog.debug(this.getClass(), String.format("Subtotal without modifiers: %s, discount without modifiers: %s, tax without modifiers: %s", subtotalWithoutModifiers, discountWithoutModifiers, taxWithoutModifiers));
        BigDecimal modifierSubtotal = NumberUtil.convertToBigDecimal("0");
        BigDecimal modifierDiscount = NumberUtil.convertToBigDecimal("0");
        BigDecimal modifierTax = NumberUtil.convertToBigDecimal("0");
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            HashSet<String> averagePricedModifierList = new HashSet<String>();
            for (TicketItemModifier modifier : ticketItemModifiers) {
                if (modifier.isInfoOnly().booleanValue()) continue;
                modifier.calculatePrice();
                if (modifier.isShouldSectionWisePrice().booleanValue() && averagePricedModifierList.contains(modifier.getItemId())) continue;
                modifierSubtotal = modifierSubtotal.add(NumberUtil.convertToBigDecimal(modifier.getSubTotalAmount()));
                modifierDiscount = modifierDiscount.add(NumberUtil.convertToBigDecimal(modifier.getDiscountAmount()));
                modifierTax = modifierTax.add(NumberUtil.convertToBigDecimal(modifier.getTaxAmount()));
                serviceCharge = serviceCharge.add(NumberUtil.convertToBigDecimal(modifier.getServiceCharge()));
                averagePricedModifierList.add(modifier.getItemId());
            }
        }
        BigDecimal subtotal = NumberUtil.round(subtotalWithoutModifiers.add(modifierSubtotal));
        BigDecimal discount = NumberUtil.round(discountWithoutModifiers.add(modifierDiscount));
        BigDecimal tax = NumberUtil.round(taxWithoutModifiers.add(modifierTax));
        BigDecimal total = NumberUtil.convertToBigDecimal("0");
        BigDecimal totalWithoutModifiers = NumberUtil.convertToBigDecimal("0");
        if (this.isTaxIncluded().booleanValue()) {
            total = subtotal.subtract(discount).add(serviceCharge);
            totalWithoutModifiers = subtotalWithoutModifiers.subtract(discountWithoutModifiers).add(serviceCharge);
        } else {
            total = subtotal.subtract(discount).add(tax).add(serviceCharge);
            totalWithoutModifiers = subtotalWithoutModifiers.subtract(discountWithoutModifiers).add(taxWithoutModifiers).add(serviceCharge);
        }
        total = NumberUtil.round(total);
        PosLog.debug(this.getClass(), String.format("Subtotal with modifiers: %s, discount with modifiers: %s, tax with modifiers: %s", subtotal, discount, tax));
        this.setSubtotalAmount(subtotal.doubleValue());
        this.setSubtotalAmountWithoutModifiers(subtotalWithoutModifiers.doubleValue());
        this.setDiscountAmount(discount.doubleValue());
        this.setDiscountWithoutModifiers(discountWithoutModifiers.doubleValue());
        this.setTaxAmount(tax.doubleValue());
        this.setTaxAmountWithoutModifiers(taxWithoutModifiers.doubleValue());
        this.setServiceCharge(serviceCharge.doubleValue());
        this.setTotalAmount(total.doubleValue());
        this.setTotalAmountWithoutModifiers(totalWithoutModifiers.doubleValue());
        this.setAdjustedUnitPrice(unitPrice.doubleValue());
        this.setAdjustedDiscount(discount.doubleValue());
        this.setAdjustedDiscountWithoutModifiers(discountWithoutModifiers.doubleValue());
        this.setAdjustedSubtotal(subtotal.doubleValue());
        this.setAdjustedSubtotalWithoutModifiers(subtotalWithoutModifiers.doubleValue());
        this.setAdjustedTax(tax.doubleValue());
        this.setAdjustedTaxWithoutModifiers(taxWithoutModifiers.doubleValue());
        this.setAdjustedTotal(total.doubleValue());
        this.setAdjustedTotalWithoutModifiers(totalWithoutModifiers.doubleValue());
    }

    public void calculateAdjustedPrice() {
        BigDecimal subtotalAfterDiscount;
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return;
        }
        BigDecimal ticketSubtotalAmount = NumberUtil.convertToBigDecimal(ticket.getSubtotalAmountWithVoidItems());
        BigDecimal ticketDiscountAmount = NumberUtil.convertToBigDecimal(ticket.getTicketDiscountAmount());
        BigDecimal itemDiscountAmount = NumberUtil.convertToBigDecimal(ticket.getItemDiscountAmount());
        BigDecimal ticketSubtotalAfterItemDiscount = ticketSubtotalAmount.subtract(itemDiscountAmount);
        BigDecimal ticketSubtotalAfterAllDiscount = ticketSubtotalAfterItemDiscount.subtract(ticketDiscountAmount);
        BigDecimal adjustedSubtotalWithoutModifiers = subtotalAfterDiscount = NumberUtil.convertToBigDecimal(this.getSubtotalAmountWithoutModifiers()).subtract(NumberUtil.convertToBigDecimal(this.getDiscountWithoutModifiers()));
        if (ticketSubtotalAfterItemDiscount.compareTo(BigDecimal.ZERO) != 0) {
            adjustedSubtotalWithoutModifiers = subtotalAfterDiscount.multiply(ticketSubtotalAfterAllDiscount).divide(ticketSubtotalAfterItemDiscount, 4, RoundingMode.HALF_UP);
        }
        BigDecimal adjustedTaxWithoutModifiers = NumberUtil.round(this.calculateTax(adjustedSubtotalWithoutModifiers));
        BigDecimal itemQuantity = NumberUtil.convertToBigDecimal(this.getQuantity());
        BigDecimal adjustedUnitPrice = adjustedSubtotalWithoutModifiers.divide(itemQuantity, 4, RoundingMode.HALF_UP);
        BigDecimal modifierAdjustedSubtotal = NumberUtil.convertToBigDecimal("0");
        BigDecimal modifierAdjustedDiscount = NumberUtil.convertToBigDecimal("0");
        BigDecimal modifierAdjustedTax = NumberUtil.convertToBigDecimal("0");
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            HashSet<String> averagePricedModifierList = new HashSet<String>();
            for (TicketItemModifier modifier : ticketItemModifiers) {
                if (modifier.isInfoOnly().booleanValue()) continue;
                modifier.calculateAdjustedPrice();
                if (!modifier.isShouldSectionWisePrice().booleanValue() && averagePricedModifierList.contains(modifier.getItemId())) continue;
                modifierAdjustedSubtotal = modifierAdjustedSubtotal.add(itemQuantity.multiply(NumberUtil.convertToBigDecimal(modifier.getAdjustedSubtotal()).abs()));
                modifierAdjustedDiscount = modifierAdjustedDiscount.add(itemQuantity.multiply(NumberUtil.convertToBigDecimal(modifier.getAdjustedDiscount()).abs()));
                modifierAdjustedTax = modifierAdjustedTax.add(itemQuantity.multiply(NumberUtil.convertToBigDecimal(modifier.getAdjustedTax()).abs()));
                averagePricedModifierList.add(modifier.getItemId());
            }
        }
        BigDecimal adjustedSubtotal = NumberUtil.round(adjustedSubtotalWithoutModifiers.add(modifierAdjustedSubtotal));
        BigDecimal myAdjustedDiscountWithoutModifiers = NumberUtil.round(NumberUtil.convertToBigDecimal(this.getSubtotalAmountWithoutModifiers()).subtract(adjustedSubtotalWithoutModifiers));
        BigDecimal adjustedDiscount = NumberUtil.round(myAdjustedDiscountWithoutModifiers.add(modifierAdjustedDiscount));
        BigDecimal adjustedTax = NumberUtil.round(adjustedTaxWithoutModifiers.add(modifierAdjustedTax));
        BigDecimal adjustedTotal = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal adjustedTotalWithoutModifiers = NumberUtil.convertToBigDecimal(0.0);
        if (this.isTaxIncluded().booleanValue()) {
            adjustedTotal = adjustedSubtotal.add(NumberUtil.convertToBigDecimal(this.getServiceCharge()));
            adjustedTotalWithoutModifiers = adjustedSubtotalWithoutModifiers.add(NumberUtil.convertToBigDecimal(this.getServiceCharge()));
        } else {
            adjustedTotal = adjustedSubtotal.add(adjustedTax).add(NumberUtil.convertToBigDecimal(this.getServiceCharge()));
            adjustedTotalWithoutModifiers = adjustedSubtotalWithoutModifiers.add(adjustedTaxWithoutModifiers).add(NumberUtil.convertToBigDecimal(this.getServiceCharge()));
        }
        adjustedTotal = NumberUtil.round(adjustedTotal);
        this.setAdjustedUnitPrice(adjustedUnitPrice.doubleValue());
        this.setAdjustedDiscount(adjustedDiscount.doubleValue());
        this.setAdjustedDiscountWithoutModifiers(myAdjustedDiscountWithoutModifiers.doubleValue());
        this.setAdjustedSubtotal(adjustedSubtotal.doubleValue());
        this.setAdjustedSubtotalWithoutModifiers(adjustedSubtotalWithoutModifiers.doubleValue());
        this.setAdjustedTax(adjustedTax.doubleValue());
        this.setAdjustedTaxWithoutModifiers(adjustedTaxWithoutModifiers.doubleValue());
        this.setAdjustedTotal(adjustedTotal.doubleValue());
        this.setAdjustedTotalWithoutModifiers(adjustedTotalWithoutModifiers.doubleValue());
    }

    public BigDecimal calculateServiceCharge(BigDecimal subtotalAmount) {
        if (!this.isServiceChargeApplicable().booleanValue() || this.getServiceChargeRate() == 0.0) {
            return new BigDecimal("0");
        }
        BigDecimal serviceChargeRate = NumberUtil.convertToBigDecimal(this.getServiceChargeRate() / 100.0);
        return NumberUtil.round(subtotalAmount.multiply(serviceChargeRate));
    }

    public boolean isMergable(TicketItem otherItem, boolean merge) {
        if (this.isTreatAsSeat().booleanValue() || otherItem.isTreatAsSeat().booleanValue()) {
            return false;
        }
        if (this.isFractionalUnit().booleanValue() || otherItem.isFractionalUnit().booleanValue()) {
            return false;
        }
        if (this.getQuantity() > 0.0 && otherItem.getQuantity() < 0.0 || this.getQuantity() < 0.0 && otherItem.getQuantity() > 0.0) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.getMenuItemId()) || StringUtils.isEmpty((String)otherItem.getMenuItemId())) {
            return false;
        }
        if (this.hasCookingInstructions() || otherItem.hasCookingInstructions()) {
            return false;
        }
        if (!this.getMenuItemId().equals(otherItem.getMenuItemId())) {
            return false;
        }
        if (!this.getUnitPrice().equals(otherItem.getUnitPrice())) {
            return false;
        }
        if (this.getSeatNumber() != otherItem.getSeatNumber()) {
            return false;
        }
        if (!this.isHasModifiers().booleanValue() && !otherItem.isHasModifiers().booleanValue()) {
            return true;
        }
        return this.isMergableModifiers(this.getTicketItemModifiers(), otherItem.getTicketItemModifiers(), merge);
    }

    public boolean isMergableModifiers(List<TicketItemModifier> thisModifiers, List<TicketItemModifier> thatModifiers, boolean merge) {
        if (thatModifiers == null) {
            return true;
        }
        if (thisModifiers.size() != thatModifiers.size()) {
            return false;
        }
        Comparator<TicketItemModifier> comparator = new Comparator<TicketItemModifier>(){

            @Override
            public int compare(TicketItemModifier o1, TicketItemModifier o2) {
                return o1.getItemId().compareTo(o2.getItemId());
            }
        };
        Collections.sort(thisModifiers, comparator);
        Collections.sort(thatModifiers, comparator);
        Iterator<TicketItemModifier> thisIterator = thisModifiers.iterator();
        Iterator<TicketItemModifier> thatIterator = thatModifiers.iterator();
        while (thisIterator.hasNext()) {
            TicketItemModifier next2;
            TicketItemModifier next1 = thisIterator.next();
            if (comparator.compare(next1, next2 = thatIterator.next()) != 0) {
                return false;
            }
            if (!merge) continue;
            next1.merge(next2);
        }
        return true;
    }

    public void merge(TicketItem otherItem) {
        if (!this.isHasModifiers().booleanValue() && !otherItem.isHasModifiers().booleanValue()) {
            this.setQuantity(this.getQuantity() + otherItem.getQuantity());
            return;
        }
        if (this.isMergable(otherItem, true)) {
            this.setQuantity(this.getQuantity() + otherItem.getQuantity());
        }
    }

    public boolean hasCookingInstructions() {
        return this.getCookingInstructions() != null && this.getCookingInstructions().size() > 0;
    }

    public BigDecimal calculateDiscount(BigDecimal subtotalAmount) {
        BigDecimal discount = NumberUtil.convertToBigDecimal(0.0);
        List<TicketItemDiscount> discounts = this.getDiscounts();
        if (discounts != null) {
            for (TicketItemDiscount ticketItemDiscount : discounts) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    discount = discount.add(NumberUtil.convertToBigDecimal(ticketItemDiscount.calculateDiscount(subtotalAmount.doubleValue())));
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                double discountPercentage = Math.abs(ticketItemDiscount.getValue() * 100.0 / subtotalAmount.doubleValue());
                TicketItemDiscount percentDiscount = new TicketItemDiscount();
                percentDiscount.setType(1);
                percentDiscount.setValue(discountPercentage);
                percentDiscount.setTicketItem(this);
                percentDiscount.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
                discount = discount.add(NumberUtil.convertToBigDecimal(percentDiscount.calculateDiscount(subtotalAmount.doubleValue())));
            }
        }
        this.buildDiscounts();
        if (discount.compareTo(subtotalAmount.abs()) > 0) {
            return subtotalAmount;
        }
        return NumberUtil.round(discount);
    }

    public double getAmountByType(TicketItemDiscount discount) {
        switch (discount.getType()) {
            case 0: {
                return discount.getValue();
            }
            case 1: {
                return discount.getValue() * this.getUnitPrice() / 100.0;
            }
        }
        return 0.0;
    }

    private BigDecimal calculateTax(BigDecimal subtotal) {
        BigDecimal totalTaxAmount = NumberUtil.convertToBigDecimal("0");
        List<TicketItemTax> taxList = this.getTaxes();
        if (taxList != null) {
            if (this.isTaxIncluded().booleanValue()) {
                BigDecimal taxRatePercentage = NumberUtil.convertToBigDecimal(0.0);
                for (TicketItemTax ticketItemTax : taxList) {
                    taxRatePercentage = taxRatePercentage.add(NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_EVEN));
                }
                if (taxRatePercentage.compareTo(NumberUtil.convertToBigDecimal("0")) == 0) {
                    return totalTaxAmount;
                }
                BigDecimal totalTaxRatePercentage = taxRatePercentage.add(NumberUtil.convertToBigDecimal(1.0));
                BigDecimal actualPrice = subtotal.divide(totalTaxRatePercentage, 4, RoundingMode.HALF_EVEN);
                for (TicketItemTax ticketItemTax : taxList) {
                    taxRatePercentage = NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_EVEN);
                    BigDecimal tax = actualPrice.multiply(taxRatePercentage);
                    ticketItemTax.setTaxAmount(tax.doubleValue());
                    totalTaxAmount = totalTaxAmount.add(tax);
                }
            } else {
                for (TicketItemTax ticketItemTax : taxList) {
                    BigDecimal taxRatePercentage = NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_EVEN);
                    if (taxRatePercentage.compareTo(NumberUtil.convertToBigDecimal("0")) == 0) continue;
                    BigDecimal tax = subtotal.multiply(taxRatePercentage);
                    ticketItemTax.setTaxAmount(tax.doubleValue());
                    totalTaxAmount = totalTaxAmount.add(tax);
                }
            }
        }
        this.buildTaxes();
        return NumberUtil.round(totalTaxAmount);
    }

    public double getTotalTaxRate() {
        List<TicketItemTax> ticketItemTaxes = this.getTaxes();
        if (ticketItemTaxes == null || ticketItemTaxes.isEmpty()) {
            return 0.0;
        }
        double totalTaxRate = 0.0;
        for (TicketItemTax tax : ticketItemTaxes) {
            totalTaxRate += tax.getRate().doubleValue();
        }
        return totalTaxRate;
    }

    @Override
    public String getNameDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return this.getName();
        }
        String displayName = "";
        if (this.getQuantity() == -1.0) {
            displayName = displayName + "-";
        } else if (Math.abs(this.getQuantity()) > 1.0) {
            displayName = displayName + this.getItemQuantityDisplay() + "x ";
        }
        if (this.isComboItem().booleanValue()) {
            List<TicketItem> comboItems = this.getComboItems();
            if (comboItems != null && !comboItems.isEmpty()) {
                displayName = displayName + this.getName();
                displayName = displayName + "\n";
                Iterator<TicketItem> iterator = comboItems.iterator();
                while (iterator.hasNext()) {
                    TicketItem item = iterator.next();
                    displayName = displayName + "   #" + NumberUtil.trimDecilamIfNotNeeded(item.getQuantity(), true) + " " + item.getName();
                    List<TicketItemModifier> ticketItemModifiers = item.getTicketItemModifiers();
                    if (iterator.hasNext() || ticketItemModifiers != null) {
                        displayName = displayName + "\n";
                    }
                    if (ticketItemModifiers == null || ticketItemModifiers.isEmpty()) continue;
                    for (TicketItemModifier modifier : ticketItemModifiers) {
                        displayName = displayName + "    " + modifier.getNameDisplay();
                        if (!iterator.hasNext()) continue;
                        displayName = displayName + "\n";
                    }
                }
                return displayName;
            }
        } else if (this.getSizeModifier() != null) {
            displayName = displayName + this.getSizeModifier().getNameDisplay().replaceAll(" -- ", "") + " " + this.getName();
            return displayName;
        }
        displayName = displayName + this.getName();
        return displayName;
    }

    @Override
    public Double getUnitPriceDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        return this.getUnitPrice();
    }

    @Override
    public String getItemQuantityDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return "";
        }
        String itemQuantity = NumberUtil.trimDecilamIfNotNeeded(this.getQuantity(), true);
        if (this.isFractionalUnit().booleanValue()) {
            return itemQuantity + this.getUnitName();
        }
        return itemQuantity;
    }

    @Override
    public Double getTaxAmountWithoutModifiersDisplay() {
        return this.getTaxAmountWithoutModifiers();
    }

    @Override
    public Double getTotalAmountWithoutModifiersDisplay() {
        return this.getTotalAmountWithoutModifiers();
    }

    @Override
    public Double getSubTotalAmountWithoutModifiersDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        return this.getSubtotalAmountWithoutModifiers();
    }

    @Override
    public String getItemCode() {
        return String.valueOf(this.getMenuItemId());
    }

    public List<Printer> getPrinters(OrderType orderType) {
        PrinterGroup printerGroup = this.getPrinterGroup();
        ArrayList<Printer> printerAll = new ArrayList<Printer>();
        PosPrinters printers = DataProvider.get().getPrinters();
        printerAll.addAll(printers.getStickerPrinters());
        if (printers.isPrintToKds()) {
            printerAll.add(VirtualPrinter.getKdsPrinter());
        }
        if (printerGroup == null) {
            printerAll.addAll(printers.getKitchenPrinters());
            return printerAll;
        }
        List<String> printerNames = printerGroup.getPrinterNames();
        List<Printer> kitchenPrinters = printers.getKitchenPrinters();
        for (Printer printer : kitchenPrinters) {
            if (!printerNames.contains(printer.getVirtualPrinter().getName())) continue;
            printerAll.add(printer);
        }
        return printerAll;
    }

    @Override
    public boolean canAddDiscount() {
        return true;
    }

    @Override
    public boolean canVoid() {
        return true;
    }

    @Override
    public boolean canAddAdOn() {
        return true;
    }

    public MenuItem getMenuItem() {
        if (this.menuItem == null) {
            String itemId = this.getMenuItemId();
            if (StringUtils.isEmpty((String)itemId)) {
                return null;
            }
            this.menuItem = MenuItemDAO.getInstance().loadInitialized(itemId);
        }
        return this.menuItem;
    }

    @Transient
    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        String menuItemId = null;
        if (menuItem != null) {
            menuItemId = menuItem.getId();
        }
        super.setMenuItemId(menuItemId);
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getKitchenStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setKitchenStatus(kitchenStatus.name());
    }

    @Override
    public String getUnitName() {
        if (super.getUnitName() == null) {
            return "";
        }
        return super.getUnitName();
    }

    public Double getQuantityToShip() {
        return this.quantityToShip == null ? 0.0 : this.quantityToShip;
    }

    public void setQuantityToShip(Double shipQuantity) {
        this.quantityToShip = shipQuantity;
    }

    @Override
    public Double getSubTotalAmountDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        return this.getSubtotalAmount();
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, Multiplier multiplier) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String itemId = ticketItemModifier.getItemId();
            if (itemId == null || !itemId.equals(menuModifier.getId()) || !multiplier.getId().equals(ticketItemModifier.getMultiplierName())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, String sectionName) {
        return this.findTicketItemModifierFor(menuModifier, sectionName, null);
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, String sectionName, Multiplier multiplier) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String itemId = ticketItemModifier.getItemId();
            if (multiplier != null && itemId != null && itemId.equals(menuModifier.getId()) && sectionName != null && sectionName.equals(ticketItemModifier.getSectionName()) && multiplier != null && multiplier.getId().equals(ticketItemModifier.getMultiplierName())) {
                return ticketItemModifier;
            }
            if (itemId == null || !itemId.equals(menuModifier.getId()) || sectionName == null || !sectionName.equals(ticketItemModifier.getSectionName())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public int countModifierFromGroup(MenuItemModifierSpec menuItemModifierGroup) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return 0;
        }
        int modifierFromGroupCount = 0;
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String groupId = ticketItemModifier.getGroupId();
            if (groupId == null || !groupId.equals(menuItemModifierGroup.getId())) continue;
            modifierFromGroupCount = (int)((double)modifierFromGroupCount + ticketItemModifier.getItemQuantity());
        }
        return modifierFromGroupCount;
    }

    public boolean requiredModifiersAdded(MenuItemModifierSpec menuItemModifierGroup) {
        int minQuantity = menuItemModifierGroup.getMinQuantity();
        if (minQuantity == 0) {
            return true;
        }
        return this.countModifierFromGroup(menuItemModifierGroup) >= minQuantity;
    }

    public boolean deleteTicketItemModifier(TicketItemModifier ticketItemModifierToRemove) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return false;
        }
        Iterator<TicketItemModifier> iterator = modifiers.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier = iterator.next();
            if (ticketItemModifier != ticketItemModifierToRemove) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean deleteTicketItemModifierByName(TicketItemModifier ticketItemModifierToRemove) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return false;
        }
        Iterator<TicketItemModifier> iterator = modifiers.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier = iterator.next();
            if (!ticketItemModifier.getName().equals(ticketItemModifierToRemove.getName())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void setPizzaSectionMode(PIZZA_SECTION_MODE pizzaSectionMode) {
        this.setPizzaSectionModeType(pizzaSectionMode.getValue());
    }

    public PIZZA_SECTION_MODE getPizzaSectionMode() {
        return PIZZA_SECTION_MODE.from(this.getPizzaSectionModeType());
    }

    public TicketItemModifier findTicketItemModifierByPageItem(MenuModifier menuModifier) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String itemId = ticketItemModifier.getPageItemId();
            if (itemId == null || !itemId.equals(menuModifier.getPageItemId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier findTicketItemComboModifierFor(MenuModifier menuModifier) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String itemId = ticketItemModifier.getItemId();
            if (itemId == null || !itemId.equals(menuModifier.getId()) || ticketItemModifier.getModifierType() != 3) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier removeTicketItemModifierByPageItem(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        if (ticketItemModifiers == null) {
            return ticketItemModifier;
        }
        Iterator<TicketItemModifier> iter = ticketItemModifiers.iterator();
        while (iter.hasNext()) {
            TicketItemModifier oldTicketItemModifier = iter.next();
            String pageItemId = oldTicketItemModifier.getPageItemId();
            if (pageItemId == null || !pageItemId.equals(ticketItemModifier.getPageItemId()) || oldTicketItemModifier.getModifierType() != ticketItemModifier.getModifierType()) continue;
            iter.remove();
            return oldTicketItemModifier;
        }
        return ticketItemModifier;
    }

    public void removeTicketItemDiscount(TicketItemDiscount itemDiscount) {
        List<TicketItemDiscount> discounts = this.getDiscounts();
        if (discounts == null) {
            return;
        }
        Iterator<TicketItemDiscount> iterator = discounts.iterator();
        while (iterator.hasNext()) {
            TicketItemDiscount ticketItemDiscount = iterator.next();
            if (ticketItemDiscount.getTableRowNum() != itemDiscount.getTableRowNum()) continue;
            iterator.remove();
            return;
        }
    }

    public boolean isInventoryAdjusted() {
        return this.getQuantity().doubleValue() == this.getInventoryAdjustQty().doubleValue();
    }

    public Boolean isIncludeVoidQuantity() {
        return this.includeVoidQuantity == null ? false : this.includeVoidQuantity;
    }

    public void setIncludeVoidQuantity(Boolean includeVoidQuantity) {
        this.includeVoidQuantity = includeVoidQuantity;
    }

    public void setVoidItem(VoidItem voidItem) {
        this.voidItem = voidItem;
    }

    public VoidItem getVoidItem() {
        return this.voidItem;
    }

    public void markVoided(String voidReason, boolean itemWasted, double quantity) {
        this.setVoided(true);
        this.setQuantity(-quantity);
        this.setVoidItem(this.createVoidItem(voidReason, itemWasted, quantity));
    }

    public VoidItem createVoidItem(String voidReason, boolean wasted, double quantity) {
        TicketItem clonedTicket = this.cloneAsNew();
        clonedTicket.setQuantity(quantity);
        clonedTicket.calculatePrice();
        VoidItem newVoidItem = new VoidItem();
        if (clonedTicket.getTicket() != null) {
            newVoidItem.setTicketId(clonedTicket.getTicket().getId());
        }
        newVoidItem.setVoidReason(voidReason);
        newVoidItem.setItemId(clonedTicket.getId());
        newVoidItem.setMenuItemId(clonedTicket.getMenuItemId());
        newVoidItem.setMenuItemName(clonedTicket.getName());
        newVoidItem.setUnitPrice(clonedTicket.getUnitPrice());
        newVoidItem.setQuantity(quantity);
        newVoidItem.setItemWasted(wasted);
        newVoidItem.setVoidDate(new Date());
        newVoidItem.setModifier(false);
        newVoidItem.setPrinterGroup(clonedTicket.getPrinterGroup());
        User currentUser = Application.getCurrentUser();
        newVoidItem.setVoidByUser(currentUser);
        newVoidItem.setTerminal(Application.getInstance().getTerminal());
        if (currentUser.getActiveDrawerPullReport() != null) {
            newVoidItem.setCashDrawerId(currentUser.getActiveDrawerPullReport().getId());
        }
        newVoidItem.setTaxAmount(clonedTicket.getTaxAmountWithoutModifiers());
        newVoidItem.setTotalPrice(clonedTicket.getAdjustedTotalWithoutModifiers());
        double ticketItemQuantity = clonedTicket.getQuantity();
        double voidItemQuantity = newVoidItem.getQuantity();
        ArrayList<VoidItem> modifierVoidItems = new ArrayList<VoidItem>();
        if (clonedTicket.isHasModifiers().booleanValue()) {
            for (TicketItemModifier ticketItemModifier : clonedTicket.getTicketItemModifiers()) {
                VoidItem modifierVoidItem = new VoidItem();
                double voidModifierquantity = ticketItemModifier.getItemQuantity() * voidItemQuantity / ticketItemQuantity;
                if (!(voidModifierquantity > 0.0)) continue;
                String tfvoidItemReason = newVoidItem.getVoidReason();
                if (!StringUtils.isEmpty((String)tfvoidItemReason)) {
                    modifierVoidItem.setVoidReason(tfvoidItemReason);
                }
                modifierVoidItem.setModifierId(ticketItemModifier.getItemId());
                modifierVoidItem.setItemId(ticketItemModifier.getId());
                modifierVoidItem.setMenuItemName(ticketItemModifier.getNameDisplay());
                modifierVoidItem.setUnitPrice(ticketItemModifier.getUnitPrice());
                modifierVoidItem.setQuantity(voidModifierquantity);
                modifierVoidItem.setItemWasted(newVoidItem.isItemWasted());
                modifierVoidItem.setVoidDate(new Date());
                modifierVoidItem.setModifier(true);
                modifierVoidItem.setVoidByUser(currentUser);
                modifierVoidItem.setTerminal(Application.getInstance().getTerminal());
                modifierVoidItem.setCashDrawerId(currentUser.getActiveDrawerPullReport().getId());
                modifierVoidItem.setTaxAmount(ticketItemModifier.getTaxAmount());
                modifierVoidItem.setTotalPrice(ticketItemModifier.getAdjustedSubtotal() + ticketItemModifier.getTaxAmount());
                modifierVoidItem.setTicketId(newVoidItem.getTicketId());
                modifierVoidItems.add(modifierVoidItem);
            }
        }
        newVoidItem.setVoidModifiers(modifierVoidItems);
        return newVoidItem;
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public boolean isRefundable() {
        return true;
    }

    public List<TicketItemCookingInstruction> getCookingInstructions() {
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>();
            String property = super.getCookingInstructionsProperty();
            if (StringUtils.isNotEmpty((String)property)) {
                JsonReader jsonParser = Json.createReader((Reader)new StringReader(property));
                JsonArray jsonArray = jsonParser.readArray();
                jsonParser.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    TicketItemCookingInstruction tic = new TicketItemCookingInstruction();
                    tic.setDescription(JsonUtil.getString(jsonObject, TicketItemCookingInstruction.PROP_DESCRIPTION));
                    tic.setPrintedToKitchen(JsonUtil.getBoolean(jsonObject, TicketItemCookingInstruction.PROP_PRINTED_TO_KITCHEN));
                    tic.setSaved(JsonUtil.getBoolean(jsonObject, TicketItemCookingInstruction.PROP_SAVED));
                    this.cookingInstructions.add(tic);
                }
            }
        }
        return this.cookingInstructions;
    }

    public PrinterGroup getPrinterGroup() {
        return DataProvider.get().getPrinterGroupById(this.getPrinterGroupId());
    }

    public void setPrinterGroup(PrinterGroup printerGroup) {
        String printerGroupId = null;
        if (printerGroup != null) {
            printerGroupId = printerGroup.getId();
        }
        super.setPrinterGroupId(printerGroupId);
    }

    public TicketItem getParentTicketItem() {
        return this.parentTicketItem;
    }

    public void setParentTicketItem(TicketItem parentTicketItem) {
        this.parentTicketItem = parentTicketItem;
    }

    public List<TicketItem> getComboItems() {
        return null;
    }

    public void addTocomboItems(TicketItem item) {
    }

    public Integer getSortOrder() {
        if (this.sortOrder != null) {
            return this.sortOrder;
        }
        if (StringUtils.isEmpty((String)this.getCourseId())) {
            return 0;
        }
        Course course = DataProvider.get().getCourse(this.getCourseId());
        if (course != null) {
            return course.getSortOrder();
        }
        return 0;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean isSyncEdited() {
        return this.syncEdited;
    }

    public void setSyncEdited(boolean syncEdited) {
        this.syncEdited = syncEdited;
    }

    public static enum PIZZA_SECTION_MODE {
        FULL(1),
        HALF(2),
        QUARTER(3);

        private final int value;

        private PIZZA_SECTION_MODE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PIZZA_SECTION_MODE from(int value) {
            if (value == 2) {
                return HALF;
            }
            if (value == 3) {
                return QUARTER;
            }
            return FULL;
        }

        public String toString() {
            return this.name();
        }
    }
}

