/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.base.BaseTicketItemDiscount;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.util.DiscountUtil;
import com.floreantpos.util.NumberUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.json.JSONObject;

public class TicketItemDiscount
extends BaseTicketItemDiscount
implements ITicketItem {
    private static final long serialVersionUID = 1L;
    private double discountPercentage;
    private int tableRowNum;
    private String ticketItemId;

    public TicketItemDiscount() {
    }

    public TicketItemDiscount(String id) {
        super(id);
    }

    public TicketItemDiscount(String id, String name, double quantity, double value, int type) {
        this.setId(id);
        this.setDiscountId(id);
        this.setName(name);
        this.setCouponQuantity(quantity);
        this.setValue(value);
        this.setType(type);
    }

    public TicketItemDiscount(TicketItemDiscount fromDiscount) {
        this.setDiscountId(fromDiscount.getDiscountId());
        this.setName(fromDiscount.getName());
        this.setType(fromDiscount.getType());
        this.setAutoApply(fromDiscount.isAutoApply());
        this.setCouponQuantity(fromDiscount.getCouponQuantity());
        this.setMinimumAmount(fromDiscount.getMinimumAmount());
        this.setValue(fromDiscount.getValue());
        this.setAmount(fromDiscount.getAmount());
    }

    public double calculateDiscount(double subtotalAmount) {
        double discountAmount;
        double quantity = 1.0;
        double couponQuantity = this.getCouponQuantity();
        if (this.getMinimumAmount() > 1.0 && couponQuantity >= (quantity = Math.floor(this.getTicketItem().getQuantity() / this.getMinimumAmount()))) {
            couponQuantity = quantity;
        }
        if ((discountAmount = DiscountUtil.calculateDiscountAmount(this, subtotalAmount) * couponQuantity) > 0.0 && discountAmount > subtotalAmount) {
            discountAmount = subtotalAmount;
        }
        this.setAmount(discountAmount);
        return discountAmount;
    }

    public BigDecimal calculateDiscount(BigDecimal subtotalAmount) {
        BigDecimal discountAmount;
        BigDecimal quantity = NumberUtil.convertToBigDecimal("1");
        BigDecimal couponQuantity = NumberUtil.convertToBigDecimal(this.getCouponQuantity());
        BigDecimal minAmount = NumberUtil.convertToBigDecimal(this.getMinimumAmount());
        if (minAmount.compareTo(BigDecimal.ONE) > 0 && couponQuantity.compareTo(quantity = NumberUtil.convertToBigDecimal(this.getTicketItem().getQuantity()).divide(minAmount, 4, RoundingMode.HALF_DOWN)) >= 0) {
            couponQuantity = quantity;
        }
        if ((discountAmount = DiscountUtil.calculateDiscountAmount(this, subtotalAmount).multiply(couponQuantity)).compareTo(BigDecimal.ZERO) > 0 && discountAmount.compareTo(subtotalAmount) > 0) {
            discountAmount = subtotalAmount;
        }
        this.setAmount(discountAmount.doubleValue());
        return discountAmount;
    }

    public void setTableRowNum(int tableRowNum) {
        this.tableRowNum = tableRowNum;
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    @Override
    public String getItemCode() {
        return "";
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getNameDisplay() {
        double couponQuantity = this.getCouponQuantity();
        String display = couponQuantity > 1.0 ? NumberUtil.trimDecilamIfNotNeeded(couponQuantity) + "x " + this.getName() : this.getName().trim();
        return "  *" + display;
    }

    @Override
    public boolean canAddCookingInstruction() {
        return false;
    }

    @Override
    public boolean canAddDiscount() {
        return false;
    }

    @Override
    public boolean canVoid() {
        return false;
    }

    @Override
    public boolean canAddAdOn() {
        return false;
    }

    @Override
    public Boolean isPrintedToKitchen() {
        return false;
    }

    @Override
    public Double getUnitPriceDisplay() {
        return null;
    }

    @Override
    public String getItemQuantityDisplay() {
        return null;
    }

    @Override
    public Double getTaxAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public Double getTotalAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public Double getSubTotalAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public void setDiscountAmount(Double amount) {
    }

    @Override
    public Double getDiscountAmount() {
        return null;
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return null;
    }

    @Override
    public Double getSubTotalAmountDisplay() {
        if (this.getTicketItem() != null) {
            return this.getTicketItem().getDiscountAmount();
        }
        double discount = this.getAmount();
        if (discount <= 0.0) {
            return null;
        }
        return -discount;
    }

    public double getDiscountPercentage() {
        return this.discountPercentage;
    }

    public void setDiscountPercentage(double discountPercentage) {
        this.discountPercentage = discountPercentage;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(PROP_DISCOUNT_ID, (Object)this.getDiscountId());
        jsonObject.put(PROP_NAME, (Object)this.getName());
        jsonObject.put(PROP_TYPE, (Object)this.getType());
        jsonObject.put(PROP_AUTO_APPLY, (Object)this.isAutoApply());
        jsonObject.put(PROP_COUPON_QUANTITY, (Object)this.getCouponQuantity());
        jsonObject.put(PROP_MINIMUM_AMOUNT, (Object)this.getMinimumAmount());
        jsonObject.put(PROP_VALUE, (Object)this.getValue());
        jsonObject.put(PROP_AMOUNT, (Object)this.getAmount());
        return jsonObject;
    }

    public String getTicketItemId() {
        return this.ticketItemId;
    }

    public void setTicketItemId(String ticketItemId) {
        this.ticketItemId = ticketItemId;
    }

    @Override
    public boolean isSaved() {
        return this.getTicketItem() == null ? false : this.getTicketItem().isSaved();
    }
}

