/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;

public class TicketItemModifier
extends BaseTicketItemModifier
implements ITicketItem {
    private static final long serialVersionUID = 1L;
    public static final int NORMAL_MODIFIER = 1;
    public static final int EXTRA_MODIFIER = 3;
    public static final int CRUST = 5;
    public static final int SEPERATOR = 6;
    public static final String TRANSIENT_PROP_TICKET_ITEM_QUANTITY = "ticketItemQuantity";
    public MenuModifier menuModifier;
    private boolean selected;
    private int tableRowNum;
    private double ticketItemQuantity;
    private List<TicketItemTax> taxes;

    public TicketItemModifier() {
    }

    public TicketItemModifier(String id) {
        super(id);
    }

    public TicketItemModifier(TicketItem ticketItem, String name, double unitPrice, double quantity) {
        this.setTicketItem(ticketItem);
        this.setName(name);
        this.setUnitPrice(unitPrice);
        this.setItemQuantity(quantity);
    }

    public TicketItemModifier(String id, TicketItem ticketItem, String name, double unitPrice, double quantity, TicketItemTax tax) {
        this.setId(id);
        this.setTicketItem(ticketItem);
        this.setName(name);
        this.setUnitPrice(unitPrice);
        this.setItemQuantity(quantity);
        this.addTotaxes(tax);
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    public void setTableRowNum(int tableRowNum) {
        this.tableRowNum = tableRowNum;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean canAddCookingInstruction() {
        return false;
    }

    public void calculatePrice() {
        if (this.isInfoOnly().booleanValue()) {
            return;
        }
        BigDecimal unitPrice = NumberUtil.convertToBigDecimal(this.getUnitPrice());
        BigDecimal subTotalAmount = NumberUtil.round(this.calculateSubTotal(unitPrice));
        BigDecimal discountAmount = NumberUtil.round(this.calculateDiscount(subTotalAmount));
        BigDecimal taxAmount = NumberUtil.round(this.calculateTax(subTotalAmount, discountAmount));
        BigDecimal serviceCharge = BigDecimal.ZERO;
        BigDecimal totalAmount = NumberUtil.convertToBigDecimal(0.0);
        TicketItem ticketItem = this.getTicketItem();
        if (ticketItem != null) {
            serviceCharge = ticketItem.calculateServiceCharge(subTotalAmount);
            if (ticketItem.isTaxOnServiceCharge().booleanValue()) {
                taxAmount = NumberUtil.round(this.calculateTax(subTotalAmount.add(serviceCharge), discountAmount));
            }
        }
        totalAmount = this.isTaxIncluded() != false ? subTotalAmount.subtract(discountAmount) : subTotalAmount.subtract(discountAmount).add(taxAmount);
        totalAmount = NumberUtil.round(totalAmount.add(serviceCharge));
        this.setSubTotalAmount(subTotalAmount.doubleValue());
        this.setDiscountAmount(discountAmount.doubleValue());
        this.setTaxAmount(taxAmount.doubleValue());
        this.setServiceCharge(serviceCharge.doubleValue());
        this.setTotalAmount(totalAmount.doubleValue());
        this.setAdjustedUnitPrice(this.getUnitPrice());
        this.setAdjustedDiscount(discountAmount.doubleValue());
        this.setAdjustedSubtotal(this.getSubTotalAmount());
        this.setAdjustedTax(this.getTaxAmount());
        this.setAdjustedTotal(this.getTotalAmount());
    }

    public void calculateAdjustedPrice() {
        Ticket ticket = this.getTicketItem().getTicket();
        if (ticket == null) {
            return;
        }
        BigDecimal subTotalAmount = NumberUtil.convertToBigDecimal(this.getSubTotalAmount());
        BigDecimal discountAmount = NumberUtil.convertToBigDecimal(this.getDiscountAmount());
        BigDecimal subtotalAfterDiscount = NumberUtil.round(subTotalAmount.subtract(discountAmount));
        BigDecimal ticketDiscountAmount = NumberUtil.round(NumberUtil.convertToBigDecimal(ticket.getTicketDiscountAmount()));
        BigDecimal ticketSubtotalAmount = NumberUtil.round(NumberUtil.convertToBigDecimal(ticket.getSubtotalAmountWithVoidItems()));
        BigDecimal totalItemDiscountAmount = NumberUtil.round(NumberUtil.convertToBigDecimal(ticket.getItemDiscountAmount()));
        BigDecimal ticketSubtotalAfterItemDiscount = NumberUtil.round(ticketSubtotalAmount.subtract(totalItemDiscountAmount));
        BigDecimal ticketSubtotalAfterAllDiscount = NumberUtil.round(ticketSubtotalAfterItemDiscount.subtract(ticketDiscountAmount));
        BigDecimal adjustedSubtotal = NumberUtil.round(subtotalAfterDiscount.multiply(ticketSubtotalAfterAllDiscount).divide(ticketSubtotalAfterItemDiscount, 4, RoundingMode.HALF_UP));
        BigDecimal adjustedDiscount = NumberUtil.round(subTotalAmount.subtract(adjustedSubtotal));
        BigDecimal adjustedTax = NumberUtil.round(this.calculateTax(adjustedSubtotal, new BigDecimal("0")));
        BigDecimal adjustedTotal = NumberUtil.convertToBigDecimal(0.0);
        adjustedTotal = this.isTaxIncluded() != false ? adjustedSubtotal : NumberUtil.round(adjustedSubtotal.add(adjustedTax));
        adjustedTotal = adjustedTotal.add(NumberUtil.convertToBigDecimal(this.getServiceCharge()));
        this.setAdjustedUnitPrice(adjustedSubtotal.divide(NumberUtil.convertToBigDecimal(this.getItemQuantity()), 4, RoundingMode.HALF_UP).doubleValue());
        this.setAdjustedDiscount(adjustedDiscount.doubleValue());
        this.setAdjustedSubtotal(adjustedSubtotal.doubleValue());
        this.setAdjustedTax(adjustedTax.doubleValue());
        this.setAdjustedTotal(adjustedTotal.doubleValue());
    }

    public double calculateDiscount(double subtotalAmount) {
        double discount = 0.0;
        List<TicketItemDiscount> discounts = this.getTicketItem().getDiscounts();
        if (discounts != null) {
            for (TicketItemDiscount ticketItemDiscount : discounts) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    discount += ticketItemDiscount.calculateDiscount(subtotalAmount);
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                double discountPercentage = ticketItemDiscount.getValue() * 100.0 / this.getTicketItem().getSubtotalAmount();
                TicketItemDiscount percentDiscount = new TicketItemDiscount();
                percentDiscount.setType(1);
                percentDiscount.setValue(discountPercentage);
                percentDiscount.setTicketItem(this.getTicketItem());
                percentDiscount.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
                discount += percentDiscount.calculateDiscount(subtotalAmount);
            }
        }
        if (discount > Math.abs(subtotalAmount)) {
            return subtotalAmount;
        }
        return discount;
    }

    public BigDecimal calculateDiscount(BigDecimal subtotalAmount) {
        BigDecimal discount = NumberUtil.convertToBigDecimal(0.0);
        List<TicketItemDiscount> discounts = this.getTicketItem().getDiscounts();
        if (discounts != null) {
            for (TicketItemDiscount ticketItemDiscount : discounts) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    discount = discount.add(ticketItemDiscount.calculateDiscount(subtotalAmount));
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                double discountPercentage = ticketItemDiscount.getValue() * 100.0 / this.getTicketItem().getSubtotalAmount();
                TicketItemDiscount percentDiscount = new TicketItemDiscount();
                percentDiscount.setType(1);
                percentDiscount.setValue(discountPercentage);
                percentDiscount.setTicketItem(this.getTicketItem());
                percentDiscount.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
                discount = discount.add(percentDiscount.calculateDiscount(subtotalAmount));
            }
        }
        if (discount.compareTo(subtotalAmount.abs()) > 0) {
            return subtotalAmount;
        }
        return NumberUtil.round(discount);
    }

    public void merge(TicketItemModifier otherItem) {
        this.setItemQuantity(this.getItemQuantity() + otherItem.getItemQuantity());
    }

    private BigDecimal calculateTax(BigDecimal subtotalAmount, BigDecimal discountAmount) {
        BigDecimal totalTaxAmount = NumberUtil.convertToBigDecimal("0");
        subtotalAmount = subtotalAmount.subtract(discountAmount);
        List<TicketItemTax> taxList = this.getTaxes();
        if (taxList != null) {
            if (this.isTaxIncluded().booleanValue()) {
                BigDecimal taxRatePercentage = NumberUtil.convertToBigDecimal(0.0);
                for (TicketItemTax ticketItemModifierTax : taxList) {
                    taxRatePercentage = taxRatePercentage.add(NumberUtil.convertToBigDecimal(ticketItemModifierTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_UP));
                }
                if (taxRatePercentage.compareTo(NumberUtil.convertToBigDecimal("0")) == 0) {
                    return totalTaxAmount;
                }
                BigDecimal totalTaxRatePercentage = taxRatePercentage.add(NumberUtil.convertToBigDecimal(1.0));
                double actualPrice = subtotalAmount.doubleValue() / totalTaxRatePercentage.doubleValue();
                for (TicketItemTax ticketItemModifierTax : taxList) {
                    taxRatePercentage = NumberUtil.convertToBigDecimal(ticketItemModifierTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_UP);
                    BigDecimal tax = NumberUtil.convertToBigDecimal(actualPrice).multiply(taxRatePercentage);
                    ticketItemModifierTax.setTaxAmount(tax.doubleValue());
                    totalTaxAmount = totalTaxAmount.add(tax);
                }
            } else {
                for (TicketItemTax ticketItemModifierTax : taxList) {
                    BigDecimal taxRatePercentage = NumberUtil.convertToBigDecimal(ticketItemModifierTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_UP);
                    if (taxRatePercentage.compareTo(NumberUtil.convertToBigDecimal("0")) == 0) {
                        return totalTaxAmount;
                    }
                    BigDecimal tax = subtotalAmount.multiply(taxRatePercentage);
                    ticketItemModifierTax.setTaxAmount(tax.doubleValue());
                    totalTaxAmount = totalTaxAmount.add(tax);
                }
            }
        }
        this.buildTaxes();
        return NumberUtil.round(totalTaxAmount);
    }

    public double getTotalTaxRate() {
        List<TicketItemTax> ticketItemTaxes = this.getTaxes();
        if (ticketItemTaxes == null || ticketItemTaxes.isEmpty()) {
            return 0.0;
        }
        double totalTaxRate = 0.0;
        for (TicketItemTax tax : ticketItemTaxes) {
            totalTaxRate += tax.getRate().doubleValue();
        }
        return totalTaxRate;
    }

    private BigDecimal calculateSubTotal(BigDecimal unitPrice) {
        Double modifierQty = this.getItemQuantity();
        if (this.getTicketItem() != null) {
            modifierQty = modifierQty * Math.abs(this.getTicketItem().getQuantity());
        }
        return unitPrice.multiply(NumberUtil.convertToBigDecimal(modifierQty));
    }

    @Override
    public String getNameDisplay() {
        return this.getItemQuantityDisplay() + " " + this.getNameDisplay(false);
    }

    public String getNameDisplay(boolean kitchenReceipt) {
        Store store;
        boolean isShowModifierPrice;
        if (this.isInfoOnly().booleanValue()) {
            return this.getName().trim();
        }
        double itemQuantity = Math.abs(this.getItemQuantity());
        String itemQuantityDisplay = "";
        if (itemQuantity > 1.0) {
            itemQuantityDisplay = NumberUtil.trimDecilamIfNotNeeded(itemQuantity) + "x ";
        }
        String display = itemQuantity > 1.0 ? itemQuantityDisplay + this.getName() : this.getName().trim();
        if (this.getModifierType() == 1 && !kitchenReceipt) {
            display = display + "*";
        }
        boolean bl = isShowModifierPrice = (store = Application.getInstance().getStore()).getProperty("showModifierPrice") == null ? false : Boolean.valueOf(store.getProperty("showModifierPrice"));
        if (isShowModifierPrice && this.getUnitPrice() > 0.0 && !kitchenReceipt) {
            display = itemQuantityDisplay + this.getName() + " @" + NumberUtil.formatNumber(this.getUnitPrice());
        }
        if (kitchenReceipt) {
            return display;
        }
        return " -- " + display;
    }

    @Override
    public Double getUnitPriceDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return this.getUnitPrice();
    }

    @Override
    public String getItemQuantityDisplay() {
        return "";
    }

    @Override
    public Double getTaxAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return this.getTaxAmount();
    }

    @Override
    public Double getTotalAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return this.getTotalAmount();
    }

    @Override
    public Double getSubTotalAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return this.getSubTotalAmount();
    }

    @Override
    public String getItemCode() {
        return "";
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public Double getItemQuantity() {
        Double itemQuantity = super.getItemQuantity();
        if (itemQuantity == 0.0) {
            itemQuantity = (double)super.getItemCount();
        }
        return itemQuantity;
    }

    @Override
    public boolean canAddDiscount() {
        return false;
    }

    @Override
    public boolean canVoid() {
        return false;
    }

    @Override
    public boolean canAddAdOn() {
        return false;
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setStatus(kitchenStatus.name());
    }

    @Override
    public Double getSubTotalAmountDisplay() {
        return null;
    }

    @XmlTransient
    public MenuModifier getMenuModifier() {
        return this.menuModifier;
    }

    public void setMenuModifier(MenuModifier menuModifier) {
        this.menuModifier = menuModifier;
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public void setTaxes(List<TicketItemTax> taxes) {
        this.taxes = taxes;
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
    }

    public List<TicketItemTax> getTaxes() {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
            String property = super.getTaxesProperty();
            if (StringUtils.isNotEmpty((String)property)) {
                JsonReader jsonParser = Json.createReader((Reader)new StringReader(property));
                JsonArray jsonArray = jsonParser.readArray();
                jsonParser.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject tObj = (JsonObject)jsonArray.get(i);
                    TicketItemTax tit = new TicketItemTax();
                    tit.setName(tObj.getString(TicketItemTax.PROP_NAME));
                    tit.setRate(POSUtil.parseDouble("" + tObj.get((Object)TicketItemTax.PROP_RATE)));
                    tit.setTaxAmount(POSUtil.parseDouble("" + tObj.get((Object)TicketItemTax.PROP_TAX_AMOUNT)));
                    this.taxes.add(tit);
                }
            }
        }
        return this.taxes;
    }

    public void addTotaxes(TicketItemTax tax) {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
        this.taxes = this.getTaxes();
        this.taxes.add(tax);
    }

    public void buildTaxes() {
        if (this.taxes == null || this.taxes.isEmpty()) {
            this.setTaxesProperty(null);
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (TicketItemTax ticketItemTax : this.taxes) {
            jsonArray.put((Object)ticketItemTax.toJson());
        }
        this.setTaxesProperty(jsonArray.toString());
    }

    public void setTicketItemQuantity(double ticketItemQuantity) {
        this.ticketItemQuantity = ticketItemQuantity;
    }

    public double getTicketItemQuantity() {
        if (this.getTicketItem() != null) {
            return this.getTicketItem().getQuantity();
        }
        return this.ticketItemQuantity;
    }
}

