/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseAttendenceHistoryDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.AttendanceReportData;
import com.floreantpos.report.PayrollReportData;
import com.floreantpos.report.WeeklyPayrollReportData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class AttendenceHistoryDAO
extends BaseAttendenceHistoryDAO {
    public List<User> findNumberOfClockedInUserAtHour(Date fromDay, Date toDay, int hour, Terminal terminal) {
        Session session = null;
        ArrayList<User> users = new ArrayList<User>();
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)fromDay));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)toDay));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_HOUR, (Object)new Short((short)hour)));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_TERMINAL, (Object)terminal));
            }
            List list = criteria.list();
            for (Object object : list) {
                AttendenceHistory history = (AttendenceHistory)object;
                if (!history.isClockedOut().booleanValue()) {
                    users.add(history.getUser());
                    continue;
                }
                if (history.getClockOutHour() < hour) continue;
                users.add(history.getUser());
            }
            ArrayList<User> arrayList = users;
            return arrayList;
        }
        catch (Exception e) {
            throw new PosException(Messages.getString("AttendenceHistoryDAO.2"), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public List<User> findNumberOfClockedInUserAtShift(Date fromDay, Date toDay, Shift shift, Terminal terminal) {
        Session session = null;
        ArrayList<User> users = new ArrayList<User>();
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)fromDay));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)toDay));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_SHIFT, (Object)shift));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_TERMINAL, (Object)terminal));
            }
            List list = criteria.list();
            for (Object object : list) {
                AttendenceHistory history = (AttendenceHistory)object;
                users.add(history.getUser());
            }
            ArrayList<User> arrayList = users;
            return arrayList;
        }
        catch (Exception e) {
            throw new PosException(Messages.getString("AttendenceHistoryDAO.5"), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttendenceHistory findHistoryByClockedInTime(User user) {
        Session session = null;
        try {
            session = this.createNewSession();
            AttendenceHistory attendenceHistory = this.findHistoryByClockedInTime(user, session);
            return attendenceHistory;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public AttendenceHistory findHistoryByClockedInTime(User user, Session session) {
        Criteria criteria = session.createCriteria(AttendenceHistory.class);
        criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER, (Object)user));
        criteria.add(Restrictions.isNull((String)AttendenceHistory.PROP_CLOCK_OUT_TIME));
        criteria.addOrder(Order.desc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
        criteria.setFirstResult(0);
        criteria.setMaxResults(1);
        List list = criteria.list();
        if (list.size() > 0) {
            return (AttendenceHistory)list.get(0);
        }
        return null;
    }

    public List<PayrollReportData> findPayroll(Date from, Date to, User user) {
        ArrayList<PayrollReportData> reportDataList = new ArrayList<PayrollReportData>();
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)to));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER, (Object)user));
            }
            this.populateReportDataList(reportDataList, criteria.list());
            if (user != null) {
                List<User> linkedUsers = user.getLinkedUser();
                for (User linkedUser : linkedUsers) {
                    if (linkedUser.getId().equals(user.getId())) continue;
                    criteria = session.createCriteria(AttendenceHistory.class);
                    criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from));
                    criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)to));
                    criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER));
                    criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
                    criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER, (Object)linkedUser));
                    this.populateReportDataList(reportDataList, criteria.list());
                }
            }
            ArrayList<PayrollReportData> arrayList = reportDataList;
            return arrayList;
        }
    }

    private void populateReportDataList(ArrayList<PayrollReportData> reportDataList, List searchResultList) {
        for (AttendenceHistory history : searchResultList) {
            PayrollReportData data = new PayrollReportData();
            data.setFrom(history.getClockInTime());
            data.setTo(history.getClockOutTime());
            data.setDate(history.getClockInTime());
            data.setUser(history.getUser());
            data.calculate();
            reportDataList.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WeeklyPayrollReportData> findWeeklyPayroll(Date from, Date to, User user, int firstDayOfWeek) {
        Session session = null;
        ArrayList<WeeklyPayrollReportData> reportDataList = new ArrayList<WeeklyPayrollReportData>();
        ArrayList<Date[]> searchDateList = new ArrayList<Date[]>();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(from);
            Date[] dateRange = new Date[2];
            dateRange[0] = from;
            while (!from.after(to)) {
                Date toDate;
                int dayOfWeek = calendar.get(7);
                int difference = dayOfWeek - (firstDayOfWeek - 1);
                calendar.add(5, 1);
                if (difference != 0 && !calendar.getTime().after(to)) continue;
                calendar.add(5, -1);
                dateRange[1] = toDate = calendar.getTime();
                searchDateList.add(dateRange);
                dateRange = new Date[2];
                calendar.add(5, 1);
                dateRange[0] = from = calendar.getTime();
            }
            for (Date[] dateRangeArray : searchDateList) {
                criteria = session.createCriteria(AttendenceHistory.class);
                Date startOfDay = DateUtil.startOfDay(dateRangeArray[0]);
                Date endOfDay = DateUtil.endOfDay(dateRangeArray[1]);
                criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)startOfDay));
                criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)endOfDay));
                criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER));
                criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
                if (user != null) {
                    criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER, (Object)user));
                }
                reportDataList.addAll(this.populateWeeklyPayrollReportDataList(criteria.list(), startOfDay, endOfDay, firstDayOfWeek));
                if (user == null) continue;
                List<User> linkedUsers = user.getLinkedUser();
                for (User linkedUser : linkedUsers) {
                    if (linkedUser.getId().equals(user.getId())) continue;
                    criteria = session.createCriteria(AttendenceHistory.class);
                    criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from));
                    criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)to));
                    criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER));
                    criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
                    criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER, (Object)linkedUser));
                    reportDataList.addAll(this.populateWeeklyPayrollReportDataList(criteria.list(), startOfDay, endOfDay, firstDayOfWeek));
                }
            }
            ArrayList<WeeklyPayrollReportData> arrayList = reportDataList;
            return arrayList;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private List<WeeklyPayrollReportData> populateWeeklyPayrollReportDataList(List searchResultList, Date from, Date to, int firstDayOfWeek) {
        HashMap<String, WeeklyPayrollReportData> reportDataMap = new HashMap<String, WeeklyPayrollReportData>();
        for (AttendenceHistory history : searchResultList) {
            WeeklyPayrollReportData data = (WeeklyPayrollReportData)reportDataMap.get(history.getUser().getId());
            if (data == null) {
                data = new WeeklyPayrollReportData();
                data.setFirstDayOfWeek(firstDayOfWeek);
                reportDataMap.put(history.getUser().getId(), data);
            }
            data.setTotalWorkHourMs(data.getTotalWorkHourMs() + (history.getClockOutTime().getTime() - history.getClockInTime().getTime()));
            data.setFromDateOfWeek(from);
            data.setToDateOfWeek(to);
            data.setUser(history.getUser());
        }
        Collection values = reportDataMap.values();
        for (WeeklyPayrollReportData data : values) {
            data.calculateTotalHour();
        }
        return new ArrayList<WeeklyPayrollReportData>(values);
    }

    public List<AttendanceReportData> findAttendance(Date from, Date to, User user) {
        ArrayList<AttendanceReportData> list = new ArrayList<AttendanceReportData>();
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)AttendenceHistory.PROP_CLOCK_OUT_TIME), (Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)to)));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER, (Object)user));
            }
            List list2 = criteria.list();
            for (AttendenceHistory history : list2) {
                AttendanceReportData data = new AttendanceReportData();
                data.setClockIn(history.getClockInTime());
                data.setClockOut(history.getClockOutTime());
                data.setUser(history.getUser());
                data.setName(history.getUser().getFirstName());
                data.calculate();
                list.add(data);
            }
            ArrayList<AttendanceReportData> arrayList = list;
            return arrayList;
        }
    }

    public List<AttendenceHistory> findHistory(Date from, Date toDate, User user) {
        try (Session session = null;){
            List list2;
            session = this.getSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_ID));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER, (Object)user));
            }
            List list = list2 = criteria.list();
            return list;
        }
    }

    public List<AttendenceHistory> findAttendanceHistory(Date from, Date to, User user) {
        try (Session session = null;){
            List list2;
            session = this.getSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)to));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_ID));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER, (Object)user));
            }
            List list = list2 = criteria.list();
            return list;
        }
    }
}

