/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.dao.BaseBookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class BookingInfoDAO
extends BaseBookingInfoDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingInfo> getBookedTables(Date startDate, Date endDate) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate), (Criterion)Restrictions.le((String)BookingInfo.PROP_TO_DATE, (Object)endDate)));
            List list = criteria.list();
            if (list != null) {
                List list2 = list;
                return list2;
            }
            List<BookingInfo> list3 = null;
            return list3;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
        return null;
    }

    public List<ShopTable> getAllTableForBookingOfFloor(Date startDate, Date endDate, ShopFloor shopFloor) {
        List<BookingInfo> bookedTables = this.getBookedTables(startDate, endDate);
        List<ShopTable> allTables = ShopTableDAO.getInstance().getByFloor(shopFloor);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingInfo> getAllOpenBooking() {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ne((String)BookingInfo.PROP_STATUS, (Object)"close"));
            List list2 = list = criteria.list();
            return list2;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void setBookingStatus(BookingInfo bookingInfo, String bookingStatus, List<ShopTableStatus> tableStatusList) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            bookingInfo.setStatus(bookingStatus);
            this.saveOrUpdate(bookingInfo);
            if (bookingStatus.equals("seat") || bookingStatus.equals("delay")) {
                ShopTableDAO.getInstance().bookedTables(tableStatusList);
            }
            if (bookingStatus.equals("cancel") || bookingStatus.equals("no appear") || bookingStatus.equals("close")) {
                ShopTableDAO.getInstance().freeTables(tableStatusList);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(BookingInfo.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTodaysBooking() {
        try (Session session = null;){
            List list;
            Calendar startDate = Calendar.getInstance();
            startDate.setLenient(false);
            startDate.setTime(new Date());
            startDate.set(11, 0);
            startDate.set(12, 0);
            startDate.set(13, 0);
            startDate.set(14, 0);
            Calendar endDate = Calendar.getInstance();
            endDate.setLenient(false);
            endDate.setTime(new Date());
            endDate.set(11, 23);
            endDate.set(12, 59);
            endDate.set(13, 59);
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(BookingInfo.class);
            criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate.getTime())).add((Criterion)Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)endDate.getTime())).add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"open"));
            List list2 = list = criteria.list();
            return list2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> getAllBookedTablesByDate(Date startDate, Date endDate) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(BookingInfo.class);
            criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate)).add((Criterion)Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)endDate)).add((Criterion)Restrictions.ne((String)BookingInfo.PROP_STATUS, (Object)"close"));
            List list = criteria.list();
            ArrayList<ShopTable> bookedTableList = new ArrayList<ShopTable>();
            for (BookingInfo bookingInfo : list) {
                for (ShopTable shopTable : bookingInfo.getTables()) {
                    bookedTableList.add(shopTable);
                }
            }
            ArrayList<ShopTable> arrayList = bookedTableList;
            return arrayList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingInfo> getAllBookingInfoByDate(Date startDate, Date endDate) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(BookingInfo.class);
            criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate)).add((Criterion)Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)endDate)).add((Criterion)Restrictions.ne((String)BookingInfo.PROP_STATUS, (Object)"close"));
            List list = criteria.list();
            if (list != null) {
                List list2 = list;
                return list2;
            }
            List<BookingInfo> list3 = null;
            return list3;
        }
        return null;
    }
}

