/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.BaseDiscountDAO;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class DiscountDAO
extends BaseDiscountDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Discount getInitialized(String discountId) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)discountId));
            Discount discount = (Discount)criteria.uniqueResult();
            Hibernate.initialize(discount.getMenuItems());
            Hibernate.initialize(discount.getMenuGroups());
            Hibernate.initialize(discount.getMenuCategories());
            Discount discount2 = discount;
            return discount2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Discount> findAllValidCoupons() {
        Session session = null;
        Date currentDate = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Discount> getValidItemCoupons() {
        Session session = null;
        Date currentDate = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)0), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Discount> getValidCoupon(MenuItem menuItem) {
        Session session = null;
        Date currentDate = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.createAlias("menuItems", "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)menuItem.getId()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)0), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Discount> getTicketValidCoupon() {
        Session session = null;
        Date currentDate = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)1), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isApplicable(String itemId, String discountId) {
        Session session = null;
        Date currentDate = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.createAlias("menuItems", "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)itemId));
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)discountId));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            Number rowCount = (Number)criteria.uniqueResult();
            boolean bl = rowCount != null && rowCount.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Discount getDiscountByBarcode(String barcode, int couponType) {
        Session session = null;
        Criteria criteria = null;
        Date currentDate = new Date();
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Discount.class);
            criteria.add((Criterion)Restrictions.like((String)Discount.PROP_BARCODE, (Object)barcode));
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)(couponType == 0 ? 0 : 1)), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                Discount discount = null;
                return discount;
            }
            Discount discount = (Discount)result.get(0);
            return discount;
        }
        finally {
            this.closeSession(session);
        }
    }

    public String getCurrentDayPropertyName(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        String propertyName = "";
        int dayOfWeek = c.get(7);
        switch (dayOfWeek) {
            case 7: {
                propertyName = Discount.PROP_APPLY_TO_SATURDAY_ONLY;
                break;
            }
            case 1: {
                propertyName = Discount.PROP_APPLY_TO_SUNDAY_ONLY;
                break;
            }
            case 2: {
                propertyName = Discount.PROP_APPLY_TO_MONDAY_ONLY;
                break;
            }
            case 3: {
                propertyName = Discount.PROP_APPLY_TO_TUESDAY_ONLY;
                break;
            }
            case 4: {
                propertyName = Discount.PROP_APPLY_TO_WEDNESDAY_ONLY;
                break;
            }
            case 5: {
                propertyName = Discount.PROP_APPLY_TO_THURSDAY_ONLY;
                break;
            }
            case 6: {
                propertyName = Discount.PROP_APPLY_TO_FRIDAY_ONLY;
                break;
            }
        }
        return propertyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Discount> getValidCoupons() {
        Session session = null;
        Date currentDate = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }
}

