/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.BaseGiftCardDAO;
import com.floreantpos.swing.PaginationSupport;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class GiftCardDAO
extends BaseGiftCardDAO {
    public void saveAsList(List<GiftCard> giftCardList) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (GiftCard giftCard : giftCardList) {
                String cardNumber = giftCard.getCardNumber();
                if (cardNumber == null) continue;
                cardNumber = cardNumber.replaceAll("-", "");
                giftCard.setCardNumber(cardNumber);
                GiftCard card = (GiftCard)session.get(GiftCard.class, (Serializable)((Object)cardNumber));
                if (card == null) {
                    session.save((Object)giftCard);
                    continue;
                }
                session.update((Object)giftCard);
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GiftCard findByCardNumber(String cardNumber) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            if (StringUtils.isNotEmpty((String)cardNumber)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_CARD_NUMBER, (Object)cardNumber));
                if (criteria.list().isEmpty()) {
                    GiftCard giftCard = null;
                    return giftCard;
                }
                GiftCard giftCard = (GiftCard)criteria.list().get(0);
                return giftCard;
            }
            GiftCard giftCard = null;
            return giftCard;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByCardAndIssueDate(String cardNumber, String batchNumber, Date fromDate, Date toDate, String status, PaginationSupport model) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            if (fromDate != null && toDate != null) {
                criteria.add(Restrictions.between((String)GiftCard.PROP_ISSUE_DATE, (Object)fromDate, (Object)toDate));
            }
            if (StringUtils.isNotEmpty((String)cardNumber)) {
                criteria.add(Restrictions.ilike((String)GiftCard.PROP_CARD_NUMBER, (String)cardNumber, (MatchMode)MatchMode.START));
            }
            if (StringUtils.isNotEmpty((String)batchNumber)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)batchNumber));
            }
            if (status.equalsIgnoreCase("ACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)true));
            } else if (status.equalsIgnoreCase("DEACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)false));
            } else if (status.equalsIgnoreCase("DISABLED")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)true));
            }
            criteria.setProjection(Projections.rowCount());
            Number uniqueResult = (Number)criteria.uniqueResult();
            model.setNumRows(uniqueResult.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)GiftCard.PROP_ISSUE_DATE));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Date> findByDate() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)GiftCard.PROP_ISSUE_DATE)));
            if (criteria.list().isEmpty()) {
                List<Date> list = null;
                return list;
            }
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GiftCard> findExceptDisable() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)false));
            if (!criteria.list().isEmpty()) {
                List list = criteria.list();
                return list;
            }
            List<GiftCard> list = null;
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GiftCard initialize(GiftCard giftCard) {
        if (giftCard == null) {
            return giftCard;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)giftCard);
            GiftCard giftCard2 = giftCard;
            return giftCard2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findActiveCardByBatchNumber(String batchNumber) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            if (StringUtils.isNotEmpty((String)batchNumber)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)batchNumber));
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)true), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)false), (Criterion)Restrictions.isNotNull((String)GiftCard.PROP_ACTIVATION_DATE))));
                if (criteria.list().isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCardListByBatchNumber(String batchNumber) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)false));
            List giftCardList = null;
            if (StringUtils.isNotEmpty((String)batchNumber)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)batchNumber));
                giftCardList = criteria.list();
                if (giftCardList != null) {
                    for (GiftCard giftCard : giftCardList) {
                        this.delete(giftCard);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GiftCard> findByBatchNumber(String batchNO) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)batchNO));
            if (!criteria.list().isEmpty()) {
                List list = criteria.list();
                return list;
            }
            List<GiftCard> list = null;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBatchNo(String batchNO) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)batchNO));
            criteria.setMaxResults(1);
            boolean bl = criteria.list().size() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GiftCard> findGiftCards(Date fromDate, Date toDate, boolean isExpired, String sortOption) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(GiftCard.class);
            criteria.add(Restrictions.between((String)GiftCard.PROP_ACTIVATION_DATE, (Object)fromDate, (Object)toDate));
            if (isExpired) {
                criteria.add((Criterion)Restrictions.lt((String)GiftCard.PROP_EXPIRY_DATE, (Object)new Date()));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)GiftCard.PROP_EXPIRY_DATE, (Object)new Date()));
            }
            if ("Owner".equals(sortOption)) {
                criteria.addOrder(Order.asc((String)GiftCard.PROP_OWNER_NAME));
            } else {
                criteria.addOrder(Order.asc((String)GiftCard.PROP_ACTIVATION_DATE));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }
}

