/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.BaseImageResourceDAO;
import com.floreantpos.swing.PaginatedTableModel;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ImageResourceDAO
extends BaseImageResourceDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rowCount() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImages(PaginatedTableModel model, ImageResource.IMAGE_CATEGORY imgCategory, String description) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.addOrder(Order.asc((String)ImageResource.PROP_ID));
            if (imgCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)imgCategory.getType()));
            }
            if (StringUtils.isNotEmpty((String)description)) {
                criteria.add(Restrictions.ilike((String)ImageResource.PROP_DESCRIPTION, (String)description, (MatchMode)MatchMode.START));
            }
            if (imgCategory != ImageResource.IMAGE_CATEGORY.DELETED) {
                criteria.add((Criterion)Restrictions.ne((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)ImageResource.IMAGE_CATEGORY.DELETED.getType()));
            }
            int currentRowIndex = model.getCurrentRowIndex();
            criteria.setFirstResult(currentRowIndex);
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        catch (Exception e) {
            model.setRows(new ArrayList());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource getDefaultFloorImage(InputStream inputStream) throws Exception {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.addOrder(Order.asc((String)ImageResource.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType()));
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_DESCRIPTION, (Object)"default_floor_image"));
            List list = criteria.list();
            if (list.size() > 0) {
                ImageResource imageResource = (ImageResource)list.get(0);
                return imageResource;
            }
            if (inputStream != null) {
                ImageResource imageResource = new ImageResource();
                byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
                imageResource.setImageData(new SerialBlob(byteArray));
                imageResource.setDescription("default_floor_image");
                imageResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                this.save(imageResource);
                ImageResource imageResource2 = imageResource;
                return imageResource2;
            }
        }
        finally {
            this.closeSession(session);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource findById(String id) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_ID, (Object)id));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                ImageResource imageResource = null;
                return imageResource;
            }
            ImageResource imageResource = (ImageResource)result.get(0);
            return imageResource;
        }
        catch (Exception e) {
            ImageResource imageResource = null;
            return imageResource;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdate(List<ImageResource> resourceList) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ImageResource resource : resourceList) {
                session.saveOrUpdate((Object)resource);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ImageResourceDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

