/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.dao.BaseInventoryVendorItemsDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.swing.PaginatedListModel;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class InventoryVendorItemsDAO
extends BaseInventoryVendorItemsDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryVendorItems> findByItem(MenuItem item) {
        if (item.getId() == null) {
            return null;
        }
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (item != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)item));
            }
            if ((list = criteria.list()).isEmpty()) {
                List<InventoryVendorItems> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryVendorItems findByItemAndVendor(MenuItem item, InventoryVendor vendor) {
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (item != null && vendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)item));
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
            }
            if ((list = criteria.list()).isEmpty()) {
                InventoryVendorItems inventoryVendorItems = null;
                return inventoryVendorItems;
            }
            InventoryVendorItems inventoryVendorItems = (InventoryVendorItems)list.get(0);
            return inventoryVendorItems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vendorHasItem(InventoryVendor vendor, MenuItem item, Session session) {
        if (item.getId() == null) {
            return false;
        }
        boolean isNewSession = false;
        try {
            List list;
            if (session == null) {
                session = this.createNewSession();
                isNewSession = true;
            }
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (item != null && vendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)item));
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
            }
            if ((list = criteria.list()).isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosLog.error(InventoryVendorDAO.class, e.getMessage(), e);
        }
        finally {
            if (isNewSession && session != null) {
                session.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveItems(PurchaseOrder order) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            List<PurchaseOrderItem> orderItems = order.getOrderItems();
            for (PurchaseOrderItem purchaseOrderItem : orderItems) {
                MenuItem menuItem = purchaseOrderItem.getMenuItem();
                InventoryVendor vendor = order.getVendor();
                if (this.vendorHasItem(vendor, menuItem, null)) continue;
                InventoryVendorItems inventoryVendorItems = new InventoryVendorItems();
                inventoryVendorItems.setItem(menuItem);
                inventoryVendorItems.setVendor(vendor);
                session.saveOrUpdate((Object)inventoryVendorItems);
            }
            session.saveOrUpdate((Object)order);
            tx.commit();
        }
    }

    public void saveItems(InventoryTransaction transaction, Session session) {
        try {
            MenuItem menuItem = transaction.getMenuItem();
            InventoryVendor vendor = null;
            if (transaction.getVendorId() != null) {
                vendor = InventoryVendorDAO.getInstance().get(transaction.getId());
            }
            if (!this.vendorHasItem(vendor, menuItem, session)) {
                InventoryVendorItems inventoryVendorItems = new InventoryVendorItems();
                inventoryVendorItems.setItem(menuItem);
                inventoryVendorItems.setVendor(vendor);
                session.saveOrUpdate((Object)inventoryVendorItems);
            }
        }
        catch (Exception e) {
            PosLog.error(InventoryVendorDAO.class, e.getMessage(), e);
        }
    }

    public void saveAll(List<InventoryVendorItems> vendorItemsList) {
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.saveAll(vendorItemsList, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveAll(List<InventoryVendorItems> vendorItemsList, Session session) {
        for (InventoryVendorItems inventoryVendorItems : vendorItemsList) {
            this.saveOrUpdate(inventoryVendorItems, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryVendorItems> findByVendor(InventoryVendor vendor) {
        if (vendor.getId() == null) {
            return null;
        }
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (vendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
            }
            if ((list = criteria.list()).isEmpty()) {
                List<InventoryVendorItems> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVendorItems(PaginatedListModel model, InventoryVendor vendor) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (vendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            model.setNumRows(rowCount.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List list = criteria.list();
            for (Object object : list) {
                InventoryVendorItems vendorItems;
                if (!(object instanceof InventoryVendorItems) || (vendorItems = (InventoryVendorItems)object).getItem() == null || vendorItems.getItem().getId() == null) continue;
                model.setData(criteria.list());
            }
        }
    }
}

