/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.dao.BaseMenuCategoryDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.ShiftUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.Transformers;

public class MenuCategoryDAO
extends BaseMenuCategoryDAO {
    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)MenuCategory.PROP_SORT_ORDER);
    }

    @Override
    public Serializable save(Object menuCategory, Session session) throws HibernateException {
        Serializable id = super.save(menuCategory, session);
        this.updateDependentModels((MenuCategory)menuCategory, session);
        return id;
    }

    @Override
    public void update(Object menuCategory, Session session) throws HibernateException {
        super.update(menuCategory, session);
        this.updateDependentModels((MenuCategory)menuCategory, session);
    }

    @Override
    public void saveOrUpdate(Object menuCategory, Session session) throws HibernateException {
        session.saveOrUpdate(menuCategory);
        this.updateDependentModels((MenuCategory)menuCategory, session);
    }

    private void updateDependentModels(MenuCategory menuCategory, Session session) {
        String hqlString = "update MenuGroup set %s=:categoryName, %s=:beverage where %s=:categoryId";
        hqlString = String.format(hqlString, MenuGroup.PROP_MENU_CATEGORY_NAME, MenuGroup.PROP_BEVERAGE, MenuGroup.PROP_MENU_CATEGORY_ID);
        Query query = session.createQuery(hqlString);
        query.setParameter("categoryName", (Object)menuCategory.getDisplayName());
        query.setParameter("beverage", (Object)menuCategory.isBeverage());
        query.setParameter("categoryId", (Object)menuCategory.getId());
        query.executeUpdate();
        hqlString = "update MenuItem set %s=:categoryName, %s=:beverage where %s=:categoryId";
        hqlString = String.format(hqlString, MenuItem.PROP_MENU_CATEGORY_NAME, MenuItem.PROP_BEVERAGE, MenuItem.PROP_MENU_CATEGORY_ID);
        query = session.createQuery(hqlString);
        query.setParameter("categoryName", (Object)menuCategory.getDisplayName());
        query.setParameter("beverage", (Object)menuCategory.isBeverage());
        query.setParameter("categoryId", (Object)menuCategory.getId());
        query.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuCategory> findAllEnable(Department department) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "category");
            criteria.add((Criterion)Restrictions.eq((String)MenuCategory.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuCategory.PROP_SORT_ORDER));
            if (department != null) {
                criteria.createAlias("category.departments", "department");
                criteria.add((Criterion)Restrictions.eq((String)"department.id", (Object)department.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuCategory> findActiveCategories(OrderType orderType) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Department department = terminal.getDepartment();
        List<MenuShift> menuShift = ShiftUtil.getCurrentMenuShifts();
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = this.setRestrictions(orderType, terminal, department, menuShift, session);
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuCategory.PROP_SORT_ORDER));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findActiveCategories(PaginatedListModel listModel, OrderType orderType) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Department department = terminal.getDepartment();
        List<MenuShift> menuShifts = ShiftUtil.getCurrentMenuShifts();
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = this.setRestrictions(orderType, terminal, department, menuShifts, session);
            criteria.setProjection((Projection)Projections.countDistinct((String)MenuCategory.PROP_ID));
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                listModel.setNumRows(rowCount.intValue());
            }
            criteria.setProjection(null);
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            criteria.addOrder(Order.asc((String)MenuCategory.PROP_SORT_ORDER));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            listModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    private Criteria setRestrictions(OrderType orderType, Terminal terminal, Department department, List<MenuShift> menuShifts, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass(), "c");
        if (orderType != null) {
            criteria.createAlias("c.orderTypes", "orderType", JoinType.LEFT_OUTER_JOIN);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.orderTypes"), (Criterion)Restrictions.in((String)"orderType.id", Arrays.asList(orderType.getId()))));
        }
        if (terminal.getTerminalType() != null) {
            criteria.createAlias("c.terminalTypes", "terminalType", JoinType.LEFT_OUTER_JOIN);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.terminalTypes"), (Criterion)Restrictions.in((String)"terminalType.id", Arrays.asList(terminal.getTerminalType().getId()))));
        }
        if (department != null) {
            criteria.createAlias("c.departments", "department", JoinType.LEFT_OUTER_JOIN);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.departments"), (Criterion)Restrictions.in((String)"department.id", Arrays.asList(department.getId()))));
        }
        if (menuShifts != null) {
            criteria.createAlias("c.menuShifts", "menuShifts", JoinType.LEFT_OUTER_JOIN);
            if (menuShifts.size() > 0) {
                ArrayList<String> shiftIds = new ArrayList<String>();
                for (MenuShift menuShift : menuShifts) {
                    shiftIds.add(menuShift.getId());
                }
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.menuShifts"), (Criterion)Restrictions.in((String)"menuShifts.id", shiftIds)));
            } else {
                criteria.add(Restrictions.isEmpty((String)"c.menuShifts"));
            }
        }
        criteria.add((Criterion)Restrictions.eq((String)MenuCategory.PROP_VISIBLE, (Object)Boolean.TRUE));
        return criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuCategory initialize(MenuCategory menuCategory) {
        if (menuCategory == null || menuCategory.getId() == null) {
            return menuCategory;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuCategory);
            Hibernate.initialize(menuCategory.getDepartments());
            Hibernate.initialize(menuCategory.getOrderTypes());
            Hibernate.initialize(menuCategory.getMenuShifts());
            Hibernate.initialize(menuCategory.getMenuGroups());
            MenuCategory menuCategory2 = menuCategory;
            return menuCategory2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void performBatchSaveOrUpdate(MenuCategory menuCategory, List<TerminalType> terminalTypes) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.saveOrUpdate((Object)menuCategory, session);
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void releaseParentAndDelete(MenuCategory category) {
        if (category == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            String queryString = "delete from MENUCATEGORY_DISCOUNT where MENUCATEGORY_ID='%s'";
            queryString = String.format(queryString, category.getId());
            NativeQuery query = session.createSQLQuery(queryString);
            query.executeUpdate();
            String queryString2 = "delete from CAT_DEPT where CATEGORY_ID='%s'";
            queryString2 = String.format(queryString2, category.getId());
            NativeQuery query2 = session.createSQLQuery(queryString2);
            query2.executeUpdate();
            String queryString3 = "delete from CATEGORY_ORDER_TYPE where CATEGORY_ID='%s'";
            queryString3 = String.format(queryString3, category.getId());
            NativeQuery query3 = session.createSQLQuery(queryString3);
            query3.executeUpdate();
            String queryString4 = "delete from TERMINAL_TYPE_CATEGORY where MENU_CATEGORY_ID='%s'";
            queryString4 = String.format(queryString4, category.getId());
            NativeQuery query4 = session.createSQLQuery(queryString4);
            query4.executeUpdate();
            String queryString5 = "update MENU_GROUP set CATEGORY_ID=null where CATEGORY_ID='%s'";
            queryString5 = String.format(queryString5, category.getId());
            NativeQuery query5 = session.createSQLQuery(queryString5);
            query5.executeUpdate();
            session.delete((Object)category);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findCategories(PaginationSupport paginationSupport, boolean includeHiddenItems, String ... fields) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "c");
            if (!includeHiddenItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuCategory.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                paginationSupport.setNumRows(rowCount.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuCategory.PROP_SORT_ORDER));
            if (fields != null && fields.length > 0) {
                ProjectionList projectionList = Projections.projectionList();
                for (String field : fields) {
                    projectionList.add((Projection)Projections.property((String)field), field);
                }
                criteria.setProjection((Projection)projectionList);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuCategory.class));
                paginationSupport.setRows(criteria.list());
            } else {
                paginationSupport.setRows(criteria.list());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuCategory findCategoriesByName(String name) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuCategory.PROP_NAME, (Object)name));
            criteria.addOrder(Order.asc((String)MenuCategory.PROP_SORT_ORDER));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuCategory menuCategory = (MenuCategory)list.get(0);
                return menuCategory;
            }
            MenuCategory menuCategory = null;
            return menuCategory;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuCategory> findAllUnSyncMenuCategory() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)MenuCategory.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)MenuCategory.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateMenuCategoriesSync(List<String> ids, boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update MenuCategory set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, MenuCategory.PROP_CLOUD_SYNCED, MenuCategory.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateMenuCategorys(List<MenuCategory> dataList) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (MenuCategory item : dataList) {
                MenuCategory existingItem = this.get(item.getId());
                if (existingItem != null) {
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    this.update(existingItem, session);
                    continue;
                }
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

