/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.dao.BaseMenuModifierDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.query.Query;

public class MenuModifierDAO
extends BaseMenuModifierDAO {
    public void initialize(MenuModifier modifier) {
        if (modifier == null || modifier.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(modifier.getPizzaModifierPriceList()) && Hibernate.isInitialized(modifier.getMultiplierPriceList())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)modifier);
            Hibernate.initialize(modifier.getPizzaModifierPriceList());
            Hibernate.initialize(modifier.getMultiplierPriceList());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuModifier> getModifierList(String tagName) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)tagName)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_TAG, (Object)tagName));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuModifier> getMenuModifiers(String itemName) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(MenuModifier.class);
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String searchString, boolean pizzaModifier) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            if (pizzaModifier) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            }
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(String searchString, boolean includeInvisibleItems, PaginatedListModel listModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            if (!includeInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_ENABLE, (Object)Boolean.TRUE));
            }
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            listModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(String searchString, boolean includeInvisibleItems, boolean pizzaModifier, BeanTableModel<MenuModifier> listModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            if (pizzaModifier) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            }
            if (!includeInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_ENABLE, (Object)Boolean.TRUE));
            }
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            listModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuModifier> getComboModifiers() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuModifier.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_COMBO_MODIFIER, (Object)Boolean.TRUE));
            return criteria.list();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuModifier findName(String stringValue) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_NAME, (Object)stringValue));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuModifier menuModifier = (MenuModifier)list.get(0);
                return menuModifier;
            }
            MenuModifier menuModifier = null;
            return menuModifier;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuModifier> findAllUnSyncMenuModifier() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)MenuModifier.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)MenuModifier.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateMenuModifierSync(List<String> ids, Boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update MenuModifier set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, MenuModifier.PROP_CLOUD_SYNCED, MenuModifier.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateMenuModifiers(List<MenuModifier> dataList) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (MenuModifier item : dataList) {
                MenuModifier existingItem = this.get(item.getId());
                if (existingItem != null) {
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    this.update(existingItem);
                    continue;
                }
                this.save(item);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

