/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseMenuPageDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.swing.PaginatedListModel;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class MenuPageDAO
extends BaseMenuPageDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdatePages(List<MenuPage> items) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (MenuPage menuPage : items) {
                session.saveOrUpdate((Object)menuPage);
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(Terminal terminal, MenuGroup menuGroup, Object selectedOrderType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuPage> findByGroup(MenuGroup menuGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, MenuGroup menuGroup, OrderType selectedOrderType, Boolean visible, PaginatedListModel listModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(1);
            listModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void deleteAll(List<MenuPage> items) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.deleteAll(items, session);
            tx.commit();
        }
    }

    public void deleteAll(List<MenuPage> items, Session session) {
        for (MenuPage menuPage : items) {
            session.delete((Object)menuPage);
        }
    }

    public void addToMenuGroupEndPage(MenuItem mnuItem) {
        if (mnuItem.getMenuGroupId() == null) {
            return;
        }
        MenuItemDAO.getInstance().initialize(mnuItem);
        MenuPage page = this.getLastPage(mnuItem.getMenuGroupId());
        MenuPageItem menuPageItem = new MenuPageItem(null, null, mnuItem, page);
        for (int i = 0; i < page.getRows(); ++i) {
            for (int j = 0; j < page.getCols(); ++j) {
                if (page.getItemForCell(j, i) != null) continue;
                menuPageItem.setCol(j);
                menuPageItem.setRow(i);
                menuPageItem.setMenuPage(page);
                MenuPageItemDAO.getInstance().saveOrUpdate(page);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MenuPage getLastPage(String menuGroupId) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)menuGroupId));
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            List list = criteria.list();
            MenuPage page = null;
            if (list != null && !list.isEmpty()) {
                page = (MenuPage)list.get(list.size() - 1);
            }
            List<MenuPageItem> pageItems = null;
            if (page != null) {
                pageItems = MenuPageItemDAO.getInstance().getPageItems(page);
            }
            if (page == null || pageItems != null && !pageItems.isEmpty() && pageItems.size() == page.getRows() * page.getCols()) {
                page = new MenuPage();
                page.setMenuGroupId(menuGroupId);
                int pageNumber = list.size() + 1;
                page.setName("Page " + pageNumber);
                page.setSortOrder(pageNumber);
                page.setCols(5);
                page.setRows(5);
                page.setButtonHeight(120);
                page.setButtonWidth(120);
                page.setVisible(true);
            }
            MenuPage menuPage = page;
            return menuPage;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initialize(MenuPage menuPage) {
        if (Hibernate.isInitialized(menuPage.getPageItems())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuPage);
            Hibernate.initialize(menuPage.getPageItems());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(Terminal terminal, List<String> menuGroupIds, Object selectedOrderType) {
        if (menuGroupIds == null || menuGroupIds.size() == 0) {
            return 0;
        }
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.in((String)MenuPage.PROP_MENU_GROUP_ID, menuGroupIds));
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, List<String> menuGroupIds, OrderType selectedOrderType, Boolean visible, PaginatedListModel listModel) {
        if (menuGroupIds == null || menuGroupIds.size() == 0) {
            return;
        }
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            criteria.add(Restrictions.in((String)MenuPage.PROP_MENU_GROUP_ID, menuGroupIds));
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(1);
            listModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }
}

