/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.BaseModifierGroupDAO;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.query.Query;

public class ModifierGroupDAO
extends BaseModifierGroupDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifierGroup> findPizzaModifierGroups() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ModifierGroup.class);
            criteria.add((Criterion)Restrictions.eq((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifierGroup> findNormalModifierGroups() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ModifierGroup.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP), (Criterion)Restrictions.eq((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP, (Object)Boolean.FALSE)));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPizzaModifierGroup() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ModifierGroup.class);
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP, (Object)Boolean.TRUE));
            Number rowCount = (Number)criteria.uniqueResult();
            boolean bl = rowCount != null && rowCount.intValue() > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModifierGroupBooleanPropertyValue(boolean pizzaGroup) {
        if (this.hasPizzaModifierGroup()) {
            return;
        }
        Session session = null;
        Criteria criteria = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            criteria = session.createCriteria(ModifierGroup.class);
            criteria.createAlias("modifiers", "m");
            if (pizzaGroup) {
                criteria.add((Criterion)Restrictions.eq((String)"m.pizzaModifier", (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)"m.pizzaModifier", (Object)Boolean.TRUE));
            }
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                for (ModifierGroup group : list) {
                    group.setPizzaModifierGroup(pizzaGroup);
                    this.saveOrUpdate(group, session);
                }
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModifierGroup findModifierGroupByName(String name) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)ModifierGroup.PROP_NAME, (Object)name));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                ModifierGroup modifierGroup = (ModifierGroup)list.get(0);
                return modifierGroup;
            }
            ModifierGroup modifierGroup = null;
            return modifierGroup;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifierGroup> findAllUnSyncModifierGroup() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)ModifierGroup.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)ModifierGroup.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateModifierGroupSync(List<String> ids, Boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update ModifierGroup set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, ModifierGroup.PROP_CLOUD_SYNCED, ModifierGroup.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateModifierGroups(List<ModifierGroup> dataList) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ModifierGroup item : dataList) {
                ModifierGroup existingItem = this.get(item.getId());
                if (existingItem != null) {
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    this.update(existingItem, session);
                    continue;
                }
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

