/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.BaseOutletDAO;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class OutletDAO
extends BaseOutletDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outlet initialize(Outlet outlet) {
        if (outlet == null || outlet.getId() == null) {
            return outlet;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)outlet);
            Hibernate.initialize(outlet.getDepartments());
            Outlet outlet2 = outlet;
            return outlet2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateOutlets(List<Outlet> dataList) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Outlet item : dataList) {
                Outlet existingItem = this.get(item.getId());
                if (existingItem != null) {
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    this.update(existingItem, session);
                    continue;
                }
                item.setVersion(0L);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

