/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.main.Application;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.BaseRecepieDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class RecepieDAO
extends BaseRecepieDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(String name, boolean subRecipeOnly) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(Recepie.class);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)name)) {
                criteria.add(Restrictions.ilike((String)Recepie.PROP_NAME, (String)name.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRecepies(BeanTableModel<Recepie> model, String name, boolean subRecipeOnly) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Recepie.class);
            if (StringUtils.isNotEmpty((String)name)) {
                Disjunction disjunction = Restrictions.disjunction();
                disjunction.add(Restrictions.ilike((String)Recepie.PROP_NAME, (String)name.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.createAlias(Recepie.PROP_MENU_ITEM, "item");
                disjunction.add(Restrictions.ilike((String)"item.name", (String)name.trim(), (MatchMode)MatchMode.START));
                criteria.add((Criterion)disjunction);
            }
            criteria.addOrder(Order.asc((String)Recepie.PROP_NAME));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Recepie> findBy(MenuItem menuItem) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Recepie.PROP_MENU_ITEM, (Object)menuItem));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void adjustInventory(List<Recepie> recipes) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.adjustInventory(recipes, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void adjustInventory(List<Recepie> recipes, Session session) throws Exception {
        HashMap<String, Double> itemMap = new HashMap<String, Double>();
        HashMap<String, Double> recipeMap = new HashMap<String, Double>();
        for (Recepie recepie : recipes) {
            Double actualYieldValue = recepie.getYield();
            Double cookingYield = recepie.getCookingYield();
            MenuItem menuItem = recepie.getMenuItem();
            Double previousValue = itemMap.get(menuItem.getId());
            if (previousValue == null) {
                previousValue = 0.0;
            }
            Double toBeAdjustQty = recepie.getPortion();
            if ((toBeAdjustQty = Double.valueOf(toBeAdjustQty + previousValue)) <= 0.0) continue;
            itemMap.put(menuItem.getId(), toBeAdjustQty);
            recepie.populateRecipeItemQuantity(recipeMap, cookingYield / actualYieldValue);
        }
        InventoryLocation defaultOutInventoryLocation = InventoryLocationDAO.getInstance().getDefaultOutInventoryLocation(session);
        InventoryLocation defaultInInventoryLocation = InventoryLocationDAO.getInstance().getDefaultInInventoryLocation(session);
        this.adjustInventory(itemMap, InventoryTransactionType.IN, "PREPARE IN", defaultInInventoryLocation, session);
        this.adjustInventory(recipeMap, InventoryTransactionType.OUT, "PREPARE OUT", defaultOutInventoryLocation, session);
    }

    public void adjustRecipeItemsFromInventory(List<Recepie> recipes, Session session) throws Exception {
        HashMap<String, Double> itemMap = new HashMap<String, Double>();
        HashMap<String, Double> recipeMap = new HashMap<String, Double>();
        for (Recepie recepie : recipes) {
            Double actualYieldValue = recepie.getYield();
            Double cookingYield = recepie.getCookingYield();
            MenuItem menuItem = recepie.getMenuItem();
            Double previousValue = (Double)itemMap.get(menuItem.getId());
            if (previousValue == null) {
                previousValue = 0.0;
            }
            Double toBeAdjustQty = recepie.getPortion();
            if ((toBeAdjustQty = Double.valueOf(toBeAdjustQty + previousValue)) <= 0.0) continue;
            itemMap.put(menuItem.getId(), toBeAdjustQty);
            recepie.populateRecipeItemQuantity(recipeMap, cookingYield / actualYieldValue);
        }
        InventoryLocation defaultOutInventoryLocation = InventoryLocationDAO.getInstance().getDefaultOutInventoryLocation(session);
        this.adjustInventory(recipeMap, InventoryTransactionType.OUT, "TICKET SALES", defaultOutInventoryLocation, session);
    }

    private void adjustInventory(HashMap<String, Double> itemMap, InventoryTransactionType transactionType, String reason, InventoryLocation location, Session session) throws Exception {
        Store store = Application.getInstance().getStore();
        boolean isUpdateOnHandBlncForSale = store.isUpdateOnHandBlncForSale();
        boolean isUpdateAvailBlncForSale = store.isUpdateAvlBlncForSale();
        for (String menuItemId : itemMap.keySet()) {
            Double unitQuantity = itemMap.get(menuItemId);
            MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemWithFields(menuItemId, MenuItem.PROP_NAME, MenuItem.PROP_PRICE, MenuItem.PROP_SKU, MenuItem.PROP_BARCODE, MenuItem.PROP_UNIT_ID, MenuItem.PROP_COST, MenuItem.PROP_AVERAGE_UNIT_PURCHASE_PRICE, MenuItem.PROP_AVG_COST);
            if (menuItem == null) continue;
            menuItem.setId(menuItemId);
            InventoryTransaction trans = new InventoryTransaction();
            trans.setReason(reason);
            trans.setTransactionDate(new Date());
            trans.setMenuItem(menuItem);
            trans.setType(transactionType.getType());
            trans.setUser(Application.getCurrentUser());
            InventoryUnit unit = menuItem.getUnit();
            trans.setUnitPrice(menuItem.getPrice());
            trans.setQuantity(unitQuantity);
            if (unit != null) {
                trans.setUnit(unit.getCode());
            }
            trans.setUnitCost(menuItem.getAverageUnitPurchasePrice());
            if (transactionType == InventoryTransactionType.IN) {
                trans.setToInventoryLocation(location);
            } else {
                trans.setFromInventoryLocation(location);
            }
            trans.setTotal(trans.getUnitPrice() * trans.getQuantity());
            InventoryTransactionDAO.getInstance().adjustInventoryStock(trans, session, isUpdateAvailBlncForSale, isUpdateOnHandBlncForSale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMenuItemName(Recepie recepie) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias("menuItem", "item");
            criteria.setProjection((Projection)Projections.property((String)"item.name"));
            criteria.add((Criterion)Restrictions.eq((String)RecipeTable.PROP_ID, (Object)recepie.getId()));
            String string = (String)criteria.uniqueResult();
            return string;
        }
        finally {
            this.closeSession(session);
        }
    }
}

