/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.dao.BaseRecipeTableDAO;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class RecipeTableDAO
extends BaseRecipeTableDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeTable findBy(String menuItemId) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias(RecipeTable.PROP_MENU_ITEM, "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)menuItemId));
            RecipeTable recipeTable = (RecipeTable)criteria.uniqueResult();
            return recipeTable;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findMenuItems(Recepie recipe) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)RecipeTable.PROP_MENU_ITEM)));
            criteria.createAlias("recipeList", "r");
            criteria.add((Criterion)Restrictions.eq((String)"r.id", (Object)recipe.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecipeTable> findRecipeTables(Recepie recipe) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias("recipeList", "r");
            criteria.add((Criterion)Restrictions.eq((String)"r.id", (Object)recipe.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecipeTable> findRecipeTables(String searchString) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)searchString)) {
                Disjunction disjunction = Restrictions.disjunction();
                criteria.createAlias("recipeList", "r");
                disjunction.add(Restrictions.ilike((String)"r.name", (String)searchString, (MatchMode)MatchMode.ANYWHERE));
                criteria.createAlias(RecipeTable.PROP_MENU_ITEM, "item");
                disjunction.add(Restrictions.ilike((String)"item", (String)searchString, (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)disjunction);
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveRecipeTables(List<MenuItem> menuItems, Object ... objects) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            if (objects != null) {
                for (Object object : objects) {
                    if (object == null) continue;
                    session.saveOrUpdate(object);
                }
            }
            if (menuItems != null) {
                for (MenuItem menuItem : menuItems) {
                    RecipeTable recipeTable = this.findBy(menuItem.getId());
                    if (recipeTable == null) continue;
                    session.delete((Object)recipeTable);
                }
            }
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

