/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.dao.BaseShopFloorDAO;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

public class ShopFloorDAO
extends BaseShopFloorDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ShopFloor> findAll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)ShopFloor.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean hasFloor() {
        Number result = (Number)this.getSession().createCriteria(this.getReferenceClass()).setProjection(Projections.rowCount()).uniqueResult();
        return result.intValue() != 0;
    }

    public void initializeTables(ShopFloor shopFloor) {
        if (shopFloor == null || shopFloor.getId() == null) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shopFloor);
            Hibernate.initialize(shopFloor.getTables());
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void delete(ShopFloor shopFloor) throws HibernateException {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            Set<ShopTable> tables = shopFloor.getTables();
            if (tables != null && !tables.isEmpty()) {
                shopFloor.getTables().removeAll(tables);
                this.saveOrUpdate(shopFloor);
            }
            super.delete(shopFloor, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopFloorDAO.class).error((Object)e);
            throw new HibernateException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

