/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableTicket;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BaseShopTableStatusDAO;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Session;

public class ShopTableStatusDAO
extends BaseShopTableStatusDAO {
    public void addTicketsToShopTableStatus(List<Integer> tableNumbers, List<Ticket> tickets, Session session) {
        if (tableNumbers == null || tableNumbers.isEmpty() || tickets == null) {
            return;
        }
        for (Integer tableNumber : tableNumbers) {
            ShopTableStatus shopTableStatus = this.get(tableNumber);
            if (shopTableStatus == null) {
                shopTableStatus = new ShopTableStatus();
                shopTableStatus.setId(tableNumber);
            }
            shopTableStatus.setTableStatus(TableStatus.Seat);
            shopTableStatus.addToTableTickets(tickets);
            if (session == null) {
                this.saveOrUpdate(shopTableStatus);
                continue;
            }
            session.saveOrUpdate((Object)shopTableStatus);
        }
    }

    public void removeTicketFromShopTableStatus(Ticket ticket, Session session) {
        if (ticket == null) {
            return;
        }
        List<Integer> tableNumbers = ticket.getTableNumbers();
        if (tableNumbers == null || tableNumbers.isEmpty()) {
            return;
        }
        for (Integer tableNumber : tableNumbers) {
            ShopTableStatus shopTableStatus;
            ShopTableStatus shopTableStatus2 = shopTableStatus = session == null ? this.get(tableNumber) : this.get(tableNumber, session);
            if (shopTableStatus == null) {
                return;
            }
            List<ShopTableTicket> ticketNumbers = shopTableStatus.getTicketNumbers();
            if (ticketNumbers != null) {
                Iterator<ShopTableTicket> iterator = ticketNumbers.iterator();
                while (iterator.hasNext()) {
                    ShopTableTicket shopTableTicket = iterator.next();
                    if (!shopTableTicket.getTicketId().equals(ticket.getId())) continue;
                    iterator.remove();
                }
            }
            shopTableStatus.setTicketNumbers(ticketNumbers);
            if (ticketNumbers == null || ticketNumbers.isEmpty()) {
                shopTableStatus.setTicketNumbers(null);
                shopTableStatus.setTableStatus(TableStatus.Available);
            }
            if (session == null) {
                this.saveOrUpdate(shopTableStatus);
                continue;
            }
            this.saveOrUpdate(shopTableStatus, session);
        }
    }
}

