/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Tax;
import com.floreantpos.model.dao.BaseTaxDAO;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.query.Query;

public class TaxDAO
extends BaseTaxDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tax findByTaxRate(double taxRate) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Tax.class);
            criteria.add((Criterion)Restrictions.eq((String)Tax.PROP_RATE, (Object)taxRate));
            Tax tax = (Tax)criteria.uniqueResult();
            return tax;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(Tax tax, String code) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Tax.PROP_NAME, (Object)code).ignoreCase());
            if (tax.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)Tax.PROP_ID, (Object)tax.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = rowCount.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tax> findAllUnSyncTax() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)Tax.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)Tax.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateTaxSync(List<String> ids, boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update Tax set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, Tax.PROP_CLOUD_SYNCED, Tax.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateTaxs(List<Tax> dataList) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Tax item : dataList) {
                Tax existingItem = this.get(item.getId());
                if (existingItem != null) {
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    this.update(existingItem, session);
                    continue;
                }
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

