/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.BaseTaxGroupDAO;
import com.floreantpos.model.dao.TaxDAO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.query.Query;

public class TaxGroupDAO
extends BaseTaxGroupDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(TaxGroup taxGroup, String name) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)TaxGroup.PROP_NAME, (Object)name).ignoreCase());
            if (taxGroup.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)TaxGroup.PROP_ID, (Object)taxGroup.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = rowCount.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxGroup> findAllUnSyncTaxGroup() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)TaxGroup.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)TaxGroup.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaxGroupSync(List<String> ids, boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update Tax set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, Tax.PROP_CLOUD_SYNCED, Tax.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateTaxGroups(List<TaxGroup> dataList) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (TaxGroup item : dataList) {
                ArrayList<Tax> existingsTax = new ArrayList<Tax>();
                if (item.getTaxes() != null) {
                    for (Tax tax : item.getTaxes()) {
                        Tax existingTax = TaxDAO.getInstance().get(tax.getId());
                        if (existingsTax == null) continue;
                        existingsTax.add(existingTax);
                    }
                }
                item.setTaxes(existingsTax);
                TaxGroup existingItem = this.get(item.getId());
                if (existingItem != null) {
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    this.update(existingItem, session);
                    continue;
                }
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

