/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.DataUpdateInfo;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.BaseTicketDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.DataUpdateInfoDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.KitchenTicketItemDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.payment.PaymentPlugin;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.NumericGlobalIdGenerator;
import com.floreantpos.util.StoreUtil;
import com.orocube.rest.service.mqtt.NotificationServiceUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.Transformers;

public class TicketDAO
extends BaseTicketDAO {
    private static final TicketDAO instance = new TicketDAO();

    @Override
    public Order getDefaultOrder() {
        return Order.desc((String)Ticket.PROP_CREATE_DATE);
    }

    @Override
    protected Serializable save(Object obj, Session session) {
        Ticket ticket = (Ticket)obj;
        if (StringUtils.isEmpty((String)ticket.getStoreSessionId())) {
            ticket.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        Serializable save = super.save(obj, session);
        this.performPostSaveOperations(session, ticket);
        return save;
    }

    @Override
    protected void update(Object obj, Session session) {
        Ticket ticket = (Ticket)obj;
        if (StringUtils.isEmpty((String)ticket.getStoreSessionId())) {
            ticket.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        super.update(obj, session);
        this.performPostSaveOperations(session, ticket);
    }

    @Override
    public synchronized void saveOrUpdate(Ticket ticket) {
        if (StringUtils.isEmpty((String)ticket.getStoreSessionId())) {
            ticket.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.saveOrUpdate(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
        NotificationServiceUtils.pulishTicket(ticket.getId());
    }

    @Override
    public void saveOrUpdate(Ticket ticket, Session session) {
        this.saveOrUpdate(ticket, session, true);
    }

    private void performPostSaveOperations(Session session, Ticket ticket) {
        this.updateStock(ticket, session);
        ticket.clearDeletedItems();
        this.clearVoidedItems(ticket);
        DataUpdateInfo lastUpdateInfo = DataUpdateInfoDAO.getLastUpdateInfo(session);
        if (lastUpdateInfo != null) {
            lastUpdateInfo.setLastUpdateTime(new Date());
            DataUpdateInfoDAO.getInstance().update(lastUpdateInfo, session);
        }
    }

    public synchronized void saveOrUpdateSplitTickets(List<Ticket> tickets, List<Integer> tableNumbers) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            Ticket parentTicket = tickets.get(0);
            for (Ticket ticket : tickets) {
                ticket.addProperty("split_ticket_id", parentTicket.getId());
                ticket.addProperty("split", "true");
                this.saveOrUpdate(ticket, session, false);
            }
            ShopTableStatusDAO.getInstance().addTicketsToShopTableStatus(tableNumbers, tickets, session);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdate(Ticket ticket, Session session, boolean updateTableStatus) {
        boolean newTicket;
        boolean bl = newTicket = StringUtils.isEmpty((String)ticket.getId()) ? true : this.isNewTicket(ticket.getId(), session);
        if (newTicket) {
            if (StringUtils.isEmpty((String)ticket.getId())) {
                ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
            }
            if (StringUtils.isEmpty((String)ticket.getShortId())) {
                ticket.setShortId(RandomStringUtils.randomNumeric((int)7));
            }
            ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
        }
        ticket.setActiveDate(StoreDAO.getServerTimestamp());
        ticket.updateGratuityInfo();
        if (ticket.isPaid().booleanValue() && ticket.getDueAmount() > 0.0) {
            ticket.setPaid(false);
        }
        if (newTicket) {
            this.save(ticket, session);
        } else {
            this.update(ticket, session);
        }
        if (updateTableStatus) {
            this.updateShopTableStatus(ticket, session, newTicket);
        }
    }

    private boolean isNewTicket(String id, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.setProjection(Projections.rowCount());
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)id));
        Number number = (Number)criteria.uniqueResult();
        return number == null || number.intValue() == 0;
    }

    private void clearVoidedItems(Ticket ticket) {
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            ticketItem.setVoidItem(null);
        }
    }

    public synchronized void saveKitchenPrintStatus(Ticket ticket, KitchenTicket kitchenTicket) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            List<KitchenTicketItem> ticketItems = kitchenTicket.getTicketItems();
            Iterator<KitchenTicketItem> iterator = ticketItems.iterator();
            while (iterator.hasNext()) {
                KitchenTicketItem kitchenTicketItem = iterator.next();
                if (!kitchenTicketItem.isVoided().booleanValue()) continue;
                String ticketItemId = kitchenTicketItem.getVoidedItemId();
                KitchenTicketItemDAO.getInstance().markVoided(ticketItemId, kitchenTicketItem.isModifierItem(), session);
                iterator.remove();
            }
            if (ticketItems.size() > 0) {
                KitchenTicketDAO.getInstance().saveOrUpdate(kitchenTicket, session);
            }
            ticket.clearDeletedItems();
            if (ticket.getId() == null) {
                ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
            }
            this.saveOrUpdate(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateShopTableStatus(Ticket ticket, Session session, boolean isNewTicket) {
        List<Integer> tableNumbers = ticket.getTableNumbers();
        if (tableNumbers == null || tableNumbers.isEmpty()) {
            return;
        }
        if (isNewTicket || ticket.isShouldUpdateTableStatus()) {
            ShopTableDAO.getInstance().occupyTables(ticket, session);
            ticket.setShouldUpdateTableStatus(false);
        }
        if (ticket.isClosed().booleanValue()) {
            ShopTableStatusDAO.getInstance().removeTicketFromShopTableStatus(ticket, session);
        }
    }

    public void voidTicket(Ticket ticket) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            ticket.setDiscounts(null);
            ticket.calculatePrice();
            this.populateVoidItems(ticket);
            ticket.calculatePrice();
            session = this.createNewSession();
            tx = session.beginTransaction();
            List<KitchenTicket> kitchenTickets = KitchenTicketDAO.getInstance().findByParentId(ticket.getId());
            Date serverTimestamp = StoreDAO.getServerTimestamp();
            if (kitchenTickets != null) {
                for (KitchenTicket kitchenTicket : kitchenTickets) {
                    kitchenTicket.setCreateDate(serverTimestamp);
                    kitchenTicket.setVoided(true);
                    session.saveOrUpdate((Object)kitchenTicket);
                }
            }
            ticket.setVoided(true);
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            String actionDescription = POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId() + "; Total: " + NumberUtil.formatNumber(ticket.getTotalAmountWithTips());
            ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), ActionHistory.VOID_CHECK, actionDescription, session);
            tx.commit();
        }
        catch (Exception x) {
            try {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw x;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        this.closeSession(session);
    }

    private void populateVoidItems(Ticket ticket) {
        HashMap<String, Double> voidedItemQuantityMap = new HashMap<String, Double>();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (!ticketItem.isVoided().booleanValue()) continue;
            Double previousValue = (Double)voidedItemQuantityMap.get(ticketItem.getMenuItemId());
            if (previousValue == null) {
                previousValue = 0.0;
            }
            double voidedQuantity = 0.0;
            voidedQuantity = Math.abs(ticketItem.getQuantity());
            if ((voidedQuantity += previousValue.doubleValue()) == 0.0) continue;
            voidedItemQuantityMap.put(ticketItem.getMenuItemId(), voidedQuantity);
        }
        HashMap<TicketItem, VoidItem> toBeVoidedItemsMap = new HashMap<TicketItem, VoidItem>();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.getId() == null || ticketItem.isVoided().booleanValue() || ticketItem.getVoidItem() != null) continue;
            Double voidedQuantity = (Double)voidedItemQuantityMap.get(ticketItem.getMenuItemId());
            double toBeVoidQuantity = ticketItem.getQuantity();
            if (voidedQuantity != null && voidedQuantity > 0.0) {
                if (voidedQuantity >= toBeVoidQuantity) {
                    voidedItemQuantityMap.put(ticketItem.getMenuItemId(), voidedQuantity - toBeVoidQuantity);
                    continue;
                }
                toBeVoidQuantity -= voidedQuantity.doubleValue();
            }
            toBeVoidedItemsMap.put(ticketItem, new VoidItem(ticket.getVoidReason(), ticket.isWasted(), toBeVoidQuantity));
        }
        Set keys = toBeVoidedItemsMap.keySet();
        for (TicketItem ticketItem : keys) {
            VoidItem voidItem = (VoidItem)toBeVoidedItemsMap.get(ticketItem);
            ticket.voidItem(ticketItem, voidItem.getVoidReason(), voidItem.isItemWasted(), voidItem.getQuantity());
        }
    }

    public void loadFullTicket(Ticket ticket) {
        if (ticket.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(ticket.getTicketItems()) && Hibernate.isInitialized(ticket.getTransactions())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)ticket);
            Hibernate.initialize(ticket.getTicketItems());
            Hibernate.initialize(ticket.getTransactions());
        }
        finally {
            this.closeSession(session);
        }
    }

    public Ticket loadFullTicket(String id) {
        Session session = this.createNewSession();
        Ticket ticket = (Ticket)session.get(this.getReferenceClass(), (Serializable)((Object)id));
        if (ticket == null) {
            return null;
        }
        Hibernate.initialize(ticket.getTicketItems());
        Hibernate.initialize(ticket.getTransactions());
        session.close();
        return ticket;
    }

    public Ticket loadCouponsAndTransactions(String ticketId) {
        Session session = this.createNewSession();
        Ticket ticket = (Ticket)session.get(this.getReferenceClass(), (Serializable)((Object)ticketId));
        Hibernate.initialize(ticket.getTransactions());
        session.close();
        return ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets() {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.addOrder(this.getDefaultOrder());
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets(Integer customerId) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            criteria.addOrder(this.getDefaultOrder());
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets(Terminal terminal, UserType userType) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (userType != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_TYPE_ID, (Object)userType.getId()));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            criteria.addOrder(this.getDefaultOrder());
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTickets() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteriaFilters(criteria);
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTickets(PaginatedTableModel tableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteriaFilters(criteria);
            criteria.addOrder(this.getDefaultOrder());
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            tableModel.setRows(criteria.list());
            return;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findCustomerTickets(String customerId, PaginatedTableModel tableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            criteria.setFirstResult(0);
            criteria.setMaxResults(tableModel.getPageSize());
            List ticketList = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                tableModel.setNumRows(rowCount.intValue());
            }
            tableModel.setCurrentRowIndex(0);
            List list = ticketList;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findNextCustomerTickets(Integer customerId, PaginatedTableModel tableModel, String filter) {
        List list;
        Session session = null;
        Criteria criteria = null;
        try {
            int nextIndex = tableModel.getNextRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            if (filter.equals((Object)PaymentStatusFilter.OPEN)) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            criteria.setFirstResult(nextIndex);
            criteria.setMaxResults(tableModel.getPageSize());
            List ticketList = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                tableModel.setNumRows(rowCount.intValue());
            }
            tableModel.setCurrentRowIndex(nextIndex);
            list = ticketList;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findPreviousCustomerTickets(Integer customerId, PaginatedTableModel tableModel, String filter) {
        List list;
        Session session = null;
        Criteria criteria = null;
        try {
            int previousIndex = tableModel.getPreviousRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            if (filter.equals((Object)PaymentStatusFilter.OPEN)) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            criteria.setFirstResult(previousIndex);
            criteria.setMaxResults(tableModel.getPageSize());
            List ticketList = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                tableModel.setNumRows(rowCount.intValue());
            }
            tableModel.setCurrentRowIndex(previousIndex);
            list = ticketList;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketByCustomer(Integer customerId) {
        Session session = null;
        Criteria criteria = null;
        try {
            List ticketList;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            List list = ticketList = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> findTickets(PaymentStatusFilter psFilter, OrderType orderType) {
        return this.findTicketsForUser(psFilter, orderType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForUser(PaymentStatusFilter psFilter, OrderType orderType, User user) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (psFilter == PaymentStatusFilter.OPEN) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            } else if (psFilter == PaymentStatusFilter.PAID) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.TRUE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            } else if (psFilter == PaymentStatusFilter.CLOSED) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
                Calendar currentTime = Calendar.getInstance();
                currentTime.add(11, -24);
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CLOSING_DATE, (Object)currentTime.getTime()));
            }
            if (orderType != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
            }
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOpenTickets(User user) {
        Session session = null;
        try {
            Number result;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if ((result = (Number)criteria.uniqueResult()) != null) {
                boolean bl = result.intValue() > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTicketsForUser(User user) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)(user == null ? null : user.getId())));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets(Date startDate, Date endDate) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)endDate));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findClosedTickets(Date startDate, Date endDate) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            if (startDate != null && endDate != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)startDate));
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)endDate));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void closeOrder(Ticket ticket) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.saveOrUpdate(ticket);
            User driver = ticket.getAssignedDriver();
            if (driver != null) {
                driver.setAvailableForDelivery(true);
                UserDAO.getInstance().saveOrUpdate(driver);
            }
            ShopTableDAO.getInstance().releaseTables(ticket);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(TicketDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTickets(Date startDate, Date endDate, boolean closed, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)endDate));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForLaborHour(Date startDate, Date endDate, int hour, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_ACTIVE_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_ACTIVE_DATE, (Object)endDate));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CREATION_HOUR, (Object)hour));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForShift(Date startDate, Date endDate, Shift shit, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)endDate));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_SHIFT_ID, (Object)(shit == null ? null : shit.getId())));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public static TicketDAO getInstance() {
        return instance;
    }

    private void updateCriteriaFilters(Criteria criteria) {
        User user = Application.getCurrentUser();
        PaymentStatusFilter paymentStatusFilter = TerminalConfig.getPaymentStatusFilter();
        String orderTypeFilter = TerminalConfig.getOrderTypeFilter();
        boolean filterByMyTicket = TerminalConfig.isFilterByOwner();
        OrderType orderType = null;
        if (!"ALL".equals(orderTypeFilter)) {
            orderType = OrderTypeDAO.getInstance().findByName(orderTypeFilter);
        }
        if (paymentStatusFilter == PaymentStatusFilter.OPEN) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (!user.canViewAllOpenTickets() || filterByMyTicket) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
        } else if (paymentStatusFilter == PaymentStatusFilter.CLOSED) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            StoreSessionControl currentStoreOperation = StoreUtil.getCurrentStoreOperation();
            if (currentStoreOperation != null && currentStoreOperation.getCurrentData() != null) {
                Date openTime = currentStoreOperation.getCurrentData().getOpenTime();
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)openTime));
            }
            if (!user.canViewAllCloseTickets() || filterByMyTicket) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
        }
        if (!orderTypeFilter.equals(POSConstants.ALL)) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
        }
    }

    public void deleteTickets(List<Ticket> tickets) {
        this.deleteTickets(tickets, false);
    }

    public void deleteTickets(List<Ticket> tickets, boolean releaseTables) {
        this.deleteTickets(tickets, releaseTables, false);
    }

    public void deleteTickets(List<Ticket> tickets, boolean releaseTables, boolean updateStock) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.deleteTickets(session, tickets, releaseTables, updateStock);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(TicketDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void deleteTickets(Session session, List<Ticket> tickets, boolean releaseTables) throws Exception {
        this.deleteTickets(session, tickets, releaseTables, false);
    }

    public void deleteTickets(Session session, List<Ticket> tickets, boolean releaseTables, boolean updateStock) throws Exception {
        for (Ticket ticket : tickets) {
            List<Integer> tableNumbers;
            if (!ticket.isClosed().booleanValue()) {
                ArrayList<TicketItem> removedTicketItems = new ArrayList<TicketItem>();
                removedTicketItems.addAll(ticket.getTicketItems());
                for (TicketItem ticketItem : removedTicketItems) {
                    ticket.addDeletedItems(ticketItem);
                }
                if (updateStock && ticket.getPaidAmount() > 0.0) {
                    TicketDAO.getInstance().updateStock(ticket, session);
                }
            }
            super.delete(ticket, session);
            if (!releaseTables || (tableNumbers = ticket.getTableNumbers()) == null || tableNumbers.isEmpty()) continue;
            ShopTableDAO.getInstance().freeTables(tableNumbers, session);
        }
    }

    protected void updateStock(Ticket ticket, Session session) {
        try {
            if (!this.shouldUpdateStock(ticket)) {
                return;
            }
            InventoryLocation defaultOutInventoryLocation = null;
            InventoryLocation defaultInInventoryLocation = null;
            defaultOutInventoryLocation = DataProvider.get().getDefaultOutLocation();
            if (defaultOutInventoryLocation == null) {
                return;
            }
            HashMap<String, Double> itemMap = this.buildItemMapForInventoryAdjustment(ticket);
            HashMap<String, Double> voidedItemsMap = this.buildItemMapForVoidItems(ticket, session);
            this.adjustInventory(ticket, itemMap, InventoryTransactionType.OUT, "TICKET SALES", defaultOutInventoryLocation, session);
            if (voidedItemsMap != null && voidedItemsMap.size() > 0) {
                defaultInInventoryLocation = DataProvider.get().getDefaultInLocation();
                this.adjustInventory(ticket, voidedItemsMap, InventoryTransactionType.IN, "VOID", defaultInInventoryLocation, session);
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), "Failed to update stock balance for ticket: " + ticket.getId());
        }
    }

    private void adjustInventory(Ticket ticket, HashMap<String, Double> itemMap, InventoryTransactionType transactionType, String reason, InventoryLocation location, Session session) throws Exception {
        Store store = Application.getInstance().getStore();
        boolean isUpdateOnHandBlncForSale = store.isUpdateOnHandBlncForSale();
        boolean isUpdateAvailBlncForSale = store.isUpdateAvlBlncForSale();
        for (String menuItemId : itemMap.keySet()) {
            Double unitQuantity = itemMap.get(menuItemId);
            MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemWithFields(session, menuItemId, MenuItem.PROP_NAME, MenuItem.PROP_PRICE, MenuItem.PROP_SKU, MenuItem.PROP_BARCODE, MenuItem.PROP_UNIT_ID, MenuItem.PROP_COST, MenuItem.PROP_AVERAGE_UNIT_PURCHASE_PRICE, MenuItem.PROP_AVG_COST, MenuItem.PROP_DEFAULT_RECIPE_ID);
            if (menuItem == null || !menuItem.isInventoryItem().booleanValue()) continue;
            InventoryTransaction outTrans = new InventoryTransaction();
            outTrans.setReason(reason);
            outTrans.setTransactionDate(new Date());
            outTrans.setMenuItem(menuItem);
            outTrans.setType(transactionType.getType());
            outTrans.setTicketId(ticket.getId());
            outTrans.setUser(ticket.getOwner());
            InventoryUnit unit = menuItem.getUnit();
            outTrans.setUnitPrice(menuItem.getPrice());
            outTrans.setQuantity(unitQuantity);
            if (unit != null) {
                outTrans.setUnit(unit.getCode());
            }
            outTrans.setUnitCost(menuItem.getAverageUnitPurchasePrice());
            if (transactionType == InventoryTransactionType.IN) {
                outTrans.setToInventoryLocation(location);
            } else {
                outTrans.setFromInventoryLocation(location);
            }
            outTrans.setTotal(outTrans.getUnitCost() * outTrans.getQuantity());
            InventoryTransactionDAO.getInstance().adjustInventoryStock(outTrans, session, isUpdateAvailBlncForSale, isUpdateOnHandBlncForSale);
            MenuItemInventoryStatus stockStatus = MenuItemInventoryStatusDAO.getInstance().get(menuItemId, session);
            if (stockStatus == null || !(stockStatus.getAvailableUnit() <= 0.0) || !StringUtils.isNotEmpty((String)menuItem.getDefaultRecipeId())) continue;
            Recepie recepie = RecepieDAO.getInstance().get(menuItem.getDefaultRecipeId(), session);
            RecepieDAO.getInstance().adjustRecipeItemsFromInventory(Arrays.asList(recepie), session);
        }
    }

    private HashMap<String, Double> buildItemMapForInventoryAdjustment(Ticket ticket) {
        List<TicketItem> ticketItems = ticket.getTicketItems();
        HashMap<String, Double> itemMap = new HashMap<String, Double>();
        this.populateItemToMap(ticketItems, itemMap);
        return itemMap;
    }

    private void populateItemToMap(List<TicketItem> ticketItems, HashMap<String, Double> itemMap) {
        for (TicketItem ticketItem : ticketItems) {
            if (!ticketItem.isInventoryItem().booleanValue() || ticketItem.getMenuItemId() == null || ticketItem.isVoided().booleanValue() || ticketItem.isInventoryAdjusted()) continue;
            Double previousValue = itemMap.get(ticketItem.getMenuItemId());
            if (previousValue == null) {
                previousValue = 0.0;
            }
            Double toBeAdjustQty = ticketItem.getQuantity();
            toBeAdjustQty = toBeAdjustQty - ticketItem.getInventoryAdjustQty();
            if ((toBeAdjustQty = Double.valueOf(toBeAdjustQty + previousValue)) <= 0.0) continue;
            itemMap.put(ticketItem.getMenuItemId(), toBeAdjustQty);
            ticketItem.setInventoryAdjustQty(ticketItem.getQuantity());
            if (!ticketItem.isComboItem().booleanValue()) continue;
            this.populateItemToMap(ticketItem.getComboItems(), itemMap);
        }
    }

    private HashMap<String, Double> buildItemMapForVoidItems(Ticket ticket, Session session) {
        List<TicketItem> ticketItems = ticket.getTicketItems();
        HashMap<String, Double> voidItemMap = new HashMap<String, Double>();
        this.populateVoidItemToMap(ticket, session, ticketItems, voidItemMap);
        return voidItemMap;
    }

    private void populateVoidItemToMap(Ticket ticket, Session session, List<TicketItem> ticketItems, HashMap<String, Double> voidItemMap) {
        for (TicketItem voidTicketItem : ticketItems) {
            VoidItem voidItem = voidTicketItem.getVoidItem();
            String menuItemId = voidTicketItem.getMenuItemId();
            String mapKey = menuItemId;
            if (StringUtils.isEmpty((String)mapKey)) {
                mapKey = voidTicketItem.getName() + "_" + voidTicketItem.getUnitPrice();
                voidTicketItem.setInventoryItem(false);
            }
            if (voidItem == null || !voidTicketItem.isVoided().booleanValue()) continue;
            Double previousValue = voidItemMap.get(mapKey);
            if (previousValue == null) {
                previousValue = 0.0;
            }
            double toBeAdjustQty = 0.0;
            toBeAdjustQty = voidItem.getQuantity();
            if ((toBeAdjustQty += previousValue.doubleValue()) == 0.0) continue;
            if (!voidItem.isItemWasted().booleanValue() && !voidTicketItem.isInventoryAdjusted()) {
                voidItemMap.put(mapKey, toBeAdjustQty);
                voidTicketItem.setInventoryAdjustQty(voidTicketItem.getQuantity());
            }
            Boolean isPrintedToKitchen = voidTicketItem.isPrintedToKitchen();
            VoidItemDAO.getInstance().saveAndSentToKitchenIfNeeded(voidItem, isPrintedToKitchen, ticket, session);
            List<VoidItem> voidedModifiers = voidItem.getVoidedModifiers();
            if (voidedModifiers != null && voidedModifiers.size() > 0) {
                for (VoidItem voidedModifier : voidedModifiers) {
                    VoidItemDAO.getInstance().saveAndSentToKitchenIfNeeded(voidedModifier, isPrintedToKitchen, ticket, session);
                }
            }
            if (!voidTicketItem.isComboItem().booleanValue()) continue;
            this.populateVoidItemToMap(ticket, session, voidTicketItem.getComboItems(), voidItemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTickets(Date start, Date end) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (start != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)start));
            }
            if (end != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)end));
            }
            criteria.add(Restrictions.isNotNull((String)Ticket.PROP_DELIVERY_DATE));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTickets(PaginatedTableModel tableModel, Date beginingDeliveryDate, Date endingDeliveryDate) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(this.getDefaultOrder());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (beginingDeliveryDate != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)beginingDeliveryDate));
            }
            if (endingDeliveryDate != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)endingDeliveryDate));
            }
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            tableModel.setRows(criteria.list());
            return;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> getTicketsWithSpecificFields(String ... fields) {
        return this.getTicketsWithSpecificFields(true, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> getTicketsWithSpecificFields(boolean isOnlyOpenTickets, String ... fields) {
        Session session = null;
        Criteria criteria = null;
        User currentUser = Application.getCurrentUser();
        boolean filterUser = !currentUser.isAdministrator() || !currentUser.isManager();
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Ticket.class);
            if (isOnlyOpenTickets) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            if (filterUser) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)currentUser.getId()));
            }
            ProjectionList projectionList = Projections.projectionList();
            for (String field : fields) {
                projectionList.add((Projection)Projections.property((String)field), field);
            }
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(Ticket.class));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTicketByOnlineOrderId(String onlineOrderId) {
        Session session = null;
        try {
            session = this.createNewSession();
            String sql = "select * from TICKET_PROPERTIES where PROPERTY_VALUE='%s' and PROPERTY_NAME='%s'";
            sql = String.format(sql, onlineOrderId, "onlineOrderId");
            NativeQuery sqlQuery = session.createSQLQuery(sql);
            List list = sqlQuery.list();
            boolean bl = list.size() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTicketByReservationId(String reservationId) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)reservationId));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TYPE, (Object)TicketType.RESERVATION.getTypeNo()));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                boolean bl = rowCount.intValue() > 0;
                return bl;
            }
        }
        catch (Exception e) {
            PosLog.error(this.getReferenceClass(), e);
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOnlineTickets(PaginatedTableModel tableModel) {
        Session session = null;
        try {
            session = this.createNewSession();
            String sql = "select TICKET_ID from TICKET_PROPERTIES where PROPERTY_VALUE='online' and PROPERTY_NAME='source'";
            NativeQuery sqlQuery = session.createSQLQuery(sql);
            List list = sqlQuery.list();
            ArrayList<Ticket> ticketList = new ArrayList<Ticket>();
            for (String ticketId : list) {
                if (ticketId == null) continue;
                Ticket ticket = this.get(ticketId);
                ticketList.add(ticket);
            }
            ArrayList<Ticket> arrayList = ticketList;
            return arrayList;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDriverOut(List<Ticket> tickets, List<User> drivers) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = TicketDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            for (Ticket ticket : tickets) {
                ticket.addProperty("OUT_AT", DateUtil.getReportDate());
                User driver = ticket.getAssignedDriver();
                if (driver != null && !drivers.contains(driver)) {
                    drivers.add(driver);
                }
                this.saveOrUpdate(ticket, session);
            }
            transaction.commit();
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTicketForDeliveryDispath(PaginatedTableModel model, OrderType orderType, String customerId, Date startDate, Date endDate, boolean onlineOrderOnly, boolean isPickupOnly, boolean isDeliveryOnly, boolean filterUnassigned) {
        User user = Application.getCurrentUser();
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(this.getDefaultOrder());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (StringUtils.isNotEmpty((String)customerId)) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            }
            if (!user.canViewAllOpenTickets()) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if (startDate != null && endDate != null) {
                criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)startDate), (Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)endDate)));
            }
            if (isPickupOnly) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.TRUE));
            }
            if (isDeliveryOnly) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.FALSE));
            }
            if (filterUnassigned) {
                criteria.add(Restrictions.isNull((String)Ticket.PROP_ASSIGNED_DRIVER_ID));
            }
            int currentRowIndex = model.getCurrentRowIndex();
            criteria.setFirstResult(currentRowIndex);
            criteria.setMaxResults(model.getPageSize());
            List list = criteria.list();
            if (onlineOrderOnly) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Ticket ticket = (Ticket)iterator.next();
                    if (ticket.isSourceOnline()) continue;
                    iterator.remove();
                }
            }
            model.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void closeOrders(Ticket ... tickets) {
        Session session = TicketDAO.getInstance().createNewSession();
        Transaction transaction = null;
        if (tickets == null) {
            return;
        }
        try {
            transaction = session.beginTransaction();
            Date serverTimestamp = StoreDAO.getServerTimestamp();
            for (Ticket ticket : tickets) {
                ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                ticket.setClosed(true);
                ticket.setClosingDate(serverTimestamp);
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
            }
            transaction.commit();
        }
        catch (Exception e) {
            PosLog.error(OrderController.class, e);
            POSMessageDialog.showError(e.getMessage());
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findBarTabOpenTickets(OrderType orderType) {
        List list;
        ArrayList<String> barTabOrderTypes;
        Session session;
        block6: {
            Iterator<OrderType> iterator;
            session = null;
            try {
                barTabOrderTypes = new ArrayList<String>();
                List<OrderType> orderTypes = DataProvider.get().getOrderTypes();
                if (orderTypes != null) {
                    for (OrderType ot : orderTypes) {
                        if (!ot.isBarTab().booleanValue()) continue;
                        barTabOrderTypes.add(ot.getId());
                    }
                }
                if (barTabOrderTypes != null && !barTabOrderTypes.isEmpty()) break block6;
                iterator = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return iterator;
        }
        session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        User user = Application.getCurrentUser();
        if (user != null && !user.canViewAllOpenTickets()) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
        }
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)(orderType == null ? null : orderType.getId())));
        criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, barTabOrderTypes));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
        criteria.addOrder(this.getDefaultOrder());
        List list2 = list = criteria.list();
        this.closeSession(session);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findVoidTicketByDate(Date startDate, Date endDate, Terminal terminal) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)true));
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CLOSING_DATE, (Object)endDate));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public User findOwner(String ticketId) {
        if (ticketId == null) {
            return null;
        }
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)ticketId));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_OWNER_ID));
        criteria.setProjection((Projection)projectionList);
        if (criteria.list().isEmpty()) {
            return null;
        }
        User user = UserDAO.getInstance().get((String)criteria.list().get(0));
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket findByCustomerAndDeliveryDate(String customerId, Date deliveryDate) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            criteria.add(Restrictions.between((String)Ticket.PROP_DELIVERY_DATE, (Object)DateUtil.startOfDay(deliveryDate), (Object)DateUtil.endOfDay(deliveryDate)));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)false));
            List list = criteria.list();
            if (!list.isEmpty()) {
                Ticket ticket = (Ticket)list.get(0);
                return ticket;
            }
            Ticket ticket = null;
            return ticket;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveMergedTickets(List<Ticket> tickets, Ticket rootTicket) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Ticket ticket : tickets) {
                this.update(ticket, session);
            }
            this.deleteTickets(session, tickets, true);
            this.saveOrUpdate(rootTicket, session, true);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateTransferedTicketsList(List<Ticket> ticketsToDelete, List<Ticket> ticketsToUpdate) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            if (ticketsToDelete != null || ticketsToDelete.size() > 0) {
                this.deleteTickets(session, ticketsToDelete, true);
            }
            for (Ticket ticket : ticketsToUpdate) {
                this.saveOrUpdate(ticket, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void reversePayment(Ticket ticket, PosTransaction transaction, boolean forceVoid) {
        String errorMessage = "Failed to reverse payment.";
        if (!forceVoid && transaction instanceof CreditCardTransaction) {
            CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
            try {
                cardProcessor.voidTransaction(transaction);
                if (!transaction.isVoided().booleanValue()) {
                    cardProcessor.refundTransaction(transaction, transaction.getAmount());
                    if (!transaction.isRefunded()) {
                        throw new PosException(errorMessage);
                    }
                }
            }
            catch (Exception e2) {
                try {
                    cardProcessor.refundTransaction(transaction, transaction.getAmount());
                    if (!transaction.isRefunded()) {
                        throw new PosException(errorMessage);
                    }
                }
                catch (Exception e3) {
                    throw new PosException(errorMessage);
                }
            }
            transaction.setVoided(true);
            ticket.setPaidAmount(ticket.getPaidAmount() - transaction.getAmount());
            ticket.setDueAmount(ticket.getDueAmount() + transaction.getAmount());
            ticket.setClosed(false);
            ticket.setPaid(false);
            this.update(ticket);
        } else {
            Session session = null;
            Transaction tx = null;
            try {
                session = this.createNewSession();
                tx = session.beginTransaction();
                PaymentType paymentType = transaction.getPaymentType();
                PaymentPlugin paymentPlugin = paymentType.getPaymentPlugin();
                if (paymentPlugin != null) {
                    paymentPlugin.voidPayment(transaction, session);
                }
                transaction.setVoided(true);
                ticket.setPaidAmount(ticket.getPaidAmount() - transaction.getAmount());
                ticket.setDueAmount(ticket.getDueAmount() + transaction.getAmount());
                ticket.setClosed(false);
                ticket.setPaid(false);
                this.update(ticket, session);
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            finally {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTicketsForUser(User user, Date from, Date to, PaginatedTableModel listModel) {
        Session session = null;
        try {
            Number rowCount;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if (from != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)from), (Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)false)));
            }
            if (to != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)to));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                listModel.setNumRows(rowCount.intValue());
            } else {
                listModel.setNumRows(0);
            }
            criteria.setProjection(null);
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            criteria.addOrder(Order.desc((String)Ticket.PROP_CREATE_DATE));
            listModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findUnsyncedTickets() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE));
            criteria.addOrder(Order.asc((String)Ticket.PROP_CREATE_DATE));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    private boolean shouldUpdateStock(Ticket ticket) {
        if (ticket.isReservation()) {
            return true;
        }
        return (ticket.getPaidAmount() > 0.0 || ticket.hasRefundableItem() != false) && !ticket.isSourceOnline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> getTicketsOfCurrentSession(StoreSession storeSession) {
        List<String> cashDrawerIds;
        Criteria criteria;
        Session session;
        block3: {
            List<Ticket> list;
            session = null;
            criteria = null;
            try {
                cashDrawerIds = CashDrawerDAO.getInstance().getCashDrawerIds(storeSession);
                if (cashDrawerIds != null && !cashDrawerIds.isEmpty()) break block3;
                list = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return list;
        }
        session = this.createNewSession();
        criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE));
        criteria.createAlias("transactions", "tx");
        criteria.add(Restrictions.in((String)("tx." + PosTransaction.PROP_CASH_DRAWER_ID), cashDrawerIds));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List list = criteria.list();
        this.closeSession(session);
        return list;
    }

    public void updateTicketAndTicketItemSync(List<Ticket> ticketOrgin, boolean synced) {
        if (ticketOrgin != null) {
            for (Ticket ticket : ticketOrgin) {
                List<TicketItem> ticketItems;
                this.loadFullTicket(ticket);
                if (!ticket.isCloudSynced().booleanValue() && ticket.isClosed().booleanValue()) {
                    ticket.setCloudSynced(synced);
                    TicketDAO.getInstance().update(ticket);
                }
                if ((ticketItems = ticket.getTicketItems()) == null) continue;
                for (TicketItem ticketItem : ticketItems) {
                    if (ticketItem.isCloudSynced().booleanValue()) continue;
                    ticketItem.setCloudSynced(synced);
                    TicketItemDAO.getInstance().update(ticketItem);
                }
            }
        }
    }

    public void saveOrUpdateTicket(Ticket ticket, Session session) throws Exception {
        if (ticket == null) {
            return;
        }
        String key = ticket.getId();
        Ticket existingTicket = this.get(key);
        if (existingTicket != null) {
            String id = existingTicket.getId();
            long version = existingTicket.getVersion();
            PropertyUtils.copyProperties((Object)existingTicket, (Object)ticket);
            if (ticket.getOutletId() != null) {
                String outletId = String.valueOf(ticket.getOutletId());
                existingTicket.setOutletId(outletId);
            }
            existingTicket.setId(id);
            existingTicket.setVersion(version);
            this.update(existingTicket, session);
        } else {
            this.save(ticket, session);
        }
    }
}

