/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.BaseTicketItemDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.Transformers;

public class TicketItemDAO
extends BaseTicketItemDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTicketItemWithTicket(Integer itemID) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(TicketItem.class);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_MENU_ITEM_ID, (Object)itemID));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            for (TicketItem ticketItem : result) {
                ticketItem.setTicket(null);
                super.delete(ticketItem, session);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TicketItem> findTicketItemWithinDate(Date startDate, Date endDate, Terminal terminal, List<MenuGroup> groups, boolean isInventoryItem) {
        List list;
        Session session = null;
        Criteria criteria = null;
        try {
            List list2;
            ArrayList<String> groupIdList = new ArrayList<String>();
            if (groups != null) {
                for (MenuGroup menuGroup : groups) {
                    groupIdList.add(menuGroup.getId());
                }
            }
            session = this.createNewSession();
            criteria = session.createCriteria(TicketItem.class, "item").createCriteria(TicketItem.PROP_TICKET, "ticket", JoinType.INNER_JOIN);
            criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)startDate, (Object)endDate));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)"ticket.terminalId", (Object)terminal.getId()));
            }
            if (!groupIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)("item." + TicketItem.PROP_GROUP_ID), groupIdList));
            }
            criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_INVENTORY_ITEM), (Object)isInventoryItem));
            ProjectionList pList = Projections.projectionList();
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_NAME)), TicketItem.PROP_NAME);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_UNIT_PRICE)), TicketItem.PROP_UNIT_PRICE);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_ADJUSTED_UNIT_PRICE)), TicketItem.PROP_ADJUSTED_UNIT_PRICE);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_UNIT_COST)), TicketItem.PROP_UNIT_COST);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_GROUP_NAME)), TicketItem.PROP_GROUP_NAME);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_MENU_ITEM_ID)), TicketItem.PROP_MENU_ITEM_ID);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_QUANTITY)), TicketItem.PROP_QUANTITY);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_SERVICE_CHARGE)), TicketItem.PROP_SERVICE_CHARGE);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_ADJUSTED_DISCOUNT)), TicketItem.PROP_ADJUSTED_DISCOUNT);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_ADJUSTED_DISCOUNT_WITHOUT_MODIFIERS)), TicketItem.PROP_ADJUSTED_DISCOUNT_WITHOUT_MODIFIERS);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_ADJUSTED_SUBTOTAL_WITHOUT_MODIFIERS)), TicketItem.PROP_ADJUSTED_SUBTOTAL_WITHOUT_MODIFIERS);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_ADJUSTED_SUBTOTAL)), TicketItem.PROP_ADJUSTED_SUBTOTAL);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_ADJUSTED_TOTAL_WITHOUT_MODIFIERS)), TicketItem.PROP_ADJUSTED_TOTAL_WITHOUT_MODIFIERS);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_ADJUSTED_TOTAL)), TicketItem.PROP_ADJUSTED_TOTAL);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_ADJUSTED_TAX)), TicketItem.PROP_ADJUSTED_TAX);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_ADJUSTED_TAX_WITHOUT_MODIFIERS)), TicketItem.PROP_ADJUSTED_TAX_WITHOUT_MODIFIERS);
            pList.add((Projection)Projections.property((String)("item." + TicketItem.PROP_TAX_INCLUDED)), TicketItem.PROP_TAX_INCLUDED);
            criteria.setProjection((Projection)pList);
            criteria.setResultTransformer(Transformers.aliasToBean(TicketItem.class));
            criteria.addOrder(Order.asc((String)TicketItem.PROP_GROUP_NAME));
            criteria.addOrder(Order.asc((String)TicketItem.PROP_NAME));
            list = list2 = criteria.list();
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TicketItemModifier> findTicketItemModifierWithinDate(Date startDate, Date endDate, Terminal terminal, List<MenuGroup> groups, boolean isInventoryItem) {
        List list;
        Session session = null;
        Criteria criteria = null;
        try {
            List list2;
            ArrayList<String> groupIdList = new ArrayList<String>();
            if (groups != null) {
                for (MenuGroup menuGroup : groups) {
                    groupIdList.add(menuGroup.getId());
                }
            }
            session = this.createNewSession();
            criteria = session.createCriteria(TicketItemModifier.class, "item").createCriteria(TicketItemModifier.PROP_TICKET_ITEM, "ticketItem").createCriteria(TicketItem.PROP_TICKET, "ticket", JoinType.INNER_JOIN);
            criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)startDate, (Object)endDate));
            criteria.add((Criterion)Restrictions.eq((String)("ticketItem." + TicketItem.PROP_INVENTORY_ITEM), (Object)isInventoryItem));
            if (!groupIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)("ticketItem." + TicketItem.PROP_GROUP_ID), groupIdList));
            }
            ProjectionList pList = Projections.projectionList();
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_ITEM_ID)), TicketItemModifier.PROP_ITEM_ID);
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_NAME)), TicketItemModifier.PROP_NAME);
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_MODIFIER_TYPE)), TicketItemModifier.PROP_MODIFIER_TYPE);
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_UNIT_PRICE)), TicketItemModifier.PROP_UNIT_PRICE);
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_ITEM_QUANTITY)), TicketItemModifier.PROP_ITEM_QUANTITY);
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_SERVICE_CHARGE)), TicketItemModifier.PROP_SERVICE_CHARGE);
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_ADJUSTED_UNIT_PRICE)), TicketItemModifier.PROP_ADJUSTED_UNIT_PRICE);
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_ADJUSTED_DISCOUNT)), TicketItemModifier.PROP_ADJUSTED_DISCOUNT);
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_ADJUSTED_SUBTOTAL)), TicketItemModifier.PROP_ADJUSTED_SUBTOTAL);
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_ADJUSTED_TOTAL)), TicketItemModifier.PROP_ADJUSTED_TOTAL);
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_ADJUSTED_TAX)), TicketItemModifier.PROP_ADJUSTED_TAX);
            pList.add((Projection)Projections.property((String)("item." + TicketItemModifier.PROP_TAX_INCLUDED)), TicketItemModifier.PROP_TAX_INCLUDED);
            pList.add((Projection)Projections.property((String)("ticketItem." + TicketItem.PROP_QUANTITY)), "ticketItemQuantity");
            criteria.setProjection((Projection)pList);
            criteria.setResultTransformer(Transformers.aliasToBean(TicketItemModifier.class));
            criteria.addOrder(Order.asc((String)TicketItemModifier.PROP_NAME));
            list = list2 = criteria.list();
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    public void saveOrUpdateTicketItems(List<TicketItem> ticketItems, Session session) throws Exception {
        if (ticketItems == null) {
            return;
        }
        for (TicketItem ticketItem : ticketItems) {
            TicketItem existingTicketItem = this.get(ticketItem.getId());
            if (existingTicketItem != null) {
                String id = existingTicketItem.getId();
                long version = existingTicketItem.getVersion();
                PropertyUtils.copyProperties((Object)existingTicketItem, (Object)ticketItem);
                existingTicketItem.setId(id);
                existingTicketItem.setVersion(version);
                this.update(existingTicketItem, session);
                continue;
            }
            this.save(ticketItem, session);
        }
    }
}

