/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.EmployeeInOutHistory;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.BaseUserDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.UserNotFoundException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;

public class UserDAO
extends BaseUserDAO {
    public static final UserDAO instance = new UserDAO();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(String filterItem) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(User.class);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)filterItem)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_ID, (String)filterItem, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_FIRST_NAME, (String)filterItem, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)User.PROP_LAST_NAME, (String)filterItem, (MatchMode)MatchMode.ANYWHERE))));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> loadUsers(PaginationSupport model, String filterItem) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(User.class);
            if (StringUtils.isNotEmpty((String)filterItem)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_ID, (String)filterItem, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_FIRST_NAME, (String)filterItem, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)User.PROP_LAST_NAME, (String)filterItem, (MatchMode)MatchMode.ANYWHERE))));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
            List list = result;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getRandomUser() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true));
            criteria.setMaxResults(1);
            List users = criteria.list();
            if (users.size() > 0) {
                User user = (User)users.get(0);
                return user;
            }
            User user = null;
            return user;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<User> findAll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findAllUser() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findClockedInUsers() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ACTIVE), (Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true)));
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_CLOCKED_IN, (Object)true));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findAllActive() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Junction activeUserCriteria = Restrictions.disjunction().add(Restrictions.isNull((String)User.PROP_ACTIVE)).add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)activeUserCriteria);
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findActiveUsersForPayroll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Junction activeUserCriteria = Restrictions.disjunction().add(Restrictions.isNull((String)User.PROP_ACTIVE)).add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)activeUserCriteria);
            criteria.addOrder(Order.asc((String)User.PROP_FIRST_NAME));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findDrivers() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_DRIVER, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public User findUser(String userId) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ID, (Object)userId));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            Object result = criteria.uniqueResult();
            if (result != null) {
                User user = (User)result;
                return user;
            }
            throw new UserNotFoundException(Messages.getString("UserDAO.0") + userId + Messages.getString("UserDAO.1"));
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUserBySecretKey(String secretKey) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_PASSWORD, (Object)this.getEncrypedPassword(secretKey)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ACTIVE), (Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true)));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                User user = (User)list.get(0);
                return user;
            }
            User user = null;
            return user;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private String getEncrypedPassword(String secretKey) {
        if (StringUtils.isNotEmpty((String)secretKey)) {
            try {
                secretKey = AESencrp.encrypt(secretKey);
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
        }
        return secretKey;
    }

    public boolean isUserExist(String userId) {
        try {
            User user = this.findUser(userId);
            return user != null;
        }
        catch (UserNotFoundException x) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer findUserWithMaxId() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)User.PROP_ID));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                Integer n = (Integer)list.get(0);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getClockedInUser(Terminal terminal, boolean includeStaffBank) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_CLOCKED_IN, (Object)Boolean.TRUE));
            if (!includeStaffBank) {
                criteria.add((Criterion)Restrictions.eq((String)User.PROP_STAFF_BANK, (Object)Boolean.FALSE));
            }
            Junction activeUserCriteria = Restrictions.disjunction().add(Restrictions.isNull((String)User.PROP_ACTIVE)).add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
            criteria.add((Criterion)activeUserCriteria);
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveClockIn(User user, AttendenceHistory attendenceHistory, Shift shift, Calendar currentTime) {
        Session session = null;
        Transaction tx = null;
        ActionHistory actionHistory = new ActionHistory();
        actionHistory.setActionName("CLOCK IN");
        actionHistory.setActionTime(attendenceHistory.getClockInTime());
        String actionMessage = String.format("User %s clocks in", user.getId());
        actionHistory.setDescription(actionMessage);
        actionHistory.setPerformer(user);
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)user);
            session.saveOrUpdate((Object)attendenceHistory);
            session.save((Object)actionHistory);
            tx.commit();
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new PosException(Messages.getString("UserDAO.2"), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveClockOut(User user, AttendenceHistory attendenceHistory, Shift shift, Calendar currentTime) {
        ActionHistory actionHistory = new ActionHistory();
        actionHistory.setActionName("CLOCK OUT");
        actionHistory.setActionTime(attendenceHistory.getClockOutTime());
        String actionMessage = String.format("User %s clocks out", user.getId());
        actionHistory.setDescription(actionMessage);
        actionHistory.setPerformer(user);
        Session session = null;
        Transaction tx = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            UserDAO.getInstance().saveOrUpdate(user, session);
            AttendenceHistoryDAO.getInstance().saveOrUpdate(attendenceHistory, session);
            ActionHistoryDAO.getInstance().save(actionHistory, session);
            tx.commit();
        }
        catch (StaleStateException e) {
            throw new PosException("Failed to clock out user because it has been modified somewhere else.\nPlease reload and try again.", e);
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveDriverOut(User user, EmployeeInOutHistory attendenceHistory, Shift shift, Calendar currentTime) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)user);
            session.saveOrUpdate((Object)attendenceHistory);
            tx.commit();
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new PosException(Messages.getString("UserDAO.2"), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveDriverIn(User user, EmployeeInOutHistory attendenceHistory, Shift shift, Calendar currentTime) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)user);
            session.saveOrUpdate((Object)attendenceHistory);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new PosException(Messages.getString("UserDAO.3"), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private boolean validate(User user, boolean editMode) throws PosException {
        String hql = "from User u where u." + User.PROP_ID + "=:userId and u." + User.PROP_USER_TYPE_ID + "=:userTypeId";
        Session session = this.getSession();
        Query query = session.createQuery(hql);
        query = query.setParameter("userId", (Object)user.getId());
        if ((query = query.setParameter("userTypeId", (Object)user.getUserTypeId())).list().size() > 0) {
            throw new PosException(Messages.getString("UserDAO.7"));
        }
        return true;
    }

    public void saveOrUpdate(User user, boolean editMode) {
        Session session = null;
        try {
            if (!editMode) {
                this.validate(user, editMode);
            }
            super.saveOrUpdate(user);
        }
        catch (Exception x) {
            throw new PosException(Messages.getString("UserDAO.8"), x);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int findNumberOfOpenTickets(User user) throws PosException {
        Session session = null;
        Transaction tx = null;
        String hql = "select count(*) from Ticket ticket where ticket.owner=:owner and ticket." + Ticket.PROP_CLOSED + "settled=false";
        int count = 0;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            Query query = session.createQuery(hql);
            query = query.setEntity("owner", (Object)user);
            Iterator iterator = query.iterate();
            if (iterator.hasNext()) {
                count = (Integer)iterator.next();
            }
            tx.commit();
            int n = count;
            return n;
        }
        catch (Exception e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PosException(Messages.getString("UserDAO.12"), e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public boolean isClockedIn(User user) {
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)User.PROP_ID, (Object)user.getId()));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)User.PROP_CLOCKED_IN));
        ResultTransformer transformer = new ResultTransformer(){

            public Object transformTuple(Object[] row, String[] arg1) {
                return row[0];
            }

            public List transformList(List arg0) {
                return arg0;
            }
        };
        criteria.setProjection((Projection)projectionList).setResultTransformer(transformer);
        Boolean result = (Boolean)criteria.uniqueResult();
        return result;
    }

    public User getRandomUser(Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
        criteria.setMaxResults(1);
        List list = criteria.list();
        if (list.size() > 0) {
            return (User)list.get(0);
        }
        return null;
    }

    public void performForceCloseStaffBank(User staffBankOwner, User closedByUser, Session session) throws Exception {
        CashDrawer cashDrawer = staffBankOwner.getActiveDrawerPullReport();
        CashDrawerReportService reportService = new CashDrawerReportService(cashDrawer);
        reportService.populateReport(session);
        cashDrawer.setClosedBy(closedByUser);
        cashDrawer.setReportTime(StoreDAO.getServerTimestamp());
        CashDrawerDAO.getInstance().saveOrUpdate(cashDrawer, session);
        staffBankOwner.setStaffBankStarted(false);
        staffBankOwner.setCurrentCashDrawer(null);
    }

    public void doForceClockOutUser(User userToClockOut, User actionPerformer) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            if (!(actionPerformer.isManager() || actionPerformer.isAdministrator() || actionPerformer.hasPermission(UserPermission.OPEN_CLOSE_STORE))) {
                throw new PosException("You have no permission to force clock out.");
            }
            AttendenceHistory attendenceHistory = AttendenceHistoryDAO.getInstance().findHistoryByClockedInTime(userToClockOut);
            session = this.createNewSession();
            tx = session.beginTransaction();
            Date currentTime = StoreDAO.getServerTimestamp();
            Calendar currentCalendar = Calendar.getInstance();
            currentCalendar.setTime(currentTime);
            if (userToClockOut.isStaffBankStarted().booleanValue()) {
                this.performForceCloseStaffBank(userToClockOut, actionPerformer, session);
                ActionHistory actionHistory = new ActionHistory();
                actionHistory.setActionName("STAFF_BANK_FORCE_CLOSE");
                actionHistory.setDescription("Forcefully closed staff bank of staff " + userToClockOut.getId());
                actionHistory.setActionTime(currentTime);
                actionHistory.setPerformer(actionPerformer);
                ActionHistoryDAO.getInstance().save(actionHistory, session);
            }
            if (attendenceHistory == null) {
                attendenceHistory = new AttendenceHistory();
                Date lastClockInTime = userToClockOut.getLastClockInTime();
                if (lastClockInTime != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(lastClockInTime);
                    attendenceHistory.setClockInTime(lastClockInTime);
                    attendenceHistory.setClockInHour((short)c.get(10));
                }
                attendenceHistory.setUser(userToClockOut);
                attendenceHistory.setTerminal(DataProvider.get().getCurrentTerminal());
                attendenceHistory.setShift(userToClockOut.getCurrentShift());
            }
            attendenceHistory.setClockedOut(true);
            attendenceHistory.setClockOutTime(currentTime);
            attendenceHistory.setClockOutHour((short)currentCalendar.get(11));
            AttendenceHistoryDAO.getInstance().saveOrUpdate(attendenceHistory, session);
            userToClockOut.setClockedIn(false);
            userToClockOut.setCurrentShift(null);
            userToClockOut.setLastClockInTime(null);
            userToClockOut.setLastClockOutTime(null);
            userToClockOut.setAvailableForDelivery(false);
            session.evict((Object)userToClockOut);
            this.update(userToClockOut, session);
            tx.commit();
        }
        catch (Exception e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        this.closeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findUsersPasswords() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true));
            criteria.setProjection((Projection)Projections.property((String)User.PROP_PASSWORD));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findAllUnSyncUser() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)User.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)User.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateUserSync(List<String> ids, boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update User set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, User.PROP_CLOUD_SYNCED, User.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public User findUserById(String userId) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ID, (Object)userId));
            Object result = criteria.uniqueResult();
            if (result != null) {
                User user = (User)result;
                return user;
            }
            throw new UserNotFoundException(Messages.getString("UserDAO.0") + userId + Messages.getString("UserDAO.1"));
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateUsers(List<User> users) throws Exception {
        if (users == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (User user : users) {
                User existingUser = this.get(user.getId());
                if (existingUser != null) {
                    String id = existingUser.getId();
                    long version = existingUser.getVersion();
                    PropertyUtils.copyProperties((Object)existingUser, (Object)user);
                    existingUser.setId(id);
                    existingUser.setVersion(version);
                    this.update(existingUser, session);
                    continue;
                }
                this.save(user, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

