/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerPullVoidEntry;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.BaseVoidItemDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.KitchenTicketItemDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.ResultTransformer;

public class VoidItemDAO
extends BaseVoidItemDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveVoidItems(List<VoidItem> voidItems, Ticket ticket) {
        Transaction tx = null;
        try (Session session = null;){
            CashDrawer activeDrawer = Application.getCurrentUser().getActiveDrawerPullReport();
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (VoidItem voidItem : voidItems) {
                List<KitchenTicketItem> kitchenTicketItems;
                Double totalPrice = Math.abs(voidItem.getTotalPrice());
                ticket.setVoidAmount(ticket.getVoidAmount() + totalPrice);
                voidItem.setTicketId(ticket.getId());
                voidItem.setCashDrawerId(activeDrawer.getId());
                if (voidItem.getItemId() != null && (kitchenTicketItems = KitchenTicketItemDAO.getInstance().find(voidItem.getItemId(), voidItem.isModifier(), session)) != null) {
                    for (KitchenTicketItem kitchenItem : kitchenTicketItems) {
                        KitchenTicket kitchenTicket = kitchenItem.getKitchenTicket();
                        if (voidItem.getQuantity() < kitchenItem.getQuantity()) {
                            KitchenTicketItem newKitchenTicketItem = (KitchenTicketItem)CopyUtil.deepCopy(kitchenItem);
                            newKitchenTicketItem.setId(null);
                            newKitchenTicketItem.setQuantity(kitchenItem.getQuantity() - voidItem.getQuantity());
                            kitchenTicket.addToticketItems(newKitchenTicketItem);
                            session.save((Object)newKitchenTicketItem);
                        }
                        if (kitchenItem.getStatus().equalsIgnoreCase(KitchenStatus.BUMP.name())) {
                            voidItem.setCooked(true);
                        }
                        kitchenItem.setVoided(true);
                        session.update((Object)kitchenItem);
                    }
                }
                session.saveOrUpdate((Object)voidItem);
            }
            TicketDAO.getInstance().updateStock(ticket, session);
            session.saveOrUpdate((Object)ticket);
            tx.commit();
        }
    }

    public void saveVoidItems(List<VoidItem> voidItems, Session session) {
        for (VoidItem voidItem : voidItems) {
            session.saveOrUpdate((Object)voidItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VoidItem> findByDate(Date startDate, Date endDate, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)VoidItem.PROP_VOID_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)VoidItem.PROP_VOID_DATE, (Object)endDate));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)VoidItem.PROP_TERMINAL, (Object)terminal));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DrawerPullVoidEntry> getVoidEntries(CashDrawer cashDrawer) {
        ArrayList<String> cashDrawerIds = new ArrayList<String>();
        cashDrawerIds.add(cashDrawer.getId());
        return this.getVoidEntries(cashDrawerIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DrawerPullVoidEntry> getVoidEntries(List<String> cashDrawerIds) {
        if (cashDrawerIds.isEmpty()) {
            return new ArrayList<DrawerPullVoidEntry>();
        }
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.countDistinct((String)VoidItem.PROP_TICKET_ID));
            projectionList.add((Projection)Projections.sum((String)VoidItem.PROP_QUANTITY));
            projectionList.add((Projection)Projections.sum((String)VoidItem.PROP_TOTAL_PRICE));
            projectionList.add((Projection)Projections.groupProperty((String)VoidItem.PROP_ITEM_WASTED));
            if (cashDrawerIds.size() == 1) {
                criteria.add((Criterion)Restrictions.eq((String)VoidItem.PROP_CASH_DRAWER_ID, (Object)cashDrawerIds.get(0)));
            } else {
                Disjunction disjunction = Restrictions.disjunction();
                for (String cashDrawerId : cashDrawerIds) {
                    disjunction.add((Criterion)Restrictions.eq((String)VoidItem.PROP_CASH_DRAWER_ID, (Object)cashDrawerId));
                }
                criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)VoidItem.PROP_CASH_DRAWER_ID), (Criterion)disjunction));
            }
            ResultTransformer transformer = new ResultTransformer(){

                public Object transformTuple(Object[] row, String[] arg1) {
                    DrawerPullVoidEntry voidEntry = new DrawerPullVoidEntry();
                    voidEntry.setCheckCount(Double.valueOf("" + row[0]));
                    voidEntry.setQuantity(Double.valueOf("" + row[1]));
                    voidEntry.setAmount(Double.valueOf("" + row[2]));
                    voidEntry.setReason((Boolean.valueOf("" + row[3]) == true ? "TOTAL WASTE" : "TOTAL VOID") + (voidEntry.getCheckCount() > 0.0 ? " (" + NumberUtil.trimDecilamIfNotNeeded(voidEntry.getCheckCount()) + ")" : ""));
                    return voidEntry;
                }

                public List transformList(List arg0) {
                    return arg0;
                }
            };
            criteria.setProjection((Projection)projectionList).setResultTransformer(transformer);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VoidItem> getVoidItems(String ticketId) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)VoidItem.PROP_TICKET_ID, (Object)ticketId));
            List list = criteria.list();
            if (list.isEmpty()) {
                List<VoidItem> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveAndSentToKitchenIfNeeded(VoidItem voidItem, boolean printedToKitchen, Ticket ticket, Session session) {
        List<KitchenTicketItem> kitchenTicketItems;
        Double totalPrice = Math.abs(voidItem.getTotalPrice());
        ticket.setVoidAmount(ticket.getVoidAmount() + totalPrice);
        ticket.setRefundableAmount(ticket.getRefundableAmount() + totalPrice);
        voidItem.setTicketId(ticket.getId());
        if (voidItem.getItemId() != null && (kitchenTicketItems = KitchenTicketItemDAO.getInstance().find(voidItem.getItemId(), voidItem.isModifier(), session)) != null) {
            HashSet<KitchenTicket> kitchenTickets = new HashSet<KitchenTicket>();
            for (KitchenTicketItem kitchenItem : kitchenTicketItems) {
                KitchenTicket kitchenTicket = kitchenItem.getKitchenTicket();
                kitchenTickets.add(kitchenTicket);
                if (voidItem.getQuantity() < kitchenItem.getQuantity()) {
                    try {
                        KitchenTicketItem newKitchenTicketItem = (KitchenTicketItem)CopyUtil.deepCopy(kitchenItem);
                        newKitchenTicketItem.setId(null);
                        newKitchenTicketItem.setQuantity(kitchenItem.getQuantity() - voidItem.getQuantity());
                        kitchenTicket.addToticketItems(newKitchenTicketItem);
                    }
                    catch (Exception e) {
                        PosLog.error(this.getClass(), e);
                    }
                }
                if (kitchenItem.getStatus().equalsIgnoreCase(KitchenStatus.BUMP.name())) {
                    voidItem.setCooked(true);
                }
                kitchenItem.setVoided(true);
            }
            for (KitchenTicket kitchenTicket : kitchenTickets) {
                KitchenTicketDAO.getInstance().update(kitchenTicket, session);
            }
        }
        this.saveOrUpdate(voidItem, session);
    }
}

