/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.model.Course;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Department;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.StoreDAO;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.proxy.HibernateProxy;

public abstract class DataProvider {
    public static final String DATA_PROVIDER_CLASS_NAME = "data.provider.class";
    private static DataProvider instance;

    public abstract void initialize();

    public abstract Store getStore();

    public abstract Outlet getOutlet();

    public abstract StoreSession getStoreSession();

    public abstract void setStoreSession(StoreSession var1);

    public abstract InventoryUnit getInventoryUnitById(String var1);

    public abstract TaxGroup getTaxGroupById(String var1);

    public abstract ReportGroup getReportGroupById(String var1);

    public abstract PrinterGroup getPrinterGroupById(String var1);

    public abstract Department getDepartmentById(String var1);

    public abstract OrderType getOrderTypeById(String var1);

    public abstract InventoryLocation getInventoryLocationById(String var1);

    public abstract User getUserById(String var1);

    public abstract Terminal getTerminalById(Integer var1);

    public abstract Shift getShiftById(String var1);

    public abstract Terminal getCurrentTerminal();

    public abstract void setCloudTerminal(Terminal var1);

    public abstract OrderType getOrderType(String var1);

    public abstract List<OrderType> getOrderTypes();

    public abstract UserType getUserType(String var1);

    public abstract Currency getCurrency(String var1);

    public abstract Course getCourse(String var1);

    public abstract TerminalType getTerminalType(String var1);

    public abstract Multiplier getMultiplierById(String var1);

    public abstract List<Multiplier> getMultiplierList();

    public abstract InventoryLocation getDefaultInLocation();

    public abstract InventoryLocation getDefaultOutLocation();

    public abstract List<Course> getCourses();

    public abstract String getDefaultCourseId();

    public abstract void refreshStore();

    public abstract void refreshCurrentTerminal();

    public abstract SalesArea getSalesArea(String var1);

    public abstract String getRecipeMenuItemName(Recepie var1);

    public abstract PosPrinters getPrinters();

    public abstract MenuItemInventoryStatus getMenuItemStockStatus(MenuItem var1);

    public abstract Customer getCustomer(String var1);

    public abstract double getPriceFromPriceRule(MenuItem var1, OrderType var2, Department var3, SalesArea var4, CustomerGroup var5);

    public abstract List<DayPart> getDaryPartShifts();

    public abstract List<PriceShift> getPriceShifts();

    public abstract List<MenuShift> getMenuShifts();

    public abstract Object getObjectOf(Class var1, Serializable var2);

    public abstract File getAppConfigFileLocation();

    public static DataProvider get() {
        if (instance == null) {
            try {
                String className = System.getProperty(DATA_PROVIDER_CLASS_NAME);
                if (StringUtils.isEmpty((String)className)) {
                    className = "com.floreantpos.model.dao.util.PosCacheManager";
                }
                instance = (DataProvider)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                LogFactory.getLog(DataProvider.class).error((Object)"Could not initialize data provider", (Throwable)e);
            }
        }
        return instance;
    }

    public static <T> T initializeAndUnproxy(T entity) {
        if (entity == null) {
            throw new NullPointerException("Entity passed for initialization is null");
        }
        StoreDAO storeDAO = StoreDAO.getInstance();
        Session session = null;
        try {
            session = storeDAO.createNewSession();
            session.refresh(entity);
            Hibernate.initialize(entity);
            if (entity instanceof HibernateProxy) {
                entity = ((HibernateProxy)entity).getHibernateLazyInitializer().getImplementation();
            }
        }
        finally {
            storeDAO.closeSession(session);
        }
        return entity;
    }
}

