/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.payment;

import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.ui.ConfigurationSubEditor;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.payment.PaymentPlugin;
import com.floreantpos.util.NumberUtil;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;

public abstract class AbstractPaymentPlugin
implements PaymentPlugin {
    @Override
    public String getId() {
        return null;
    }

    @Override
    public boolean requireLicense() {
        return false;
    }

    @Override
    public boolean hasValidLicense() {
        return false;
    }

    @Override
    public void initLicense() {
    }

    @Override
    public void initUI(PosWindow posWindow) {
    }

    @Override
    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
    }

    @Override
    public void initConfigurationView(JDialog configurationDialog) {
    }

    @Override
    public List<ConfigurationSubEditor> getSubEditors() {
        return null;
    }

    @Override
    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    protected double getRefundableAmount(Ticket ticket) {
        double refundableAmount = 0.0;
        if (ticket.getDueAmount() >= 0.0) {
            return 0.0;
        }
        refundableAmount = Math.abs(ticket.getDueAmount());
        return NumberUtil.roundToTwoDigit(refundableAmount);
    }

    protected double calculateTaxAmount(Ticket ticket) {
        double totalTransactionTaxAmount = 0.0;
        for (PosTransaction t : ticket.getTransactions()) {
            if (t instanceof RefundTransaction || t.isVoided().booleanValue()) continue;
            totalTransactionTaxAmount += t.getTaxAmount().doubleValue();
        }
        return totalTransactionTaxAmount;
    }
}

