/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.payment;

import com.floreantpos.PosException;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.payment.AbstractPaymentPlugin;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

@PluginImplementation
public class MemberPaymentPlugin
extends AbstractPaymentPlugin
implements PostPaymentProcessor {
    private static final String MEMBER_PAYMENT = "Member payment";
    private Customer member;

    @Override
    public String getName() {
        return MEMBER_PAYMENT;
    }

    @Override
    public void pay(Ticket ticket, double tenderAmount, SettleTicketProcessor settleTicketProcessor) throws Exception {
        this.member = this.doSetMember(ticket);
        if (this.member.getBalance() < ticket.getTotalAmount()) {
            throw new PosException("Member does not have enough balance!");
        }
        CustomerAccountTransaction transaction = (CustomerAccountTransaction)PaymentType.MEMBER_ACCOUNT.createTransaction(ticket, tenderAmount);
        settleTicketProcessor.settleTicket(transaction, this);
    }

    @Override
    public String getId() {
        return MEMBER_PAYMENT;
    }

    @Override
    public void paymentDone(PosTransaction transaction, Session session) {
        this.member.setBalance(this.member.getBalance() - transaction.getAmount());
        CustomerDAO.getInstance().saveOrUpdate(this.member, session);
    }

    public void doRefund(Ticket ticket, List<PosTransaction> selectedTransactions) throws Exception {
        Transaction tx = null;
        try (Session session = null;){
            Customer member = this.doSetMember(ticket);
            double refundableAmount = this.getRefundableAmount(ticket);
            double refundAmount = NumberSelectionDialog2.takeDoubleInput("Enter refund amount", refundableAmount);
            if (refundAmount <= 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount must be greater than zero.");
                return;
            }
            if (refundAmount > refundableAmount) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount cannot be greater than " + NumberUtil.round(refundableAmount));
                return;
            }
            double totalTransactionTaxAmount = this.calculateTaxAmount(ticket);
            Double refundTaxAmount = NumberUtil.roundToTwoDigit(totalTransactionTaxAmount * refundAmount / ticket.getPaidAmount());
            session = CustomerDAO.getInstance().createNewSession();
            tx = session.beginTransaction();
            PosTransactionService transactionService = PosTransactionService.getInstance();
            RefundTransaction refundTransaction = transactionService.createRefundTransaction(ticket, null, refundAmount);
            refundTransaction.setPaymentType(PaymentType.MEMBER_ACCOUNT);
            refundTransaction.setCustomPaymentFieldName("MEMBER ID");
            refundTransaction.setCustomPaymentRef(member.getId());
            User currentUser = Application.getCurrentUser();
            double refundedAmount = transactionService.refundTicket(ticket, refundTransaction, refundAmount, refundTaxAmount, currentUser, session);
            member.setBalance(member.getBalance() + refundedAmount);
            CustomerDAO.getInstance().saveOrUpdate(member, session);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refunded " + CurrencyUtil.getCurrencySymbol() + refundedAmount);
            tx.commit();
        }
    }

    private Customer doSetMember(Ticket ticket) {
        Customer member = ticket.getCustomer();
        if (member == null) {
            CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(ticket.getOrderType());
            dialog.setCreateNewTicket(false);
            if (ticket != null) {
                dialog.setTicket(ticket);
            }
            dialog.openUndecoratedFullScreen();
            if (dialog.isCanceled()) {
                throw new PosException("Member not selected!");
            }
            member = dialog.getSelectedCustomer();
            if (member == null) {
                throw new PosException("Member not selected!");
            }
            ticket.setCustomer(member);
            OrderController.saveOrder(ticket);
        }
        return member;
    }

    @Override
    public void voidPayment(PosTransaction transaction, Session session) {
        String customerId = transaction.getCustomerId();
        if (StringUtils.isEmpty((String)customerId)) {
            throw new PosException("Member ID not found in transaction.");
        }
        Customer customer = CustomerDAO.getInstance().get(customerId);
        customer.setBalance(customer.getBalance() + transaction.getAmount());
        CustomerDAO.getInstance().saveOrUpdate(customer, session);
    }
}

