/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.AttendanceReportData;
import com.floreantpos.swing.ListTableModel;
import java.text.DecimalFormat;

public class AttendanceReportModel
extends ListTableModel {
    DecimalFormat decimalFormat = new DecimalFormat("0.00");

    public AttendanceReportModel() {
        super(new String[]{"employeeId", "employeeName", "clockIn", "clockOut", "workTime"});
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AttendanceReportData data = (AttendanceReportData)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return String.valueOf(data.getUser().getId());
            }
            case 1: {
                return data.getUser().getFirstName() + " " + data.getUser().getLastName();
            }
            case 2: {
                return DateUtil.formatFullDateAndTimeAsString(data.getClockIn());
            }
            case 3: {
                if (data.getClockOut() == null) break;
                return DateUtil.formatFullDateAndTimeAsString(data.getClockOut());
            }
            case 4: {
                if (data.getWorkTime() == 0.0) break;
                return this.decimalFormat.format(data.getWorkTime());
            }
        }
        return null;
    }
}

