/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.DailySummaryReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class DailySummaryReportView
extends TransparentPanel {
    private JButton btnGo;
    private JComboBox cbTerminal;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private JComboBox jcbEmployee;

    public DailySummaryReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void viewReport() throws Exception {
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        User userType = null;
        if (this.jcbEmployee.getSelectedItem() instanceof User) {
            userType = (User)this.jcbEmployee.getSelectedItem();
        }
        Terminal terminal = null;
        if (this.cbTerminal.getSelectedItem() instanceof Terminal) {
            terminal = (Terminal)this.cbTerminal.getSelectedItem();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        List<StoreSession> storeSessions = StoreSessionDAO.getInstance().findSessions(fromDate, toDate);
        ArrayList<DailySummaryReportData> rows = new ArrayList<DailySummaryReportData>();
        for (StoreSession storeSession : storeSessions) {
            List<CashDrawer> cashDrawers = CashDrawerDAO.getInstance().findByStoreOperationData(storeSession);
            CashDrawer cashDrawersReportSummary = PosPrintService.populateCashDrawerReportSummary(cashDrawers);
            cashDrawersReportSummary.setStartTime(storeSession.getOpenTime());
            cashDrawersReportSummary.setAssignedBy(storeSession.getOpenedBy());
            cashDrawersReportSummary.setReportTime(storeSession.getCloseTime());
            cashDrawersReportSummary.setClosedBy(storeSession.getClosedBy());
            DailySummaryReportData data = new DailySummaryReportData();
            data.setPeriod(DateUtil.formatFullDateAsString(cashDrawersReportSummary.getStartTime()));
            String number = storeSession.getId();
            String lastFourDigit = number.substring(number.length() - 4, number.length());
            data.setSessionID(lastFourDigit);
            double balance = CashDrawerDAO.getInstance().getSumOfOpeningBalance(storeSession);
            data.setOpeningBalance(balance);
            data.setDeposit(cashDrawersReportSummary.getCashToDeposit());
            data.setOverOutage(cashDrawersReportSummary.getCashToDeposit() - cashDrawersReportSummary.getDrawerAccountable());
            data.setCash(cashDrawersReportSummary.getCashReceiptAmount());
            data.setTips(cashDrawersReportSummary.getTipsPaid());
            data.setOnAccount(cashDrawersReportSummary.getCashReceiptAmount() - balance);
            double customPayment = cashDrawersReportSummary.getCustomPaymentAmount() != null ? cashDrawersReportSummary.getCustomPaymentAmount() : 0.0;
            data.setOtherPayment(customPayment + cashDrawersReportSummary.getGiftCardAddBalance() + cashDrawersReportSummary.getCreditCardReceiptAmount() + cashDrawersReportSummary.getDebitCardReceiptAmount());
            data.setPayInOut(0.0 + cashDrawersReportSummary.getPayOutAmount() * -1.0);
            data.setVoids(cashDrawersReportSummary.getTotalVoid());
            int guestNumber = StoreSessionDAO.getInstance().getStoreSessionTotalGuest(storeSession);
            data.setTotalGuest(guestNumber);
            rows.add(data);
        }
        if (rows.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "no data");
            return;
        }
        JasperReport dailySummaryReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("daily_summary_subreport"));
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("daily_summary_report"));
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties);
        properties.put("reportTitle", POSConstants.DAILY_SUMMARY_REPORT);
        properties.put("reportTime", ReportService.formatFullDate(new Date()));
        properties.put("fromDay", ReportService.formatFullDate(fromDate));
        properties.put("toDay", ReportService.formatFullDate(toDate));
        properties.put(POSConstants.TYPE, POSConstants.BY_RANGE_ACTUAL);
        properties.put("type", userType == null ? POSConstants.ALL : userType.getFullName());
        properties.put("cntr", terminal == null ? POSConstants.ALL : terminal.getName());
        properties.put("dailySummaryReport", (String)dailySummaryReport);
        properties.put("dailySummaryReportDatasource", (String)new JRTableModelDataSource((TableModel)new DailySummaryReportModel(rows)));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JREmptyDataSource());
        JRViewer viewer = new JRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void createUI() {
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getCurrentMonthEnd();
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    DailySummaryReportView.this.viewReport();
                }
                catch (Exception e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e);
                }
            }
        });
        this.jcbEmployee = new JComboBox();
        UserDAO dao = new UserDAO();
        List<User> userTypes = dao.findAll();
        Vector<Object> list = new Vector<Object>();
        list.add(POSConstants.ALL);
        list.addAll(userTypes);
        this.jcbEmployee.setModel(new DefaultComboBoxModel(list));
        this.cbTerminal = new JComboBox();
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> terminals = terminalDAO.findAll();
        terminals.add(0, (Terminal)((Object)POSConstants.ALL));
        this.cbTerminal.setModel(new ListComboBoxModel(terminals));
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.toDatePicker);
        topPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        topPanel.add(this.jcbEmployee);
        topPanel.add(new JLabel(POSConstants.TERMINAL_LABEL + ":"));
        topPanel.add(this.cbTerminal);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }

    public static class DailySummaryReportData {
        private String period;
        private String sessionID;
        private double openingBalance;
        private double deposit;
        private double overOutage;
        private double cash;
        private double tips;
        private double onAccount;
        private double otherPayment;
        private double payInOut;
        private double voids;
        private int totalGuest;
        private double avgChk;

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public double getDeposit() {
            return this.deposit;
        }

        public void setDeposit(double deposit) {
            this.deposit = deposit;
        }

        public double getOverOutage() {
            return this.overOutage;
        }

        public void setOverOutage(double overOutage) {
            this.overOutage = overOutage;
        }

        public double getCash() {
            return this.cash;
        }

        public void setCash(double cash) {
            this.cash = cash;
        }

        public double getOnAccount() {
            return this.onAccount;
        }

        public void setOnAccount(double onAccount) {
            this.onAccount = onAccount;
        }

        public double getOtherPayment() {
            return this.otherPayment;
        }

        public void setOtherPayment(double otherPayment) {
            this.otherPayment = otherPayment;
        }

        public double getPayInOut() {
            return this.payInOut;
        }

        public void setPayInOut(double payInOut) {
            this.payInOut = payInOut;
        }

        public double getVoids() {
            return this.voids;
        }

        public void setVoids(double voids) {
            this.voids = voids;
        }

        public int getTotalGuest() {
            return this.totalGuest;
        }

        public void setTotalGuest(int totalGuest) {
            this.totalGuest = totalGuest;
        }

        public double getAvgChk() {
            return this.avgChk;
        }

        public void setAvgChk(double avgChk) {
            this.avgChk = avgChk;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public void setSessionID(String sessionID) {
            this.sessionID = sessionID;
        }

        public double getOpeningBalance() {
            return this.openingBalance;
        }

        public void setOpeningBalance(double openingBalance) {
            this.openingBalance = openingBalance;
        }

        public double getTips() {
            return this.tips;
        }

        public void setTips(double tips) {
            this.tips = tips;
        }
    }
}

