/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.LabelItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalPrintersDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.KitchenStickerModel;
import com.floreantpos.report.KitchenTicketDataSource;
import com.floreantpos.report.LabelPrinterTableModel;
import com.floreantpos.report.OrderDataSource;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.PrintServiceUtil;
import com.floreantpos.util.ReceiptUtil;
import java.awt.print.PrinterAbortException;
import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import us.fatehi.magnetictrack.bankcard.BankCardMagneticTrack;

public class ReceiptPrintService {
    private static final String DATA = "data";
    private static final String TITLE = "title";
    private static final String ORDER_ = "ORDER-";
    public static final String PROP_PRINTER_NAME = "printerName";
    private static final String TIP_AMOUNT = "tipAmount";
    private static final String SERVICE_CHARGE = "serviceCharge";
    private static final String DELIVERY_CHARGE = "deliveryCharge";
    private static final String TAX_AMOUNT = "taxAmount";
    private static final String DISCOUNT_AMOUNT = "discountAmount";
    private static final String HEADER_LINE1 = "headerLine1";
    private static final String REPORT_DATE = "reportDate";
    private static final String SHOW_FOOTER = "showFooter";
    private static final String SHOW_HEADER_SEPARATOR = "showHeaderSeparator";
    private static final String SHOW_SUBTOTAL = "showSubtotal";
    private static final String RECEIPT_TYPE = "receiptType";
    private static final String SUB_TOTAL_TEXT = "subTotalText";
    private static final String QUANTITY_TEXT = "quantityText";
    private static final String ITEM_TEXT = "itemText";
    private static Log logger = LogFactory.getLog(ReceiptPrintService.class);
    public static final String CUSTOMER_COPY = "Customer Copy";
    public static final String DRIVER_COPY = "Driver Copy";
    public static final String CENTER = "center";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String OROPOS_PDF_PRINTER = "Oropos PDF printer";
    private static File pdfPrinterDir;

    public static void printGenericReport(String title, String data) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(TITLE, title);
        map.put(DATA, data);
        JasperPrint jasperPrint = ReceiptPrintService.createJasperPrint(ReportUtil.getReport("generic-receipt"), map, (JRDataSource)new JREmptyDataSource());
        jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
        ReceiptPrintService.printQuitely(jasperPrint);
    }

    public static void printClockInOutReceipt(User user) throws Exception {
        Date currentTime = new Date();
        Store store = Application.getInstance().getStore();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM, yyyy");
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("dd MMM, hh:mm aaa");
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm:ss aaa");
        String clockInOutInfo = user.isClockedIn() != false ? "Clock in at    : " + timeFormat.format(user.getLastClockInTime()) : "Clock out at : " + timeFormat.format(currentTime);
        String sep = "\n.......................................................................";
        String data = "\n" + store.getName();
        data = data + "\n" + store.getAddressLine1();
        data = data + sep;
        data = data + "\n-" + user.getFullName() + " (#" + user.getId() + ")" + (user.isClockedIn() != false ? " clock in" : " clock out") + "-";
        data = data + sep;
        data = data + "\nDate             : " + dateFormat.format(currentTime);
        data = data + "\n" + clockInOutInfo;
        data = data + "\nPrinted On   : " + dateFormat2.format(new Date());
        data = data + sep;
        ReceiptPrintService.printGenericReport("", data);
    }

    public static void testPrinter(String deviceName, String title, String data) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(TITLE, title);
        map.put(DATA, data);
        JasperPrint jasperPrint = ReceiptPrintService.createJasperPrint(ReportUtil.getReport("test-printer"), map, (JRDataSource)new JREmptyDataSource());
        jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
        ReceiptPrintService.printQuitely(jasperPrint);
    }

    public static JasperPrint createJasperPrint(JasperReport report, Map<String, Object> properties, JRDataSource dataSource) throws Exception {
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)dataSource);
        return jasperPrint;
    }

    public static JasperPrint createPrint(Ticket ticket, Map<String, Object> map, PosTransaction transaction) throws Exception {
        TicketDataSource dataSource = new TicketDataSource(ticket);
        ReciptPaperSize paperSize = ReceiptPrintService.getReceiptPaperSize("main.recipt.paper_size");
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(paperSize.getReportNameAccording2Size("ticket-recipt")), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public static JasperPrint createPurchaseOrderPrint(PurchaseOrder order) throws Exception {
        TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
        printProperties.setPrintCookingInstructions(false);
        HashMap map = ReceiptPrintService.populatePurchaseOrderProperties(order, printProperties, null);
        map.put("copyType", "");
        OrderDataSource dataSource = new OrderDataSource(order);
        String receiptName = "order_receipt";
        map.put("previousDueText", "Previous Due  ");
        map.put("previousDue", "");
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(receiptName), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public static JasperPrint createPurchaseOrderItemsBarcodePrint(List<LabelItem> orderedItemList) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        LabelPrinterTableModel dataSource = new LabelPrinterTableModel(orderedItemList);
        String receiptName = "barcode_report";
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(receiptName), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public static JasperPrint printKitchenStickerItems(List<KitchenStickerModel.KitchenSticker> stickerItemList) throws Exception {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            KitchenStickerModel dataSource = new KitchenStickerModel(stickerItemList);
            String receiptName = "kitchenStickerReport";
            return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(receiptName), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
        }
        catch (Exception e) {
            PosLog.error(ReceiptPrintService.class, e.getMessage(), e);
            return null;
        }
    }

    public static byte[] createPDFStream(Ticket ticket) {
        try {
            TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
            map.put("IS_IGNORE_PAGINATION", true);
            JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, map, null);
            jasperPrint.setName("TICKET_RECEIPT" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
        }
        catch (Exception e) {
            PosLog.error(ReceiptPrintService.class, e);
            return null;
        }
    }

    public static void printTicket(Ticket ticket) {
        TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
        printProperties.setPrintCookingInstructions(false);
        HashMap map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
        ReceiptPrintService.printTicket(ticket, map);
    }

    public static void printTicket(Ticket ticket, HashMap map) {
        try {
            List<Printer> receiptPrinters = DataProvider.get().getPrinters().getReceiptPrinters();
            for (Printer receiptPrinter : receiptPrinters) {
                String deviceName = receiptPrinter.getDeviceName();
                if (deviceName == null) continue;
                logger.info((Object)String.format("Printing ticket %s payment using printer %s. Total amount %s", ticket.getId(), deviceName, ticket.getTotalAmount()));
                ReceiptPrintService.setPaginationProperty(map, deviceName);
                JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, map, null);
                jasperPrint.setName(ORDER_ + ticket.getId() + deviceName);
                jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
                ReceiptPrintService.printQuitely(jasperPrint);
            }
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    public static void printTicket(Ticket ticket, String copyType) {
        TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
        printProperties.setPrintCookingInstructions(false);
        HashMap map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
        map.put("copyType", copyType);
        map.put("cardPayment", true);
        ReceiptPrintService.printTicket(ticket, map);
    }

    public static void printTicket(Ticket ticket, Terminal terminal) {
        try {
            TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
            List<TerminalPrinters> terminalPrinters = TerminalPrintersDAO.getInstance().findTerminalPrinters(terminal);
            ArrayList<Printer> activeReceiptPrinters = new ArrayList<Printer>();
            for (TerminalPrinters terminalPrinters2 : terminalPrinters) {
                int printerType = terminalPrinters2.getVirtualPrinter().getType();
                if (printerType != 1) continue;
                Printer printer = new Printer(terminalPrinters2.getVirtualPrinter(), terminalPrinters2.getPrinterName());
                activeReceiptPrinters.add(printer);
            }
            for (Printer receiptPrinter : activeReceiptPrinters) {
                String deviceName = receiptPrinter.getDeviceName();
                if (deviceName == null) continue;
                ReceiptPrintService.setPaginationProperty(map, deviceName);
                JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, map, null);
                jasperPrint.setName(ORDER_ + ticket.getId() + deviceName);
                jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
                ReceiptPrintService.printQuitely(jasperPrint);
            }
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    public static JasperPrint createRefundPrint(Ticket ticket, HashMap map) throws Exception {
        TicketDataSource dataSource = new TicketDataSource(ticket);
        ReciptPaperSize paperSize = ReceiptPrintService.getReceiptPaperSize("main.recipt.paper_size");
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(paperSize.getReportNameAccording2Size("ticket-recipt")), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public static void printRefundTicket(Ticket ticket, List<PosTransaction> posTransactions) {
        try {
            if (posTransactions == null || posTransactions.isEmpty()) {
                return;
            }
            double refundAmount = 0.0;
            if (posTransactions != null) {
                for (PosTransaction t : posTransactions) {
                    if (!(t instanceof RefundTransaction) && !t.isVoided().booleanValue()) continue;
                    refundAmount += t.getAmount().doubleValue();
                }
            }
            TicketPrintProperties printProperties = new TicketPrintProperties("*** REFUND RECEIPT ***", true, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
            map.put("refundAmountText", Messages.getString("ReceiptPrintService.1"));
            map.put("refundAmount", NumberUtil.formatNumber(refundAmount));
            map.put("cashRefundText", Messages.getString("ReceiptPrintService.2"));
            map.put("cashRefund", NumberUtil.formatNumber(refundAmount));
            JasperPrint jasperPrint = ReceiptPrintService.createRefundPrint(ticket, map);
            jasperPrint.setName("REFUND_" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            ReceiptPrintService.printQuitely(jasperPrint);
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    public static void printRefundTicket(Ticket ticket, RefundTransaction posTransaction) {
        try {
            TicketPrintProperties printProperties = new TicketPrintProperties("*** REFUND RECEIPT ***", true, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, posTransaction);
            map.put("refundAmountText", Messages.getString("ReceiptPrintService.1"));
            map.put("refundAmount", NumberUtil.formatNumber(posTransaction.getAmount()));
            map.put("cashRefundText", Messages.getString("ReceiptPrintService.2"));
            map.put("cashRefund", NumberUtil.formatNumber(posTransaction.getAmount()));
            JasperPrint jasperPrint = ReceiptPrintService.createRefundPrint(ticket, map);
            jasperPrint.setName("REFUND_" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            ReceiptPrintService.printQuitely(jasperPrint);
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    public static void printVoidTicket(Ticket ticket) {
        try {
            TicketPrintProperties printProperties = new TicketPrintProperties("*** VOID RECEIPT ***", true, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
            String refundText = "";
            if (ticket.getTransactions() != null) {
                Set<PosTransaction> posTransactions = ticket.getTransactions();
                double refundAmount = 0.0;
                if (posTransactions != null) {
                    for (PosTransaction t : posTransactions) {
                        if (!(t instanceof RefundTransaction) && !t.isVoided().booleanValue()) continue;
                        refundAmount += t.getAmount().doubleValue();
                    }
                }
                refundAmount = NumberUtil.roundToTwoDigit(refundAmount);
            }
            map.put("additionalProperties", "<html><b>" + refundText + "</b></html>");
            map.put("additionalPaymentProperties", "");
            JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, map, null);
            jasperPrint.setName("VOID_" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            ReceiptPrintService.printQuitely(jasperPrint);
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    public static void printTransaction(PosTransaction transaction, HashMap map) {
        try {
            Ticket ticket = transaction.getTicket();
            List<Printer> receiptPrinters = DataProvider.get().getPrinters().getReceiptPrinters();
            for (Printer receiptPrinter : receiptPrinters) {
                String deviceName = receiptPrinter.getDeviceName();
                if (deviceName == null) continue;
                logger.info((Object)String.format("Printing ticket %s payment using printer %s. Total amount %s", ticket.getId(), deviceName, ticket.getTotalAmount()));
                ReceiptPrintService.setPaginationProperty(map, deviceName);
                JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, map, transaction);
                jasperPrint.setName(ORDER_ + ticket.getId() + deviceName);
                jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
                ReceiptPrintService.printQuitely(jasperPrint);
            }
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    public static void printTransaction(PosTransaction transaction) {
        Ticket ticket = transaction.getTicket();
        TicketPrintProperties printProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
        printProperties.setPrintCookingInstructions(false);
        HashMap map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction);
        if (transaction != null && transaction.isCard()) {
            CardReader cardReader = CardReader.fromString(transaction.getCardReader());
            if (cardReader == CardReader.EXTERNAL_TERMINAL) {
                return;
            }
            map.put("cardPayment", true);
            map.put("copyType", Messages.getString("ReceiptPrintService.4"));
            ReceiptPrintService.printTransaction(transaction, map);
            map.put("copyType", Messages.getString("ReceiptPrintService.5"));
            ReceiptPrintService.printTransaction(transaction, map);
        } else if (transaction.getPaymentType() == PaymentType.MEMBER_ACCOUNT) {
            map.put("additionalPaymentProperties", ReceiptPrintService.createMemberAccountInfo(transaction.getTicket()));
            ReceiptPrintService.printTransaction(transaction, map);
        } else {
            ReceiptPrintService.printTransaction(transaction, map);
        }
    }

    public static void printTransaction(PosTransaction transaction, boolean printCustomerCopy) {
        Ticket ticket = transaction.getTicket();
        TicketPrintProperties printProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.6"), true, true, true);
        printProperties.setPrintCookingInstructions(false);
        HashMap map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction);
        if (transaction != null && transaction.isCard()) {
            map.put("cardPayment", true);
            map.put("copyType", Messages.getString("ReceiptPrintService.7"));
            ReceiptPrintService.printTransaction(transaction, map);
            if (printCustomerCopy) {
                map.put("copyType", Messages.getString("ReceiptPrintService.8"));
                ReceiptPrintService.printTransaction(transaction, map);
            }
        } else {
            ReceiptPrintService.printTransaction(transaction, map);
        }
    }

    private static String createMemberAccountInfo(Ticket ticket) {
        StringBuilder info = new StringBuilder();
        info.append("<html>");
        Customer customer = CustomerDAO.getInstance().findById(ticket.getCustomerId());
        ReceiptPrintService.beginRow(info);
        ReceiptPrintService.addColumn(info, "Payment from member balance ---");
        ReceiptPrintService.endRow(info);
        ReceiptPrintService.beginRow(info);
        ReceiptPrintService.addColumn(info, "Member: " + customer.getId());
        ReceiptPrintService.endRow(info);
        ReceiptPrintService.beginRow(info);
        ReceiptPrintService.addColumn(info, "Name: " + customer.getName());
        ReceiptPrintService.endRow(info);
        ReceiptPrintService.beginRow(info);
        ReceiptPrintService.addColumn(info, "Balance: " + CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumberAcceptNegative(customer.getBalance()));
        ReceiptPrintService.endRow(info);
        info.append("</html>");
        return info.toString();
    }

    public static JasperPrint getTransactionReceipt(PosTransaction transaction) {
        try {
            Ticket ticket = transaction.getTicket();
            TicketPrintProperties printProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction);
            map.put("IS_IGNORE_PAGINATION", true);
            if (transaction != null && transaction.isCard()) {
                CardReader cardReader = CardReader.fromString(transaction.getCardReader());
                if (cardReader == CardReader.EXTERNAL_TERMINAL) {
                    return null;
                }
                map.put("cardPayment", true);
                map.put("copyType", Messages.getString("ReceiptPrintService.4"));
                JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, map, transaction);
                jasperPrint.setName("Ticket-" + ticket.getId() + "-CustomerCopy");
                jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
                map.put("copyType", Messages.getString("ReceiptPrintService.5"));
                jasperPrint = ReceiptPrintService.createPrint(ticket, map, transaction);
                jasperPrint.setName("Ticket-" + ticket.getId() + "-MerchantCopy");
                jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
                return jasperPrint;
            }
            JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, map, transaction);
            jasperPrint.setName("Ticket-" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            return jasperPrint;
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
            return null;
        }
    }

    private static void beginRow(StringBuilder html) {
        html.append("<div>");
    }

    private static void endRow(StringBuilder html) {
        html.append("</div>");
    }

    private static void addColumn(StringBuilder html, String columnText) {
        html.append("<span>" + columnText + "</span>");
    }

    public static HashMap populateTicketProperties(Ticket ticket, TicketPrintProperties printProperties, PosTransaction transaction) {
        return ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction, false);
    }

    public static HashMap populateTicketProperties(Ticket ticket, TicketPrintProperties printProperties, PosTransaction transaction, boolean kitchenReceipt) {
        StringBuilder taxBreakdown;
        boolean isShowTipsSuggestion;
        ImageIcon storeLogo;
        String barcodeParamName;
        Application.getInstance().refreshStore();
        Store store = Application.getInstance().getStore();
        Terminal terminal = Application.getInstance().getTerminal();
        String header = "";
        String footer = "";
        String bottom = "";
        String orderInfo = "";
        String extraOrderInfo = "";
        OrderType orderType = ticket.getOrderType();
        String orderTypeId = "";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (orderType != null) {
            orderTypeId = orderType.getId();
        }
        if (kitchenReceipt) {
            header = ReceiptUtil.getReceiptSection(store, "kitchen.header", orderTypeId);
            orderInfo = ReceiptUtil.getReceiptSection(store, "kitchen.order.info", orderTypeId);
            extraOrderInfo = ReceiptUtil.getReceiptSection(store, "kitchen.order.extrainfo1", orderTypeId);
            footer = ReceiptUtil.getReceiptSection(store, "kitchen.footer", orderTypeId);
            bottom = ReceiptUtil.getReceiptSection(store, "kitchen.bottom", orderTypeId);
        } else {
            header = ReceiptUtil.getReceiptSection(store, "ticket.header", orderTypeId);
            orderInfo = ReceiptUtil.getReceiptSection(store, "ticket.order.info", orderTypeId);
            extraOrderInfo = ReceiptUtil.getReceiptSection(store, "ticket.order.extrainfo1", orderTypeId);
            footer = ReceiptUtil.getReceiptSection(store, "ticket.footer", orderTypeId);
            bottom = ReceiptUtil.getReceiptSection(store, "ticket.bottom", orderTypeId);
            ReceiptPrintService.setPaginationProperty(parameters, DataProvider.get().getPrinters().getReceiptPrinter());
        }
        boolean showHeaderLogo = Boolean.valueOf(ReceiptUtil.getReceiptSection(store, kitchenReceipt ? "kitchen.header.logo.show" : "ticket.header.logo.show", orderTypeId));
        double totalAmount = ticket.getTotalAmount();
        double tipAmount = 0.0;
        String currencySymbol = CurrencyUtil.getCurrencySymbol();
        parameters.put(ReceiptParam.STORE_NAME.getParamName(), store.getName());
        parameters.put(ReceiptParam.STORE_ADDRESS1.getParamName(), store.getAddressLine1());
        parameters.put(ReceiptParam.STORE_ADDRESS2.getParamName(), store.getAddressLine2());
        parameters.put(ReceiptParam.STORE_ADDRESS3.getParamName(), store.getAddressLine3());
        parameters.put(ReceiptParam.STORE_PHONE_NO.getParamName(), store.getTelephone());
        parameters.put(ReceiptParam.CURRENCY_SYMBOL.getParamName(), currencySymbol);
        parameters.put(ReceiptParam.TICKET_ID.getParamName(), ticket.getId());
        parameters.put(ReceiptParam.TICKET_SHORT_ID.getParamName(), ticket.getShortId());
        parameters.put(ReceiptParam.ORDER_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(ticket.getCreateDate()));
        parameters.put(ReceiptParam.TOKEN_NO.getParamName(), "" + ticket.getTokenNo());
        if (ticket.getOrderType().isDelivery().booleanValue() || ticket.getOrderType().isPickup().booleanValue()) {
            if (ticket.isCustomerWillPickup().booleanValue()) {
                parameters.put(ReceiptParam.ORDER_TYPE.getParamName(), "PICKUP");
            } else {
                parameters.put(ReceiptParam.ORDER_TYPE.getParamName(), "DELIVERY");
            }
            parameters.put(ReceiptParam.DELIVERY_ADDRESS.getParamName(), ticket.getDeliveryAddress() + ticket.getExtraDeliveryInfo());
            Date deliveryDate = ticket.getDeliveryDate();
            if (deliveryDate != null) {
                parameters.put(ReceiptParam.DELIVERY_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(deliveryDate));
            }
        } else {
            parameters.put(ReceiptParam.ORDER_TYPE.getParamName(), ticket.getOrderType());
        }
        parameters.put(ReceiptParam.TERMINAL_ID.getParamName(), ticket.getTerminal().getId());
        parameters.put(ReceiptParam.TERMINAL_NAME.getParamName(), ticket.getTerminal().getName());
        parameters.put(ReceiptParam.SERVER_NAME.getParamName(), ticket.getOwner().getFullName());
        parameters.put(ReceiptParam.SERVER_ID.getParamName(), ticket.getOwner().getId());
        parameters.put(ReceiptParam.GUEST_COUNT.getParamName(), ticket.getNumberOfGuests().toString());
        if (terminal.isShowTableNumber()) {
            parameters.put(ReceiptParam.TABLE_NO.getParamName(), ticket.getTableNumbers() != null ? ticket.getTableNumbers().toString() : "");
        } else {
            parameters.put(ReceiptParam.TABLE_NO.getParamName(), ticket.getTableNames());
        }
        if (ticket.getCustomer() != null) {
            Customer customer = ticket.getCustomer();
            parameters.put(ReceiptParam.CUSTOMER_NAME.getParamName(), customer.getName());
            parameters.put(ReceiptParam.CUSTOMER_ID.getParamName(), customer.getMemberId() != null ? customer.getMemberId() : "");
            parameters.put(ReceiptParam.CUSTOMER_PHONE.getParamName(), customer.getMobileNo());
            parameters.put(ReceiptParam.CUSTOMER_SIGNATURE.getParamName(), customer.getSignatureImageId());
        }
        if (ticket.getSalesArea() != null) {
            SalesArea salesArea = ticket.getSalesArea();
            parameters.put(ReceiptParam.SALES_AREA.getParamName(), salesArea.getName());
        }
        if (ticket.getTransactions() != null) {
            String strPaymentType = PosTransactionDAO.getInstance().findLastTxPaymentTypeName(ticket);
            parameters.put(ReceiptParam.PAYMENT_TYPE.getParamName(), strPaymentType);
        }
        if (ticket.getAssignedDriver() != null) {
            User driver = ticket.getAssignedDriver();
            parameters.put(ReceiptParam.DRIVER_NAME.getParamName(), driver.getFullName());
            parameters.put(ReceiptParam.DRIVER_ID.getParamName(), driver.getId());
        }
        if (header.contains(barcodeParamName = ReceiptParam.BARCODE.getParamName()) || orderInfo.contains(barcodeParamName) || extraOrderInfo.contains(barcodeParamName) || footer.contains(barcodeParamName) || bottom.contains(barcodeParamName)) {
            parameters.put(barcodeParamName, String.valueOf(ticket.getId()));
        }
        parameters.put(ReceiptParam.RECEIPT_TYPE.getParamName(), printProperties.getReceiptTypeName());
        String splitTicketId = ticket.getProperty("SPLIT_TICKET");
        if (StringUtils.isNotEmpty((String)splitTicketId)) {
            parameters.put("splitTicketId", splitTicketId);
        }
        parameters.put(ReceiptParam.PRINT_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(new Date()));
        parameters.put(ITEM_TEXT, POSConstants.RECEIPT_REPORT_ITEM_LABEL);
        parameters.put(QUANTITY_TEXT, POSConstants.RECEIPT_REPORT_QUANTITY_LABEL);
        parameters.put(SUB_TOTAL_TEXT, POSConstants.RECEIPT_REPORT_SUBTOTAL_LABEL);
        parameters.put(SHOW_SUBTOTAL, printProperties.isShowSubtotal());
        parameters.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        parameters.put(SHOW_FOOTER, printProperties.isShowFooter());
        String ticketHeaderString = ReceiptPrintService.getReceiptParamValuesAsString(parameters, orderInfo);
        if (ticket.isVoided().booleanValue()) {
            ticketHeaderString = ticketHeaderString + "***VOID***<br>";
        }
        parameters.put("ticketHeader", ticketHeaderString);
        parameters.put("additionalOrderInfo", ReceiptPrintService.getReceiptParamValuesAsString(parameters, extraOrderInfo));
        parameters.put(HEADER_LINE1, ReceiptPrintService.getReceiptParamValuesAsString(parameters, header));
        if (printProperties.isShowFooter()) {
            if (ticket.getDiscountAmount() > 0.0) {
                parameters.put(DISCOUNT_AMOUNT, NumberUtil.formatNumber(ticket.getDiscountAmount()));
            }
            if (ticket.getTaxAmount() != 0.0) {
                parameters.put(TAX_AMOUNT, NumberUtil.formatNumber(ticket.getTaxAmount(), true));
            }
            if (ticket.getServiceCharge() > 0.0) {
                parameters.put(SERVICE_CHARGE, NumberUtil.formatNumber(ticket.getServiceCharge()));
            }
            if (ticket.getDeliveryCharge() > 0.0) {
                parameters.put(DELIVERY_CHARGE, NumberUtil.formatNumber(ticket.getDeliveryCharge()));
            }
            if (ticket.getGratuity() != null) {
                tipAmount = ticket.getGratuity().getAmount();
                parameters.put(TIP_AMOUNT, NumberUtil.formatNumber(tipAmount));
            }
            parameters.put("totalText", POSConstants.SUBTOTAL + currencySymbol);
            parameters.put("discountText", POSConstants.RECEIPT_REPORT_DISCOUNT_LABEL + currencySymbol);
            parameters.put("taxText", POSConstants.RECEIPT_REPORT_TAX_LABEL + currencySymbol);
            parameters.put("serviceChargeText", POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL + currencySymbol);
            parameters.put("deliveryChargeText", POSConstants.RECEIPT_REPORT_DELIVERY_CHARGE_LABEL + currencySymbol);
            parameters.put("tipsText", POSConstants.RECEIPT_REPORT_TIPS_LABEL + currencySymbol);
            parameters.put("netAmountText", POSConstants.RECEIPT_REPORT_TOTAL_LABEL + currencySymbol);
            parameters.put("paidAmountText", POSConstants.RECEIPT_REPORT_PAIDAMOUNT_LABEL + currencySymbol);
            parameters.put("dueAmountText", POSConstants.RECEIPT_REPORT_DUEAMOUNT_LABEL + currencySymbol);
            parameters.put("changeAmountText", POSConstants.RECEIPT_REPORT_CHANGEAMOUNT_LABEL + currencySymbol);
            parameters.put("netAmount", NumberUtil.formatNumber(totalAmount, true));
            parameters.put("paidAmount", NumberUtil.formatNumber(ticket.getPaidAmount()));
            Double refundAmount = ticket.getRefundAmount();
            if (transaction != null) {
                Double tenderAmount = transaction.getTenderAmount();
                parameters.put("tenderAmountText", POSConstants.RECEIPT_TENDERED_AMOUNT_LABEL + currencySymbol);
                parameters.put("tenderAmount", NumberUtil.formatNumber(tenderAmount, true));
            }
            if (refundAmount > 0.0) {
                parameters.put("refundAmountText", "Refund Amount" + currencySymbol);
                parameters.put("refundAmount", NumberUtil.formatNumber(refundAmount));
            }
            parameters.put("dueAmount", NumberUtil.formatNumber(ticket.getDueAmount() - ticket.getGratuityAmount()));
            parameters.put("grandSubtotal", NumberUtil.formatNumber(ticket.getSubtotalAmount(), true));
            parameters.put("footerMessage", ReceiptPrintService.getReceiptParamValuesAsString(parameters, footer));
            parameters.put("bottomMessage", ReceiptPrintService.getReceiptParamValuesAsString(parameters, bottom));
            parameters.put("copyType", printProperties.getReceiptCopyType());
            if (ticket.isRefunded().booleanValue()) {
                ReceiptPrintService.populateRefundProperties(transaction, ticket.getTransactions(), parameters);
            }
            if (StringUtils.isEmpty((String)splitTicketId) || transaction != null || !ticket.isClosed().booleanValue()) {
                // empty if block
            }
            if (transaction != null) {
                double changedAmount = transaction.getTenderAmount() - transaction.getAmount();
                if (changedAmount < 0.0) {
                    changedAmount = 0.0;
                }
                parameters.put("changedAmount", NumberUtil.formatNumber(changedAmount));
                if (transaction.isCard()) {
                    String cardInformationForReceipt;
                    if (!orderType.isRetailOrder().booleanValue()) {
                        parameters.put("cardPayment", true);
                    }
                    if (StringUtils.isEmpty((String)(cardInformationForReceipt = CardConfig.getPaymentGateway().getProcessor().getCardInformationForReceipt(transaction)))) {
                        cardInformationForReceipt = ReceiptPrintService.getCardInformation(transaction);
                    }
                    parameters.put("approvalCode", cardInformationForReceipt);
                }
                if (transaction instanceof CustomerAccountTransaction && !orderType.isRetailOrder().booleanValue()) {
                    parameters.put("cardPayment", true);
                }
            }
            StringBuilder paymentSummary = null;
            if (StringUtils.isEmpty((String)splitTicketId)) {
                paymentSummary = ReceiptPrintService.buildPayments(ticket);
            }
            if (paymentSummary != null) {
                parameters.put("additionalPaymentProperties", paymentSummary.toString());
            }
            if (Application.getInstance().getTerminal().isEnableMultiCurrency().booleanValue()) {
                StringBuilder multiCurrencyBreakdownCashBack = ReceiptPrintService.buildMultiCurrency(ticket, printProperties);
                if (multiCurrencyBreakdownCashBack != null) {
                    parameters.put("additionalProperties", multiCurrencyBreakdownCashBack.toString());
                } else {
                    StringBuilder multiCurrencyTotalAmount = ReceiptPrintService.buildMultiCurrencyTotalAmount(ticket, printProperties);
                    if (multiCurrencyTotalAmount != null && splitTicketId == null) {
                        parameters.put("additionalProperties", multiCurrencyTotalAmount.toString());
                    }
                }
            }
        }
        if (showHeaderLogo && (storeLogo = store.getStoreLogo()) != null) {
            parameters.put("storeLogoIcon", storeLogo.getImage());
        }
        boolean bl = isShowTipsSuggestion = store.getProperty(orderTypeId + "." + "receipt.show_tips_suggestion") == null ? false : Boolean.valueOf(store.getProperty(orderTypeId + "." + "receipt.show_tips_suggestion"));
        if (isShowTipsSuggestion) {
            parameters.put("showTips", ReceiptPrintService.tipsCalculation(ticket));
        }
        boolean isShowTipsBlock = store.getProperty(orderTypeId + "." + "receipt.show_tips_block") == null ? false : Boolean.valueOf(store.getProperty(orderTypeId + "." + "receipt.show_tips_block"));
        parameters.put("showTipsBlock", isShowTipsBlock);
        boolean isShowTaxBreakdown = store.getProperty(orderTypeId + "." + "receipt.show_tax_breakdown") == null ? false : Boolean.valueOf(store.getProperty(orderTypeId + "." + "receipt.show_tax_breakdown"));
        parameters.put("isShowTaxBreakdown", isShowTaxBreakdown);
        if (isShowTaxBreakdown && (taxBreakdown = ReceiptPrintService.getTaxBreakdown(ticket)) != null) {
            parameters.put("taxBreakdownText", taxBreakdown.toString());
        }
        return parameters;
    }

    private static void setPaginationProperty(HashMap parameters, String printerName) {
        if (printerName != null && printerName.equalsIgnoreCase(OROPOS_PDF_PRINTER)) {
            parameters.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        } else {
            parameters.put("IS_IGNORE_PAGINATION", false);
        }
    }

    private static void setPaginationProperty(HashMap parameters, String printerName, boolean ignorePagination) {
        if (printerName != null && printerName.equalsIgnoreCase(OROPOS_PDF_PRINTER)) {
            parameters.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        } else {
            parameters.put("IS_IGNORE_PAGINATION", ignorePagination);
        }
    }

    private static String getReceiptParamValuesAsString(Map map, String info) {
        ReceiptParam[] receiptParams;
        if (info == null) {
            return "";
        }
        for (ReceiptParam receiptParam : receiptParams = ReceiptParam.values()) {
            String paramName = receiptParam.getParamName();
            Object object = map.get(paramName);
            if (object == null || StringUtils.isEmpty((String)object.toString()) || object.toString().equals("[]")) {
                String text = "<" + receiptParam.getParamName() + ">.*</" + receiptParam.getParamName() + ">";
                info = info.replaceAll("<br>" + text, "");
                info = info.replaceAll(text, "");
                continue;
            }
            String val = object.toString();
            try {
                info = info.replaceAll("\\$" + paramName, val);
            }
            catch (Exception e) {
                info = info.replaceAll("\\$" + paramName, "\\" + val);
            }
        }
        return info;
    }

    private static void populateRefundProperties(PosTransaction t, Set<PosTransaction> transactions, HashMap map) {
        if (transactions == null) {
            return;
        }
        TicketPrintProperties printProperties = new TicketPrintProperties("*** REFUND RECEIPT ***", true, true, true);
        printProperties.setPrintCookingInstructions(false);
        double refundAmount = 0.0;
        for (PosTransaction transaction : transactions) {
            if (!(transaction instanceof RefundTransaction) && !transaction.isVoided().booleanValue()) continue;
            refundAmount += transaction.getAmount().doubleValue();
        }
        String refundText = "";
        refundText = t != null ? "<br>" + (Object)((Object)t.getPaymentType()) + " VOID/REFUND " + CurrencyUtil.getCurrencySymbol() + "&nbsp;" + t.getAmount() : "<br>Total Void/Refund " + CurrencyUtil.getCurrencySymbol() + "&nbsp;" + NumberUtil.formatNumber(refundAmount);
        map.put("additionalProperties", "<html><b>" + refundText + "</b></html>");
    }

    public static HashMap populatePurchaseOrderProperties(PurchaseOrder order, TicketPrintProperties printProperties, PosTransaction transaction) {
        Store store = StoreDAO.getRestaurant();
        double totalAmount = order.getTotalAmount();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReceiptPrintService.setPaginationProperty(map, DataProvider.get().getPrinters().getReceiptPrinter());
        String currencySymbol = CurrencyUtil.getCurrencySymbol();
        ImageIcon logo = IconFactory.getIcon("/icons/", "header_logo.png");
        if (logo != null) {
            map.put("logo", logo.getImage());
        }
        map.put("currencySymbol", currencySymbol);
        map.put("nameText", "Vendor: ");
        map.put("addressText", "Address: ");
        map.put("slNoText", "Sl. No.");
        map.put(ITEM_TEXT, "Description");
        map.put(QUANTITY_TEXT, "Quantity");
        map.put("priceText", "Unit Cost (" + CurrencyUtil.getCurrencySymbol() + ")");
        map.put("unitText", "Unit");
        map.put(SUB_TOTAL_TEXT, "Amount (" + CurrencyUtil.getCurrencySymbol() + ")");
        map.put("note", "Note");
        map.put("shipDateTxt", "Ship Date:");
        String shipmentDate = order.getShipDate() != null ? DateUtil.formatFullDateAndTimeAsString(order.getShipDate()) : null;
        map.put("shipDate", shipmentDate);
        map.put("signature1", "Signature");
        map.put("signature2", "Verified By");
        InventoryVendor vendor = order.getVendor();
        if (vendor != null) {
            String vendorName = vendor.getName();
            String vendorAddress = vendor.getAddress();
            String vendorMobile = vendor.getPhone();
            map.put("customerName", vendorName);
            String address = "";
            if (vendorAddress != null && !vendorAddress.isEmpty()) {
                address = address + vendorAddress;
            }
            if (vendorMobile != null && !vendorMobile.isEmpty()) {
                address = address + ", Cell:" + vendorMobile;
            }
            map.put("customerAddress", StringUtils.isNotEmpty((String)address) ? address : null);
        }
        map.put(RECEIPT_TYPE, printProperties.getReceiptTypeName());
        map.put(SHOW_SUBTOTAL, printProperties.isShowSubtotal());
        map.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        map.put(SHOW_FOOTER, printProperties.isShowFooter());
        map.put(REPORT_DATE, POSConstants.RECEIPT_REPORT_DATE_LABEL + DateUtil.formatFullDateAndTimeAsString(new Date()));
        StringBuilder ticketHeaderBuilder2 = ReceiptPrintService.buildOrderInfo(order, printProperties);
        map.put("ticketHeader2", ticketHeaderBuilder2.toString());
        map.put("ticketHeader3", "Purchase Order");
        String invoiceNumber = order.getInvoiceNumber() != null ? "Invoice: " + order.getInvoiceNumber() : null;
        map.put("invoiceNumber", invoiceNumber);
        map.put(HEADER_LINE1, store.getName());
        map.put("headerLine2", store.getAddress());
        map.put("headerLine3", store.getAddressLine2());
        map.put("headerLine4", store.getAddressLine3());
        map.put("headerLine5", store.getTelephone());
        map.put("headerLine6", store.getZipCode());
        if (printProperties.isShowFooter()) {
            if (order.getDiscountAmount() > 0.0) {
                map.put(DISCOUNT_AMOUNT, NumberUtil.formatNumber(order.getDiscountAmount()));
            }
            if (order.getTaxAmount() > 0.0) {
                map.put(TAX_AMOUNT, NumberUtil.formatNumber(order.getTaxAmount()));
            }
            map.put("totalText", POSConstants.RECEIPT_REPORT_TOTAL_LABEL + currencySymbol);
            map.put("discountText", POSConstants.RECEIPT_REPORT_DISCOUNT_LABEL + currencySymbol);
            map.put("taxText", POSConstants.RECEIPT_REPORT_TAX_LABEL + currencySymbol);
            map.put("serviceChargeText", POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL + currencySymbol);
            map.put("tipsText", POSConstants.RECEIPT_REPORT_TIPS_LABEL + currencySymbol);
            map.put("netAmountText", POSConstants.RECEIPT_REPORT_NETAMOUNT_LABEL + currencySymbol);
            map.put("paidAmountText", POSConstants.RECEIPT_REPORT_PAIDAMOUNT_LABEL + currencySymbol);
            map.put("dueAmountText", POSConstants.RECEIPT_REPORT_DUEAMOUNT_LABEL + currencySymbol);
            map.put("changeAmountText", POSConstants.RECEIPT_REPORT_CHANGEAMOUNT_LABEL + currencySymbol);
            map.put("netAmount", NumberUtil.formatNumber(totalAmount));
            map.put("paidAmount", NumberUtil.formatNumber(order.getPaidAmount()));
            map.put("dueAmount", NumberUtil.formatNumber(order.getDueAmount()));
            map.put("grandSubtotal", NumberUtil.formatNumber(order.getSubtotalAmount()));
            map.put("footerMessage", store.getTicketFooterMessage());
            map.put("copyType", printProperties.getReceiptCopyType());
            if (transaction != null) {
                double changedAmount = transaction.getTenderAmount() - transaction.getAmount();
                if (changedAmount < 0.0) {
                    changedAmount = 0.0;
                }
                map.put("changedAmount", NumberUtil.formatNumber(changedAmount));
                if (transaction.isCard()) {
                    map.put("cardPayment", true);
                    if (StringUtils.isNotEmpty((String)transaction.getCardTrack())) {
                        BankCardMagneticTrack track = BankCardMagneticTrack.from((String)transaction.getCardTrack());
                        String string = transaction.getCardType();
                        string = string + "<br/>APPROVAL: " + transaction.getCardAuthCode();
                        try {
                            string = string + "<br/>ACCT: " + ReceiptPrintService.getCardNumber(track);
                            string = string + "<br/>EXP: " + track.getTrack1().getExpirationDate();
                            string = string + "<br/>CARDHOLDER: " + track.getTrack1().getName();
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                        map.put("approvalCode", string);
                    } else {
                        String string = "APPROVAL: " + transaction.getCardAuthCode();
                        string = string + "<br/>Card processed in ext. device.";
                        map.put("approvalCode", string);
                    }
                }
            }
            String messageString = "<html>";
            messageString = messageString + "</html>";
            map.put("additionalProperties", messageString);
        }
        return map;
    }

    private static String tipsCalculation(Ticket ticket) {
        StringBuilder buildTips = new StringBuilder();
        buildTips.append("<html>");
        double totalAmount = ticket.getTotalAmountWithTips();
        double tenPercent = totalAmount * 10.0 / 100.0;
        double fiftheenPercent = totalAmount * 15.0 / 100.0;
        double twentyPercent = totalAmount * 20.0 / 100.0;
        double twentyFivePercent = totalAmount * 25.0 / 100.0;
        ReceiptPrintService.beginRow(buildTips);
        ReceiptPrintService.addColumn(buildTips, "<br>10% Tip is   " + NumberUtil.formatNumber(tenPercent) + "<br>15% Tip is   " + NumberUtil.formatNumber(fiftheenPercent) + "<br>20% Tip is   " + NumberUtil.formatNumber(twentyPercent) + "<br>25% Tip is   " + NumberUtil.formatNumber(twentyFivePercent));
        ReceiptPrintService.endRow(buildTips);
        buildTips.append("</html>");
        return buildTips.toString();
    }

    private static StringBuilder buildOrderInfo(PurchaseOrder order, TicketPrintProperties printProperties) {
        String orderNo = " ";
        if (order.getOrderId() != null) {
            orderNo = order.getOrderId();
        }
        StringBuilder ticketHeaderBuilder = new StringBuilder();
        ticketHeaderBuilder.append("<html>");
        InventoryLocation location = order.getInventoryLocation();
        String inventoryLocation = "";
        String locationAddress = "";
        if (location != null) {
            inventoryLocation = location.getName();
            locationAddress = location.getAddress();
        }
        if (order.getVarificationDate() != null) {
            ReceiptPrintService.beginRow(ticketHeaderBuilder);
            ReceiptPrintService.addColumn(ticketHeaderBuilder, "Date: " + DateUtil.formatFullDateAndTimeAsString(order.getVarificationDate()));
            ReceiptPrintService.endRow(ticketHeaderBuilder);
        }
        ReceiptPrintService.beginRow(ticketHeaderBuilder);
        ReceiptPrintService.addColumn(ticketHeaderBuilder, "Purchase Order #" + orderNo);
        ReceiptPrintService.endRow(ticketHeaderBuilder);
        if (StringUtils.isNotEmpty((String)inventoryLocation)) {
            ReceiptPrintService.beginRow(ticketHeaderBuilder);
            ReceiptPrintService.addColumn(ticketHeaderBuilder, "Inventory Location: " + inventoryLocation);
            ReceiptPrintService.endRow(ticketHeaderBuilder);
        }
        if (StringUtils.isNotEmpty((String)locationAddress)) {
            ReceiptPrintService.beginRow(ticketHeaderBuilder);
            ReceiptPrintService.addColumn(ticketHeaderBuilder, "Inventory Location Address: " + locationAddress);
            ReceiptPrintService.endRow(ticketHeaderBuilder);
        }
        ticketHeaderBuilder.append("</html>");
        return ticketHeaderBuilder;
    }

    public static StringBuilder getTaxBreakdown(Ticket ticket) {
        StringBuilder taxBreakdownBuilder = new StringBuilder();
        taxBreakdownBuilder.append("<html><table>");
        HashMap<String, Double> taxProperties = new HashMap<String, Double>();
        List<TicketItem> ticketItems = ticket.getTicketItems();
        ArrayList<TicketItemTax> taxes = new ArrayList<TicketItemTax>();
        for (TicketItem ticketItem : ticketItems) {
            for (TicketItemTax ticketItemTax : ticketItem.getTaxes()) {
                String key = ticketItemTax.getName();
                Double taxAmount = (Double)taxProperties.get(key);
                if (taxAmount == null) {
                    taxAmount = 0.0;
                }
                taxAmount = taxAmount + ticketItemTax.getTaxAmount();
                taxProperties.put(key, taxAmount);
                taxes.add(ticketItemTax);
            }
        }
        if (taxProperties.isEmpty()) {
            return null;
        }
        String currencySymbol = CurrencyUtil.getCurrencySymbol();
        for (Map.Entry entry : taxProperties.entrySet()) {
            String taxValue = NumberUtil.formatNumber((Double)entry.getValue());
            String taxName = (String)entry.getKey();
            int numberOfSpace = 24;
            int length = (int)(Math.log10((Double)entry.getValue()) + 1.0);
            numberOfSpace = length > 2 ? ++numberOfSpace : (length > 1 ? (numberOfSpace += 2) : (numberOfSpace += 3));
            ReceiptPrintService.beginRow(taxBreakdownBuilder);
            ReceiptPrintService.addColumn(taxBreakdownBuilder, ReceiptPrintService.getHtmlText(taxName + currencySymbol, numberOfSpace, RIGHT));
            ReceiptPrintService.addColumn(taxBreakdownBuilder, ReceiptPrintService.getHtmlText(taxValue, numberOfSpace, RIGHT));
            ReceiptPrintService.endRow(taxBreakdownBuilder);
        }
        taxBreakdownBuilder.append("</table></html>");
        return taxBreakdownBuilder;
    }

    private static StringBuilder buildMultiCurrencyTotalAmount(Ticket ticket, TicketPrintProperties printProperties) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        StringBuilder currencyAmountBuilder = new StringBuilder();
        currencyAmountBuilder.append("<html><table>");
        String sep = "------------------------------------";
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, "&nbsp;");
        ReceiptPrintService.addColumn(currencyAmountBuilder, "&nbsp;");
        ReceiptPrintService.addColumn(currencyAmountBuilder, "&nbsp;");
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, "<b>Currency breakdown</b>");
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, sep);
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("", 10, CENTER));
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("Net Amount", 10, CENTER));
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("Due", 10, CENTER));
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, sep);
        ReceiptPrintService.endRow(currencyAmountBuilder);
        int rowCount = 0;
        List<Currency> allCurrency = CurrencyUtil.getAllCurrency();
        if (allCurrency != null) {
            for (Currency currency : allCurrency) {
                if (currency == null) continue;
                String key = currency.getName();
                double rate = currency.getExchangeRate();
                ReceiptPrintService.beginRow(currencyAmountBuilder);
                ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(key, 10, LEFT));
                ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(decimalFormat.format(ticket.getTotalAmountWithTips() * rate), 10, RIGHT));
                ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(decimalFormat.format(ticket.getDueAmount() * rate), 10, RIGHT));
                ReceiptPrintService.endRow(currencyAmountBuilder);
                ++rowCount;
            }
        }
        if (rowCount == 0) {
            return null;
        }
        currencyAmountBuilder.append("</table></html>");
        return currencyAmountBuilder;
    }

    private static StringBuilder buildMultiCurrency(Ticket ticket, TicketPrintProperties printProperties) {
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        StringBuilder currencyAmountBuilder = new StringBuilder();
        currencyAmountBuilder.append("<html><table>");
        String sep = "------------------------------------";
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, "&nbsp;");
        ReceiptPrintService.addColumn(currencyAmountBuilder, "&nbsp;");
        ReceiptPrintService.addColumn(currencyAmountBuilder, "&nbsp;");
        ReceiptPrintService.endRow(currencyAmountBuilder);
        String groupSettleTickets = ticket.getProperty("GROUP_SETTLE_TICKETS");
        if (groupSettleTickets == null) {
            groupSettleTickets = "";
        }
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, groupSettleTickets + "<b>Currency breakdown</b>");
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, sep);
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("", 10, CENTER));
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("Paid", 10, CENTER));
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("Cashback", 10, CENTER));
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, sep);
        ReceiptPrintService.endRow(currencyAmountBuilder);
        int rowCount = 0;
        for (Currency currency : CurrencyUtil.getAllCurrency()) {
            if (currency == null) continue;
            String key = currency.getName();
            String paidAmount = ticket.getProperty(key);
            String cashBackAmount = ticket.getProperty(key + "_CASH_BACK");
            if (paidAmount == null) {
                paidAmount = "0";
            }
            if (cashBackAmount == null) {
                cashBackAmount = "0";
            }
            Double paid = Double.valueOf(paidAmount);
            Double changeDue = Double.valueOf(cashBackAmount);
            if (paid == 0.0 && changeDue == 0.0) continue;
            ReceiptPrintService.beginRow(currencyAmountBuilder);
            ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(key, 10, LEFT));
            ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(decimalFormat.format(paid), 10, RIGHT));
            ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(decimalFormat.format(changeDue), 10, RIGHT));
            ReceiptPrintService.endRow(currencyAmountBuilder);
            ++rowCount;
        }
        if (rowCount == 0) {
            return null;
        }
        currencyAmountBuilder.append("</table></html>");
        return currencyAmountBuilder;
    }

    private static StringBuilder buildPayments(Ticket ticket) {
        Set<PosTransaction> transactionList = ticket.getTransactions();
        if (transactionList == null || transactionList.size() <= 1) {
            return null;
        }
        ArrayList<PosTransaction> transactions = new ArrayList<PosTransaction>(transactionList);
        Collections.sort(transactions, new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction o1, PosTransaction o2) {
                return o1.getTransactionTime().compareTo(o2.getTransactionTime());
            }
        });
        StringBuilder paymentsBuilder = new StringBuilder();
        paymentsBuilder.append("<html><table>");
        ReceiptPrintService.beginRow(paymentsBuilder);
        ReceiptPrintService.addColumn(paymentsBuilder, "&nbsp;");
        ReceiptPrintService.addColumn(paymentsBuilder, "&nbsp;");
        ReceiptPrintService.addColumn(paymentsBuilder, "&nbsp;");
        ReceiptPrintService.endRow(paymentsBuilder);
        ReceiptPrintService.beginRow(paymentsBuilder);
        ReceiptPrintService.addColumn(paymentsBuilder, "Payments:");
        ReceiptPrintService.endRow(paymentsBuilder);
        String tagStart = "";
        String tagEng = "";
        for (PosTransaction transaction : transactions) {
            ReceiptPrintService.beginRow(paymentsBuilder);
            tagStart = transaction.isVoided() != false ? "<strike>" : "";
            tagEng = transaction.isVoided() != false ? "</strike>" : "";
            ReceiptPrintService.addColumn(paymentsBuilder, tagStart + ReceiptPrintService.getHtmlText(transaction.getPaymentType().getDisplayString(), 10, LEFT) + tagEng);
            ReceiptPrintService.addColumn(paymentsBuilder, tagStart + ReceiptPrintService.getHtmlText(transaction.getTipsAmount() > 0.0 ? NumberUtil.formatNumber(transaction.getTipsAmount()) : "", 10, RIGHT) + tagEng);
            Double amount = transaction.getAmount();
            ReceiptPrintService.addColumn(paymentsBuilder, ReceiptPrintService.getHtmlText(tagStart + NumberUtil.formatNumberAcceptNegative(transaction instanceof RefundTransaction ? -amount.doubleValue() : amount), 10, RIGHT) + tagEng);
            ReceiptPrintService.endRow(paymentsBuilder);
        }
        paymentsBuilder.append("</table></html>");
        return paymentsBuilder;
    }

    public static String getHtmlText(String txt, int length, String align) {
        block5: {
            block6: {
                block4: {
                    if (txt.length() > 30) {
                        txt = txt.substring(0, 30);
                    }
                    if (!align.equals(CENTER)) break block4;
                    int space = (length - txt.length()) / 2;
                    for (int i = 1; i < space; ++i) {
                        txt = "&nbsp;" + txt + "&nbsp;";
                    }
                    break block5;
                }
                if (!align.equals(RIGHT)) break block6;
                int space = length - txt.length();
                for (int i = 1; i < space; ++i) {
                    txt = "&nbsp;" + txt;
                }
                break block5;
            }
            if (!align.equals(LEFT)) break block5;
            int space = length - txt.length();
            for (int i = 1; i < space; ++i) {
                txt = txt + "&nbsp;";
            }
        }
        return txt;
    }

    public static JasperPrint createKitchenPrint(KitchenTicket ticket) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardPayment", true);
        map.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        map.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        KitchenTicketDataSource dataSource = new KitchenTicketDataSource(ticket);
        ReciptPaperSize paperSize = ReceiptPrintService.getReceiptPaperSize("kitchen.recipt.paper_size");
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(paperSize.getReportNameAccording2Size("kitchen-receipt")), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public static JasperPrint createKitchenPrint(String virtualPrinterName, KitchenTicket ticket, String deviceName) throws Exception {
        return ReceiptPrintService.createKitchenPrint(virtualPrinterName, ticket, deviceName, false);
    }

    public static JasperPrint createKitchenPrint(String virtualPrinterName, KitchenTicket ticket, String deviceName, boolean ignorePagination) throws Exception {
        OrderType orderType;
        String ticketType;
        TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
        HashMap map = ReceiptPrintService.populateTicketProperties(ticket.getParentTicket(), printProperties, null, true);
        ReceiptPrintService.setPaginationProperty(map, deviceName, ignorePagination);
        if (ReceiptPrintService.containsVoidItemOnly(ticket)) {
            map.put(HEADER_LINE1, "*" + Messages.getString("VOID ITEMS") + "*");
        }
        if (StringUtils.isNotEmpty((String)(ticketType = ticket.getOrderType().toString()))) {
            ticketType = ticketType.replaceAll("_", " ");
        }
        if ((orderType = ticket.getOrderType()).isDelivery().booleanValue() || orderType.isPickup().booleanValue()) {
            if (ticket.getParentTicket().isCustomerWillPickup().booleanValue()) {
                map.put("orderType", "*" + Messages.getString("PICKUP") + "*");
            } else {
                map.put("orderType", "*" + Messages.getString("DELIVERY") + "*");
            }
        } else {
            map.put("orderType", "* " + ticketType + " *");
        }
        map.put(PROP_PRINTER_NAME, "Printer Name : " + virtualPrinterName);
        KitchenTicketDataSource dataSource = new KitchenTicketDataSource(ticket);
        String reciptName = "kitchen-receipt";
        ReciptPaperSize paperSize = ReceiptPrintService.getReceiptPaperSize("kitchen.recipt.paper_size");
        if (Application.getInstance().getTerminal().isGroupByCatagoryKitReceipt().booleanValue()) {
            reciptName = "kitchen-receipt-with-group";
        }
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(paperSize.getReportNameAccording2Size(reciptName)), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    private static boolean containsVoidItemOnly(KitchenTicket ticket) {
        for (KitchenTicketItem item : ticket.getTicketItems()) {
            if (item.isVoided().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static JasperPrint createKitchenVoidPrint(String virtualPrinterName, KitchenTicket ticket, String deviceName) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(HEADER_LINE1, Application.getInstance().getStore().getName());
        map.put("cardPayment", true);
        map.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        map.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        map.put(ReceiptParam.TICKET_ID.getParamName(), POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ticket.getTicketId());
        if (ticket.getTableNumbers() != null && ticket.getTableNumbers().size() > 0) {
            map.put(ReceiptParam.TABLE_NO.getParamName(), POSConstants.RECEIPT_REPORT_TABLE_NO_LABEL + ticket.getTableNumbers());
        }
        if (StringUtils.isNotEmpty((String)ticket.getCustomerName())) {
            map.put("customer", Messages.getString("ReceiptPrintService.0") + ticket.getCustomerName());
        }
        map.put(ReceiptParam.SERVER_NAME.getParamName(), POSConstants.RECEIPT_REPORT_SERVER_LABEL + ticket.getServerName());
        map.put(REPORT_DATE, Messages.getString("ReceiptPrintService.119") + DateUtil.getReportDate());
        map.put("ticketHeader", "VOID ITEMS");
        String ticketType = ticket.getOrderType().toString();
        if (StringUtils.isNotEmpty((String)ticketType)) {
            ticketType = ticketType.replaceAll("_", " ");
        }
        map.put("orderType", "** VOID **");
        map.put(PROP_PRINTER_NAME, "Printer Name : " + virtualPrinterName);
        KitchenTicketDataSource dataSource = new KitchenTicketDataSource(ticket);
        String reportName = "kitchen-receipt";
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(reportName), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public static void printToKitchen(Ticket ticket) {
        ReceiptPrintService.printToKitchen(ticket, true);
    }

    public static void printToKitchen(Ticket ticket, boolean isFilterKitchenPrintedItems) {
        ReceiptPrintService.printToKitchen(ticket, isFilterKitchenPrintedItems, true);
    }

    public static void printToKitchen(Ticket ticket, boolean isFilterKitchenPrintedItems, boolean saveAndUpdateStatus) {
        try {
            List<KitchenTicket> kitchenTickets = KitchenTicket.fromTicket(ticket, isFilterKitchenPrintedItems);
            ReceiptPrintService.doPrintToKitchenAndSaveStatus(ticket, kitchenTickets, saveAndUpdateStatus);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public static void printItemsToKitchen(Ticket ticket, List<TicketItem> ticketItems) {
        try {
            if (ticket == null && ticketItems == null) {
                return;
            }
            List<KitchenTicket> kitchenTickets = KitchenTicket.fromTicket(ticket, true, ticketItems);
            ReceiptPrintService.doPrintToKitchenAndSaveStatus(ticket, kitchenTickets, true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private static void doPrintToKitchenAndSaveStatus(Ticket ticket, List<KitchenTicket> kitchenTickets, boolean saveAndUpdateStatus) throws Exception {
        for (KitchenTicket kitchenTicket : kitchenTickets) {
            kitchenTicket.setParentTicket(ticket);
            Printer printer = kitchenTicket.getPrinter();
            String deviceName = printer.getDeviceName();
            if (printer.getVirtualPrinter().getType() == 2 && deviceName != null) {
                logger.info((Object)("Printing to kitchen using printer: " + deviceName));
                JasperPrint jasperPrint = ReceiptPrintService.createKitchenPrint(printer.getVirtualPrinter().getName(), kitchenTicket, deviceName);
                jasperPrint.setName("KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
                ReceiptPrintService.printQuitely(jasperPrint);
                continue;
            }
            if (printer.getVirtualPrinter().getType() == 6 && deviceName != null) {
                logger.info((Object)("Printing to sticker using printer: " + deviceName));
                ReceiptPrintService.doPrintKitchenStickers(kitchenTicket, deviceName);
                continue;
            }
            if (printer.getVirtualPrinter().getType() != 4) continue;
            TicketDAO.getInstance().saveKitchenPrintStatus(ticket, kitchenTicket);
        }
        if (saveAndUpdateStatus) {
            ticket.clearDeletedItems();
            TicketDAO.getInstance().saveOrUpdate(ticket);
        }
    }

    public static void doPrintKitchenStickers(Ticket ticket) {
        try {
            List<Printer> stickerPrinters = DataProvider.get().getPrinters().getStickerPrinters();
            if (stickerPrinters.isEmpty()) {
                return;
            }
            List<KitchenTicket> kitchenTickets = KitchenTicket.fromTicket(ticket, true);
            for (KitchenTicket kitchenTicket : kitchenTickets) {
                Printer printer = kitchenTicket.getPrinter();
                String deviceName = printer.getDeviceName();
                kitchenTicket.setParentTicket(ticket);
                if (printer.getVirtualPrinter().getType() != 6 || deviceName == null) continue;
                ReceiptPrintService.doPrintKitchenStickers(kitchenTicket, deviceName);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private static void doPrintKitchenStickers(KitchenTicket kitchenTicket, String deviceName) {
        try {
            List<KitchenTicketItem> ticketItems = kitchenTicket.getTicketItems();
            ArrayList<KitchenStickerModel.KitchenSticker> kitchenStickers = new ArrayList<KitchenStickerModel.KitchenSticker>();
            for (KitchenTicketItem kitchenTicketItem : ticketItems) {
                if (!kitchenTicketItem.isPrintKitchenSticker().booleanValue() || kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isCookingInstruction().booleanValue()) continue;
                int quantity = (int)Math.ceil(kitchenTicketItem.getQuantity());
                for (int i = 0; i < quantity; ++i) {
                    KitchenStickerModel.KitchenSticker kitchenSticker = new KitchenStickerModel.KitchenSticker();
                    kitchenSticker.setToken(kitchenTicket.getTokenNo());
                    kitchenSticker.setItemName(kitchenTicketItem.getMenuItemName());
                    kitchenSticker.setModifiers(kitchenTicket.getModifiersForTicketItem(kitchenTicketItem.getTicketItemId()));
                    kitchenSticker.setCookingInstructions(kitchenTicket.getCookingInstructionForTicketItem(kitchenTicketItem.getTicketItemId()));
                    kitchenSticker.setTime("Time: " + DateUtil.formatSmall(new Date()));
                    kitchenSticker.setOrderType(kitchenTicket.getOrderType().getName());
                    kitchenSticker.setItemCount("Item: " + (i + 1) + " of " + quantity);
                    kitchenStickers.add(kitchenSticker);
                }
            }
            JasperPrint jasperPrint = ReceiptPrintService.printKitchenStickerItems(kitchenStickers);
            jasperPrint.setName("Kitchen_Sticker_" + kitchenTicket.getSequenceNumber());
            jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
            ReceiptPrintService.printQuitely(jasperPrint);
        }
        catch (Exception e) {
            PosLog.error(ReceiptPrintService.class, e.getMessage(), e);
        }
    }

    @Deprecated
    public static JasperPrint getKitchenJasperPrint(Ticket ticket, boolean isFilterKitchenPrintedItems) {
        return ReceiptPrintService.getKitchenJasperPrint(ticket, isFilterKitchenPrintedItems, false);
    }

    @Deprecated
    public static JasperPrint getKitchenJasperPrint(Ticket ticket, boolean isFilterKitchenPrintedItems, boolean ignorePagination) {
        try {
            List<KitchenTicket> kitchenTickets = KitchenTicket.fromTicket(ticket, isFilterKitchenPrintedItems);
            for (KitchenTicket kitchenTicket : kitchenTickets) {
                kitchenTicket.setParentTicket(ticket);
                Printer printer = kitchenTicket.getPrinter();
                String deviceName = printer.getDeviceName();
                if (deviceName == null) continue;
                JasperPrint jasperPrint = ReceiptPrintService.createKitchenPrint(printer.getVirtualPrinter().getName(), kitchenTicket, deviceName, ignorePagination);
                jasperPrint.setName("FP_KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
                return jasperPrint;
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
        return null;
    }

    public static void printVoidItemsToKitchen(Ticket ticket) {
        try {
            if (!ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
                return;
            }
            ArrayList<VoidItem> voidItems = new ArrayList<VoidItem>();
            for (TicketItem ticketItem : ticket.getTicketItems()) {
                VoidItem voidItem = ticketItem.getVoidItem();
                if (voidItem == null) continue;
                if (voidItem.getVoidedModifiers() != null) {
                    voidItems.addAll(voidItem.getVoidedModifiers());
                }
                voidItems.add(voidItem);
            }
            HashMap<Printer, KitchenTicket> itemMap = new HashMap<Printer, KitchenTicket>();
            Date serverTimestamp = StoreDAO.getServerTimestamp();
            for (VoidItem voidItem : voidItems) {
                PrinterGroup printerGroup;
                List<Printer> printers;
                if (voidItem.isCooked() || (printers = ReceiptPrintService.getPrinters(printerGroup = voidItem.getPrinterGroup())) == null) continue;
                for (Printer printer : printers) {
                    KitchenTicket kitchenTicket = (KitchenTicket)itemMap.get(printer);
                    if (kitchenTicket == null) {
                        kitchenTicket = new KitchenTicket();
                        kitchenTicket.setPrinterGroup(printerGroup);
                        kitchenTicket.setTicketId(ticket.getId());
                        kitchenTicket.setTokenNo(ticket.getTokenNo());
                        kitchenTicket.setCreateDate(serverTimestamp);
                        kitchenTicket.setOrderType(ticket.getOrderType());
                        if (ticket.getTableNumbers() != null) {
                            kitchenTicket.setTableNumbers(new ArrayList<Integer>(ticket.getTableNumbers()));
                        }
                        kitchenTicket.setServerName(ticket.getOwner().getFirstName());
                        kitchenTicket.setStatus(KitchenStatus.WAITING.name());
                        if (StringUtils.isNotEmpty((String)ticket.getProperty("CUSTOMER_NAME"))) {
                            kitchenTicket.setCustomerName(ticket.getProperty("CUSTOMER_NAME"));
                        }
                        kitchenTicket.setPrinter(printer);
                        itemMap.put(printer, kitchenTicket);
                    }
                    KitchenTicketItem item = new KitchenTicketItem();
                    item.setTicketItemId(voidItem.getId());
                    item.setMenuItemCode(String.valueOf(voidItem.getMenuItemId()));
                    item.setMenuItemName(voidItem.getMenuItemName());
                    item.setQuantity(voidItem.getQuantity());
                    item.setUnitName("");
                    item.setMenuItemGroupName("VOID");
                    item.setSortOrder(10001);
                    item.setStatus(KitchenStatus.VOID.name());
                    item.setKitchenTicket(kitchenTicket);
                    kitchenTicket.addToticketItems(item);
                }
            }
            for (KitchenTicket kitchenTicket : itemMap.values()) {
                Printer printer = kitchenTicket.getPrinter();
                String deviceName = printer.getDeviceName();
                JasperPrint jasperPrint = ReceiptPrintService.createKitchenVoidPrint(printer.getVirtualPrinter().getName(), kitchenTicket, deviceName);
                jasperPrint.setName("Void_KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
                ReceiptPrintService.printQuitely(jasperPrint);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public static List<Printer> getPrinters(PrinterGroup printerGroup) {
        PosPrinters printers = DataProvider.get().getPrinters();
        if (printerGroup == null) {
            printerGroup = PrinterGroupDAO.getInstance().getDefaultPrinterGroup();
        }
        ArrayList<Printer> printerAll = new ArrayList<Printer>();
        if (printerGroup == null) {
            printerAll.addAll(printers.getKitchenPrinters());
            return printerAll;
        }
        List<String> printerNames = printerGroup.getPrinterNames();
        List<Printer> kitchenPrinters = printers.getKitchenPrinters();
        for (Printer printer : kitchenPrinters) {
            if (!printerNames.contains(printer.getVirtualPrinter().getName())) continue;
            printerAll.add(printer);
        }
        if (printerAll.isEmpty() && PrintServiceUtil.getFallBackPrinter() != null) {
            printerAll.add(PrintServiceUtil.getFallBackPrinter());
        }
        return printerAll;
    }

    public static void printQuitely(JasperPrint jasperPrint) throws JRException {
        block4: {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                Date date = new Date();
                String dateTime = dateFormat.format(date);
                String printerName = jasperPrint.getProperty(PROP_PRINTER_NAME);
                if (printerName != null && printerName.equals(OROPOS_PDF_PRINTER)) {
                    String fileName = jasperPrint.getName().replace(printerName, "") + "-[" + dateTime + "]";
                    File pdfFile = new File(pdfPrinterDir, fileName + ".pdf");
                    JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)pdfFile.getAbsolutePath());
                } else {
                    SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
                    configuration.setPrintService(PrintServiceUtil.getPrintServiceForPrinter(jasperPrint.getProperty(PROP_PRINTER_NAME)));
                    JRPrintServiceExporter exporter = new JRPrintServiceExporter();
                    exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    exporter.setConfiguration((ExporterConfiguration)configuration);
                    exporter.exportReport();
                }
            }
            catch (Exception x) {
                if (x != null && x.getCause() instanceof PrinterAbortException) break block4;
                String msg = "No print selected\n";
                logger.error((Object)(msg + x));
            }
        }
    }

    private static String getCardNumber(BankCardMagneticTrack track) {
        String no = "";
        try {
            if (track.getTrack1().hasPrimaryAccountNumber()) {
                no = track.getTrack1().getPrimaryAccountNumber().getAccountNumber();
                no = "************" + no.substring(12);
            } else if (track.getTrack2().hasPrimaryAccountNumber()) {
                no = track.getTrack2().getPrimaryAccountNumber().getAccountNumber();
                no = "************" + no.substring(12);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return no;
    }

    private static String getCardInformation(PosTransaction transaction) {
        String string = "<br/>CARD INFO: ------------------------";
        string = string + "<br/>PROCESS: " + transaction.getCardReader();
        string = string + "<br/> TYPE: " + transaction.getCardType();
        try {
            String cardNumber = transaction.getCardNumber();
            if (transaction.getCardNumber() != null) {
                string = string + "<br/> ACCT: **** **** **** " + cardNumber.substring(cardNumber.length() - 4, cardNumber.length());
            }
            if (transaction.getCardHolderName() != null) {
                string = string + "<br/> CARDHOLDER: " + transaction.getCardHolderName();
            }
            if (transaction.getCardTransactionId() != null) {
                string = string + "<br/> TRANS ID: " + transaction.getCardTransactionId();
            }
            string = string + "<br/> APPROVAL: " + transaction.getCardAuthCode();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return string;
    }

    public static void printCloudTicket(Ticket ticket, Terminal terminal, PosTransaction transaction) {
        try {
            TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction);
            List<TerminalPrinters> terminalPrinters = TerminalPrintersDAO.getInstance().findTerminalPrinters(terminal);
            ArrayList<Printer> activeReceiptPrinters = new ArrayList<Printer>();
            for (TerminalPrinters terminalPrinters2 : terminalPrinters) {
                int printerType = terminalPrinters2.getVirtualPrinter().getType();
                if (printerType != 1) continue;
                Printer printer = new Printer(terminalPrinters2.getVirtualPrinter(), terminalPrinters2.getPrinterName());
                activeReceiptPrinters.add(printer);
            }
            if (activeReceiptPrinters == null || activeReceiptPrinters.isEmpty()) {
                JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, map, null);
                jasperPrint.setName(ORDER_ + ticket.getId());
                jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
                ReceiptPrintService.printQuitely(jasperPrint);
            } else {
                for (Printer activeReceiptPrinter : activeReceiptPrinters) {
                    String deviceName = activeReceiptPrinter.getDeviceName();
                    if (deviceName == null) continue;
                    JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, map, null);
                    jasperPrint.setName(ORDER_ + ticket.getId() + deviceName);
                    jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
                    ReceiptPrintService.printQuitely(jasperPrint);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    private static ReciptPaperSize getReceiptPaperSize(String receiptPropertyName) {
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        String receiptProperty = currentTerminal.getProperty(receiptPropertyName);
        ReciptPaperSize paperSize = ReciptPaperSize.Eighty;
        try {
            if (StringUtils.isNotEmpty((String)receiptProperty)) {
                paperSize = ReciptPaperSize.valueOf(receiptProperty);
            }
        }
        catch (Exception e) {
            paperSize = ReciptPaperSize.Eighty;
        }
        return paperSize;
    }

    static {
        String homeDir = System.getProperty("user.home");
        pdfPrinterDir = new File(homeDir, "oropos-pdf-print");
        if (!pdfPrinterDir.exists()) {
            pdfPrinterDir.mkdirs();
        }
    }
}

