/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.OpenTicketSummaryReport;
import com.floreantpos.report.Report;
import com.floreantpos.report.VoidItemReport;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;

public class ReportViewer
extends JPanel {
    private JButton btnRefresh;
    private JButton btnClear;
    private JLabel lblGroup;
    private JComboBox<MenuGroup> cbGroup;
    private JComboBox cbTerminal;
    private JXDatePicker dpEndDate;
    private JXDatePicker dpStartDate;
    private JComboBox<Date> jcbStartTime;
    private JComboBox<Date> jcbEndTime;
    private JLabel lblFromDate;
    private JLabel lblToDate;
    private JLabel lblTerminal;
    private JCheckBox chkBoxFree;
    private JCheckBox chkShowInGroups;
    private JLabel lblUserType;
    private JComboBox cbUserType;
    private TransparentPanel reportSearchOptionPanel;
    private TransparentPanel reportConstraintPanel;
    private TransparentPanel reportPanel;
    private Report report;
    private MultiSelectComboBox<MenuGroup> cbMenuGroup;

    public ReportViewer() {
        this.initComponents();
    }

    public ReportViewer(Report report) {
        this.initComponents();
        this.cbMenuGroup.setItems(MenuGroupDAO.getInstance().findAll());
        TerminalDAO terminalDAO = new TerminalDAO();
        ArrayList<Object> drawerTerminals = new ArrayList<Object>();
        drawerTerminals.add(0, POSConstants.ALL);
        List<Terminal> terminals = terminalDAO.findAll();
        for (Terminal terminal : terminals) {
            if (!terminal.isHasCashDrawer().booleanValue()) continue;
            drawerTerminals.add(terminal);
        }
        this.cbTerminal.setModel(new ListComboBoxModel(drawerTerminals));
        this.setReport(report);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.reportSearchOptionPanel = new TransparentPanel(new BorderLayout());
        this.reportConstraintPanel = new TransparentPanel();
        this.reportConstraintPanel.setLayout((LayoutManager)new MigLayout("", "[][][]"));
        this.lblGroup = new JLabel("Group");
        this.cbGroup = new JComboBox();
        this.lblTerminal = new JLabel(Messages.getString("ReportViewer.3"));
        this.cbTerminal = new JComboBox();
        this.cbTerminal.setPreferredSize(new Dimension(115, 0));
        this.lblFromDate = new JLabel(POSConstants.START_DATE + ":");
        this.dpStartDate = UiUtil.getCurrentMonthStart();
        TimeComboBox tcb = new TimeComboBox();
        this.jcbStartTime = tcb.getDefaultTimeComboBox();
        this.jcbEndTime = tcb.getDefaultTimeComboBox();
        this.lblToDate = new JLabel(POSConstants.END_DATE + ":");
        this.dpEndDate = UiUtil.getCurrentMonthEnd();
        this.chkBoxFree = new JCheckBox(Messages.getString("ReportViewer.6"));
        this.chkShowInGroups = new JCheckBox("Show In Groups");
        this.lblUserType = new JLabel(Messages.getString("ReportViewer.7"));
        this.cbUserType = new JComboBox();
        this.btnRefresh = new JButton(Messages.getString("ReportViewer.2"));
        this.reportPanel = new TransparentPanel();
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportViewer.this.doRefreshReport(evt);
            }
        });
        this.btnClear = new JButton("CLEAR");
        this.reportPanel = new TransparentPanel();
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportViewer.this.doClear(evt);
            }
        });
        this.cbMenuGroup = new MultiSelectComboBox();
        this.reportConstraintPanel.add(this.lblGroup);
        this.reportConstraintPanel.add(this.cbMenuGroup, "split 8");
        this.reportConstraintPanel.add(this.lblTerminal);
        this.reportConstraintPanel.add(this.cbTerminal);
        this.reportConstraintPanel.add(this.lblFromDate);
        this.reportConstraintPanel.add((Component)this.dpStartDate);
        this.reportConstraintPanel.add(this.jcbStartTime);
        this.reportConstraintPanel.add(this.lblToDate);
        this.reportConstraintPanel.add((Component)this.dpEndDate);
        this.reportConstraintPanel.add(this.jcbEndTime, "wrap");
        this.reportConstraintPanel.add(new JLabel(""));
        this.reportConstraintPanel.add((Component)this.chkBoxFree, "split 5");
        this.reportConstraintPanel.add(this.chkShowInGroups);
        this.reportConstraintPanel.add(new JLabel(""));
        this.reportConstraintPanel.add(this.btnRefresh);
        this.reportSearchOptionPanel.add((Component)this.reportConstraintPanel, "North");
        this.reportSearchOptionPanel.add((Component)new JSeparator(), "Center");
        this.reportPanel.setLayout(new BorderLayout());
        this.add((Component)this.reportSearchOptionPanel, "North");
        this.add((Component)this.reportPanel, "Center");
    }

    private void doRefreshReport(ActionEvent evt) {
        Date fromDate = this.dpStartDate.getDate();
        Date toDate = this.dpEndDate.getDate();
        Date startTime = (Date)this.jcbStartTime.getSelectedItem();
        Date endTime = (Date)this.jcbEndTime.getSelectedItem();
        if ((fromDate = DateUtil.copyTime(fromDate, startTime)).after(toDate = DateUtil.copyTime(toDate, endTime))) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        try {
            this.reportPanel.removeAll();
            this.reportPanel.revalidate();
            if (this.report != null) {
                UserType userType = null;
                if (this.cbUserType.getSelectedItem() instanceof UserType) {
                    userType = (UserType)this.cbUserType.getSelectedItem();
                }
                this.report.setUserType(userType);
                Terminal terminal = null;
                if (this.cbTerminal.getSelectedItem() instanceof Terminal) {
                    terminal = (Terminal)this.cbTerminal.getSelectedItem();
                }
                this.report.setMenuGroups(this.cbMenuGroup.getSelectedItems());
                this.report.setTerminal(terminal);
                this.report.setStartDate(fromDate);
                this.report.setEndDate(toDate);
                this.report.setIncludeFreeItems(this.chkBoxFree.isSelected());
                this.report.setShowInGroups(this.chkShowInGroups.isSelected());
                this.report.refresh();
                if (this.report != null && this.report.getViewer() != null) {
                    this.reportPanel.add((Component)this.report.getViewer());
                    this.reportPanel.revalidate();
                }
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    public void doClear(ActionEvent evt) {
        if (this.report != null) {
            this.cbUserType.setSelectedIndex(0);
            this.cbTerminal.setSelectedIndex(0);
        }
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
        if (report instanceof VoidItemReport) {
            this.reportConstraintPanel.removeAll();
            this.reportConstraintPanel.add(this.lblTerminal);
            this.reportConstraintPanel.add(this.cbTerminal);
            this.reportConstraintPanel.add(this.lblFromDate);
            this.reportConstraintPanel.add((Component)this.dpStartDate);
            this.reportConstraintPanel.add(this.jcbStartTime);
            this.reportConstraintPanel.add(this.lblToDate);
            this.reportConstraintPanel.add((Component)this.dpEndDate);
            this.reportConstraintPanel.add(this.jcbEndTime);
            this.reportConstraintPanel.add(this.btnRefresh);
        }
        if (report instanceof OpenTicketSummaryReport) {
            this.reportConstraintPanel.removeAll();
            UserTypeDAO dao = new UserTypeDAO();
            List<UserType> userTypes = dao.findAll();
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(0, POSConstants.ALL);
            list.addAll(userTypes);
            this.cbUserType.setModel(new ListComboBoxModel(list));
            this.cbUserType.setPreferredSize(this.cbTerminal.getPreferredSize());
            this.reportConstraintPanel.add(this.lblUserType);
            this.reportConstraintPanel.add((Component)this.cbUserType, "gap 0px 20px");
            this.reportConstraintPanel.add(this.lblTerminal);
            this.reportConstraintPanel.add(this.cbTerminal);
            this.reportConstraintPanel.add(new JLabel(""));
            this.reportConstraintPanel.add(this.btnRefresh);
            this.reportConstraintPanel.add(this.btnClear);
        }
    }
}

