/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.Report;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.util.CurrencyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;

public class SalesReport
extends Report {
    private SalesReportModel itemReportModel;
    private SalesReportModel modifierReportModel;
    private boolean isInventory;

    public SalesReport(boolean isInventory) {
        this.isInventory = isInventory;
    }

    @Override
    public void refresh() throws Exception {
        this.createModels();
        JasperReport itemReport = ReportUtil.getReport("sales_sub_report");
        JasperReport modifierReport = ReportUtil.getReport("sales_sub_report");
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(map);
        String reportTitle = this.isInventory ? Messages.getString("SalesReport.3") : Messages.getString("SalesReport.9");
        map.put("reportTitle", reportTitle);
        map.put("reportTime", ReportService.formatFullDate(new Date()));
        map.put("dateRange", ReportService.formatFullDate(this.getStartDate()) + " to " + ReportService.formatFullDate(this.getEndDate()));
        map.put("terminalName", this.getTerminal() == null ? POSConstants.ALL : this.getTerminal().getName());
        map.put("itemDataSource", new JRTableModelDataSource((TableModel)this.itemReportModel));
        map.put("modifierDataSource", new JRTableModelDataSource((TableModel)this.modifierReportModel));
        map.put("currency", Messages.getString("SalesReport.8") + " " + CurrencyUtil.getCurrencyName() + " (" + CurrencyUtil.getCurrencySymbol() + ")");
        map.put("itemReport", itemReport);
        map.put("isShowGroup", this.isShowInGroups());
        map.put("modifierReport", modifierReport);
        if (this.modifierReportModel.getItems().size() > 0) {
            map.put("modifierSection", "MODIFIERS");
        }
        JasperReport masterReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_report"));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JREmptyDataSource());
        this.viewer = new JRViewer(print);
    }

    @Override
    public boolean isDateRangeSupported() {
        return true;
    }

    @Override
    public boolean isTypeSupported() {
        return true;
    }

    public void createModels() {
        Date startDate = this.getStartDate();
        Date toDate = this.getEndDate();
        Terminal terminal = this.getTerminal();
        List<MenuGroup> groups = this.getMenuGroups();
        LinkedHashMap<String, ReportItem> itemMap = new LinkedHashMap<String, ReportItem>();
        LinkedHashMap<String, ReportItem> modifierMap = new LinkedHashMap<String, ReportItem>();
        List<TicketItem> ticketItems = TicketItemDAO.getInstance().findTicketItemWithinDate(startDate, toDate, terminal, groups, this.isInventory);
        String key = null;
        for (TicketItem ticketItem : ticketItems) {
            if (ticketItem.getUnitPrice() == 0.0 && !this.isIncludedFreeItems()) continue;
            String menuItemId = ticketItem.getMenuItemId();
            key = (menuItemId == null ? ticketItem.getName() : menuItemId) + "-" + ticketItem.getUnitPrice();
            ReportItem reportItem = (ReportItem)((HashMap)itemMap).get(key);
            if (reportItem == null) {
                reportItem = new ReportItem();
                reportItem.setId(key);
                reportItem.setPrice(ticketItem.getUnitPrice());
                reportItem.setCost(ticketItem.getUnitCost());
                reportItem.setName(ticketItem.getName());
                reportItem.setTaxRate(ticketItem.getTotalTaxRate());
                reportItem.setGroupName(ticketItem.getGroupName());
                reportItem.setBarcode(menuItemId);
                reportItem.setAdjustedPrice(ticketItem.getAdjustedUnitPrice());
                itemMap.put(key, reportItem);
            }
            reportItem.setQuantity(reportItem.getQuantity() + ticketItem.getQuantity());
            reportItem.setGrossTotal(reportItem.getGrossTotal() + ticketItem.getAdjustedTotalWithoutModifiers());
            reportItem.setDiscount(reportItem.getDiscount() + ticketItem.getAdjustedDiscountWithoutModifiers());
            reportItem.setTaxTotal(reportItem.getTaxTotal() + ticketItem.getAdjustedTaxWithoutModifiers());
            reportItem.setServiceCharge(reportItem.getServiceCharge() + ticketItem.getServiceCharge());
            double adjustedAmount = ticketItem.isTaxIncluded() != false ? ticketItem.getAdjustedTotalWithoutModifiers() - ticketItem.getAdjustedTaxWithoutModifiers() : ticketItem.getAdjustedSubtotalWithoutModifiers();
            reportItem.setNetTotal(reportItem.getNetTotal() + adjustedAmount);
        }
        this.itemReportModel = new SalesReportModel();
        Collection values = ((HashMap)itemMap).values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            ReportItem reportItem = (ReportItem)iterator.next();
            if (reportItem.getQuantity() != 0.0) continue;
            iterator.remove();
        }
        this.itemReportModel.setItems(new ArrayList<ReportItem>(values));
        List<TicketItemModifier> ticketModifierItems = TicketItemDAO.getInstance().findTicketItemModifierWithinDate(startDate, toDate, terminal, groups, this.isInventory);
        for (TicketItemModifier modifier : ticketModifierItems) {
            if (modifier.getUnitPrice() == 0.0 && !this.isIncludedFreeItems()) continue;
            String itemId = modifier.getItemId();
            key = (itemId == null ? modifier.getName() : itemId) + "-" + modifier.getModifierType() + "-" + modifier.getUnitPrice();
            ReportItem modifierReportItem = (ReportItem)((HashMap)modifierMap).get(key);
            if (modifierReportItem == null) {
                modifierReportItem = new ReportItem();
                modifierReportItem.setId(itemId);
                modifierReportItem.setPrice(modifier.getUnitPrice());
                modifierReportItem.setName(modifier.getName());
                modifierReportItem.setTaxRate(modifier.getTotalTaxRate());
                modifierReportItem.setAdjustedPrice(modifier.getAdjustedUnitPrice());
                modifierReportItem.setServiceCharge(modifier.getServiceCharge());
                modifierMap.put(key, modifierReportItem);
            }
            modifierReportItem.setQuantity(modifierReportItem.getQuantity() + modifier.getItemQuantity() * modifier.getTicketItemQuantity());
            modifierReportItem.setDiscount(modifierReportItem.getDiscount() + modifier.getAdjustedDiscount());
            modifierReportItem.setServiceCharge(modifierReportItem.getServiceCharge() + modifier.getServiceCharge());
            modifierReportItem.setGrossTotal(modifierReportItem.getGrossTotal() + modifier.getAdjustedTotal());
            modifierReportItem.setTaxTotal(modifierReportItem.getTaxTotal() + modifier.getAdjustedTax());
            double adjustedAmount = modifier.isTaxIncluded() != false ? modifier.getAdjustedSubtotal() - modifier.getAdjustedTax() : modifier.getAdjustedSubtotal();
            modifierReportItem.setNetTotal(modifierReportItem.getNetTotal() + adjustedAmount);
        }
        this.modifierReportModel = new SalesReportModel();
        ArrayList<ReportItem> modifiers = new ArrayList<ReportItem>(((HashMap)modifierMap).values());
        this.modifierReportModel.setItems(modifiers);
    }
}

