/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.ui.ticket.TicketItemRowCreator;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;

public class TicketDataSource
extends AbstractReportDataSource {
    public TicketDataSource() {
        super(new String[]{"itemName", "itemQty", "itemSubtotal"});
    }

    public TicketDataSource(Ticket ticket) {
        super(new String[]{"itemName", "itemQty", "itemSubtotal"});
        this.setTicket(ticket);
    }

    private void setTicket(Ticket ticket) {
        Collections.sort(ticket.getTicketItems(), new Comparator<TicketItem>(){

            @Override
            public int compare(TicketItem o1, TicketItem o2) {
                return o1.isVoided().compareTo(o2.isVoided());
            }
        });
        ArrayList<ITicketItem> rows = new ArrayList<ITicketItem>();
        LinkedHashMap<String, ITicketItem> tableRows = new LinkedHashMap<String, ITicketItem>();
        TicketItemRowCreator.calculateTicketRows(ticket, tableRows, true, false, true);
        rows.addAll(tableRows.values());
        this.setRows(rows);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ITicketItem item = (ITicketItem)this.rows.get(rowIndex);
        if (item instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)item;
            ticketItem.setIncludeVoidQuantity(true);
        }
        switch (columnIndex) {
            case 0: {
                return item.getNameDisplay();
            }
            case 1: {
                return "";
            }
            case 2: {
                Double total = item.getSubTotalAmountDisplay();
                if (total == null) {
                    return null;
                }
                return NumberUtil.formatNumberAcceptNegative(total);
            }
        }
        return null;
    }
}

