/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ServerSummaryReportService {
    private StoreSession storeSession;
    private Session session;
    private User user;
    private CashDrawer serverSummaryReport = new CashDrawer();

    public ServerSummaryReportService(User user, StoreSession storeSession) {
        this.user = user;
        this.storeSession = storeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CashDrawer populateServerSummaryReport() {
        GenericDAO dao = new GenericDAO();
        try {
            this.session = dao.createNewSession();
            this.calculateNetSales();
            this.calculateCashTips();
            this.calculateChargedTips();
            double totalRev = 0.0;
            double totalGratuityAmount = 0.0;
            double totalGrossReceipts = 0.0;
            totalRev = this.serverSummaryReport.getNetSales() + this.serverSummaryReport.getSalesTax() + this.serverSummaryReport.getServiceCharge() - this.serverSummaryReport.getTotalDiscountSales();
            this.serverSummaryReport.setTotalRevenue(POSUtil.getRoundedDouble(totalRev));
            totalGratuityAmount = this.serverSummaryReport.getCashTips() + this.serverSummaryReport.getChargedTips();
            totalGrossReceipts = totalRev + totalGratuityAmount;
            this.serverSummaryReport.setGrossReceipts(totalGrossReceipts);
            this.calculateCashReceipt();
            this.calculateCreditReceipt();
            this.calculateDebitReceipt();
            this.calculateMemberPayment();
            this.calculateCustomPaymentWithoutPromotion();
            this.calculatePromotionPayment();
            this.calculateGiftCertReceipts();
            this.calculateRefundAmount();
            this.calculateToleranceAmount();
            double totalReceiptsDiff = this.serverSummaryReport.getCashReceiptAmount() + this.serverSummaryReport.getCreditCardReceiptAmount() + this.serverSummaryReport.getDebitCardReceiptAmount() + this.serverSummaryReport.getCustomerPaymentAmount() + this.serverSummaryReport.getPromotionAmount() + this.serverSummaryReport.getCustomPaymentAmount() + this.serverSummaryReport.getGiftCertChangeAmount() - this.serverSummaryReport.getRefundAmount() - this.serverSummaryReport.getToleranceAmount();
            this.serverSummaryReport.setReceiptDifferential(POSUtil.getRoundedDouble(totalGrossReceipts - totalReceiptsDiff));
            this.serverSummaryReport.setAssignedUser(this.user);
            this.serverSummaryReport.setStartTime(this.storeSession.getOpenTime());
            this.serverSummaryReport.setAssignedBy(this.storeSession.getOpenedBy());
            this.serverSummaryReport.setReportTime(this.storeSession.getCloseTime());
            this.serverSummaryReport.setClosedBy(this.storeSession.getClosedBy());
            this.serverSummaryReport.setStoreOperationData(this.storeSession);
            CashDrawer cashDrawer = this.serverSummaryReport;
            return cashDrawer;
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
        }
    }

    private void calculateNetSales() {
        Criteria criteria = this.session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_TAX_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SERVICE_CHARGE));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_DISCOUNT_AMOUNT));
        criteria.setProjection((Projection)projectionList);
        List list = criteria.list();
        for (Object[] objects : list) {
            double salesAmnt = objects[0] != null ? ((Number)objects[0]).doubleValue() : 0.0;
            double taxAmnt = objects[1] != null ? ((Number)objects[1]).doubleValue() : 0.0;
            double serviceChrgAmnt = objects[2] != null ? ((Number)objects[2]).doubleValue() : 0.0;
            double discountAmount = objects[3] != null ? ((Number)objects[3]).doubleValue() : 0.0;
            this.serverSummaryReport.setNetSales(NumberUtil.round(salesAmnt));
            this.serverSummaryReport.setSalesTax(NumberUtil.round(taxAmnt));
            this.serverSummaryReport.setServiceCharge(NumberUtil.round(serviceChrgAmnt));
            this.serverSummaryReport.setTotalDiscountSales(NumberUtil.round(discountAmount));
        }
    }

    private Criteria getCriteriaForTransaction(Class transactionClass) {
        Criteria criteria = this.session.createCriteria(transactionClass);
        if (transactionClass.equals(RefundTransaction.class) || transactionClass.equals(PayOutTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        return criteria;
    }

    private void calculateCashReceipt() {
        Criteria criteria = this.getCriteriaForTransaction(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.serverSummaryReport.setCashReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateToleranceAmount() {
        Criteria criteria = this.getCriteriaForTransaction(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TOLERANCE_AMOUNT));
        this.serverSummaryReport.setToleranceAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCreditReceipt() {
        Criteria criteria = this.getCriteriaForTransaction(CreditCardTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.serverSummaryReport.setCreditCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateDebitReceipt() {
        Criteria criteria = this.getCriteriaForTransaction(DebitCardTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)CashTransaction.PROP_USER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        this.serverSummaryReport.setDebitCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateMemberPayment() {
        Criteria criteria = this.getCriteriaForTransaction(CustomerAccountTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.serverSummaryReport.setCustomerPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCustomPaymentWithoutPromotion() {
        Criteria criteria = this.getCriteriaForTransaction(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.serverSummaryReport.setCustomPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculatePromotionPayment() {
        Criteria criteria = this.getCriteriaForTransaction(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.serverSummaryReport.setPromotionAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateGiftCertReceipts() {
        Criteria criteria = this.getCriteriaForTransaction(GiftCertificateTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        this.serverSummaryReport.setGiftCertChangeAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateRefundAmount() {
        Criteria criteria = this.getCriteriaForTransaction(RefundTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)RefundTransaction.PROP_USER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.serverSummaryReport.setRefundAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCashTips() {
        Criteria criteria = this.getCriteriaForTransaction(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.serverSummaryReport.setCashTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateChargedTips() {
        Criteria criteria = this.getCriteriaForTransaction(PosTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.user.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.serverSummaryReport.setChargedTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }
}

