/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PaginationSupport;
import java.util.List;

public abstract class PaginatedTableModel<E>
extends ListTableModel
implements PaginationSupport {
    private int numRows;
    private int currentRowIndex;
    private int pageSize = 100;

    public PaginatedTableModel() {
    }

    public PaginatedTableModel(String[] columnNames, List rows) {
        super(columnNames, rows);
    }

    public PaginatedTableModel(String[] columnNames) {
        super(columnNames);
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    @Override
    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    @Override
    public void setCurrentRowIndex(int currentRowIndex) {
        this.currentRowIndex = currentRowIndex;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public boolean hasNext() {
        return this.currentRowIndex + this.pageSize < this.numRows;
    }

    @Override
    public boolean hasPrevious() {
        return this.currentRowIndex > 0;
    }

    @Override
    public int getNextRowIndex() {
        if (this.numRows == 0) {
            return 0;
        }
        return this.getCurrentRowIndex() + this.getPageSize();
    }

    @Override
    public int getPreviousRowIndex() {
        int i = this.getCurrentRowIndex() - this.getPageSize();
        if (i < 0) {
            i = 0;
        }
        return i;
    }
}

