/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import java.awt.Color;
import java.util.Date;
import javax.swing.BorderFactory;
import org.apache.commons.lang.StringUtils;

public class ShopTableButton
extends PosButton {
    private ShopTable shopTable;
    private User user;
    private Ticket ticket;
    int pressedX;
    int pressedY;

    public ShopTableButton(ShopTable shopTable) {
        this.shopTable = shopTable;
        this.setBorder(BorderFactory.createLineBorder(new Color(150, 0, 0, 127), 1, true));
        this.setBounds(shopTable.getX(), shopTable.getY(), TerminalConfig.getFloorButtonWidth(), TerminalConfig.getFloorButtonHeight());
        this.setBackground(shopTable.getFloor().getForegroundColor());
        this.update();
    }

    public int getId() {
        return this.shopTable.getId();
    }

    public void setShopTable(ShopTable shopTable) {
        this.shopTable = shopTable;
    }

    public ShopTable getShopTable() {
        return this.shopTable;
    }

    public String getTicketId() {
        return this.shopTable.getTicketId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShopTableButton)) {
            return false;
        }
        ShopTableButton that = (ShopTableButton)obj;
        return this.shopTable.equals(that.shopTable);
    }

    public int hashCode() {
        return this.shopTable.hashCode();
    }

    @Override
    public String toString() {
        return this.shopTable.toString();
    }

    public void update() {
        Date ticketCreateTime;
        String ticketId;
        Color freeBgColor;
        Terminal terminal = Application.getInstance().getTerminal();
        int priSize = terminal.getProperty("floorplan.primaryFontSize") == null ? 12 : Integer.valueOf(terminal.getProperty("floorplan.primaryFontSize"));
        int secSize = terminal.getProperty("floorplan.secondaryFontSize") == null ? 2 : Integer.valueOf(terminal.getProperty("floorplan.secondaryFontSize"));
        Color seatForeColor = StringUtils.isEmpty((String)terminal.getProperty("floorplan.seatForeColor")) ? null : new Color(Integer.parseInt(terminal.getProperty("floorplan.seatForeColor")));
        Color seatBgColor = StringUtils.isEmpty((String)terminal.getProperty("floorplan.seatBGColor")) ? null : new Color(Integer.parseInt(terminal.getProperty("floorplan.seatBGColor")));
        Color bookForeColor = StringUtils.isEmpty((String)terminal.getProperty("floorplan.bookForeColor")) ? null : new Color(Integer.parseInt(terminal.getProperty("floorplan.bookForeColor")));
        Color bookBgColor = StringUtils.isEmpty((String)terminal.getProperty("floorplan.bookBGColor")) ? null : new Color(Integer.parseInt(terminal.getProperty("floorplan.bookBGColor")));
        Color freeForeColor = StringUtils.isEmpty((String)terminal.getProperty("floorplan.freeForeColor")) ? null : new Color(Integer.parseInt(terminal.getProperty("floorplan.freeForeColor")));
        Color color = freeBgColor = StringUtils.isEmpty((String)terminal.getProperty("floorplan.freeBGColor")) ? null : new Color(Integer.parseInt(terminal.getProperty("floorplan.freeBGColor")));
        if (this.shopTable.getTableStatus() == null || this.shopTable == null) {
            this.setEnabled(true);
            this.setBackground(freeBgColor != null ? freeBgColor : Color.white);
            this.setForeground(freeForeColor != null ? freeForeColor : Color.black);
        } else if (this.shopTable.getTableStatus().equals((Object)TableStatus.Seat)) {
            this.setBackground(seatBgColor != null ? seatBgColor : new Color(255, 102, 102));
            this.setForeground(seatForeColor != null ? seatForeColor : Color.BLACK);
        } else if (this.shopTable.getTableStatus().equals((Object)TableStatus.Booked)) {
            this.setEnabled(false);
            this.setOpaque(true);
            this.setBackground(bookBgColor != null ? bookBgColor : Color.orange);
            this.setForeground(bookForeColor != null ? bookForeColor : Color.BLACK);
        } else {
            this.setEnabled(true);
            this.setBackground(freeBgColor != null ? freeBgColor : Color.white);
            this.setForeground(freeForeColor != null ? freeForeColor : Color.black);
        }
        String text = "<html><center>";
        text = text + "<font size=" + priSize + ">" + this.shopTable.getTableNumber() + "</font>";
        if (!terminal.isShowTableNumber() && this.shopTable.getName() != null) {
            text = "<html><center><font size=" + priSize + ">" + this.shopTable.getName() + "</font>";
        }
        if ((ticketId = this.shopTable.getTicketId()) != null && StringUtils.isNotEmpty((String)this.shopTable.getUserId())) {
            if (terminal.isShowServerName()) {
                text = text + "<div><font size=" + secSize + ">" + this.shopTable.getUserName() + "</font></div>";
            }
            if (!this.shopTable.getUserId().toString().equals(Application.getCurrentUser().getId().toString())) {
                if (this.shopTable.getShopTableStatus().hasMultipleTickets()) {
                    this.setBackground(seatBgColor != null ? seatBgColor : new Color(255, 102, 102));
                    this.setForeground(seatForeColor != null ? seatForeColor : Color.BLACK);
                } else {
                    this.setBackground(new Color(139, 0, 139));
                    this.setForeground(Color.WHITE);
                }
            }
        }
        if ((ticketCreateTime = this.shopTable.getTicketCreateTime()) != null && !this.shopTable.isShowStatus()) {
            text = text + "<div><font size=" + secSize + ">" + DateUtil.getElapsedTime(ticketCreateTime, new Date()) + "</font></div>";
        } else if (this.shopTable.isShowStatus()) {
            int availableCap = this.shopTable.getCapacity() - this.shopTable.getGuestNumber();
            text = text + "<div><font size=" + secSize + ">Avail Cap: " + availableCap + "</font></div>";
            text = text + "<div><font size=" + secSize + ">Total Cap: " + this.shopTable.getCapacity() + "</font></div>";
        } else if (StringUtils.isNotEmpty((String)ticketId) && terminal.isShowTokenNum()) {
            text = text + "<div><font size=" + secSize + ">#" + this.shopTable.getTicketShortId() + "</font></div>";
        }
        text = text + "</center></html>";
        this.setText(text);
    }

    public void setUser(User user) {
        if (user != null) {
            this.user = user;
        }
    }

    public User getUser() {
        return this.user;
    }

    public boolean hasUserAccess() {
        String ticketUserId;
        if (this.shopTable.getShopTableStatus().hasMultipleTickets()) {
            return true;
        }
        if (this.user == null) {
            return true;
        }
        User currentUser = Application.getCurrentUser();
        String currentUserId = currentUser.getId();
        if (currentUserId.equals(ticketUserId = this.user.getId())) {
            return true;
        }
        if (currentUser.hasPermission(UserPermission.PERFORM_MANAGER_TASK) || currentUser.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
            return true;
        }
        String password = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)password)) {
            return false;
        }
        String inputUserId = UserDAO.getInstance().findUserBySecretKey(password).getId();
        if (inputUserId.equals(this.user.getId())) {
            POSMessageDialog.showError(Application.getPosWindow(), "Incorrect password");
            return false;
        }
        return true;
    }

    public void initializeUser() {
        String userId = this.shopTable.getUserId();
        if (StringUtils.isEmpty((String)userId)) {
            return;
        }
        if (this.user != null && this.user.getId().equals(userId)) {
            return;
        }
        this.user = UserDAO.getInstance().get(this.shopTable.getUserId());
    }

    public void initializeTicket() {
        String ticketId = this.shopTable.getTicketId();
        if (StringUtils.isEmpty((String)ticketId)) {
            return;
        }
        if (this.shopTable.getTicketId() == null) {
            return;
        }
        if (this.ticket != null && this.ticket.getId().equals(ticketId)) {
            return;
        }
        this.ticket = TicketService.getTicket(this.shopTable.getTicketId());
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }
}

