/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.table;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.table.ShopTableForm;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ShopTableBrowser
extends TransparentPanel {
    private JTable table;
    private BeanTableModel<ShopTable> tableModel;
    private JTextField tfSearchSubject;

    public ShopTableBrowser() {
        this.initComponents();
        this.initData();
    }

    private void initComponents() {
        this.setBorder(new TitledBorder(null, "TABLES", 2, 2, null, null));
        this.tableModel = new BeanTableModel(ShopTable.class);
        this.tableModel.addColumn(Messages.getString("ShopTableBrowser.0"), ShopTable.PROP_ID);
        this.tableModel.addColumn("Name", ShopTable.PROP_NAME);
        this.tableModel.addColumn(Messages.getString("ShopTableBrowser.1"), ShopTable.PROP_CAPACITY);
        this.tableModel.addColumn("Type", "typesAsString");
        this.tableModel.addColumn("Min Guest", ShopTable.PROP_MIN_CAPACITY);
        this.tableModel.addColumn("Reservable", ShopTable.PROP_RESERVABLE);
        this.tableModel.addColumn(Messages.getString("ShopTableBrowser.2"), ShopTable.PROP_DESCRIPTION);
        this.table = new JTable(this.tableModel);
        this.table.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.table.setSelectionMode(0);
        this.table.setRowHeight(PosUIManager.getSize(20));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    ShopTableBrowser.this.doEditSelectedRow();
                }
            }
        });
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)new PosScrollPane(this.table), "Center");
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.createSearchPanel(), "North");
    }

    private JPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        addButton.setText("NEW");
        editButton.setText("EDIT");
        deleteButton.setText("DELETE");
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.doEditSelectedRow();
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.doCreateShopTable();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.doDeleteShopTable();
            }
        });
        JButton btnDuplicate = new JButton("DUPLICATE");
        btnDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.doDuplicateShopTable();
            }
        });
        JButton btnDeleteAll = new JButton("DELETE ALL");
        btnDeleteAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.doDeleteAllShopTable();
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center", ""));
        TransparentPanel actionButtonPanel = new TransparentPanel();
        actionButtonPanel.add(addButton);
        actionButtonPanel.add(editButton);
        actionButtonPanel.add(deleteButton);
        actionButtonPanel.add(btnDuplicate);
        actionButtonPanel.add(btnDeleteAll);
        bottomPanel.add((Component)actionButtonPanel, "");
        return bottomPanel;
    }

    public void initData() {
        List<ShopTable> tables = ShopTableDAO.getInstance().findAllWithTypes();
        BeanTableModel tableModel = (BeanTableModel)this.table.getModel();
        tableModel.removeAll();
        tableModel.addRows(tables);
    }

    public void doRefreshTable() {
        List<ShopTable> tables = ShopTableDAO.getInstance().findAllWithTypes();
        BeanTableModel tableModel = (BeanTableModel)this.table.getModel();
        tableModel.removeAll();
        tableModel.addRows(tables);
    }

    private void doCreateShopTable() {
        ShopTableForm editor = new ShopTableForm(new ShopTable(), false);
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.openFullScreen();
        if (dialog.isCanceled()) {
            return;
        }
        ShopTable shopTable = (ShopTable)editor.getBean();
        this.tableModel.addRow(shopTable);
    }

    private void doEditSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a table.");
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            ShopTable shopTable = this.tableModel.getRow(index);
            this.tableModel.setRow(index, shopTable);
            ShopTableForm editor = new ShopTableForm(shopTable, false);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.openFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteShopTable() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a table.");
            return;
        }
        index = this.table.convertRowIndexToModel(index);
        ShopTable shopTable = this.tableModel.getRow(index);
        this.tableModel.setRow(index, shopTable);
        ShopTableForm editor = new ShopTableForm(shopTable, false);
        editor.delete();
        this.table.repaint();
        this.doRefreshTable();
    }

    private void doDeleteAllShopTable() {
        boolean isDeleted = this.deleteAllTables();
        if (isDeleted) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "All table successfully deleted!");
        }
        this.table.repaint();
        this.doRefreshTable();
    }

    public boolean deleteAllTables() {
        List<ShopTable> list = ShopTableDAO.getInstance().findAll();
        if (list.isEmpty()) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.51"));
            return false;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.20"), Messages.getString("ShopTableForm.21"));
        if (option != 0) {
            return false;
        }
        List<BookingInfo> bookingList = BookingInfoDAO.getInstance().findAll();
        for (BookingInfo info : bookingList) {
            info.setTables(null);
            BookingInfoDAO.getInstance().saveOrUpdate(info);
        }
        for (ShopTable table : list) {
            table.setFloor(null);
            table.setTypes(null);
            ShopTableDAO.getInstance().delete(table);
        }
        return true;
    }

    private void doDuplicateShopTable() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a table.");
            return;
        }
        index = this.table.convertRowIndexToModel(index);
        ShopTable shopTable = this.tableModel.getRow(index);
        NumberSelectionDialog2 dialog = new NumberSelectionDialog2();
        dialog.setTitle("How many duplicates?");
        dialog.setFloatingPoint(false);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        int numberOfDuplicates = (int)dialog.getValue();
        for (int i = 0; i < numberOfDuplicates; ++i) {
            this.doDuplicate(shopTable);
        }
        this.table.repaint();
        this.doRefreshTable();
    }

    private void doDuplicate(ShopTable originalTable) {
        ShopTable table = new ShopTable();
        int nxtTableNumber = ShopTableDAO.getInstance().getNextTableNumber();
        if (table.getId() == null) {
            table.setId(nxtTableNumber + 1);
        }
        List<ShopTableType> types = originalTable.getTypes();
        ArrayList<ShopTableType> newTypes = new ArrayList<ShopTableType>();
        for (ShopTableType shopTableType : types) {
            newTypes.add(shopTableType);
        }
        table.setTypes(newTypes);
        table.setCapacity(originalTable.getCapacity());
        table.setDescription(originalTable.getDescription());
        table.setName(originalTable.getName());
        table.setTableStatus(TableStatus.Available);
        table.setMinCapacity(originalTable.getMinCapacity());
        table.setReservable(originalTable.isReservable());
        ShopTableDAO.getInstance().saveOrUpdate(table);
    }

    private JPanel createSearchPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][][][]", ""));
        JLabel lblSearch = new JLabel("Search by capacity: ");
        this.tfSearchSubject = new JTextField(15);
        JButton btnSearch = new JButton("Search");
        JButton btnReset = new JButton("Reset");
        JButton btnRefresh = new JButton("Refresh");
        this.tfSearchSubject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.doSearchTable();
            }
        });
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.doSearchTable();
            }
        });
        btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.tfSearchSubject.setText("");
                ShopTableBrowser.this.doRefreshTable();
            }
        });
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.tfSearchSubject.setText("");
                ShopTableBrowser.this.doRefreshTable();
            }
        });
        panel.add((Component)lblSearch, "grow");
        panel.add((Component)this.tfSearchSubject, "grow");
        panel.add((Component)btnSearch, "grow");
        panel.add((Component)btnRefresh, "grow");
        return panel;
    }

    private void doSearchTable() {
        String searchSubject = this.tfSearchSubject.getText();
        if (StringUtils.isEmpty((CharSequence)searchSubject)) {
            return;
        }
        List<ShopTable> searchedTables = ShopTableDAO.getInstance().findBy(searchSubject);
        if (searchedTables == null || searchedTables.size() == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No result found!");
            return;
        }
        BeanTableModel tableModel = (BeanTableModel)this.table.getModel();
        tableModel.removeAll();
        tableModel.addRows(searchedTables);
    }
}

