/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosUIManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXCollapsiblePane;

public class DeliveryDispatchTicketFilterPanel
extends JXCollapsiblePane {
    private List<String> filters;
    private DeliveryDispatchTicketFilterListener listener;
    private JToggleButton toggleButton;

    public DeliveryDispatchTicketFilterPanel(List<String> filters) {
        this.filters = filters;
        this.getContentPane().setLayout((LayoutManager)new MigLayout("inset 0 0 5 0,fillx", "[][][grow]", ""));
        this.setCollapsed(true);
        this.createFilterPanel();
    }

    public void addFilterListener(DeliveryDispatchTicketFilterListener listener) {
        this.listener = listener;
    }

    private void createFilterPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("inset 0,fillx", "", ""));
        JPanel datePanel = new JPanel((LayoutManager)new MigLayout("fill"));
        datePanel.setBorder(BorderFactory.createTitledBorder(""));
        JPanel onlineOrderPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        onlineOrderPanel.setBorder(BorderFactory.createTitledBorder(""));
        JPanel orderPanel = new JPanel((LayoutManager)new MigLayout("fill", "sg,fill", ""));
        orderPanel.setBorder(BorderFactory.createTitledBorder(""));
        ButtonGroup dateGroup = new ButtonGroup();
        for (String filter : this.filters) {
            FilterButton btnFilter = new FilterButton(filter);
            if (filter.equals(POSConstants.ALL)) {
                btnFilter.setSelected(true);
                this.setToggleButton(btnFilter);
                dateGroup.add(btnFilter);
                datePanel.add((Component)btnFilter, "grow");
                continue;
            }
            if (filter.equals(POSConstants.TODAY) || filter.equals(POSConstants.TOMORROW)) {
                dateGroup.add(btnFilter);
                datePanel.add((Component)btnFilter, "grow");
                continue;
            }
            if (filter.equals("ONLINE")) {
                onlineOrderPanel.add((Component)btnFilter, "grow");
                continue;
            }
            if (filter.equals("PICK UP")) {
                orderPanel.add((Component)btnFilter, "grow");
                continue;
            }
            if (!filter.equals("DELIVERY")) continue;
            orderPanel.add((Component)btnFilter, "grow");
        }
        panel.add(datePanel);
        panel.add((Component)onlineOrderPanel, "w " + PosUIManager.getSize(150));
        panel.add(orderPanel);
        this.getContentPane().add((Component)panel, "growx");
    }

    public JToggleButton getToggleButton() {
        return this.toggleButton;
    }

    public void setToggleButton(JToggleButton toggleButton) {
        this.toggleButton = toggleButton;
    }

    public static interface DeliveryDispatchTicketFilterListener {
        public void filterSelected(JToggleButton var1);

        public void filterUnSelected(JToggleButton var1);
    }

    private class FilterButton
    extends POSToggleButton
    implements ActionListener {
        public FilterButton(String name) {
            this.setText(name);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton tBtn = (JToggleButton)e.getSource();
            if (tBtn.isSelected()) {
                this.setSelected(true);
                DeliveryDispatchTicketFilterPanel.this.listener.filterSelected(tBtn);
            } else {
                this.setSelected(false);
                DeliveryDispatchTicketFilterPanel.this.listener.filterUnSelected(tBtn);
            }
        }
    }
}

